/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.opensdk.modelmsg;

import android.os.Bundle;
import com.tencent.mm.opensdk.modelmsg.WXMediaMessage;
import com.tencent.mm.opensdk.utils.Log;
import java.io.File;

public class WXFileObject
implements WXMediaMessage.IMediaObject {
    private static final int CONTENT_LENGTH_LIMIT = 0xA00000;
    private static final String TAG = "MicroMsg.SDK.WXFileObject";
    private int contentLengthLimit = 0xA00000;
    public byte[] fileData;
    public String filePath;

    public WXFileObject() {
        this.fileData = null;
        this.filePath = null;
    }

    public WXFileObject(String string2) {
        this.filePath = string2;
    }

    public WXFileObject(byte[] byArray) {
        this.fileData = byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getFileSize(String object) {
        int n2;
        int n3 = n2 = 0;
        if (object == null) return n3;
        if (((String)object).length() == 0) {
            return n2;
        }
        object = new File((String)object);
        n3 = n2;
        if (!((File)object).exists()) return n3;
        return (int)((File)object).length();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkArgs() {
        boolean bl = false;
        if (!(this.fileData != null && this.fileData.length != 0 || this.filePath != null && this.filePath.length() != 0)) {
            Log.e(TAG, "checkArgs fail, both arguments is null");
            return bl;
        }
        if (this.fileData != null && this.fileData.length > this.contentLengthLimit) {
            Log.e(TAG, "checkArgs fail, fileData is too large");
            return bl;
        }
        if (this.filePath == null) return true;
        if (this.getFileSize(this.filePath) <= this.contentLengthLimit) return true;
        Log.e(TAG, "checkArgs fail, fileSize is too large");
        return bl;
    }

    public void serialize(Bundle bundle) {
        bundle.putByteArray("_wxfileobject_fileData", this.fileData);
        bundle.putString("_wxfileobject_filePath", this.filePath);
    }

    public void setContentLengthLimit(int n2) {
        this.contentLengthLimit = n2;
    }

    public void setFileData(byte[] byArray) {
        this.fileData = byArray;
    }

    public void setFilePath(String string2) {
        this.filePath = string2;
    }

    public int type() {
        return 6;
    }

    public void unserialize(Bundle bundle) {
        this.fileData = bundle.getByteArray("_wxfileobject_fileData");
        this.filePath = bundle.getString("_wxfileobject_filePath");
    }
}

