/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.opensdk.modelmsg;

import android.graphics.Bitmap;
import android.os.Bundle;
import com.tencent.mm.opensdk.modelmsg.WXMediaMessage;
import com.tencent.mm.opensdk.utils.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;

public class WXImageObject
implements WXMediaMessage.IMediaObject {
    private static final int CONTENT_LENGTH_LIMIT = 0xA00000;
    private static final int PATH_LENGTH_LIMIT = 10240;
    private static final String TAG = "MicroMsg.SDK.WXImageObject";
    public byte[] imageData;
    public String imagePath;

    public WXImageObject() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WXImageObject(Bitmap bitmap) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 85, (OutputStream)byteArrayOutputStream);
            this.imageData = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            return;
        }
        catch (Exception exception) {
            Log.e(TAG, "WXImageObject <init>, exception:" + exception.getMessage());
            return;
        }
    }

    public WXImageObject(byte[] byArray) {
        this.imageData = byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getFileSize(String object) {
        int n2;
        int n3 = n2 = 0;
        if (object == null) return n3;
        if (((String)object).length() == 0) {
            return n2;
        }
        object = new File((String)object);
        n3 = n2;
        if (!((File)object).exists()) return n3;
        return (int)((File)object).length();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkArgs() {
        boolean bl = false;
        if (!(this.imageData != null && this.imageData.length != 0 || this.imagePath != null && this.imagePath.length() != 0)) {
            Log.e(TAG, "checkArgs fail, all arguments are null");
            return bl;
        }
        if (this.imageData != null && this.imageData.length > 0xA00000) {
            Log.e(TAG, "checkArgs fail, content is too large");
            return bl;
        }
        if (this.imagePath != null && this.imagePath.length() > 10240) {
            Log.e(TAG, "checkArgs fail, path is invalid");
            return bl;
        }
        if (this.imagePath == null) return true;
        if (this.getFileSize(this.imagePath) <= 0xA00000) return true;
        Log.e(TAG, "checkArgs fail, image content is too large");
        return bl;
    }

    public void serialize(Bundle bundle) {
        bundle.putByteArray("_wximageobject_imageData", this.imageData);
        bundle.putString("_wximageobject_imagePath", this.imagePath);
    }

    public void setImagePath(String string2) {
        this.imagePath = string2;
    }

    public int type() {
        return 2;
    }

    public void unserialize(Bundle bundle) {
        this.imageData = bundle.getByteArray("_wximageobject_imageData");
        this.imagePath = bundle.getString("_wximageobject_imagePath");
    }
}

