/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.opensdk.modelmsg;

import android.os.Bundle;
import com.tencent.mm.opensdk.modelmsg.WXMediaMessage;
import com.tencent.mm.opensdk.utils.Log;
import java.io.File;

public class WXVideoFileObject
implements WXMediaMessage.IMediaObject {
    private static final int FILE_SIZE_LIMIT = 0xA00000;
    private static final String TAG = "MicroMsg.SDK.WXVideoFileObject";
    public String filePath;

    public WXVideoFileObject() {
        this.filePath = null;
    }

    public WXVideoFileObject(String string2) {
        this.filePath = string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getFileSize(String object) {
        int n2;
        int n3 = n2 = 0;
        if (object == null) return n3;
        if (((String)object).length() == 0) {
            return n2;
        }
        object = new File((String)object);
        n3 = n2;
        if (!((File)object).exists()) return n3;
        return (int)((File)object).length();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkArgs() {
        boolean bl = false;
        if (this.filePath == null || this.filePath.length() == 0) {
            Log.e(TAG, "checkArgs fail, filePath is null");
            return bl;
        }
        if (this.getFileSize(this.filePath) <= 0xA00000) return true;
        Log.e(TAG, "checkArgs fail, video file size is too large");
        return bl;
    }

    public void serialize(Bundle bundle) {
        bundle.putString("_wxvideofileobject_filePath", this.filePath);
    }

    public int type() {
        return 38;
    }

    public void unserialize(Bundle bundle) {
        this.filePath = bundle.getString("_wxvideofileobject_filePath");
    }
}

