/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.smtt.export.external;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import dalvik.system.DexClassLoader;
import dalvik.system.VMStack;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;

public class DexLoader {
    private static final String JAVACORE_PACKAGE_PREFIX = "org.chromium";
    private static final String TAG = "DexLoader";
    private static final String TBS_FUSION_DEX = "tbs_jars_fusion_dex";
    private static final String TBS_WEBVIEW_DEX = "webview_dex";
    private static Boolean mUseTbsCorePrivateClassLoader = false;
    private DexClassLoader mClassLoader;

    public DexLoader(Context context, String string2, String string3) {
        this(context, new String[]{string2}, string3);
    }

    public DexLoader(Context context, String[] stringArray, String string2) {
        this(null, context, stringArray, string2);
    }

    public DexLoader(Context context, String[] stringArray, String string2, DexLoader dexLoader) {
        dexLoader = dexLoader.getClassLoader();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            dexLoader = this.createDexClassLoader(stringArray[i2], string2, context.getApplicationInfo().nativeLibraryDir, (ClassLoader)((Object)dexLoader));
            this.mClassLoader = dexLoader;
        }
    }

    public DexLoader(Context object, String[] stringArray, String string2, String object2) {
        ClassLoader classLoader = object.getClassLoader();
        String string3 = object.getApplicationInfo().nativeLibraryDir;
        object = string3;
        if (!TextUtils.isEmpty((CharSequence)object2)) {
            object = string3 + File.pathSeparator + (String)object2;
        }
        object2 = classLoader;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            object2 = this.createDexClassLoader(stringArray[i2], string2, (String)object, (ClassLoader)object2);
            this.mClassLoader = object2;
        }
    }

    public DexLoader(String string2, Context context, String[] stringArray, String string3) {
        this(string2, context, stringArray, string3, null);
    }

    public DexLoader(String string2, Context object, String[] stringArray, String string3, Map<String, Object> object2) {
        DexLoader.initTbsSettings(object2);
        ClassLoader classLoader = VMStack.getCallingClassLoader();
        object2 = classLoader;
        if (classLoader == null) {
            object2 = object.getClassLoader();
        }
        object = object2;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            object = this.createDexClassLoader(stringArray[i2], string3, string2, (ClassLoader)object);
            this.mClassLoader = object;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DexClassLoader createDexClassLoader(String object, String string2, String string3, ClassLoader classLoader) {
        void var1_3;
        void var4_7;
        void var3_6;
        void var2_5;
        if (this.shouldUseTbsCorePrivateClassLoader((String)object)) {
            TbsCorePrivateClassLoader tbsCorePrivateClassLoader = new TbsCorePrivateClassLoader((String)object, (String)var2_5, (String)var3_6, (ClassLoader)var4_7);
            return var1_3;
        }
        DexClassLoader dexClassLoader = new DexClassLoader(object, (String)var2_5, (String)var3_6, (ClassLoader)var4_7);
        return var1_3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void initTbsSettings(Map<String, Object> map) {
        if (map == null) return;
        try {
            mUseTbsCorePrivateClassLoader = (Boolean)map.get("use_private_classloader");
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldUseTbsCorePrivateClassLoader(String string2) {
        boolean bl = false;
        if (!mUseTbsCorePrivateClassLoader.booleanValue()) {
            return bl;
        }
        if (string2.contains(TBS_FUSION_DEX)) return true;
        if (!string2.contains(TBS_WEBVIEW_DEX)) return bl;
        return true;
    }

    public DexClassLoader getClassLoader() {
        return this.mClassLoader;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getStaticField(String object, String string2) {
        Object var3_3 = null;
        try {
            Object object2 = this.mClassLoader.loadClass((String)object).getField(string2);
            ((Field)object2).setAccessible(true);
            return object2 = ((Field)object2).get(null);
        }
        catch (Throwable throwable) {
            Log.e((String)this.getClass().getSimpleName(), (String)("'" + (String)object + "' get field '" + string2 + "' failed"), (Throwable)throwable);
            return var3_3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object invokeMethod(Object object, String string2, String string3, Class<?>[] object2, Object ... objectArray) {
        try {
            object2 = this.mClassLoader.loadClass(string2).getMethod(string3, (Class<?>)object2);
            ((Method)object2).setAccessible(true);
            return ((Method)object2).invoke(object, objectArray);
        }
        catch (Throwable throwable) {
            Log.e((String)this.getClass().getSimpleName(), (String)("'" + string2 + "' invoke method '" + string3 + "' failed"), (Throwable)throwable);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object invokeStaticMethod(String object, String string2, Class<?>[] object2, Object ... objectArray) {
        try {
            object2 = this.mClassLoader.loadClass((String)object).getMethod(string2, (Class<?>)object2);
            ((Method)object2).setAccessible(true);
            return object2 = ((Method)object2).invoke(null, objectArray);
        }
        catch (Throwable throwable) {
            if (string2 != null && string2.equalsIgnoreCase("initTesRuntimeEnvironment")) {
                Log.e((String)this.getClass().getSimpleName(), (String)("'" + (String)object + "' invoke static method '" + string2 + "' failed"), (Throwable)throwable);
                return throwable;
            }
            Log.e((String)this.getClass().getSimpleName(), (String)("'" + (String)object + "' invoke static method '" + string2 + "' failed"), (Throwable)throwable);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Class<?> loadClass(String object) {
        try {
            Class clazz = this.mClassLoader.loadClass((String)object);
            return clazz;
        }
        catch (Throwable throwable) {
            Log.e((String)this.getClass().getSimpleName(), (String)("loadClass '" + (String)object + "' failed"), (Throwable)throwable);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object newInstance(String string2) {
        void var1_3;
        try {
            Object t2;
            Object t3 = t2 = this.mClassLoader.loadClass(string2).newInstance();
            return var1_3;
        }
        catch (Throwable throwable) {
            Log.e((String)this.getClass().getSimpleName(), (String)("create " + string2 + " instance failed"), (Throwable)throwable);
            return var1_3;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object newInstance(String object, Class<?>[] object2, Object ... objectArray) {
        void var1_3;
        try {
            void var3_9;
            void var2_6;
            Object t2;
            Object t3 = t2 = this.mClassLoader.loadClass(object).getConstructor((Class<?>)var2_6).newInstance((Object[])var3_9);
            return var1_3;
        }
        catch (Throwable throwable) {
            if ("com.tencent.smtt.webkit.adapter.X5WebViewAdapter".equalsIgnoreCase((String)object)) {
                Log.e((String)this.getClass().getSimpleName(), (String)("'newInstance " + object + " failed"), (Throwable)throwable);
                Throwable throwable2 = throwable;
                return var1_3;
            }
            Log.e((String)this.getClass().getSimpleName(), (String)("create '" + object + "' instance failed"), (Throwable)throwable);
            return var1_3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setStaticField(String string2, String string3, Object object) {
        try {
            Field field = this.mClassLoader.loadClass(string2).getField(string3);
            field.setAccessible(true);
            field.set(null, object);
            return;
        }
        catch (Throwable throwable) {
            Log.e((String)this.getClass().getSimpleName(), (String)("'" + string2 + "' set field '" + string3 + "' failed"), (Throwable)throwable);
            return;
        }
    }

    private static class TbsCorePrivateClassLoader
    extends DexClassLoader {
        public TbsCorePrivateClassLoader(String string2, String string3, String string4, ClassLoader classLoader) {
            super(string2, string3, string4, classLoader);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Class<?> loadClass(String string2, boolean bl) {
            if (string2 == null) return super.loadClass(string2, bl);
            if (!string2.startsWith(DexLoader.JAVACORE_PACKAGE_PREFIX)) return super.loadClass(string2, bl);
            Class clazz = this.findLoadedClass(string2);
            Class<?> clazz2 = clazz;
            if (clazz != null) return clazz2;
            try {
                clazz2 = this.findClass(string2);
                clazz = clazz2;
            }
            catch (ClassNotFoundException classNotFoundException) {}
            clazz2 = clazz;
            if (clazz != null) return clazz2;
            ClassLoader classLoader = this.getParent();
            clazz2 = clazz;
            if (classLoader == null) return clazz2;
            return classLoader.loadClass(string2);
        }
    }
}

