/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.android.wrtckit.controller;

import android.content.Context;
import android.content.Intent;
import android.media.AudioManager;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.common.gmacs.utils.GmacsEnvi;
import com.common.gmacs.utils.GmacsUtils;
import com.common.gmacs.utils.TimeUtil;
import com.common.gmacs.utils.ToastUtil;
import com.wuba.android.wrtckit.R;
import com.wuba.android.wrtckit.WRTCRoomActivity;
import com.wuba.android.wrtckit.controller.WRTCManager;
import com.wuba.android.wrtckit.model.State;
import com.wuba.android.wrtckit.view.AudioConnectedFragment;
import com.wuba.android.wrtckit.view.PercentFrameLayout;
import com.wuba.android.wrtckit.view.VideoConnectedFragment;
import org.wrtc.RendererCommon;
import org.wrtc.SurfaceViewRenderer;

public final class FloatingViewController
implements View.OnClickListener,
View.OnTouchListener,
WRTCManager.StateSubscriber {
    private static final int LOCAL_HEIGHT_CONNECTED = 25;
    private static final int LOCAL_WIDTH_CONNECTED = 25;
    private static final int LOCAL_X_CONNECTED = 72;
    private static final int LOCAL_Y_CONNECTED = 3;
    private TextView chatTimeText;
    private boolean hasDragged;
    private boolean isVideoCall;
    private float lastX;
    private float lastY;
    private SurfaceViewRenderer localRender;
    private Context mContext;
    private int mTouchGap = GmacsUtils.dipToPixel((float)3.0f);
    private FrameLayout mWholeView;
    private WindowManager mWindowManager;
    private SurfaceViewRenderer remoteRender;

    public FloatingViewController(Context context) {
        this.mContext = context;
        this.mWindowManager = (WindowManager)context.getSystemService("window");
    }

    private void dragTo(float f2, float f3) {
        if (this.mWholeView != null) {
            WindowManager.LayoutParams layoutParams = (WindowManager.LayoutParams)this.mWholeView.getLayoutParams();
            layoutParams.x = (int)((float)layoutParams.x + f2);
            layoutParams.y = (int)((float)layoutParams.y + f3);
            this.mWindowManager.updateViewLayout((View)this.mWholeView, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void positionRestore() {
        if (this.mWholeView != null) {
            WindowManager.LayoutParams layoutParams = (WindowManager.LayoutParams)this.mWholeView.getLayoutParams();
            layoutParams.x = (double)layoutParams.x > (double)GmacsEnvi.screenWidth * 0.5 - (double)layoutParams.width * 0.5 ? GmacsEnvi.screenWidth : 0;
            this.mWindowManager.updateViewLayout((View)this.mWholeView, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    private void removePoppedViewAndClear() {
        if (this.mWindowManager != null && this.mWholeView != null) {
            if (this.localRender != null) {
                this.localRender.release();
                this.localRender = null;
            }
            if (this.remoteRender != null) {
                this.remoteRender.release();
                this.remoteRender = null;
            }
            this.mWholeView.setOnClickListener(null);
            this.mWholeView.setOnTouchListener(null);
            this.mWindowManager.removeView((View)this.mWholeView);
        }
    }

    public void onAudioConnected() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onAudioModeChanged(int n2) {
        if (WRTCManager.getInstance().getCurrentState() == null) return;
        switch (n2) {
            case 2: {
                WRTCManager.getInstance().onToggleMicMode();
            }
            default: {
                return;
            }
            case 1: 
        }
        ToastUtil.showToast((CharSequence)GmacsEnvi.appContext.getString(R.string.audio_mode_speaker));
    }

    public void onCameraSwitch(boolean bl) {
    }

    public void onChatTimeChanged(int n2) {
        if (this.chatTimeText != null) {
            this.chatTimeText.setText((CharSequence)TimeUtil.secondsToChatTime((int)n2));
        }
    }

    public void onClick(View view) {
        view = new Intent(this.mContext, WRTCRoomActivity.class);
        view.addFlags(0x10000000);
        view.putExtra("fromFloatingView", true);
        this.mContext.startActivity((Intent)view);
        this.removePoppedViewAndClear();
    }

    public void onError(String string2) {
        ((AudioManager)this.mContext.getSystemService("audio")).abandonAudioFocus(null);
        this.removePoppedViewAndClear();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onFinishedWithState(State state) {
        switch (state.status) {
            case 0: {
                if (state.isSelfAction) {
                    ToastUtil.showToast((CharSequence)GmacsEnvi.appContext.getString(R.string.toast_chat_cancel));
                    break;
                }
                ToastUtil.showToast((CharSequence)GmacsEnvi.appContext.getString(R.string.toast_chat_cancel_remote));
                break;
            }
            case 1: {
                if (!state.isSelfAction) {
                    ToastUtil.showToast((CharSequence)GmacsEnvi.appContext.getString(R.string.toast_chat_cancel_remote));
                    break;
                }
                ToastUtil.showToast((CharSequence)GmacsEnvi.appContext.getString(R.string.toast_chat_cancel));
                break;
            }
            case 3: {
                if (state.isSelfAction) {
                    ToastUtil.showToast((CharSequence)GmacsEnvi.appContext.getString(R.string.toast_chat_cancel));
                    break;
                }
                ToastUtil.showToast((CharSequence)GmacsEnvi.appContext.getString(R.string.toast_chat_hang_up_remote));
                break;
            }
            case 11: {
                ToastUtil.showToast((CharSequence)GmacsEnvi.appContext.getString(R.string.toast_callee_unsupported));
                break;
            }
        }
        AudioConnectedFragment.sPreferAudioMode = 2;
        VideoConnectedFragment.isLocalRendererLarger = false;
        ((AudioManager)this.mContext.getSystemService("audio")).abandonAudioFocus(null);
        this.removePoppedViewAndClear();
    }

    public void onJoinedToRoom() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onNetworkStats(int n2) {
        switch (n2) {
            default: {
                return;
            }
            case 1: 
        }
        ToastUtil.showToast((CharSequence)GmacsEnvi.appContext.getString(R.string.network_state));
    }

    /*
     * Unable to fully structure code
     */
    public boolean onTouch(View var1_1, MotionEvent var2_2) {
        var3_3 = true;
        switch (var2_2.getAction()) lbl-1000:
        // 5 sources

        {
            default: lbl-1000:
            // 2 sources

            {
                while (true) {
                    var3_3 = false;
lbl6:
                    // 2 sources

                    return var3_3;
                }
            }
            case 0: {
                this.lastX = var2_2.getRawX();
                this.lastY = var2_2.getRawY();
                ** GOTO lbl-1000
            }
            case 2: {
                if (this.lastX == 0.0f || this.lastY == 0.0f) ** GOTO lbl-1000
                var4_4 = var2_2.getRawX();
                var5_5 = var2_2.getRawY();
                var6_6 = var4_4 - this.lastX;
                var7_7 = var5_5 - this.lastY;
                this.lastX = var4_4;
                this.lastY = var5_5;
                this.dragTo(var6_6, var7_7);
                if (!(var6_6 * var6_6 + var7_7 * var7_7 > (float)this.mTouchGap)) ** GOTO lbl-1000
                this.hasDragged = true;
                ** GOTO lbl-1000
            }
            case 1: 
            case 3: 
        }
        ** while (!this.hasDragged)
lbl26:
        // 1 sources

        this.positionRestore();
        this.hasDragged = false;
        ** while (true)
    }

    public void onVideoConnected() {
    }

    public void onVideoConnectedSwitchToAudioConnectedLocal() {
    }

    public void onVideoConnectedSwitchToAudioConnectedRemote() {
        this.isVideoCall = false;
        WindowManager.LayoutParams layoutParams = (WindowManager.LayoutParams)this.mWholeView.getLayoutParams();
        this.mWindowManager.removeView((View)this.mWholeView);
        this.mWholeView.setOnClickListener(null);
        this.mWholeView.setOnTouchListener(null);
        this.mWholeView = (FrameLayout)View.inflate((Context)this.mContext, (int)R.layout.floating_audio_layout, null);
        if (Build.VERSION.SDK_INT >= 21) {
            this.mWholeView.setElevation(10.0f);
        }
        this.chatTimeText = (TextView)this.mWholeView.findViewById(R.id.chat_time_text);
        layoutParams.width = GmacsUtils.dipToPixel((float)64.0f);
        layoutParams.height = GmacsUtils.dipToPixel((float)84.5f);
        this.mWindowManager.addView((View)this.mWholeView, (ViewGroup.LayoutParams)layoutParams);
        this.mWholeView.setOnClickListener((View.OnClickListener)this);
        this.mWholeView.setOnTouchListener((View.OnTouchListener)this);
        ToastUtil.showToast((CharSequence)GmacsEnvi.appContext.getString(R.string.toast_chat_to_audio_connected));
    }

    public void onVideoInvitingSwitchToAudioConnectedRemote() {
    }

    public void onVideoInvitingSwitchToAudioInvitingLocal() {
    }

    public void onVideoInvitingSwitchToAudioInvitingRemote() {
        ToastUtil.showToast((CharSequence)GmacsEnvi.appContext.getString(R.string.toast_chat_to_audio_inviting));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void show() {
        State state = WRTCManager.getInstance().getCurrentState();
        if (state == null) {
            this.removePoppedViewAndClear();
            return;
        }
        WRTCManager.getInstance().setWRTCStateSubscriber((WRTCManager.StateSubscriber)this);
        this.isVideoCall = state.isVideoCall;
        int n2 = Build.VERSION.SDK_INT >= 19 ? 2005 : 2002;
        WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams(-1, -1, n2, 327976, -3);
        layoutParams.gravity = 51;
        if (this.isVideoCall) {
            this.mWholeView = (FrameLayout)View.inflate((Context)this.mContext, (int)R.layout.floating_render_layout, null);
            if (Build.VERSION.SDK_INT >= 21) {
                this.mWholeView.setElevation(10.0f);
            }
            this.localRender = (SurfaceViewRenderer)this.mWholeView.findViewById(R.id.local_video_view);
            this.remoteRender = (SurfaceViewRenderer)this.mWholeView.findViewById(R.id.remote_video_view);
            state = (PercentFrameLayout)this.mWholeView.findViewById(R.id.local_video_layout);
            this.remoteRender.setScalingType(RendererCommon.ScalingType.SCALE_ASPECT_FILL);
            state.setPosition(72.0f, 3.0f, 25.0f, 25.0f);
            this.localRender.setScalingType(RendererCommon.ScalingType.SCALE_ASPECT_FIT);
            layoutParams.width = (int)((float)GmacsEnvi.screenWidth * 0.25f);
            layoutParams.height = (int)((float)GmacsEnvi.screenHeight * 0.25f);
            layoutParams.x = (int)((float)GmacsEnvi.screenWidth * 0.72f);
            layoutParams.y = GmacsEnvi.statusBarHeight;
            WRTCManager.getInstance().changeRender(this.localRender, this.remoteRender);
            if (VideoConnectedFragment.isLocalRendererLarger) {
                WRTCManager.getInstance().switchRender();
            }
            this.localRender.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (FloatingViewController.this.localRender != null) {
                        FloatingViewController.this.localRender.setVisibility(8);
                    }
                }
            }, 3000L);
            this.remoteRender.setMirror(false);
        } else {
            this.mWholeView = (FrameLayout)View.inflate((Context)this.mContext, (int)R.layout.floating_audio_layout, null);
            if (Build.VERSION.SDK_INT >= 21) {
                this.mWholeView.setElevation(10.0f);
            }
            this.chatTimeText = (TextView)this.mWholeView.findViewById(R.id.chat_time_text);
            layoutParams.width = GmacsUtils.dipToPixel((float)64.0f);
            layoutParams.height = GmacsUtils.dipToPixel((float)84.5f);
            layoutParams.x = GmacsEnvi.screenWidth;
            layoutParams.y = GmacsEnvi.statusBarHeight;
            if (state.audioMode != 3) {
                AudioConnectedFragment.sPreferAudioMode = state.audioMode;
                if (state.audioMode == 2) {
                    WRTCManager.getInstance().onToggleMicMode();
                }
            }
        }
        this.mWholeView.setOnTouchListener((View.OnTouchListener)this);
        this.mWholeView.setOnClickListener((View.OnClickListener)this);
        this.mWindowManager.addView((View)this.mWholeView, (ViewGroup.LayoutParams)layoutParams);
    }
}

