/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.api.filter;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import com.wuba.api.filter.BaseFilterDes;
import com.wuba.api.filter.GLFrame;
import com.wuba.api.filter.GLParam;
import com.wuba.api.filter.GLSLRender;
import com.wuba.api.filter.WImage;
import com.wuba.api.filter.common.LogUtil;
import com.wuba.api.filter.common.RendererUtils;
import com.wuba.api.filter.filters.FaceDetectFilter;
import java.util.ArrayList;

public class BaseFilter {
    public String fragmentShaderString;
    private long glFilterId = 0L;
    protected int glsl_programID;
    protected BaseFilterDes mBaseFilterDes;
    protected ArrayList<GLParam> mGLParamList = new ArrayList();
    protected boolean mIsGPU = true;
    protected boolean mIsPreviewFilter;
    protected BaseFilter mNextFilter;
    protected int mProgramIds;
    protected int[] mTextureIndexMap;

    static {
        System.loadLibrary("wb_filter_sdk");
    }

    public BaseFilter(BaseFilterDes baseFilterDes, int n2) {
        this.mBaseFilterDes = baseFilterDes;
        this.glsl_programID = n2;
    }

    public WImage ApplyFilter(WImage wImage) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void ApplyGLSLFilter() {
        if (this.glsl_programID >= 0) {
            this.nativeInitial(0, this.glsl_programID);
        } else {
            this.nativeInitial2(0, this.fragmentShaderString.getBytes());
        }
        this.nativeInitial(0, this.glsl_programID);
        this.mProgramIds = this.nativeApplyFilter();
        int n2 = 0;
        while (n2 < this.mGLParamList.size()) {
            this.mGLParamList.get(n2).initialParams(this.mProgramIds);
            ++n2;
        }
        return;
    }

    public void ApplyGLSLFilter(boolean bl) {
        this.mIsPreviewFilter = bl;
        if (this.mProgramIds <= 0) {
            this.ApplyGLSLFilter();
        }
        if (this.mNextFilter != null) {
            this.mNextFilter.ApplyGLSLFilter(bl);
        }
    }

    public void ClearGLSL() {
        for (int i2 = 0; i2 < this.mGLParamList.size(); ++i2) {
            this.mGLParamList.get(i2).clear();
        }
        this.nativeClear();
        this.mProgramIds = 0;
        if (this.mNextFilter != null) {
            this.mNextFilter.ClearGLSL();
        }
    }

    protected void OnDrawFrameGLSL() {
        GLES20.glUseProgram((int)this.mProgramIds);
        RendererUtils.checkGlError("glUseProgram:" + this.mProgramIds);
        for (int i2 = 0; i2 < this.mGLParamList.size(); ++i2) {
            this.mGLParamList.get(i2).setParams(this.mProgramIds);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void RendProcessImage(WImage wImage, GLFrame gLFrame) {
        float[] fArray;
        int[] nArray;
        int n2;
        int n3;
        long l2 = System.currentTimeMillis();
        if (this instanceof FaceDetectFilter.FaceDetectBaseFilter) {
            int n4;
            n3 = wImage.getWidth();
            int n5 = n3 > (n2 = wImage.getHeight()) ? n3 : n2;
            int n6 = n3 < n2 ? n3 : n2;
            int n7 = n4 = n6 / 640;
            if (n4 < 1) {
                n7 = 1;
            }
            if ((float)n5 / (float)n6 < 2.5f) {
                Bitmap bitmap = Bitmap.createBitmap((int)(n3 / n7), (int)(n2 / n7), (Bitmap.Config)Bitmap.Config.RGB_565);
                wImage.ToBitmap(bitmap);
                ((FaceDetectFilter.FaceDetectBaseFilter)this).initial(bitmap, 0);
                bitmap.recycle();
            }
        }
        nArray[0] = 1;
        (nArray = new int[2])[1] = 1;
        GLSLRender.nativePreprocessJepg(wImage, nArray);
        int[] nArray2 = new int[1];
        GLES20.glGenTextures((int)nArray2.length, (int[])nArray2, (int)0);
        float[] fArray2 = fArray = new float[9];
        fArray[0] = 1.0f;
        fArray2[1] = 0.0f;
        fArray2[2] = 0.0f;
        fArray2[3] = 0.0f;
        fArray2[4] = 1.0f;
        fArray2[5] = 0.0f;
        fArray2[6] = 0.0f;
        fArray2[7] = 0.0f;
        fArray2[8] = 1.0f;
        nArray3[0] = 0;
        (nArray3 = new int[2])[1] = 0;
        n2 = 0;
        while (true) {
            if (n2 >= nArray[0]) {
                this.setGlobalTextureMatrix(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f});
                GLES20.glDeleteTextures((int)nArray2.length, (int[])nArray2, (int)0);
                LogUtil.d(this, "RendProcessImage:" + (System.currentTimeMillis() - l2));
                return;
            }
            for (n3 = 0; n3 < nArray[1]; ++n3) {
                int[] nArray3;
                GLSLRender.nativePickJepgToTexture(wImage, n2, n3, nArray[0], nArray[1], nArray2[0], nArray3);
                fArray[0] = (float)nArray3[0] / (float)wImage.getWidth();
                fArray[4] = (float)nArray3[1] / (float)wImage.getHeight();
                fArray[2] = (float)n2 / (float)nArray[0];
                fArray[5] = (float)n3 / (float)nArray[1];
                this.setGlobalTextureMatrix(fArray);
                this.RenderProcess(nArray2[0], nArray3[0], nArray3[1], -1, 0.0, gLFrame);
                GLSLRender.nativePushJepgFromTexture(wImage, n2, n3, nArray[0], nArray[1]);
            }
            ++n2;
        }
    }

    public void RenderProcess(int n2, int n3, int n4, int n5, double d2, GLFrame gLFrame) {
        this.RenderProcess(n2, n3, n4, n3, n4, n5, d2, gLFrame);
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public void RenderProcess(int n2, int n3, int n4, int n5, int n6, int n7, double d2, GLFrame gLFrame) {
        if (gLFrame == null) {
            return;
        }
        GLFrame gLFrame2 = gLFrame;
        GLFrame gLFrame3 = gLFrame;
        BaseFilter baseFilter = this;
        while (baseFilter != null) {
            if (baseFilter.mNextFilter == null) {
                gLFrame3.bindFrame(n7, n5, n6, d2);
            } else {
                gLFrame3.bindFrame(-1, n5, n6, d2);
            }
            RendererUtils.checkGlError("before OnDrawFrameGLSL");
            baseFilter.OnDrawFrameGLSL();
            if (baseFilter.mTextureIndexMap != null && baseFilter.mTextureIndexMap.length > 0) {
                for (int i2 = 0; i2 < baseFilter.mTextureIndexMap.length; ++i2) {
                    if (baseFilter.mTextureIndexMap[i2] < 0) {
                        baseFilter.setTextureParam(n2, i2);
                        continue;
                    }
                    baseFilter.setTextureParam(this.findFrame((GLFrame)gLFrame, (int)baseFilter.mTextureIndexMap[i2]).texture[0], i2);
                }
            }
            RendererUtils.checkGlError("before nativeRenderTexture");
            if (baseFilter == this) {
                baseFilter.nativeRenderTexture(n2, n3, n4);
            } else {
                baseFilter.nativeRenderTexture(gLFrame2.getTextureId(), n3, n4);
                gLFrame2 = gLFrame3;
            }
            RendererUtils.checkGlError("after nativeRenderTexture");
            baseFilter = baseFilter.mNextFilter;
            if (baseFilter == null) continue;
            if (gLFrame3.nextGLFrame == null) {
                gLFrame3.nextGLFrame = new GLFrame();
            }
            gLFrame3 = gLFrame3.nextGLFrame;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BaseFilter addParam(GLParam gLParam) {
        if (gLParam == null) {
            return this;
        }
        for (int i2 = 0; i2 < this.mGLParamList.size(); ++i2) {
            if (!gLParam.name.equals(this.mGLParamList.get((int)i2).name)) continue;
            gLParam.handle = this.mGLParamList.remove((int)i2).handle;
            this.mGLParamList.add(gLParam);
            return this;
        }
        this.mGLParamList.add(gLParam);
        return this;
    }

    public void clearNext() {
        this.mNextFilter = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) return false;
        if (!(object instanceof BaseFilter)) {
            return false;
        }
        object = (BaseFilter)object;
        return this.mBaseFilterDes.equals(((BaseFilter)object).mBaseFilterDes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    GLFrame findFrame(GLFrame gLFrame, int n2) {
        while (gLFrame != null) {
            if (n2 == 0) {
                return gLFrame;
            }
            gLFrame = gLFrame.nextGLFrame;
            --n2;
        }
        return null;
    }

    public BaseFilter getLastFilter() {
        BaseFilter baseFilter = this;
        while (baseFilter.mNextFilter != null) {
            baseFilter = baseFilter.mNextFilter;
        }
        return baseFilter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GLParam getParam(String object) {
        int n2 = 0;
        while (n2 < this.mGLParamList.size()) {
            if (((String)object).equals(this.mGLParamList.get((int)n2).name)) {
                return this.mGLParamList.get(n2);
            }
            ++n2;
        }
        return null;
    }

    public boolean isGPUProcess() {
        return this.mIsGPU;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isNormal() {
        if (this.glsl_programID != GLSLRender.FILTER_SHADER_NONE) return false;
        if (this.mNextFilter != null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSameFilter(BaseFilterDes baseFilterDes) {
        if (this.mBaseFilterDes == null) return false;
        if (baseFilterDes != null) return this.mBaseFilterDes.equals(baseFilterDes);
        return false;
    }

    protected native int nativeApplyFilter();

    protected native boolean nativeClear();

    protected native boolean nativeInitial(int var1, int var2);

    protected native boolean nativeInitial2(int var1, byte[] var2);

    protected native boolean nativeRenderTexture(int var1, int var2, int var3);

    protected native void nativeSetBrightness(float var1);

    public native boolean nativeSetGlobalTextureMatrix(float[] var1);

    public native boolean nativeSetRotationAndFlip(int var1, int var2, int var3);

    public native boolean nativeUpdateMatrix(float[] var1);

    public native boolean nativeUpdateModelMatrix(float[] var1);

    public native boolean nativeUpdateTexCoord(float[] var1);

    protected void setGlobalTextureMatrix(float[] fArray) {
        this.nativeSetGlobalTextureMatrix(fArray);
        if (this.mNextFilter != null) {
            this.mNextFilter.setGlobalTextureMatrix(fArray);
        }
    }

    public void setNextFilter(BaseFilter baseFilter, int[] nArray) {
        this.mNextFilter = baseFilter;
        if (baseFilter != null) {
            baseFilter.mTextureIndexMap = nArray;
        }
    }

    public void setTextureParam(int n2, int n3) {
        int n4 = n3 + 2;
        String string2 = "inputImageTexture" + n4;
        n3 = GLES20.glGetUniformLocation((int)this.mProgramIds, (String)string2);
        if (n3 >= 0) {
            GLES20.glActiveTexture((int)(33984 + n4));
            GLES20.glBindTexture((int)3553, (int)n2);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9728.0f);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLES20.glUniform1i((int)n3, (int)n4);
        }
    }

    public void setbrightness(int n2) {
        this.nativeSetBrightness((float)(0.5 + (double)((float)(n2 + 100) / 200.0f)));
    }
}

