/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.api.filter;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.os.Build;
import android.os.Process;
import android.util.Log;
import com.wuba.ColorTemperatureFilter;
import com.wuba.GroupInfos;
import com.wuba.MyFilterExceptipon;
import com.wuba.PhotoSimple;
import com.wuba.api.filter.BaseFilter;
import com.wuba.api.filter.BaseFilterDes;
import com.wuba.api.filter.FilterAlgorithm;
import com.wuba.api.filter.FilterManager;
import com.wuba.api.filter.GLFrame;
import com.wuba.api.filter.GLSLRender;
import com.wuba.api.filter.JsonUtils;
import com.wuba.api.filter.SDKConfig;
import com.wuba.api.filter.WImage;
import com.wuba.api.filter.common.BitmapSimpleUtils;
import com.wuba.api.filter.common.Exif;
import com.wuba.api.filter.common.LogUtil;
import com.wuba.api.filter.common.PhoneProperty;
import com.wuba.api.filter.common.RendererUtils;
import com.wuba.api.filter.filters.Curve2DFilter;
import com.wuba.api.filter.filters.DoubleBeautysFilter;
import com.wuba.api.filter.filters.DoubleBeautysSkinBlurFilter;
import com.wuba.api.filter.filters.FaceBeautyFilter;
import com.wuba.api.filter.filters.FaceDetectFilter;
import com.wuba.api.filter.filters.LensFilter;
import com.wuba.api.filter.filters.NaturalBeautyFilter;
import com.wuba.fileencrypt.IOUtils;
import com.wuba.filter.R;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

public class ImageProcess
extends Thread {
    private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    private static final int EGL_OPENGL_ES2_BIT = 4;
    public static final int EffECTID = 2000;
    private static ArrayList<Integer> EffectIDArray;
    public static final int FOOD_EFFECT = 2002;
    private static GroupInfos GroupInfomations;
    public static final int QUEUE_LIMIT = 6;
    private final int[] CONFIG_SPEC;
    private final String TAG = this.getClass().getSimpleName();
    private Context mContext;
    private EGL10 mEgl;
    private EGLConfig mEglConfig;
    private EGLContext mEglContext;
    private EGLDisplay mEglDisplay;
    private EGLSurface mEglSurface;
    private boolean mHasInit;
    private GLFrame mPictureGLFrame;
    private ArrayList<ImageProcessRequest> mQueue;
    private volatile boolean mStop;

    public ImageProcess(Context context) {
        this.CONFIG_SPEC = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12344};
        this.mPictureGLFrame = new GLFrame();
        this.mContext = context;
        this.mQueue = new ArrayList();
        FilterManager.main_Context = this.mContext;
        this.start();
    }

    private EGLConfig chooseConfig(EGL10 eGL10, EGLDisplay eGLDisplay) {
        int[] nArray = new int[1];
        if (!eGL10.eglChooseConfig(eGLDisplay, this.CONFIG_SPEC, null, 0, nArray)) {
            throw new MyFilterExceptipon(30002, (Throwable)new RuntimeException("failed to eglMakeCurrent"));
        }
        int n2 = nArray[0];
        if (n2 <= 0) {
            throw new MyFilterExceptipon(30002, (Throwable)new IllegalArgumentException("No configs match configSpec"));
        }
        EGLConfig[] eGLConfigArray = new EGLConfig[n2];
        if (!eGL10.eglChooseConfig(eGLDisplay, this.CONFIG_SPEC, eGLConfigArray, n2, nArray)) {
            throw new MyFilterExceptipon(30002, (Throwable)new IllegalArgumentException("eglChooseConfig#2 failed"));
        }
        return eGLConfigArray[0];
    }

    private void doInitGL() {
        this.mEgl = (EGL10)EGLContext.getEGL();
        this.mEglDisplay = this.mEgl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (this.mEglDisplay == EGL10.EGL_NO_DISPLAY) {
            throw new MyFilterExceptipon(30002, (Throwable)new RuntimeException("eglGetDisplay failed"));
        }
        int[] nArray = new int[2];
        if (!this.mEgl.eglInitialize(this.mEglDisplay, nArray)) {
            throw new MyFilterExceptipon(30002, (Throwable)new RuntimeException("eglInitialize failed"));
        }
        Log.v((String)this.TAG, (String)("EGL version: " + nArray[0] + '.' + nArray[1]));
        this.mEglConfig = this.chooseConfig(this.mEgl, this.mEglDisplay);
        this.mEglContext = this.mEgl.eglCreateContext(this.mEglDisplay, this.mEglConfig, EGL10.EGL_NO_CONTEXT, new int[]{12440, 2, 12344});
        if (this.mEglContext == null || this.mEglContext == EGL10.EGL_NO_CONTEXT) {
            throw new MyFilterExceptipon(30002, (Throwable)new RuntimeException("failed to createContext"));
        }
        try {
            this.mEglSurface = this.mEgl.eglCreatePbufferSurface(this.mEglDisplay, this.mEglConfig, new int[]{12375, 2, 12374, 2, 12344});
            if (this.mEglSurface == null || this.mEglSurface == EGL10.EGL_NO_SURFACE) {
                throw new MyFilterExceptipon(30002, (Throwable)new RuntimeException("failed to createWindowSurface"));
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new MyFilterExceptipon(30008, (Throwable)new RuntimeException("failed to createWindowSurface"));
        }
        if (!this.mEgl.eglMakeCurrent(this.mEglDisplay, this.mEglSurface, this.mEglSurface, this.mEglContext)) {
            throw new MyFilterExceptipon(30002, (Throwable)new RuntimeException("failed to eglMakeCurrent"));
        }
    }

    private void doRelease() {
        this.mPictureGLFrame.clear();
        this.mEgl.eglDestroySurface(this.mEglDisplay, this.mEglSurface);
        this.mEgl.eglDestroyContext(this.mEglDisplay, this.mEglContext);
        this.mEgl.eglMakeCurrent(this.mEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
        this.mEgl.eglTerminate(this.mEglDisplay);
        this.mEglSurface = null;
        this.mEglContext = null;
        this.mEglDisplay = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static BaseFilterDes getFilterDes(int n2) {
        BaseFilterDes baseFilterDes;
        switch (n2) {
            default: {
                baseFilterDes = new LensFilter();
                baseFilterDes.filter_tag = "1101";
                baseFilterDes.iconName = "native_mini";
                break;
            }
            case 1000: {
                baseFilterDes = new LensFilter();
                baseFilterDes.filter_tag = "1101";
                baseFilterDes.iconName = "native_mini";
                break;
            }
            case 1016: {
                baseFilterDes = FaceBeautyFilter.createBornBeauty();
                baseFilterDes.filter_tag = "1101";
                baseFilterDes.iconName = "tianshenglizhi_mini";
                break;
            }
            case 1001: {
                baseFilterDes = BaseFilterDes.createBeautyFilter();
                baseFilterDes.filter_tag = "1106";
                baseFilterDes.iconName = "castle_mini";
                break;
            }
            case 1002: {
                baseFilterDes = DoubleBeautysSkinBlurFilter.createSweetPleasantFilter();
                baseFilterDes.filter_tag = "0034";
                baseFilterDes.iconName = "sweetpleasant_mini";
                break;
            }
            case 1003: {
                baseFilterDes = Curve2DFilter.CreateWeicoFilm();
                baseFilterDes.filter_tag = "0053";
                baseFilterDes.iconName = "danya_mini";
                break;
            }
            case 1017: {
                baseFilterDes = FaceBeautyFilter.createLightWite();
                baseFilterDes.filter_tag = "1104";
                baseFilterDes.iconName = "castle_mini";
                break;
            }
            case 1004: {
                baseFilterDes = new NaturalBeautyFilter();
                baseFilterDes.filter_tag = "1205";
                baseFilterDes.iconName = "meifu_mini";
                break;
            }
            case 1005: {
                baseFilterDes = DoubleBeautysFilter.createSmoothSkinFilter();
                baseFilterDes.filter_tag = "1206";
                baseFilterDes.iconName = "meifu_mini";
                break;
            }
            case 1007: {
                baseFilterDes = Curve2DFilter.CreateAmaroFilter();
                baseFilterDes.filter_tag = "0006";
                baseFilterDes.iconName = "colin_mini";
                break;
            }
            case 1008: {
                baseFilterDes = Curve2DFilter.CreateQQTonnychurch();
                baseFilterDes.filter_tag = "0052";
                baseFilterDes.iconName = "shishang_mini";
                break;
            }
            case 1009: {
                baseFilterDes = BaseFilterDes.createABaoFilter();
                baseFilterDes.filter_tag = "0036";
                baseFilterDes.iconName = "abao_mini";
                break;
            }
            case 1010: {
                baseFilterDes = BaseFilterDes.createWarmFilter();
                baseFilterDes.filter_tag = "1203";
                baseFilterDes.iconName = "beautywarm_mini";
                break;
            }
            case 1011: {
                baseFilterDes = BaseFilterDes.createLittleSunShine();
                baseFilterDes.filter_tag = "0051";
                baseFilterDes.iconName = "yangguang_mini";
                break;
            }
            case 1012: {
                baseFilterDes = DoubleBeautysSkinBlurFilter.createDepthWhiteningFilter();
                baseFilterDes.filter_tag = "0032";
                baseFilterDes.iconName = "depthwhitening_mini";
                break;
            }
            case 1013: {
                baseFilterDes = DoubleBeautysFilter.createFreshBeautyFilter();
                baseFilterDes.filter_tag = "0035";
                baseFilterDes.iconName = "freshbeauty_mini";
                break;
            }
            case 1014: {
                baseFilterDes = Curve2DFilter.CreateTonnyTwoPass();
                baseFilterDes.filter_tag = "0054";
                baseFilterDes.iconName = "huanxiang_mini";
                break;
            }
            case 1015: {
                baseFilterDes = Curve2DFilter.CreateTonnyNostalgic();
                baseFilterDes.filter_tag = "0055";
                baseFilterDes.iconName = "gudian_mini";
            }
        }
        baseFilterDes.id = n2;
        return baseFilterDes;
    }

    private Bitmap getFlashBitmap(int n2) {
        return BitmapSimpleUtils.decodeBitmap(FilterManager.main_Context, n2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static GroupInfos getSupportedEffects(Context object) {
        Object object2;
        int n2;
        void var0_2;
        block9: {
            if (object == null || GroupInfomations != null) {
                if (object == null) {
                    LogUtil.d("ImageProcess", "getSupportedEffect context is null");
                }
                GroupInfos groupInfos = GroupInfomations;
                return var0_2;
            }
            Object object3 = null;
            SDKConfig sDKConfig = JsonUtils.getInstance().getSDKConfig((Context)object, R.raw.sdkconfig);
            LogUtil.d("ImageProcess", "getSupportedEffect getSDKConfig" + sDKConfig.toString());
            n2 = 0;
            while (true) {
                object2 = object3;
                if (n2 >= sDKConfig.getPluginArray().size()) break block9;
                object2 = sDKConfig.getPluginArray().get(n2);
                if ("effect".equalsIgnoreCase(((SDKConfig.PluginInfo)object2).getPluginName())) {
                    break;
                }
                ++n2;
            }
            for (n2 = 0; n2 < ((SDKConfig.PluginInfo)object2).getGroupInfoArray().size(); ++n2) {
                object3 = ((SDKConfig.PluginInfo)object2).getGroupInfoArray().get(n2);
                if (!"portrait".equalsIgnoreCase(((SDKConfig.GroupInfo)object3).getGroupName())) continue;
                object2 = ((SDKConfig.GroupInfo)object3).getEffectIdArray();
                break block9;
            }
            object2 = null;
        }
        GroupInfomations = JsonUtils.getInstance().readJsonFromFile(new GroupInfos(), (Context)object, R.raw.groupinfos);
        if (object2 != null && GroupInfomations != null && ImageProcess.GroupInfomations.groupInfoArray.size() > 0) {
            GroupInfos.GroupInfo groupInfo = ImageProcess.GroupInfomations.groupInfoArray.get(0);
            n2 = 0;
            while (n2 < groupInfo.filterInfoArray.size()) {
                boolean bl;
                int n3;
                block10: {
                    for (n3 = 0; n3 < ((ArrayList)object2).size(); ++n3) {
                        if (groupInfo.filterInfoArray.get((int)n2).filterId != (Integer)((ArrayList)object2).get(n3)) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
                n3 = n2;
                if (!bl) {
                    groupInfo.filterInfoArray.remove(n2);
                    n3 = n2 - 1;
                }
                n2 = n3 + 1;
            }
        }
        GroupInfos groupInfos = GroupInfomations;
        return var0_2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Bitmap makeEffect(Bitmap object, int n2) {
        switch (n2) {
            default: {
                return null;
            }
            case 2000: {
                WImage wImage = WImage.Bitmap2WImage((Bitmap)object);
                object.recycle();
                WImage wImage2 = new WImage(wImage.getWidth(), wImage.getHeight());
                FilterAlgorithm.nativeFilterHDR(wImage, wImage2, 0.3f, 80.0f);
                wImage.Dispose();
                object = Bitmap.createBitmap((int)wImage.getWidth(), (int)wImage.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                wImage2.ToBitmap((Bitmap)object);
                wImage2.Dispose();
                return object;
            }
            case 2001: {
                WImage wImage = WImage.Bitmap2WImage((Bitmap)object);
                FilterAlgorithm.nativeFilterFlash(wImage, this.getFlashBitmap(R.raw.flash));
                wImage.ToBitmap((Bitmap)object);
                wImage.Dispose();
                return object;
            }
            case 2002: {
                return null;
            }
            case 2004: {
                WImage wImage = WImage.Bitmap2WImage((Bitmap)object);
                object.recycle();
                WImage wImage3 = new WImage(wImage.getWidth(), wImage.getHeight());
                FilterAlgorithm.nativeFilterPeople(wImage, wImage3, this.getFlashBitmap(R.raw.people));
                wImage.Dispose();
                object = Bitmap.createBitmap((int)wImage.getWidth(), (int)wImage.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                wImage3.ToBitmap((Bitmap)object);
                wImage3.Dispose();
                return object;
            }
            case 2005: 
        }
        this.doInitGL();
        object = PhotoSimple.create((Bitmap)object);
        PhotoSimple photoSimple = PhotoSimple.create(((PhotoSimple)object).width(), ((PhotoSimple)object).height());
        RendererUtils.createFrame();
        ColorTemperatureFilter colorTemperatureFilter = new ColorTemperatureFilter();
        colorTemperatureFilter.setScale(0.1f, 0.1f);
        colorTemperatureFilter.process((PhotoSimple)object, photoSimple);
        ((PhotoSimple)object).clear();
        object = photoSimple.save();
        RendererUtils.deleteFrame();
        photoSimple.clear();
        this.doRelease();
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Bitmap makeFilter(Bitmap bitmap, int n2, int n3, BaseFilter baseFilter, int n4, int n5, int n6) {
        long l2;
        block12: {
            int[] nArray;
            block11: {
                block10: {
                    block9: {
                        LogUtil.d(this, "makeFilter begin");
                        if (bitmap == null) {
                            return null;
                        }
                        l2 = System.currentTimeMillis();
                        baseFilter.ApplyGLSLFilter(false);
                        if (Build.VERSION.SDK_INT >= 14 && n6 == 1002) {
                            baseFilter.nativeUpdateMatrix(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
                        }
                        if (!baseFilter.isGPUProcess()) break block9;
                        nArray = new int[1];
                        GLES20.glGenTextures((int)nArray.length, (int[])nArray, (int)0);
                        if (!(baseFilter instanceof FaceDetectFilter.FaceDetectBaseFilter)) break block10;
                        if (n2 == 0 && n3 == 0) {
                            n5 = 1;
                            n4 = n3;
                            n3 = n2;
                            n2 = n5;
                        } else {
                            bitmap = BitmapSimpleUtils.rotateAndFlipY(bitmap, n2, n3, 0);
                            n3 = 0;
                            n4 = 0;
                            n2 = 0;
                        }
                        ((FaceDetectFilter.FaceDetectBaseFilter)baseFilter).initial(bitmap, 0);
                        n6 = n3;
                        n5 = n2;
                        break block11;
                    }
                    if (n2 != 0 || n3 != 0) {
                        bitmap = BitmapSimpleUtils.rotateAndFlipY(bitmap, n2, n3, 0);
                    }
                    WImage wImage = WImage.Bitmap2WImage(bitmap);
                    baseFilter.ApplyFilter(wImage);
                    wImage.ToBitmap(bitmap);
                    wImage.Dispose();
                    break block12;
                }
                n5 = 1;
                n6 = n2;
                n4 = n3;
            }
            if (n5 != 0) {
                baseFilter.nativeUpdateModelMatrix(BitmapSimpleUtils.rotateAndFlipY(bitmap, n6, 0, n4, baseFilter));
            }
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)nArray[0]);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9728.0f);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLUtils.texImage2D((int)3553, (int)0, (int)GLUtils.getInternalFormat((Bitmap)bitmap), (Bitmap)bitmap, (int)GLUtils.getType((Bitmap)bitmap), (int)0);
            if ((n6 + 0) % 180 == 0) {
                long l3 = System.currentTimeMillis();
                baseFilter.RenderProcess(nArray[0], bitmap.getWidth(), bitmap.getHeight(), -1, 0.0, this.mPictureGLFrame);
                LogUtil.d(this, "nativeRenderTexture :" + (System.currentTimeMillis() - l3));
                l3 = System.currentTimeMillis();
                GLSLRender.nativeCopyPixelToBitmap(bitmap);
                LogUtil.d(this, "nativeCopyPixelToBitmap :" + (System.currentTimeMillis() - l3));
            } else {
                n2 = bitmap.getHeight();
                n3 = bitmap.getWidth();
                bitmap.recycle();
                bitmap = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                baseFilter.RenderProcess(nArray[0], n3, n2, n2, n3, -1, 0.0, this.mPictureGLFrame);
                GLSLRender.nativeCopyPixelToBitmap(bitmap);
            }
            GLES20.glDeleteTextures((int)nArray.length, (int[])nArray, (int)0);
        }
        if (baseFilter != null) {
            baseFilter.ApplyGLSLFilter(true);
        }
        LogUtil.d(this, "makeFilter :" + (System.currentTimeMillis() - l2));
        return bitmap;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] openFile(Uri object) {
        void var1_3;
        InputStream inputStream;
        Object object2;
        Object var2_9 = null;
        try {
            if (object.getScheme().toLowerCase().startsWith("file")) {
                object2 = object.toString().substring("file://".length());
                inputStream = new FileInputStream((String)object2);
            } else {
                inputStream = this.mContext.getContentResolver().openInputStream(object);
            }
            if (inputStream == null) return var1_3;
        }
        catch (Exception exception) {
            LogUtil.d(this, "openFile uri:" + object.toString() + " FileInputStream error:" + exception.toString());
            Object var1_4 = var2_9;
            return var1_3;
        }
        try {
            object2 = IOUtils.toByteArray(inputStream);
            inputStream.close();
            Object object3 = object2;
            return var1_3;
        }
        catch (IOException iOException) {
            LogUtil.d(this, "openFile uri:" + object.toString() + " toByteArray error:" + iOException.toString());
            iOException.printStackTrace();
            Object var1_5 = var2_9;
            return var1_3;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
            Object var1_7 = var2_9;
            return var1_3;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void finish() {
        LogUtil.d(this, "finish");
        synchronized (this) {
            this.mStop = true;
            this.notifyAll();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(ImageProcessRequest imageProcessRequest) {
        synchronized (this) {
            while (true) {
                int n2;
                if ((n2 = this.mQueue.size()) < 6) {
                    this.mQueue.add(imageProcessRequest);
                    this.notifyAll();
                    return;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Process.setThreadPriority((int)10);
        while (true) {
            int n2;
            Object object;
            ImageProcessRequest imageProcessRequest;
            block16: {
                block17: {
                    block15: {
                        synchronized (this) {
                            if (this.mQueue.isEmpty()) {
                                this.notifyAll();
                                if (this.mStop) {
                                    return;
                                }
                                this.wait();
                                break block14;
                            }
                            imageProcessRequest = this.mQueue.get(0);
                        }
                        byte[] byArray = this.openFile(imageProcessRequest.uri);
                        object = byArray != null ? BitmapSimpleUtils.makeFitBitmap(byArray, 0, PhoneProperty.instance().isUseSmallPicture()) : null;
                        Log.d((String)this.TAG, (String)("process filter id:" + imageProcessRequest.filterID));
                        imageProcessRequest.filter = ImageProcess.getFilterDes(imageProcessRequest.filterID);
                        if (imageProcessRequest.filter == null || imageProcessRequest.filterID >= 2000 && imageProcessRequest.filterID != 2002) break block15;
                        if (!this.mHasInit) {
                            this.doInitGL();
                            this.mHasInit = true;
                        }
                        BaseFilter baseFilter = imageProcessRequest.filter.newFilter();
                        object = byArray != null ? this.makeFilter((Bitmap)object, Exif.getOrientation(byArray), imageProcessRequest.flipY, baseFilter, imageProcessRequest.camera, 0, imageProcessRequest.filterID) : null;
                        baseFilter.ClearGLSL();
                        n2 = 0;
                        break block16;
                    }
                    if (imageProcessRequest.filterID < 2000) break block17;
                    object = this.makeEffect((Bitmap)object, imageProcessRequest.filterID);
                    n2 = 0;
                    break block16;
                    {
                        block14: {
                            catch (InterruptedException interruptedException) {}
                        }
                        continue;
                    }
                }
                n2 = -1;
                object = null;
            }
            if (imageProcessRequest.imageProcessCallback != null) {
                imageProcessRequest.imageProcessCallback.onImageProcess((Bitmap)object, n2);
            }
            synchronized (this) {
                if (this.mQueue.size() > 0) {
                    this.mQueue.remove(0);
                }
                this.notifyAll();
                if (!this.mHasInit) continue;
            }
            this.doRelease();
            this.mHasInit = false;
        }
    }

    public static interface ImageProcessCallback {
        public void onImageProcess(Bitmap var1, int var2);
    }

    public static class ImageProcessRequest {
        int camera;
        BaseFilterDes filter;
        public int filterID = -1;
        int flipY = 0;
        public ImageProcessCallback imageProcessCallback;
        int orientation;
        public Uri uri;
    }
}

