/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.api.filter.common;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.net.Uri;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.opengl.Matrix;
import com.wuba.api.filter.BaseFilter;
import com.wuba.api.filter.common.Exif;
import com.wuba.api.filter.common.PhoneProperty;
import com.wuba.fileencrypt.FileEncryptUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class BitmapSimpleUtils {
    public static final int DEFAULT_COMPRESS_QUALITY = 90;
    private static final int DEFAULT_SIZE = 1000;
    private static final int DEFAULT_SIZE_SMALL = 500;
    private static final String[] IMAGE_PROJECTION = new String[]{"orientation"};
    private static final int INDEX_ORIENTATION = 0;
    private static final String[] PATH_PROJECTION = new String[]{"_data"};
    private static final String TAG = "BitmapUtils";
    private static final float[] mMatrixValues = new float[16];
    private static final float[] mTempMatrix = new float[32];
    private final Context context;

    public BitmapSimpleUtils(Context context) {
        this.context = context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void closeSilently(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeStream(Closeable closeable) {
        if (closeable == null) return;
        try {
            closeable.close();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int computeInitialSampleSize(BitmapFactory.Options options, int n2, int n3) {
        int n4;
        double d2 = options.outWidth;
        double d3 = options.outHeight;
        int n5 = n2 < 0 ? 128 : (int)Math.min(Math.floor(d2 / (double)n2), Math.floor(d3 / (double)n2));
        if (n5 < (n4 = n3 < 0 ? 1 : (int)Math.ceil(Math.sqrt(d2 * d3 / (double)n3)))) {
            return n4;
        }
        if (n3 < 0 && n2 < 0) {
            return 1;
        }
        if (n2 < 0) return n4;
        return n5;
    }

    public static int computeSampleSize(BitmapFactory.Options options, int n2, int n3) {
        int n4 = BitmapSimpleUtils.computeInitialSampleSize(options, n2, n3);
        if (n4 <= 8) {
            n2 = 1;
            while (true) {
                n3 = n2;
                if (n2 < n4) {
                    n2 <<= 1;
                    continue;
                }
                break;
            }
        } else {
            n3 = (n4 + 7) / 8 * 8;
        }
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int computeSampleSizeLarger(int n2, int n3, int n4) {
        int n5 = 1;
        if ((n2 = Math.max(n2 / n4, n3 / n4)) <= 1) {
            return n5;
        }
        if (n2 > 8) return n2 / 8 * 8;
        return BitmapSimpleUtils.prevPowerOf2(n2);
    }

    public static int computeSampleSizeSmaller(int n2, int n3, boolean bl) {
        int n4;
        int n5;
        int n6 = 1000;
        if (bl) {
            n6 = 500;
        }
        if ((n5 = Math.max(n2 / n6, n3 / n6)) <= 8) {
            int n7 = 1;
            while (true) {
                n4 = n7;
                if (n7 < n5) {
                    n7 <<= 1;
                    continue;
                }
                break;
            }
        } else {
            n4 = (n5 + 7) / 8 * 8;
        }
        while (n4 > 0 && Math.max(n2 / n4, n3 / n4) < n6) {
            n4 /= 2;
        }
        return n4;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Bitmap createBitmap(Bitmap bitmap, int n2, int n3, int n4, int n5, android.graphics.Matrix matrix) {
        Bitmap bitmap2 = null;
        RectF rectF = null;
        Canvas canvas = new Canvas();
        if (matrix == null || matrix.isIdentity()) {
            bitmap2 = Bitmap.createBitmap((int)n4, (int)n5, (Bitmap.Config)bitmap.getConfig());
        } else {
            rectF = new RectF(0.0f, 0.0f, (float)n4, (float)n5);
            matrix.mapRect(rectF);
            Bitmap bitmap3 = Bitmap.createBitmap((int)Math.round(rectF.width()), (int)Math.round(rectF.height()), (Bitmap.Config)bitmap.getConfig());
            canvas.translate(-rectF.left, -rectF.top);
            canvas.concat(matrix);
            Paint paint = new Paint(2);
            rectF = paint;
            bitmap2 = bitmap3;
            if (!matrix.rectStaysRect()) {
                paint.setAntiAlias(true);
                rectF = paint;
                bitmap2 = bitmap3;
            }
        }
        bitmap2.setDensity(bitmap.getDensity());
        canvas.setBitmap(bitmap2);
        canvas.drawBitmap(bitmap, new Rect(n2, n3, n2 + n4, n3 + n5), new RectF(0.0f, 0.0f, (float)n4, (float)n5), (Paint)rectF);
        return bitmap2;
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
            return bitmap2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Bitmap createBitmapSmaller(Bitmap bitmap, float f2, android.graphics.Matrix matrix) {
        int n2 = Math.round((float)bitmap.getWidth() * f2);
        int n3 = Math.round((float)bitmap.getHeight() * f2);
        if (n2 == bitmap.getWidth() && n3 == bitmap.getHeight()) {
            return bitmap;
        }
        Bitmap bitmap2 = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)BitmapSimpleUtils.getConfig(bitmap));
        Canvas canvas = new Canvas(bitmap2);
        canvas.scale(f2, f2);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, new Paint(6));
        if (matrix == null) return bitmap2;
        bitmap = BitmapSimpleUtils.createBitmap(bitmap2, 0, 0, bitmap2.getWidth(), bitmap2.getHeight(), matrix);
        bitmap2.recycle();
        return bitmap;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Bitmap createBitmapSmaller(Bitmap bitmap, int n2, int n3, int n4, int n5, float f2, android.graphics.Matrix matrix) {
        RectF rectF;
        Canvas canvas = new Canvas();
        if (matrix == null || matrix.isIdentity()) {
            matrix = Bitmap.createBitmap((int)Math.round((float)n4 * f2), (int)Math.round((float)n5 * f2), (Bitmap.Config)bitmap.getConfig());
            rectF = null;
        } else {
            rectF = new RectF(0.0f, 0.0f, (float)Math.round((float)n5 * f2), (float)Math.round((float)n4 * f2));
            matrix.mapRect(rectF);
            Bitmap bitmap2 = Bitmap.createBitmap((int)Math.round(rectF.height()), (int)Math.round(rectF.width()), (Bitmap.Config)bitmap.getConfig());
            canvas.scale(f2, f2);
            canvas.translate(-rectF.left, -rectF.top);
            canvas.concat(matrix);
            rectF = new Paint(6);
            matrix = bitmap2;
        }
        canvas.setBitmap((Bitmap)matrix);
        canvas.drawBitmap(bitmap, new Rect(n2, n3, n2 + n4, n3 + n5), new RectF(0.0f, 0.0f, (float)Math.round((float)n5 * f2), (float)Math.round((float)n4 * f2)), (Paint)rectF);
        return matrix;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Bitmap decodeBitmap(Context object, int n2) {
        void var0_3;
        void var1_7;
        Object var2_8 = null;
        InputStream inputStream = object.getResources().openRawResource((int)var1_7);
        byte[] byArray = FileEncryptUtils.decryptFile(inputStream);
        BitmapSimpleUtils.closeSilently(inputStream);
        if (byArray == null) {
            Object var0_2 = var2_8;
            return var0_3;
        }
        inputStream = new BitmapFactory.Options();
        ((BitmapFactory.Options)inputStream).inPreferredConfig = Bitmap.Config.ARGB_8888;
        try {
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)inputStream);
            return var0_3;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Object var0_6 = var2_8;
            return var0_3;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Bitmap decodeBitmap(Context object, int n2, Bitmap.Config config) {
        void var2_6;
        void var0_3;
        void var1_5;
        InputStream inputStream = object.getResources().openRawResource((int)var1_5);
        byte[] byArray = FileEncryptUtils.decryptFile(inputStream);
        BitmapSimpleUtils.closeSilently(inputStream);
        if (byArray == null) {
            return var0_3;
        }
        inputStream = new BitmapFactory.Options();
        ((BitmapFactory.Options)inputStream).inPreferredConfig = var2_6;
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)inputStream);
        return var0_3;
    }

    public static Bitmap decodeBitmap(Resources resources, int n2, int n3, int n4) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)resources, (int)n2, (BitmapFactory.Options)options);
        resources = Bitmap.createBitmap((int)n3, (int)n4, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas((Bitmap)resources);
        options = new Paint(6);
        canvas.drawBitmap(bitmap, new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight()), new Rect(0, 0, n3, n4), (Paint)options);
        bitmap.recycle();
        return resources;
    }

    public static int decodeBitmap2Texture(Context context, int n2) {
        int n3 = 0;
        context = BitmapSimpleUtils.decodeBitmap(context, n2);
        n2 = n3;
        if (context != null) {
            int[] nArray = new int[]{0};
            GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
            GLES20.glBindTexture((int)3553, (int)nArray[0]);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9728.0f);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLUtils.texImage2D((int)3553, (int)0, (Bitmap)context, (int)0);
            context.recycle();
            n2 = nArray[0];
        }
        return n2;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Bitmap decodeBitmapWithoutResize(Uri var1_1) {
        var2_3 = true;
        var3_4 = null;
        var4_5 /* !! */  = null;
        while (true) {
            block22: {
                block21: {
                    var5_9 = var4_5 /* !! */ ;
                    var6_10 = var4_5 /* !! */ ;
                    var7_11 = var4_5 /* !! */ ;
                    var8_12 = var4_5 /* !! */ ;
                    var9_13 /* !! */  = this.getBitmapBounds(var1_1);
                    var5_9 = var4_5 /* !! */ ;
                    var6_10 = var4_5 /* !! */ ;
                    var7_11 = var4_5 /* !! */ ;
                    var8_12 = var4_5 /* !! */ ;
                    var10_14 = var9_13 /* !! */ .width();
                    var5_9 = var4_5 /* !! */ ;
                    var6_10 = var4_5 /* !! */ ;
                    var7_11 = var4_5 /* !! */ ;
                    var8_12 = var4_5 /* !! */ ;
                    var11_15 = var9_13 /* !! */ .height();
                    var5_9 = var4_5 /* !! */ ;
                    var6_10 = var4_5 /* !! */ ;
                    var7_11 = var4_5 /* !! */ ;
                    var8_12 = var4_5 /* !! */ ;
                    var5_9 = var4_5 /* !! */ ;
                    var6_10 = var4_5 /* !! */ ;
                    var7_11 = var4_5 /* !! */ ;
                    var8_12 = var4_5 /* !! */ ;
                    var12_16 = new BitmapFactory.Options();
                    var5_9 = var4_5 /* !! */ ;
                    var6_10 = var4_5 /* !! */ ;
                    var7_11 = var4_5 /* !! */ ;
                    var8_12 = var4_5 /* !! */ ;
                    var12_16.inSampleSize = BitmapSimpleUtils.computeSampleSizeSmaller(var10_14, var11_15, PhoneProperty.instance().isUseSmallPicture());
                    var5_9 = var4_5 /* !! */ ;
                    var6_10 = var4_5 /* !! */ ;
                    var7_11 = var4_5 /* !! */ ;
                    var8_12 = var4_5 /* !! */ ;
                    var12_16.inPreferredConfig = Bitmap.Config.ARGB_8888;
                    var5_9 = var4_5 /* !! */ ;
                    var6_10 = var4_5 /* !! */ ;
                    var7_11 = var4_5 /* !! */ ;
                    var8_12 = var4_5 /* !! */ ;
                    if (!var1_1.getScheme().toLowerCase().startsWith("file")) break block21;
                    var5_9 = var4_5 /* !! */ ;
                    var6_10 = var4_5 /* !! */ ;
                    var7_11 = var4_5 /* !! */ ;
                    var8_12 = var4_5 /* !! */ ;
                    var13_17 = var1_1.toString().substring("file://".length());
                    var5_9 = var4_5 /* !! */ ;
                    var6_10 = var4_5 /* !! */ ;
                    var7_11 = var4_5 /* !! */ ;
                    var8_12 = var4_5 /* !! */ ;
                    var5_9 = var4_5 /* !! */ ;
                    var6_10 = var4_5 /* !! */ ;
                    var7_11 = var4_5 /* !! */ ;
                    var8_12 = var4_5 /* !! */ ;
                    var9_13 /* !! */  = new FileInputStream(var13_17);
                    var4_5 /* !! */  = var9_13 /* !! */ ;
lbl68:
                    // 2 sources

                    while (true) {
                        var5_9 = var4_5 /* !! */ ;
                        var6_10 = var4_5 /* !! */ ;
                        var7_11 = var4_5 /* !! */ ;
                        var8_12 = var4_5 /* !! */ ;
                        var9_13 /* !! */  = BitmapFactory.decodeStream((InputStream)var4_5 /* !! */ , null, (BitmapFactory.Options)var12_16);
                        this.closeStream((Closeable)var4_5 /* !! */ );
                        var7_11 = var9_13 /* !! */ ;
                        var2_3 = false;
                        var3_4 = var4_5 /* !! */ ;
                        var4_5 /* !! */  = var7_11;
lbl80:
                        // 4 sources

                        ** while (!var2_3)
lbl-1000:
                        // 1 sources

                        {
                            if (var4_5 /* !! */  != null && var4_5 /* !! */ .getConfig() != Bitmap.Config.ARGB_8888) {
                                var1_1 = var4_5 /* !! */ .copy(Bitmap.Config.ARGB_8888, true);
                                var4_5 /* !! */ .recycle();
                                var4_5 /* !! */  = var1_1;
                            }
                            return var4_5 /* !! */ ;
lbl86:
                            // 1 sources

                            break block22;
                        }
                        break;
                    }
                }
                var5_9 = var4_5 /* !! */ ;
                var6_10 = var4_5 /* !! */ ;
                var7_11 = var4_5 /* !! */ ;
                var8_12 = var4_5 /* !! */ ;
                try {
                    var4_5 /* !! */  = this.context.getContentResolver().openInputStream(var1_1);
                    ** continue;
                }
                catch (FileNotFoundException var4_6) {
                    this.closeStream((Closeable)var5_9);
                    var4_5 /* !! */  = var3_4;
                    var3_4 = var5_9;
                    var2_3 = false;
                    ** GOTO lbl80
                }
                catch (OutOfMemoryError var4_7) {
                    this.closeStream((Closeable)var6_10);
                    var4_5 /* !! */  = var3_4;
                    var3_4 = var6_10;
                    ** GOTO lbl80
                }
                catch (Exception var4_8) {
                    this.closeStream((Closeable)var7_11);
                    var4_5 /* !! */  = var3_4;
                    var3_4 = var7_11;
                    ** GOTO lbl80
                }
                catch (Throwable var1_2) {
                    this.closeStream((Closeable)var8_12);
                    throw var1_2;
                }
            }
            var7_11 = var4_5 /* !! */ ;
            var4_5 /* !! */  = var3_4;
            var3_4 = var7_11;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static void deletePicture(ContentResolver var0, Uri var1_6) {
        block21: {
            block20: {
                block19: {
                    var2_7 = null;
                    var3_8 = var0.query(var1_6, BitmapSimpleUtils.PATH_PROJECTION, null, null, null);
                    var4_9 /* !! */  = var2_7;
                    if (var3_8 == null) break block19;
                    var4_9 /* !! */  = var2_7;
                    var2_7 = var3_8;
                    if (!var3_8.moveToNext()) break block19;
                    var2_7 = var3_8;
                    var4_9 /* !! */  = var3_8.getString(0);
                }
                if (var4_9 /* !! */  != null) {
                    var2_7 = var3_8;
                    var2_7 = var3_8;
                    var5_10 = new File((String)var4_9 /* !! */ );
                    var2_7 = var3_8;
                    if (!var5_10.isFile()) break block20;
                    var2_7 = var3_8;
                    if (!var5_10.exists()) break block20;
                    var2_7 = var3_8;
                    var5_10.delete();
                }
            }
            var2_7 = var3_8;
            try {
                var0.delete(var1_6, null, null);
                if (var3_8 == null) break block21;
            }
            catch (Exception var0_5) {
                ** continue;
            }
            var3_8.close();
        }
lbl37:
        // 3 sources

        return;
        catch (Exception var0_1) {
            var3_8 = null;
lbl41:
            // 2 sources

            while (true) {
                var2_7 = var3_8;
                var0.printStackTrace();
                if (var3_8 == null) ** GOTO lbl37
                var3_8.close();
                ** continue;
                break;
            }
        }
        catch (Throwable var0_2) {
            var2_7 = null;
lbl50:
            // 2 sources

            while (true) {
                if (var2_7 != null) {
                    var2_7.close();
                }
                throw var0_3;
            }
        }
        {
            catch (Throwable var0_4) {
                ** continue;
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Rect getBitmapBounds(Uri object) {
        Closeable closeable = null;
        BitmapFactory.Options options = null;
        Rect rect = new Rect();
        BitmapFactory.Options options2 = options;
        Closeable closeable2 = closeable;
        try {
            void var1_3;
            if (object.getScheme().toLowerCase().startsWith("file")) {
                BitmapFactory.Options options3 = options;
                closeable2 = closeable;
                String string2 = object.toString().substring("file://".length());
                BitmapFactory.Options options4 = options;
                closeable2 = closeable;
                BitmapFactory.Options options5 = options;
                closeable2 = closeable;
                FileInputStream fileInputStream = new FileInputStream(string2);
            } else {
                BitmapFactory.Options options6 = options;
                closeable2 = closeable;
                InputStream inputStream = this.context.getContentResolver().openInputStream(object);
            }
            void var5_14 = var1_3;
            closeable2 = var1_3;
            void var5_15 = var1_3;
            closeable2 = var1_3;
            options = new BitmapFactory.Options();
            void var5_16 = var1_3;
            closeable2 = var1_3;
            options.inJustDecodeBounds = true;
            void var5_17 = var1_3;
            closeable2 = var1_3;
            BitmapFactory.decodeStream((InputStream)var1_3, null, (BitmapFactory.Options)options);
            void var5_18 = var1_3;
            closeable2 = var1_3;
            rect.right = options.outWidth;
            void var5_19 = var1_3;
            closeable2 = var1_3;
            rect.bottom = options.outHeight;
            this.closeStream((Closeable)var1_3);
            return rect;
        }
        catch (FileNotFoundException fileNotFoundException) {
            void var5_21;
            closeable2 = var5_21;
            fileNotFoundException.printStackTrace();
            this.closeStream((Closeable)var5_21);
            return rect;
        }
        catch (Throwable throwable) {
            this.closeStream(closeable2);
            throw throwable;
        }
    }

    private static Bitmap.Config getConfig(Bitmap bitmap) {
        Bitmap.Config config = bitmap.getConfig();
        bitmap = config;
        if (config == null) {
            bitmap = Bitmap.Config.ARGB_8888;
        }
        return bitmap;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Bitmap makeBitmap(byte[] object, int n2, int n3, int n4) {
        void var2_4;
        Bitmap bitmap;
        void var5_8;
        Object var4_6 = null;
        if (object == null) {
            Object var5_7 = var4_6;
            return var5_8;
        }
        try {
            void var3_5;
            void var1_3;
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeByteArray((byte[])object, (int)0, (int)((byte[])object).length, (BitmapFactory.Options)options);
            Object var5_9 = var4_6;
            if (options.mCancel) return var5_8;
            Object var5_10 = var4_6;
            if (options.outWidth == -1) return var5_8;
            Object var5_11 = var4_6;
            if (options.outHeight == -1) return var5_8;
            options.inSampleSize = BitmapSimpleUtils.computeSampleSize(options, (int)var1_3, (int)var3_5);
            options.inJustDecodeBounds = false;
            options.inDither = false;
            options.inPreferredConfig = Bitmap.Config.ARGB_4444;
            Bitmap bitmap2 = bitmap = BitmapFactory.decodeByteArray((byte[])object, (int)0, (int)((byte[])object).length, (BitmapFactory.Options)options);
            if (var2_4 == false) return var5_8;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Object var5_15 = var4_6;
            return var5_8;
        }
        android.graphics.Matrix matrix = new android.graphics.Matrix();
        matrix.setRotate((float)var2_4);
        Bitmap bitmap3 = BitmapSimpleUtils.createBitmap(bitmap, 0, 0, bitmap.getWidth(), bitmap.getHeight(), matrix);
        bitmap.recycle();
        return var5_8;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Bitmap makeFitBitmap(byte[] object, int n2, int n3, int n4, boolean bl) {
        void var0_2;
        BitmapFactory.Options options = null;
        if (object == null) {
            return var0_2;
        }
        int n5 = 1;
        int n6 = -1;
        while (true) {
            int n7 = n6;
            try {
                BitmapFactory.Options options2;
                block16: {
                    block15: {
                        n7 = n6;
                        options2 = new BitmapFactory.Options();
                        n7 = n6;
                        options2.inJustDecodeBounds = true;
                        n7 = n6;
                        BitmapFactory.decodeByteArray((byte[])object, (int)0, (int)((byte[])object).length, (BitmapFactory.Options)options2);
                        n7 = n6;
                        if (options2.mCancel) break block15;
                        n7 = n6;
                        if (options2.outWidth == -1) break block15;
                        n7 = n6;
                        if (options2.outHeight != -1) break block16;
                    }
                    Object var0_3 = null;
                    return var0_2;
                }
                if (n6 == -1) {
                    void var4_11;
                    n7 = n6;
                    options2.inSampleSize = BitmapSimpleUtils.computeSampleSizeSmaller(options2.outWidth, options2.outHeight, (boolean)var4_11);
                    n7 = n6;
                    n6 = options2.inSampleSize;
                } else {
                    n7 = n6 *= 2;
                    options2.inSampleSize = n6;
                }
                n7 = n6;
                options2.inJustDecodeBounds = false;
                n7 = n6;
                options2.inDither = false;
                n7 = n6;
                options2.inPreferredConfig = Bitmap.Config.ARGB_8888;
                n7 = n6;
                options2 = BitmapFactory.decodeByteArray((byte[])object, (int)0, (int)((byte[])object).length, (BitmapFactory.Options)options2);
                n5 = 0;
                options = options2;
                n7 = n6;
                n6 = n5;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                n6 = n5;
            }
            if (n6 == 0) {
                void var3_10;
                void var2_9;
                void var1_8;
                if (var1_8 == false && var2_9 == false) {
                    BitmapFactory.Options options3 = options;
                    if (var3_10 == false) return var0_2;
                }
                android.graphics.Matrix matrix = new android.graphics.Matrix();
                float f2 = options.getWidth();
                if (var2_9 == true) {
                    matrix.setValues(new float[]{-1.0f, 0.0f, f2, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f});
                }
                if (var1_8 != false) {
                    matrix.preRotate((float)var1_8);
                }
                if (var3_10 != false) {
                    matrix.postRotate((float)var3_10);
                }
                Bitmap bitmap = BitmapSimpleUtils.createBitmap(options, 0, 0, options.getWidth(), options.getHeight(), matrix);
                options.recycle();
                return var0_2;
            }
            n5 = n6;
            n6 = n7;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Bitmap makeFitBitmap(byte[] object, int n2, boolean bl) {
        void var0_2;
        if (object == null) {
            return var0_2;
        }
        int n3 = 1;
        BitmapFactory.Options options = null;
        int n4 = -1;
        while (true) {
            int n5 = n4;
            try {
                BitmapFactory.Options options2;
                block12: {
                    block11: {
                        n5 = n4;
                        options2 = new BitmapFactory.Options();
                        n5 = n4;
                        options2.inJustDecodeBounds = true;
                        n5 = n4;
                        BitmapFactory.decodeByteArray((byte[])object, (int)0, (int)((byte[])object).length, (BitmapFactory.Options)options2);
                        n5 = n4;
                        if (options2.mCancel) break block11;
                        n5 = n4;
                        if (options2.outWidth == -1) break block11;
                        n5 = n4;
                        if (options2.outHeight != -1) break block12;
                    }
                    Object var0_3 = null;
                    return var0_2;
                }
                if (n4 == -1) {
                    void var2_8;
                    n5 = n4;
                    options2.inSampleSize = BitmapSimpleUtils.computeSampleSizeSmaller(options2.outWidth, options2.outHeight, (boolean)var2_8);
                    n5 = n4;
                    n4 = options2.inSampleSize;
                } else {
                    n5 = n4 *= 2;
                    options2.inSampleSize = n4;
                }
                n5 = n4;
                options2.inJustDecodeBounds = false;
                n5 = n4;
                options2.inDither = false;
                n5 = n4;
                options2.inPreferredConfig = Bitmap.Config.ARGB_8888;
                n5 = n4;
                options2 = BitmapFactory.decodeByteArray((byte[])object, (int)0, (int)((byte[])object).length, (BitmapFactory.Options)options2);
                n5 = n4;
                options = options2;
                n4 = 0;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                n4 = n3;
            }
            if (n4 == 0) {
                void var1_7;
                BitmapFactory.Options options3 = options;
                if (var1_7 == false) return var0_2;
                android.graphics.Matrix matrix = new android.graphics.Matrix();
                matrix.setRotate((float)var1_7);
                Bitmap bitmap = BitmapSimpleUtils.createBitmap(options, 0, 0, options.getWidth(), options.getHeight(), matrix);
                options.recycle();
                return var0_2;
            }
            n3 = n4;
            n4 = n5;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Bitmap makeLimitedBitmap(byte[] object, int n2, int n3) {
        void var2_4;
        Bitmap bitmap;
        void var5_10;
        Object var3_5 = null;
        try {
            void var1_3;
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeByteArray((byte[])object, (int)0, (int)((byte[])object).length, (BitmapFactory.Options)options);
            Object var5_7 = var3_5;
            if (options.mCancel) return var5_10;
            Object var5_8 = var3_5;
            if (options.outWidth == -1) return var5_10;
            if (options.outHeight == -1) {
                Object var5_9 = var3_5;
                return var5_10;
            }
            options.inSampleSize = BitmapSimpleUtils.computeSampleSize(options, -1, (int)var1_3);
            options.inJustDecodeBounds = false;
            options.inDither = false;
            options.inPreferredConfig = Bitmap.Config.ARGB_8888;
            Bitmap bitmap2 = bitmap = BitmapFactory.decodeByteArray((byte[])object, (int)0, (int)((byte[])object).length, (BitmapFactory.Options)options);
            if (var2_4 == false) return var5_10;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Object var5_14 = var3_5;
            return var5_10;
        }
        android.graphics.Matrix matrix = new android.graphics.Matrix();
        matrix.setRotate((float)var2_4);
        Bitmap bitmap3 = BitmapSimpleUtils.createBitmap(bitmap, 0, 0, bitmap.getWidth(), bitmap.getHeight(), matrix);
        bitmap.recycle();
        return var5_10;
    }

    public static int prevPowerOf2(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException();
        }
        return Integer.highestOneBit(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Bitmap resizeBitmapByScale(Bitmap bitmap, float f2, boolean bl) {
        int n2 = Math.round((float)bitmap.getWidth() * f2);
        int n3 = Math.round((float)bitmap.getHeight() * f2);
        if (n2 == bitmap.getWidth() && n3 == bitmap.getHeight()) {
            return bitmap;
        }
        Bitmap bitmap2 = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)BitmapSimpleUtils.getConfig(bitmap));
        Canvas canvas = new Canvas(bitmap2);
        canvas.scale(f2, f2);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, new Paint(6));
        if (!bl) return bitmap2;
        bitmap.recycle();
        return bitmap2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Bitmap resizeDownAndCropCenter(Bitmap bitmap, int n2, boolean bl) {
        int n3 = bitmap.getWidth();
        int n4 = bitmap.getHeight();
        int n5 = Math.min(n3, n4);
        if (n3 == n4 && n5 <= n2) {
            return bitmap;
        }
        n4 = Math.min(n2, n5);
        float f2 = Math.max((float)n4 / (float)bitmap.getWidth(), (float)n4 / (float)bitmap.getHeight());
        Bitmap bitmap2 = Bitmap.createBitmap((int)n4, (int)n4, (Bitmap.Config)BitmapSimpleUtils.getConfig(bitmap));
        n2 = Math.round((float)bitmap.getWidth() * f2);
        n5 = Math.round((float)bitmap.getHeight() * f2);
        Canvas canvas = new Canvas(bitmap2);
        canvas.translate((float)(n4 - n2) / 2.0f, (float)(n4 - n5) / 2.0f);
        canvas.scale(f2, f2);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, new Paint(6));
        if (!bl) return bitmap2;
        bitmap.recycle();
        return bitmap2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Bitmap resizeDownBySideLength(Bitmap bitmap, int n2, boolean bl) {
        int n3;
        int n4 = bitmap.getWidth();
        float f2 = Math.min((float)n2 / (float)n4, (float)n2 / (float)(n3 = bitmap.getHeight()));
        if (!(f2 >= 1.0f)) return BitmapSimpleUtils.resizeBitmapByScale(bitmap, f2, bl);
        return bitmap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void rotate(float f2, float f3, float f4, float f5) {
        if (f2 == 0.0f) {
            return;
        }
        float[] fArray = mTempMatrix;
        Matrix.setRotateM((float[])fArray, (int)0, (float)f2, (float)f3, (float)f4, (float)f5);
        Matrix.multiplyMM((float[])fArray, (int)16, (float[])mMatrixValues, (int)0, (float[])fArray, (int)0);
        System.arraycopy(fArray, 16, mMatrixValues, 0, 16);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void rotate(int n2) {
        if (n2 == 0) {
            return;
        }
        BitmapSimpleUtils.rotate(n2, 0.0f, 0.0f, 1.0f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Bitmap rotateAndFlipY(Bitmap bitmap, int n2, int n3, int n4) {
        android.graphics.Matrix matrix = new android.graphics.Matrix();
        float f2 = bitmap.getWidth();
        if (n3 == 1) {
            matrix.setValues(new float[]{-1.0f, 0.0f, f2, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f});
        }
        if (n2 != 0) {
            matrix.preRotate((float)n2);
        }
        if (n4 != 0) {
            matrix.postRotate((float)n4);
        }
        if ((matrix = BitmapSimpleUtils.createBitmap(bitmap, 0, 0, bitmap.getWidth(), bitmap.getHeight(), matrix)) == null) {
            return bitmap;
        }
        bitmap.recycle();
        return matrix;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static float[] rotateAndFlipY(Bitmap bitmap, int n2, int n3, int n4, BaseFilter baseFilter) {
        Matrix.setIdentityM((float[])mMatrixValues, (int)0);
        BitmapSimpleUtils.rotate(n2);
        if (n4 % 2 == 1) {
            if (n2 % 180 == 0) {
                Matrix.scaleM((float[])mMatrixValues, (int)0, (float)-1.0f, (float)1.0f, (float)1.0f);
            } else {
                Matrix.scaleM((float[])mMatrixValues, (int)0, (float)1.0f, (float)-1.0f, (float)1.0f);
            }
            if (n3 != 0) {
                BitmapSimpleUtils.rotate(n3);
            }
        }
        return mMatrixValues;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Bitmap decodeBitmap(Uri var1_1, int var2_3, int var3_4) {
        var4_5 /* !! */  = null;
        var5_8 = -1;
        var6_9 = 1;
        var7_10 = null;
        while (true) {
            block15: {
                block16: {
                    block14: {
                        block13: {
                            var8_11 = var5_8;
                            var9_12 = var4_5 /* !! */ ;
                            var10_13 = var5_8;
                            var11_14 = var4_5 /* !! */ ;
                            var12_15 = var4_5 /* !! */ ;
                            try {
                                var13_16 /* !! */  = this.getBitmapBounds(var1_1);
                                var8_11 = var5_8;
                                var9_12 = var4_5 /* !! */ ;
                                var10_13 = var5_8;
                                var11_14 = var4_5 /* !! */ ;
                                var12_15 = var4_5 /* !! */ ;
                                var14_17 = var13_16 /* !! */ .width();
                                var8_11 = var5_8;
                                var9_12 = var4_5 /* !! */ ;
                                var10_13 = var5_8;
                                var11_14 = var4_5 /* !! */ ;
                                var12_15 = var4_5 /* !! */ ;
                                var15_18 = var13_16 /* !! */ .height();
                                var8_11 = var5_8;
                                var9_12 = var4_5 /* !! */ ;
                                var10_13 = var5_8;
                                var11_14 = var4_5 /* !! */ ;
                                var12_15 = var4_5 /* !! */ ;
                                var8_11 = var5_8;
                                var9_12 = var4_5 /* !! */ ;
                                var10_13 = var5_8;
                                var11_14 = var4_5 /* !! */ ;
                                var12_15 = var4_5 /* !! */ ;
                                var16_19 = new BitmapFactory.Options();
                                if (var5_8 != -1) break block13;
                                var17_20 = var2_3 > var3_4 ? var2_3 : var3_4;
                                var8_11 = var5_8;
                                var9_12 = var4_5 /* !! */ ;
                                var10_13 = var5_8;
                                var11_14 = var4_5 /* !! */ ;
                                var12_15 = var4_5 /* !! */ ;
                                var16_19.inSampleSize = BitmapSimpleUtils.computeSampleSizeLarger(var14_17, var15_18, var17_20);
                                var8_11 = var5_8;
                                var9_12 = var4_5 /* !! */ ;
                                var10_13 = var5_8;
                                var11_14 = var4_5 /* !! */ ;
                                var12_15 = var4_5 /* !! */ ;
                                var5_8 = var16_19.inSampleSize;
                            }
                            catch (FileNotFoundException var4_6) {
                                this.closeStream((Closeable)var9_12);
                                var10_13 = 0;
                                var4_5 /* !! */  = var7_10;
                                var5_8 = var8_11;
                                var8_11 = var10_13;
                                var7_10 = var9_12;
                                ** GOTO lbl112
                            }
                            catch (OutOfMemoryError var4_7) {
                                this.closeStream((Closeable)var11_14);
                                var8_11 = var6_9;
                                var4_5 /* !! */  = var7_10;
                                var5_8 = var10_13;
                                var7_10 = var11_14;
                                ** GOTO lbl112
                            }
                            catch (Throwable var1_2) {
                                this.closeStream((Closeable)var12_15);
                                throw var1_2;
                            }
lbl69:
                            // 2 sources

                            while (true) {
                                var8_11 = var5_8;
                                var9_12 = var4_5 /* !! */ ;
                                var10_13 = var5_8;
                                var11_14 = var4_5 /* !! */ ;
                                var12_15 = var4_5 /* !! */ ;
                                var16_19.inPreferredConfig = Bitmap.Config.ARGB_8888;
                                var8_11 = var5_8;
                                var9_12 = var4_5 /* !! */ ;
                                var10_13 = var5_8;
                                var11_14 = var4_5 /* !! */ ;
                                var12_15 = var4_5 /* !! */ ;
                                if (!var1_1.getScheme().toLowerCase().startsWith("file")) break block14;
                                var8_11 = var5_8;
                                var9_12 = var4_5 /* !! */ ;
                                var10_13 = var5_8;
                                var11_14 = var4_5 /* !! */ ;
                                var12_15 = var4_5 /* !! */ ;
                                var18_21 = var1_1.toString().substring("file://".length());
                                var8_11 = var5_8;
                                var9_12 = var4_5 /* !! */ ;
                                var10_13 = var5_8;
                                var11_14 = var4_5 /* !! */ ;
                                var12_15 = var4_5 /* !! */ ;
                                var8_11 = var5_8;
                                var9_12 = var4_5 /* !! */ ;
                                var10_13 = var5_8;
                                var11_14 = var4_5 /* !! */ ;
                                var12_15 = var4_5 /* !! */ ;
                                var13_16 /* !! */  = new FileInputStream(var18_21);
                                var4_5 /* !! */  = var13_16 /* !! */ ;
lbl100:
                                // 2 sources

                                while (true) {
                                    var8_11 = var5_8;
                                    var9_12 = var4_5 /* !! */ ;
                                    var10_13 = var5_8;
                                    var11_14 = var4_5 /* !! */ ;
                                    var12_15 = var4_5 /* !! */ ;
                                    var13_16 /* !! */  = BitmapFactory.decodeStream((InputStream)var4_5 /* !! */ , null, (BitmapFactory.Options)var16_19);
                                    this.closeStream((Closeable)var4_5 /* !! */ );
                                    var8_11 = 0;
                                    var9_12 = var13_16 /* !! */ ;
                                    var7_10 = var4_5 /* !! */ ;
                                    var4_5 /* !! */  = var9_12;
lbl112:
                                    // 3 sources

                                    if (var8_11 != 0) break block15;
                                    if (var4_5 /* !! */  != null && var4_5 /* !! */ .getConfig() != Bitmap.Config.ARGB_8888) {
                                        var1_1 = var4_5 /* !! */ .copy(Bitmap.Config.ARGB_8888, true);
                                        var4_5 /* !! */ .recycle();
lbl116:
                                        // 2 sources

                                        while (true) {
                                            var4_5 /* !! */  = var1_1;
                                            if (var1_1 != null) {
                                                var19_22 = Math.max(Math.min((float)var2_3 / (float)var1_1.getWidth(), (float)var3_4 / (float)var1_1.getHeight()), Math.min((float)var3_4 / (float)var1_1.getWidth(), (float)var2_3 / (float)var1_1.getHeight()));
                                                var4_5 /* !! */  = var1_1;
                                                if (var19_22 < 1.0f) {
                                                    var4_5 /* !! */  = new android.graphics.Matrix();
                                                    var4_5 /* !! */ .setScale(var19_22, var19_22);
                                                    var4_5 /* !! */  = BitmapSimpleUtils.createBitmap((Bitmap)var1_1, 0, 0, var1_1.getWidth(), var1_1.getHeight(), (android.graphics.Matrix)var4_5 /* !! */ );
                                                    var1_1.recycle();
                                                }
                                            }
                                            return var4_5 /* !! */ ;
                                        }
                                    }
                                    break block16;
                                    break;
                                }
                                break;
                            }
                        }
                        var8_11 = var5_8 *= 2;
                        var9_12 = var4_5 /* !! */ ;
                        var10_13 = var5_8;
                        var11_14 = var4_5 /* !! */ ;
                        var12_15 = var4_5 /* !! */ ;
                        {
                            var16_19.inSampleSize = var5_8;
                            ** continue;
                        }
                    }
                    var8_11 = var5_8;
                    var9_12 = var4_5 /* !! */ ;
                    var10_13 = var5_8;
                    var11_14 = var4_5 /* !! */ ;
                    var12_15 = var4_5 /* !! */ ;
                    {
                        var4_5 /* !! */  = this.context.getContentResolver().openInputStream(var1_1);
                        ** continue;
                    }
                }
                var1_1 = var4_5 /* !! */ ;
                ** continue;
            }
            var9_12 = var4_5 /* !! */ ;
            var4_5 /* !! */  = var7_10;
            var6_9 = var8_11;
            var7_10 = var9_12;
        }
    }

    public Bitmap getBitmap(Uri uri, int n2, int n3) {
        Bitmap bitmap;
        Bitmap bitmap2 = bitmap = this.decodeBitmap(uri, n2, n3);
        if (bitmap != null) {
            n2 = this.getOrientation(uri);
            bitmap2 = bitmap;
            if (n2 != 0) {
                uri = new android.graphics.Matrix();
                uri.setRotate((float)n2);
                bitmap2 = BitmapSimpleUtils.createBitmap(bitmap, 0, 0, bitmap.getWidth(), bitmap.getHeight(), (android.graphics.Matrix)uri);
                bitmap.recycle();
            }
        }
        return bitmap2;
    }

    public Bitmap getBitmapWithoutResize(Uri uri) {
        Bitmap bitmap;
        Bitmap bitmap2 = bitmap = this.decodeBitmapWithoutResize(uri);
        if (bitmap != null) {
            int n2 = this.getOrientation(uri);
            bitmap2 = bitmap;
            if (n2 != 0) {
                uri = new android.graphics.Matrix();
                uri.setRotate((float)n2);
                bitmap2 = BitmapSimpleUtils.createBitmap(bitmap, 0, 0, bitmap.getWidth(), bitmap.getHeight(), (android.graphics.Matrix)uri);
                bitmap.recycle();
            }
        }
        return bitmap2;
    }

    /*
     * Unable to fully structure code
     */
    public int getOrientation(Uri var1_1) {
        block19: {
            block17: {
                block18: {
                    var2_4 = 0;
                    var3_5 = 0;
                    var4_6 = null;
                    var5_13 = null;
                    var6_14 = null;
                    if (!var1_1.getScheme().toLowerCase().contains("file")) break block18;
                    if ((var1_1 = var1_1.getPath()) == null || !var1_1.toLowerCase().endsWith("jpg") && !var1_1.toLowerCase().endsWith("jpeg")) break block19;
                    var1_1 = new File((String)var1_1);
                    var4_6 = new FileInputStream((File)var1_1);
                    var1_1 = ByteBuffer.allocate(var4_6.available());
                    var4_6.read(var1_1.array());
                    while (var1_1 != null && var1_1.array() != null) {
                        var7_15 = Exif.getOrientation(var1_1.array());
lbl17:
                        // 2 sources

                        while (true) {
                            var2_4 = var7_15;
lbl19:
                            // 5 sources

                            return var2_4;
                        }
                    }
                    break block19;
                    catch (FileNotFoundException var4_7) {
                        var1_1 = null;
lbl24:
                        // 2 sources

                        while (true) {
                            var4_8.printStackTrace();
                            break;
                        }
                    }
                    catch (IOException var4_9) {
                        var1_1 = var6_14;
lbl29:
                        // 2 sources

                        while (true) {
                            var4_10.printStackTrace();
                            break;
                        }
                    }
                }
                var6_14 = var5_13;
                var1_1 = this.context.getContentResolver().query((Uri)var1_1, BitmapSimpleUtils.IMAGE_PROJECTION, null, null, null);
                var7_16 = var2_4;
                if (var1_1 == null) break block17;
                var7_16 = var2_4;
                var4_6 = var1_1;
                var6_14 = var1_1;
                if (!var1_1.moveToNext()) break block17;
                var4_6 = var1_1;
                var6_14 = var1_1;
                try {
                    var7_16 = var1_1.getInt(0);
                }
                catch (Exception var1_2) {
                    var2_4 = var3_5;
                    if (var4_6 == null) ** GOTO lbl19
                    var4_6.close();
                    var2_4 = var3_5;
                    ** continue;
                }
                catch (Throwable var1_3) {
                    if (var6_14 != null) {
                        var6_14.close();
                    }
                    throw var1_3;
                }
            }
            var2_4 = var7_16;
            if (var1_1 == null) ** GOTO lbl19
            var1_1.close();
            var2_4 = var7_16;
            ** GOTO lbl19
            catch (IOException var4_11) {
                ** continue;
            }
            catch (FileNotFoundException var4_12) {
                ** continue;
            }
        }
        var7_15 = 0;
        ** while (true)
    }

    /*
     * Exception decompiling
     */
    public File saveBitmap(Bitmap var1_1, String var2_5, String var3_6, Bitmap.CompressFormat var4_11, String var5_12) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 14[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public File saveJpegData(byte[] var1_1, String var2_5, String var3_6, Bitmap.CompressFormat var4_7, String var5_12) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 14[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

