/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.api.filter.common;

import android.graphics.Bitmap;
import android.graphics.RectF;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.util.Log;
import com.wuba.api.filter.GLSLRender;
import com.wuba.api.filter.WImage;
import com.wuba.api.filter.common.PhoneProperty;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class RendererUtils {
    private static final float DEGREE_TO_RADIAN = (float)Math.PI / 180;
    private static final int FLOAT_SIZE_BYTES = 4;
    private static final String FRAGMENT_SHADER = "precision mediump float;\nuniform sampler2D tex_sampler;\nuniform float alpha;\nuniform vec4 bkg;\nvarying vec2 v_texcoord;\nvoid main() {\nvec4 color = texture2D(tex_sampler, v_texcoord);\ngl_FragColor = vec4(color.r*alpha + bkg.r*(1.0-alpha), color.g*alpha + bkg.g*(1.0-alpha), color.b*alpha + bkg.b*(1.0-alpha), 1.0);\n}\n";
    private static final float[] POS_VERTICES;
    private static final float[] TEX_VERTICES;
    private static final String VERTEX_SHADER = "attribute vec4 a_position;\nattribute vec2 a_texcoord;\nvarying vec2 v_texcoord;\nvoid main() {\n  gl_Position = a_position;\n  v_texcoord = a_texcoord;\n}\n";
    private static int[] frame;

    static {
        frame = new int[1];
        TEX_VERTICES = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        POS_VERTICES = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f};
    }

    public static void checkGlError(String stackTraceElementArray) {
        int n2 = GLES20.glGetError();
        if (n2 != 0) {
            Log.e((String)"RendererUtils", (String)((String)stackTraceElementArray + ": glError " + n2));
            stackTraceElementArray = Thread.getAllStackTraces().get(Thread.currentThread());
            int n3 = stackTraceElementArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                Log.e((String)"SS     ", (String)stackTraceElementArray[n2].toString());
            }
        }
    }

    public static void clearTexture(int n2) {
        int[] nArray = new int[]{n2};
        GLES20.glDeleteTextures((int)nArray.length, (int[])nArray, (int)0);
        RendererUtils.checkGlError("glDeleteTextures");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FilterContext createFilterProgram(String object, String object2, float[] fArray, float[] fArray2) {
        int n2;
        Object var4_4 = null;
        Object object3 = object;
        if (object == null) {
            object3 = VERTEX_SHADER;
        }
        if ((n2 = RendererUtils.loadShader(35633, (String)object3)) == 0) {
            return var4_4;
        }
        int n3 = RendererUtils.loadShader(35632, (String)object2);
        object = var4_4;
        if (n3 == 0) return object;
        int n4 = GLES20.glCreateProgram();
        if (n4 != 0) {
            GLES20.glAttachShader((int)n4, (int)n2);
            RendererUtils.checkGlError("glAttachShader");
            GLES20.glAttachShader((int)n4, (int)n3);
            RendererUtils.checkGlError("glAttachShader");
            GLES20.glLinkProgram((int)n4);
            GLES20.glDeleteShader((int)n2);
            GLES20.glDeleteShader((int)n3);
            object = new int[1];
            GLES20.glGetProgramiv((int)n4, (int)35714, (int[])object, (int)0);
            if (object[0] != true) {
                object = GLES20.glGetProgramInfoLog((int)n4);
                GLES20.glDeleteProgram((int)n4);
                throw new RuntimeException("Could not link program: " + (String)object);
            }
        }
        object2 = new FilterContext();
        ((FilterContext)object2).texSamplerHandle = GLES20.glGetUniformLocation((int)n4, (String)"tex_sampler");
        ((FilterContext)object2).texCoordHandle = GLES20.glGetAttribLocation((int)n4, (String)"a_texcoord");
        ((FilterContext)object2).posCoordHandle = GLES20.glGetAttribLocation((int)n4, (String)"a_position");
        object = fArray2;
        if (fArray2 == null) {
            object = TEX_VERTICES;
        }
        ((FilterContext)object2).texVertices = RendererUtils.createVerticesBuffer((float[])object);
        object = fArray;
        if (fArray == null) {
            object = POS_VERTICES;
        }
        ((FilterContext)object2).posVertices = RendererUtils.createVerticesBuffer((float[])object);
        ((FilterContext)object2).shaderProgram = n4;
        return object2;
    }

    public static void createFrame() {
        GLES20.glGenFramebuffers((int)1, (int[])frame, (int)0);
        RendererUtils.checkGlError("glGenFramebuffers");
    }

    public static RenderContext createProgram() {
        return RendererUtils.createProgram(POS_VERTICES, TEX_VERTICES);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static RenderContext createProgram(float[] object, float[] fArray) {
        void var1_2;
        Object object2 = null;
        int n2 = RendererUtils.loadShader(35633, VERTEX_SHADER);
        if (n2 == 0) {
            return object2;
        }
        int n3 = RendererUtils.loadShader(35632, FRAGMENT_SHADER);
        if (n3 == 0) return object2;
        int n4 = GLES20.glCreateProgram();
        if (n4 != 0) {
            GLES20.glAttachShader((int)n4, (int)n2);
            RendererUtils.checkGlError("glAttachShader");
            GLES20.glAttachShader((int)n4, (int)n3);
            RendererUtils.checkGlError("glAttachShader");
            GLES20.glLinkProgram((int)n4);
            GLES20.glDeleteShader((int)n2);
            GLES20.glDeleteShader((int)n3);
            object2 = new int[1];
            GLES20.glGetProgramiv((int)n4, (int)35714, (int[])object2, (int)0);
            if (object2[0] != true) {
                String string2 = GLES20.glGetProgramInfoLog((int)n4);
                GLES20.glDeleteProgram((int)n4);
                throw new RuntimeException("Could not link program: " + string2);
            }
        }
        object2 = new RenderContext();
        RenderContext.access$602((RenderContext)object2, GLES20.glGetUniformLocation((int)n4, (String)"tex_sampler"));
        RenderContext.access$702((RenderContext)object2, GLES20.glGetUniformLocation((int)n4, (String)"alpha"));
        RenderContext.access$802((RenderContext)object2, GLES20.glGetUniformLocation((int)n4, (String)"bkg"));
        RenderContext.access$302((RenderContext)object2, GLES20.glGetAttribLocation((int)n4, (String)"a_texcoord"));
        RenderContext.access$502((RenderContext)object2, GLES20.glGetAttribLocation((int)n4, (String)"a_position"));
        RenderContext.access$402((RenderContext)object2, RendererUtils.createVerticesBuffer((float[])var1_2));
        RenderContext.access$002((RenderContext)object2, RendererUtils.createVerticesBuffer(object));
        RenderContext.access$202((RenderContext)object2, n4);
        return object2;
    }

    public static int createTexture() {
        int[] nArray = new int[1];
        GLES20.glGenTextures((int)nArray.length, (int[])nArray, (int)0);
        RendererUtils.checkGlError("glGenTextures");
        return nArray[0];
    }

    public static int createTexture(Bitmap bitmap) {
        int n2 = RendererUtils.createTexture();
        GLES20.glBindTexture((int)3553, (int)n2);
        GLUtils.texImage2D((int)3553, (int)0, (int)GLUtils.getInternalFormat((Bitmap)bitmap), (Bitmap)bitmap, (int)GLUtils.getType((Bitmap)bitmap), (int)0);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        RendererUtils.checkGlError("texImage2D");
        return n2;
    }

    private static FloatBuffer createVerticesBuffer(float[] fArray) {
        if (fArray.length != 8) {
            throw new RuntimeException("Number of vertices should be four.");
        }
        FloatBuffer floatBuffer = ByteBuffer.allocateDirect(fArray.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        floatBuffer.put(fArray).position(0);
        return floatBuffer;
    }

    public static void deleteFrame() {
        GLES20.glDeleteFramebuffers((int)1, (int[])frame, (int)0);
        RendererUtils.checkGlError("glDeleteFramebuffer");
    }

    public static void deleteProgram(int n2) {
        GLES20.glDeleteProgram((int)n2);
    }

    public static void fromTexture(Bitmap bitmap, int n2) {
        if (n2 >= 0) {
            GLES20.glBindFramebuffer((int)36160, (int)n2);
        }
        RendererUtils.checkGlError("glBindFramebuffer");
        GLSLRender.nativeCopyPixelToBitmap(bitmap);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static float[] getFitVertices(int n2, int n3, int n4, int n5) {
        float f2 = (float)n2 / (float)n3;
        f2 = (float)n4 / (float)n5 / f2;
        float[] fArray = new float[8];
        System.arraycopy(POS_VERTICES, 0, fArray, 0, fArray.length);
        if (f2 > 1.0f) {
            fArray[0] = fArray[0] / f2;
            fArray[2] = fArray[2] / f2;
            fArray[4] = fArray[4] / f2;
            fArray[6] = fArray[6] / f2;
            return fArray;
        }
        fArray[1] = fArray[1] * f2;
        fArray[3] = fArray[3] * f2;
        fArray[5] = fArray[5] * f2;
        fArray[7] = f2 * fArray[7];
        return fArray;
    }

    private static int loadShader(int n2, String object) {
        int n3 = GLES20.glCreateShader((int)n2);
        if (n3 != 0) {
            GLES20.glShaderSource((int)n3, (String)object);
            GLES20.glCompileShader((int)n3);
            object = new int[1];
            GLES20.glGetShaderiv((int)n3, (int)35713, (int[])object, (int)0);
            if (object[0] == false) {
                object = GLES20.glGetShaderInfoLog((int)n3);
                GLES20.glDeleteShader((int)n3);
                throw new RuntimeException("Could not compile shader " + n2 + ":" + (String)object);
            }
        }
        return n3;
    }

    public static void renderBackground() {
        GLES20.glClearColor((float)0.203125f, (float)0.203125f, (float)0.21484375f, (float)1.0f);
        GLES20.glClear((int)16384);
    }

    public static void renderTexture(RenderContext renderContext, int n2, int n3, int n4) {
        GLES20.glUseProgram((int)renderContext.shaderProgram);
        if (GLES20.glGetError() != 0) {
            RendererUtils.createProgram();
            RendererUtils.checkGlError("createProgram");
        }
        GLES20.glViewport((int)0, (int)0, (int)n3, (int)n4);
        RendererUtils.checkGlError("glViewport");
        GLES20.glDisable((int)3042);
        GLES20.glVertexAttribPointer((int)renderContext.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)renderContext.texVertices);
        GLES20.glEnableVertexAttribArray((int)renderContext.texCoordHandle);
        GLES20.glVertexAttribPointer((int)renderContext.posCoordHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)renderContext.posVertices);
        GLES20.glEnableVertexAttribArray((int)renderContext.posCoordHandle);
        RendererUtils.checkGlError("vertex attribute setup");
        GLES20.glActiveTexture((int)33984);
        RendererUtils.checkGlError("glActiveTexture");
        GLES20.glBindTexture((int)3553, (int)n2);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        RendererUtils.checkGlError("glBindTexture");
        GLES20.glUniform1i((int)renderContext.texSamplerHandle, (int)0);
        GLES20.glUniform1f((int)renderContext.alphaHandle, (float)renderContext.alpha);
        GLES20.glUniform4f((int)renderContext.bkgHandle, (float)0.203125f, (float)0.203125f, (float)0.21484375f, (float)1.0f);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glFinish();
    }

    public static void renderTexture2FBO(FilterContext filterContext, int n2, int n3, int n4, int n5) {
        GLES20.glActiveTexture((int)33984);
        RendererUtils.checkGlError("glActiveTexture");
        GLES20.glBindTexture((int)3553, (int)n3);
        RendererUtils.checkGlError("glBindTexture");
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)n4, (int)n5, (int)0, (int)6408, (int)5121, null);
        RendererUtils.checkGlError("glTexImage2D");
        GLES20.glBindFramebuffer((int)36160, (int)frame[0]);
        RendererUtils.checkGlError("glBindFramebuffer");
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)n3, (int)0);
        RendererUtils.checkGlError("glFramebufferTexture2D");
        GLES20.glViewport((int)0, (int)0, (int)n4, (int)n5);
        RendererUtils.checkGlError("glViewport");
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GLES20.glClear((int)16384);
        GLES20.glUseProgram((int)filterContext.shaderProgram);
        if (GLES20.glGetError() != 0) {
            RendererUtils.checkGlError("createProgram");
        }
        GLES20.glVertexAttribPointer((int)filterContext.texCoordHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)filterContext.texVertices);
        GLES20.glEnableVertexAttribArray((int)filterContext.texCoordHandle);
        GLES20.glVertexAttribPointer((int)filterContext.posCoordHandle, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)filterContext.posVertices);
        GLES20.glEnableVertexAttribArray((int)filterContext.posCoordHandle);
        RendererUtils.checkGlError("vertex attribute setup");
        GLES20.glUniform1i((int)filterContext.texSamplerHandle, (int)0);
        RendererUtils.checkGlError("glUniform1i");
        GLES20.glActiveTexture((int)33984);
        RendererUtils.checkGlError("glActiveTexture");
        GLES20.glBindTexture((int)3553, (int)n2);
        RendererUtils.checkGlError("glBindTexture");
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glFinish();
        GLES20.glBindFramebuffer((int)36160, (int)0);
        RendererUtils.checkGlError("glBindFramebuffer");
        RendererUtils.deleteProgram(filterContext.shaderProgram);
    }

    public static Bitmap saveTexture(int n2, int n3, int n4) {
        if (PhoneProperty.instance().isGpuWorkaroundForTU880()) {
            GLES20.glActiveTexture((int)33984);
            RendererUtils.checkGlError("glActiveTexture");
            GLES20.glBindTexture((int)3553, (int)n2);
            RendererUtils.checkGlError("glBindTexture");
            GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)n3, (int)n4, (int)0, (int)6408, (int)5121, null);
            RendererUtils.checkGlError("glTexImage2D");
        }
        GLES20.glBindFramebuffer((int)36160, (int)frame[0]);
        RendererUtils.checkGlError("glBindFramebuffer");
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)n2, (int)0);
        RendererUtils.checkGlError("glFramebufferTexture2D");
        RendererUtils.checkGlError("glReadPixels");
        Bitmap bitmap = Bitmap.createBitmap((int)n3, (int)n4, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        GLSLRender.nativeCopyPixelToBitmap(bitmap);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        RendererUtils.checkGlError("glBindFramebuffer");
        return bitmap;
    }

    public static WImage saveTexture2WImage(int n2, int n3, int n4) {
        if (PhoneProperty.instance().isGpuWorkaroundForTU880()) {
            GLES20.glActiveTexture((int)33984);
            RendererUtils.checkGlError("glActiveTexture");
            GLES20.glBindTexture((int)3553, (int)n2);
            RendererUtils.checkGlError("glBindTexture");
            GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)n3, (int)n4, (int)0, (int)6408, (int)5121, null);
            RendererUtils.checkGlError("glTexImage2D");
        }
        GLES20.glBindFramebuffer((int)36160, (int)frame[0]);
        RendererUtils.checkGlError("glBindFramebuffer");
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)n2, (int)0);
        RendererUtils.checkGlError("glFramebufferTexture2D");
        RendererUtils.checkGlError("glReadPixels");
        WImage wImage = GLSLRender.nativeCopyTexture(n3, n4);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        RendererUtils.checkGlError("glBindFramebuffer");
        return wImage;
    }

    public static void setRenderToAlpha(RenderContext renderContext, int n2) {
        RenderContext.access$102(renderContext, (float)n2 / 255.0f);
    }

    public static void setRenderToFit(RenderContext renderContext, int n2, int n3, int n4, int n5) {
        RenderContext.access$002(renderContext, RendererUtils.createVerticesBuffer(RendererUtils.getFitVertices(n2, n3, n4, n5)));
    }

    public static void setRenderToFlip(RenderContext renderContext, int n2, int n3, int n4, int n5, float f2, float f3) {
        float f4;
        float[] fArray = RendererUtils.getFitVertices(n2, n3, n4, n5);
        n3 = (int)f2 / 180;
        if (n3 % 2 != 0) {
            fArray[0] = -fArray[0];
            fArray[4] = fArray[0];
            fArray[2] = -fArray[2];
            fArray[6] = fArray[2];
        }
        if ((n2 = (int)f3 / 180) % 2 != 0) {
            fArray[1] = -fArray[1];
            fArray[3] = fArray[1];
            fArray[5] = -fArray[5];
            fArray[7] = fArray[5];
        }
        float[] fArray2 = new float[8];
        System.arraycopy(fArray, 0, fArray2, 0, fArray2.length);
        if (f2 % 180.0f != 0.0f) {
            f4 = (f2 - (float)(n3 * 180)) * ((float)Math.PI / 180);
            f2 = (float)Math.cos(f4);
            float f5 = (float)Math.sin(f4);
            f4 = 5.0f / (fArray[0] * f5 + 5.0f);
            fArray2[0] = fArray[0] * f2 * f4;
            fArray2[1] = fArray[1] * f4;
            fArray2[4] = fArray2[0];
            fArray2[5] = f4 * fArray[5];
            f4 = 5.0f / (f5 * fArray[2] + 5.0f);
            fArray2[2] = f2 * fArray[2] * f4;
            fArray2[3] = fArray[3] * f4;
            fArray2[6] = fArray2[2];
            fArray2[7] = f4 * fArray[7];
        }
        if (f3 % 180.0f != 0.0f) {
            f3 = (f3 - (float)(n2 * 180)) * ((float)Math.PI / 180);
            f2 = (float)Math.cos(f3);
            f4 = (float)Math.sin(f3);
            f3 = 5.0f / (fArray[1] * f4 + 5.0f);
            fArray2[0] = fArray[0] * f3;
            fArray2[1] = fArray[1] * f2 * f3;
            fArray2[2] = f3 * fArray[2];
            fArray2[3] = fArray2[1];
            f3 = 5.0f / (f4 * fArray[5] + 5.0f);
            fArray2[4] = fArray[4] * f3;
            fArray2[5] = f2 * fArray[5] * f3;
            fArray2[6] = fArray[6] * f3;
            fArray2[7] = fArray2[5];
        }
        RenderContext.access$002(renderContext, RendererUtils.createVerticesBuffer(fArray2));
    }

    public static void setRenderToRotate(RenderContext renderContext, int n2, int n3, int n4, int n5, float f2) {
        float[] fArray;
        f2 = -f2 * ((float)Math.PI / 180);
        float f3 = (float)Math.cos(f2);
        float f4 = (float)Math.sin(f2);
        float f5 = (float)n2 * f3;
        f2 = (float)n2 * f4;
        fArray = new float[]{-f5 + (f4 *= (float)n3), -f2 - (f3 *= (float)n3), f4 + f5, f2 - f3, -fArray[2], -fArray[3], -fArray[0], -fArray[1]};
        f5 = Math.max(Math.abs(fArray[0]), Math.abs(fArray[2]));
        f2 = Math.max(Math.abs(fArray[1]), Math.abs(fArray[3]));
        f2 = Math.min((float)n4 / f5, (float)n5 / f2);
        for (n2 = 0; n2 < 8; n2 += 2) {
            fArray[n2] = fArray[n2] * (f2 / (float)n4);
            n3 = n2 + 1;
            fArray[n3] = fArray[n3] * (f2 / (float)n5);
        }
        RenderContext.access$002(renderContext, RendererUtils.createVerticesBuffer(fArray));
    }

    public static void setRenderToScale(RenderContext renderContext, int n2, int n3, int n4, int n5, RectF rectF) {
        RenderContext.access$002(renderContext, RendererUtils.createVerticesBuffer(new float[]{rectF.left * 2.0f - 1.0f, 1.0f - rectF.bottom * 2.0f, rectF.right * 2.0f - 1.0f, 1.0f - rectF.bottom * 2.0f, rectF.left * 2.0f - 1.0f, 1.0f - rectF.top * 2.0f, rectF.right * 2.0f - 1.0f, 1.0f - rectF.top * 2.0f}));
    }

    public static void update2Texture(Bitmap bitmap, int n2) {
        GLES20.glBindTexture((int)3553, (int)n2);
        GLUtils.texImage2D((int)3553, (int)0, (int)GLUtils.getInternalFormat((Bitmap)bitmap), (Bitmap)bitmap, (int)GLUtils.getType((Bitmap)bitmap), (int)0);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        RendererUtils.checkGlError("texImage2D");
    }

    public static class FilterContext {
        public int posCoordHandle;
        public FloatBuffer posVertices;
        public int shaderProgram;
        public int texCoordHandle;
        public int texSamplerHandle;
        public FloatBuffer texVertices;
    }

    public static class RenderContext {
        private float alpha = 1.0f;
        private int alphaHandle;
        private int bkgHandle;
        private int posCoordHandle;
        private FloatBuffer posVertices;
        private int shaderProgram;
        private int texCoordHandle;
        private int texSamplerHandle;
        private FloatBuffer texVertices;

        static /* synthetic */ FloatBuffer access$002(RenderContext renderContext, FloatBuffer floatBuffer) {
            renderContext.posVertices = floatBuffer;
            return floatBuffer;
        }

        static /* synthetic */ float access$102(RenderContext renderContext, float f2) {
            renderContext.alpha = f2;
            return f2;
        }

        static /* synthetic */ int access$202(RenderContext renderContext, int n2) {
            renderContext.shaderProgram = n2;
            return n2;
        }

        static /* synthetic */ int access$302(RenderContext renderContext, int n2) {
            renderContext.texCoordHandle = n2;
            return n2;
        }

        static /* synthetic */ FloatBuffer access$402(RenderContext renderContext, FloatBuffer floatBuffer) {
            renderContext.texVertices = floatBuffer;
            return floatBuffer;
        }

        static /* synthetic */ int access$502(RenderContext renderContext, int n2) {
            renderContext.posCoordHandle = n2;
            return n2;
        }

        static /* synthetic */ int access$602(RenderContext renderContext, int n2) {
            renderContext.texSamplerHandle = n2;
            return n2;
        }

        static /* synthetic */ int access$702(RenderContext renderContext, int n2) {
            renderContext.alphaHandle = n2;
            return n2;
        }

        static /* synthetic */ int access$802(RenderContext renderContext, int n2) {
            renderContext.bkgHandle = n2;
            return n2;
        }
    }
}

