/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.api.filter.filters;

import android.graphics.Bitmap;
import com.wuba.api.filter.BaseFilter;
import com.wuba.api.filter.BaseFilterDes;
import com.wuba.api.filter.GLParam;

public class VideoWaterMarkFilter
extends BaseFilterDes {
    private static final String main_0 = "precision highp float;\nvarying highp vec2 textureCoordinate;\nuniform sampler2D inputImageTexture;\nuniform sampler2D inputImageTexture2;\nuniform float mvPictureX;\nuniform float mvPictureY;\nuniform float mvPictureW;\nuniform float mvPictureH;\nuniform float mvPictureAlpha;\nuniform int mvReversed;\nvoid main()\n{\n\tvec4 baseColor;\n";
    private static final String main_1_0 = "\t\tbaseColor = texture2D(inputImageTexture2, vec2(textureCoordinate.x, 1.0 - textureCoordinate.y));\n";
    private static final String main_1_1 = "\t\tbaseColor = texture2D(inputImageTexture, textureCoordinate);\n";
    private static final String main_2 = "\tvec2 pos = textureCoordinate;\n\tpos.x -= mvPictureX;\n\tpos.y -= mvPictureY;\n\tif(pos.x < 0.0 || pos.x > max(mvPictureW, -mvPictureW) || pos.y < 0.0 || pos.y > max(mvPictureH, -mvPictureH)) {\n\t\tgl_FragColor = baseColor;\n\t\treturn;\n\t}\n\tpos.x /= mvPictureW;\n\tpos.y /= mvPictureH;\n\tif(pos.x < 0.0){\n\t\tpos.x += 1.0;\n\t}\n\tif(pos.y < 0.0){\n    \tpos.y += 1.0;\n\t}\n\tpos = clamp(pos, 0.0, 1.0);\n\tvec4 picColor;\n";
    private static final String main_3_0_reversed = "\t\tpicColor = texture2D(inputImageTexture, pos);\n";
    private static final String main_3_0_reversed_preview = "\t\tpicColor = texture2D(inputImageTexture, vec2(pos.x, 1.0/mvPictureH - pos.y));\n";
    private static final String main_3_1 = "\t\tpicColor = texture2D(inputImageTexture2, pos);\n";
    private static final String main_3_1_preview = "\t\tpicColor = texture2D(inputImageTexture2, vec2(pos.x, 1.0/mvPictureH - pos.y));\n";
    private static final String main_end = "\tpicColor = picColor * mvPictureAlpha;\n\tvec4 finalColor = picColor + (1.0 - picColor.a) * baseColor;\n\tgl_FragColor = finalColor;\n}\n";
    VideoWaterMarkBaseFilter filter;
    boolean mIsPreview = false;
    GLParam.TextureBitmapGLDelayUpdateParam mParam;
    GLParam.FloatGLParam mPictureH;
    GLParam.FloatGLParam mPictureW;
    GLParam.FloatGLParam mPictureX;
    GLParam.FloatGLParam mPictureY;
    GLParam.IntGLParam mReversed;
    GLParam.FloatGLParam mvPictureAlpha;
    int reversed;

    public VideoWaterMarkFilter(int n2, boolean bl) {
        super("VideoWaterMarkFilter", -1, 0);
        this.reversed = n2;
        this.mIsPreview = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getMain3() {
        if (this.reversed > 0) {
            if (!this.mIsPreview) return main_3_0_reversed;
            return main_3_0_reversed_preview;
        }
        if (!this.mIsPreview) return main_3_1;
        return main_3_1_preview;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public BaseFilter newFilter() {
        if (this.filter != null) {
            return this.filter;
        }
        this.filter = new VideoWaterMarkBaseFilter(this, -1);
        this.filter.textureParam = new GLParam.TextureBitmapGLDelayUpdateParam("inputImageTexture2", 33985);
        this.filter.mvPictureXParam = new GLParam.FloatGLParam("mvPictureX", 0.0f);
        this.filter.mvPictureYParam = new GLParam.FloatGLParam("mvPictureY", 0.0f);
        this.filter.mvPictureWParam = new GLParam.FloatGLParam("mvPictureW", 1.0f);
        this.filter.mvPictureHParam = new GLParam.FloatGLParam("mvPictureH", 1.0f);
        this.filter.mvPictureAlphaParam = new GLParam.FloatGLParam("mvPictureAlpha", 1.0f);
        this.filter.mvReversedParam = new GLParam.IntGLParam("mvReversed", 0);
        this.filter.addParam(this.filter.textureParam);
        this.filter.addParam(this.filter.mvPictureXParam);
        this.filter.addParam(this.filter.mvPictureYParam);
        this.filter.addParam(this.filter.mvPictureWParam);
        this.filter.addParam(this.filter.mvPictureHParam);
        this.filter.addParam(this.filter.mvPictureAlphaParam);
        this.filter.addParam(this.filter.mvReversedParam);
        VideoWaterMarkBaseFilter videoWaterMarkBaseFilter = this.filter;
        StringBuilder stringBuilder = new StringBuilder().append(main_0);
        String string2 = this.reversed > 0 ? main_1_0 : main_1_1;
        videoWaterMarkBaseFilter.fragmentShaderString = stringBuilder.append(string2).append(main_2).append(this.getMain3()).append(main_end).append("\u0000").toString();
        return this.filter;
    }

    public class VideoWaterMarkBaseFilter
    extends BaseFilter {
        GLParam.FloatGLParam mvPictureAlphaParam;
        GLParam.FloatGLParam mvPictureHParam;
        GLParam.FloatGLParam mvPictureWParam;
        GLParam.FloatGLParam mvPictureXParam;
        GLParam.FloatGLParam mvPictureYParam;
        GLParam.IntGLParam mvReversedParam;
        GLParam.TextureBitmapGLDelayUpdateParam textureParam;

        public VideoWaterMarkBaseFilter(BaseFilterDes baseFilterDes, int n2) {
            super(baseFilterDes, n2);
        }

        public void updateBitmap(Bitmap bitmap) {
            if (bitmap != null) {
                this.textureParam.updateParam(bitmap);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void updateParams(float f2, float f3, float f4, float f5, float f6, int n2, boolean bl) {
            this.mvPictureXParam.updateParam(f2);
            if (bl) {
                this.mvPictureYParam.updateParam(0.0f - f3);
            } else {
                this.mvPictureYParam.updateParam(f3);
            }
            this.mvPictureWParam.updateParam(f4);
            this.mvPictureHParam.updateParam(f5);
            this.mvPictureAlphaParam.updateParam(f6);
            this.mvReversedParam.updateParam(n2);
        }
    }
}

