/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.api.filter.filters;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Parcel;
import com.wuba.api.filter.BaseFilter;
import com.wuba.api.filter.BaseFilterDes;
import com.wuba.api.filter.GLParam;
import com.wuba.api.filter.GLSLRender;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class WaterMarkFilter
extends BaseFilterDes {
    private Bitmap bitmap;
    private BaseFilter filter;
    private float height = 1.0f;
    private float width = 1.0f;
    private float x = 0.0f;
    private float y = 0.0f;

    public WaterMarkFilter(Bitmap bitmap) {
        super("CropFilter", GLSLRender.FILTER_WATER_MARK, 0);
        this.bitmap = bitmap;
    }

    public WaterMarkFilter(Bitmap bitmap, int n2, int n3, int n4, int n5) {
        super("CropFilter", GLSLRender.FILTER_WATER_MARK, 0);
        this.bitmap = bitmap;
        this.x = n2;
        this.y = n3;
        this.width = n4;
        this.height = n5;
    }

    public WaterMarkFilter(Parcel parcel) {
        super(parcel);
        byte[] byArray = new byte[parcel.readInt()];
        parcel.readByteArray(byArray);
        this.bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
        this.x = parcel.readFloat();
        this.y = parcel.readFloat();
        this.width = parcel.readFloat();
        this.height = parcel.readFloat();
    }

    @Override
    public BaseFilter newFilter() {
        this.filter = new BaseFilter(this, GLSLRender.FILTER_WATER_MARK);
        this.filter.addParam(new GLParam.TextureBitmapGLParam("inputImageTexture2", this.bitmap, 33985));
        return this.filter;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n2) {
        super.writeToParcel(parcel, n2);
        parcel.writeInt(this.bitmap.getByteCount());
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.bitmap.getByteCount());
        this.bitmap.copyPixelsToBuffer((Buffer)byteBuffer);
        parcel.writeByteArray(byteBuffer.array());
        parcel.writeFloat(this.x);
        parcel.writeFloat(this.y);
        parcel.writeFloat(this.width);
        parcel.writeFloat(this.height);
    }
}

