/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.cache.download;

import android.os.AsyncTask;
import android.os.SystemClock;
import android.text.TextUtils;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.wuba.cache.download.DownloadThreadPoolUtil;
import com.wuba.cache.download.FileDownloadFinishCallBack;
import com.wuba.cache.download.FileEntityHandler;
import com.wuba.cache.download.FileProgressCallBack;
import com.wuba.cache.download.UserStopException;
import com.wuba.recorder.util.LogUtils;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;

public class HttpFilesHandler<T>
extends AsyncTask<Object, Object, Object>
implements FileProgressCallBack {
    private static final String TAG = HttpFilesHandler.class.getSimpleName();
    private static final int UPDATE_FAILURE = 3;
    private static final int UPDATE_LOADING = 2;
    private static final int UPDATE_START = 1;
    private static final int UPDATE_SUCCESS = 4;
    private final FileDownloadFinishCallBack<T> callback;
    private final OkHttpClient client;
    private String[] downloadUrl;
    private int executionCount = 0;
    int fileCount = 1;
    private boolean isResume = true;
    private final FileEntityHandler mFileEntityHandler = new FileEntityHandler();
    private int mPriority = 5;
    private String[] targetUri = null;
    private long time;

    public HttpFilesHandler(String[] stringArray, OkHttpClient okHttpClient, FileDownloadFinishCallBack<T> fileDownloadFinishCallBack, boolean bl) {
        this.downloadUrl = stringArray;
        this.fileCount = this.downloadUrl.length;
        this.client = okHttpClient;
        this.callback = fileDownloadFinishCallBack;
        this.isResume = bl;
    }

    /*
     * Unable to fully structure code
     */
    private void handleResponse(Response var1_1, int var2_3) throws IOException {
        block6: {
            if (var1_1 == null || !var1_1.isSuccessful()) break block6;
            var4_6 = var3_4 = null;
            if (var1_1 == null) ** GOTO lbl13
            try {
                this.time = SystemClock.uptimeMillis();
                var4_6 = var3_4;
            }
            catch (Exception var1_2) {
                this.publishProgress(new Object[]{3, new Exception("HandleEntity Exception"), -101, ""});
                throw new IOException("HandleEntity Exception");
            }
            if (this.targetUri != null) {
                var4_6 = this.mFileEntityHandler.handleEntity(var1_1, this, this.targetUri[var2_3], this.isResume, var2_3);
            }
lbl13:
            // 4 sources

            this.publishProgress(new Object[]{4, var4_6, var2_3});
            return;
        }
        var4_7 = var3_5 = "response status error code:" + var1_1.code();
        if (var1_1.code() == 416) {
            var4_7 = var3_5;
            if (this.isResume) {
                var4_7 = var3_5 + " \n maybe you have download complete.";
            }
        }
        this.publishProgress(new Object[]{3, new IOException(), var1_1.code(), var4_7});
        throw new IOException("StatusCode Error:" + var1_1.code());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void makeRequestWithRetries(Request request, int n2) throws IOException {
        Object object = new File(this.targetUri[n2]);
        if (this.isResume && this.targetUri != null && ((File)object).isFile() && ((File)object).exists()) {
            ((File)object).delete();
        }
        object = null;
        boolean bl = true;
        while (bl) {
            try {
                if (this.isCancelled()) return;
                object = this.client.newCall(request).execute();
                if (this.isCancelled()) return;
                this.handleResponse((Response)object, n2);
                return;
            }
            catch (UserStopException userStopException) {
                LogUtils.d("", "Userstop?" + userStopException.getMessage());
                break;
            }
            catch (UnknownHostException unknownHostException) {
                this.publishProgress(new Object[]{3, unknownHostException, 0, "unknownHostException\uff1acan't resolve host"});
                return;
            }
            catch (IOException iOException) {
                this.publishProgress(new Object[]{3, iOException, 0, iOException.getMessage()});
                bl = false;
            }
            catch (NullPointerException nullPointerException) {
                object = new IOException("NPE in OkHttpClient" + nullPointerException.getMessage());
                bl = false;
            }
            catch (Exception exception) {
                object = new IOException("Exception" + exception.getMessage());
                bl = false;
            }
        }
        if (object == null) throw new IOException("\u672a\u77e5\u7f51\u7edc\u9519\u8bef");
        throw object;
    }

    public static HttpFilesHandler<File> newInstanceAsyncTask(HttpFilesHandler<File> httpFilesHandler) {
        return new HttpFilesHandler<File>(httpFilesHandler.getDownloadUrl(), httpFilesHandler.getClient(), httpFilesHandler.getCallback(), httpFilesHandler.isResume());
    }

    private void setPrority(int n2) {
        this.mPriority = n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void callBack(long l2, long l3, boolean bl, int n2) {
        if (this.callback == null) return;
        if (!this.callback.isProgress()) return;
        if (bl) {
            this.publishProgress(new Object[]{2, l2, l3, n2});
            return;
        }
        long l4 = SystemClock.uptimeMillis();
        if (l4 - this.time < (long)this.callback.getRate()) return;
        this.time = l4;
        this.publishProgress(new Object[]{2, l2, l3, n2});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object doInBackground(Object ... objectArray) {
        if (objectArray != null && objectArray.length == 3) {
            this.targetUri = (String[])objectArray[1];
            this.isResume = (Boolean)objectArray[2];
        }
        DownloadThreadPoolUtil.filterDowloadThreadPool.activeHandlers.add(this);
        LogUtils.d("HttpFilesHandler", "HttpFilesDownload begin -->");
        this.setCurrentThreadPriority(this.mPriority);
        this.publishProgress(new Object[]{1});
        objectArray = (Request[])objectArray[0];
        int n2 = objectArray.length;
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++n3, ++i2) {
            Object object = objectArray[i2];
            try {
                StringBuilder stringBuilder = new StringBuilder();
                LogUtils.d("HttpFilesHandler", stringBuilder.append("downloadfile begin-->").append(this.targetUri[n3]).toString());
                this.makeRequestWithRetries((Request)object, n3);
                object = new StringBuilder();
                LogUtils.d("HttpFilesHandler", ((StringBuilder)object).append("downloadfile finish-->").append(this.targetUri[n3]).toString());
                continue;
            }
            catch (IOException iOException) {
                LogUtils.d("HttpFilesHandler", "Userstop" + iOException.getMessage());
                this.publishProgress(new Object[]{3, iOException, 0, iOException.getMessage()});
                break;
            }
            catch (Exception exception) {
                LogUtils.d("HttpFilesHandler", "otherException" + exception.getMessage());
                this.publishProgress(new Object[]{3, exception, 0, exception.getMessage()});
                break;
            }
        }
        this.setCurrentThreadPriority(5);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof HttpFilesHandler)) return super.equals(object);
        if (this.downloadUrl == null) return false;
        if (this.downloadUrl.length == 0) {
            return false;
        }
        if (((HttpFilesHandler)object).downloadUrl == null) return false;
        if (((HttpFilesHandler)object).downloadUrl.length == 0) {
            return false;
        }
        if (!TextUtils.equals((CharSequence)this.downloadUrl[0], (CharSequence)((HttpFilesHandler)object).downloadUrl[0])) return super.equals(object);
        return true;
    }

    public FileDownloadFinishCallBack<T> getCallback() {
        return this.callback;
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    public String[] getDownloadUrl() {
        return this.downloadUrl;
    }

    public boolean isResume() {
        return this.isResume;
    }

    public boolean isStop() {
        return this.mFileEntityHandler.isStop();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void onProgressUpdate(Object ... objectArray) {
        block15: {
            switch (Integer.valueOf(String.valueOf(objectArray[0]))) {
                case 1: {
                    if (this.callback != null) {
                        this.callback.onStart();
                    }
                    break block15;
                }
                case 2: {
                    if (this.callback != null) {
                        this.callback.onLoading(Long.valueOf(String.valueOf(objectArray[1])), Long.valueOf(String.valueOf(objectArray[2])), (Integer)objectArray[3], this.fileCount);
                    }
                    break block15;
                }
                case 3: {
                    DownloadThreadPoolUtil.filterDowloadThreadPool.activeHandlers.remove(this);
                    break;
                }
                case 4: {
                    if (this.callback != null) {
                        this.callback.onSuccess(objectArray[1], (Integer)objectArray[2]);
                        if ((Integer)objectArray[2] == this.fileCount - 1) {
                            try {
                                DownloadThreadPoolUtil.filterDowloadThreadPool.activeHandlers.remove(this);
                            }
                            catch (Exception exception) {}
                        }
                    }
                    break block15;
                }
                catch (Exception exception) {}
            }
            if (this.callback != null) {
                this.callback.onFailure((Throwable)objectArray[1], (Integer)objectArray[2], (String)objectArray[3]);
            }
        }
        super.onProgressUpdate(objectArray);
    }

    public void setCurrentThreadPriority(int n2) {
        Thread.currentThread().setPriority(n2);
    }

    public void setDownloadUrl(String[] stringArray) {
        this.downloadUrl = stringArray;
    }

    public void setResume(boolean bl) {
        this.isResume = bl;
    }

    public void stop() {
        this.mFileEntityHandler.setStop(true);
    }
}

