/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.cache.download;

import android.os.Handler;
import android.os.Looper;
import android.widget.ImageView;
import com.google.gson.Gson;
import com.google.gson.internal.$Gson$Types;
import com.squareup.okhttp.FormEncodingBuilder;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.MultipartBuilder;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.wuba.cache.download.c;
import com.wuba.cache.download.d;
import com.wuba.cache.download.e;
import com.wuba.cache.download.f;
import com.wuba.cache.download.g;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class OkHttpClientManager {
    private static final String SESSION_KEY = "Set-Cookie";
    private static final String TAG = "OkHttpClientManager";
    private static OkHttpClientManager mInstance;
    private static final String mSessionKey = "JSESSIONID";
    private Handler mDelivery;
    private Gson mGson;
    private OkHttpClient mOkHttpClient;
    private Map<String, String> mSessions = new HashMap<String, String>();

    private OkHttpClientManager() {
        this.mOkHttpClient = new OkHttpClient();
        this.mOkHttpClient.setCookieHandler(new CookieManager(null, CookiePolicy.ACCEPT_ORIGINAL_SERVER));
        this.mDelivery = new Handler(Looper.getMainLooper());
        this.mGson = new Gson();
    }

    private void _downloadAsyn(String string2, String string3, ResultCallback resultCallback) {
        Request request = new Request.Builder().url(string2).build();
        this.mOkHttpClient.newCall(request).enqueue(new c(this, resultCallback, string3, string2));
    }

    private String _getAsString(String string2) throws IOException {
        return this._getAsyn(string2).body().string();
    }

    private Response _getAsyn(String object) throws IOException {
        object = new Request.Builder().url((String)object).build();
        return this.mOkHttpClient.newCall((Request)object).execute();
    }

    private void _getAsyn(String string2, ResultCallback resultCallback) {
        this.deliveryResult(resultCallback, new Request.Builder().url(string2).build());
    }

    private Response _post(String object, File file, String string2) throws IOException {
        object = this.buildMultipartFormRequest((String)object, new File[]{file}, new String[]{string2}, null);
        return this.mOkHttpClient.newCall((Request)object).execute();
    }

    private Response _post(String object, File file, String string2, Param ... paramArray) throws IOException {
        object = this.buildMultipartFormRequest((String)object, new File[]{file}, new String[]{string2}, paramArray);
        return this.mOkHttpClient.newCall((Request)object).execute();
    }

    private Response _post(String object, Param ... paramArray) throws IOException {
        object = this.buildPostRequest((String)object, paramArray);
        return this.mOkHttpClient.newCall((Request)object).execute();
    }

    private Response _post(String object, File[] fileArray, String[] stringArray, Param ... paramArray) throws IOException {
        object = this.buildMultipartFormRequest((String)object, fileArray, stringArray, paramArray);
        return this.mOkHttpClient.newCall((Request)object).execute();
    }

    private String _postAsString(String string2, Param ... paramArray) throws IOException {
        return this._post(string2, paramArray).body().string();
    }

    private void _postAsyn(String string2, ResultCallback resultCallback, File file, String string3) throws IOException {
        this.deliveryResult(resultCallback, this.buildMultipartFormRequest(string2, new File[]{file}, new String[]{string3}, null));
    }

    private void _postAsyn(String string2, ResultCallback resultCallback, File file, String string3, Param ... paramArray) throws IOException {
        this.deliveryResult(resultCallback, this.buildMultipartFormRequest(string2, new File[]{file}, new String[]{string3}, paramArray));
    }

    private void _postAsyn(String string2, ResultCallback resultCallback, Map<String, String> map) {
        this.deliveryResult(resultCallback, this.buildPostRequest(string2, this.map2Params(map)));
    }

    private void _postAsyn(String string2, ResultCallback resultCallback, Param ... paramArray) {
        this.deliveryResult(resultCallback, this.buildPostRequest(string2, paramArray));
    }

    private void _postAsyn(String string2, ResultCallback resultCallback, File[] fileArray, String[] stringArray, Param ... paramArray) throws IOException {
        this.deliveryResult(resultCallback, this.buildMultipartFormRequest(string2, fileArray, stringArray, paramArray));
    }

    static /* synthetic */ void access$000(OkHttpClientManager okHttpClientManager, Request request, Exception exception, ResultCallback resultCallback) {
        okHttpClientManager.sendFailedStringCallback(request, exception, resultCallback);
    }

    static /* synthetic */ String access$100(OkHttpClientManager okHttpClientManager, String string2) {
        return okHttpClientManager.getFileName(string2);
    }

    static /* synthetic */ void access$200(OkHttpClientManager okHttpClientManager, Object object, ResultCallback resultCallback) {
        okHttpClientManager.sendSuccessResultCallback(object, resultCallback);
    }

    static /* synthetic */ Gson access$300(OkHttpClientManager okHttpClientManager) {
        return okHttpClientManager.mGson;
    }

    private Request buildMultipartFormRequest(String string2, File[] object, String[] stringArray, Param[] object2) {
        Object object3;
        int n2;
        Object object4 = this.validateParam((Param[])object2);
        object2 = new MultipartBuilder().type(MultipartBuilder.FORM);
        int n3 = ((Param[])object4).length;
        for (n2 = 0; n2 < n3; ++n2) {
            object3 = object4[n2];
            ((MultipartBuilder)object2).addPart(Headers.of("Content-Disposition", "form-data; name=\"" + ((Param)object3).key + "\""), RequestBody.create(null, ((Param)object3).value));
        }
        if (object != null) {
            for (n2 = 0; n2 < ((File[])object).length; ++n2) {
                object3 = object[n2];
                object4 = ((File)object3).getName();
                object3 = RequestBody.create(MediaType.parse(this.guessMimeType((String)object4)), (File)object3);
                ((MultipartBuilder)object2).addPart(Headers.of("Content-Disposition", "form-data; name=\"" + stringArray[n2] + "\"; filename=\"" + (String)object4 + "\""), (RequestBody)object3);
            }
        }
        object = ((MultipartBuilder)object2).build();
        return new Request.Builder().url(string2).post((RequestBody)object).build();
    }

    private Request buildPostRequest(String string2, Param[] object) {
        int n2 = 0;
        Param[] paramArray = object;
        if (object == null) {
            paramArray = new Param[]{};
        }
        FormEncodingBuilder formEncodingBuilder = new FormEncodingBuilder();
        int n3 = paramArray.length;
        while (n2 < n3) {
            object = paramArray[n2];
            formEncodingBuilder.add(object.key, object.value);
            ++n2;
        }
        object = formEncodingBuilder.build();
        return new Request.Builder().url(string2).post((RequestBody)object).build();
    }

    private void deliveryResult(ResultCallback resultCallback, Request request) {
        this.mOkHttpClient.newCall(request).enqueue(new e(this, resultCallback));
    }

    public static void downloadAsyn(String string2, String string3, ResultCallback resultCallback) {
        OkHttpClientManager.getInstance()._downloadAsyn(string2, string3, resultCallback);
    }

    public static String getAsString(String string2) throws IOException {
        return OkHttpClientManager.getInstance()._getAsString(string2);
    }

    public static Response getAsyn(String string2) throws IOException {
        return OkHttpClientManager.getInstance()._getAsyn(string2);
    }

    public static void getAsyn(String string2, ResultCallback resultCallback) {
        OkHttpClientManager.getInstance()._getAsyn(string2, resultCallback);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getFileName(String string2) {
        int n2 = string2.lastIndexOf("/");
        if (n2 >= 0) return string2.substring(n2 + 1, string2.length());
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static OkHttpClientManager getInstance() {
        if (mInstance == null) {
            synchronized (OkHttpClientManager.class) {
                if (mInstance == null) {
                    OkHttpClientManager okHttpClientManager;
                    mInstance = okHttpClientManager = new OkHttpClientManager();
                }
            }
        }
        return mInstance;
    }

    private String guessMimeType(String string2) {
        String string3;
        string2 = string3 = URLConnection.getFileNameMap().getContentTypeFor(string2);
        if (string3 == null) {
            string2 = "application/octet-stream";
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Param[] map2Params(Map<String, String> object) {
        if (object == null) {
            return new Param[0];
        }
        Param[] paramArray = new Param[object.size()];
        Iterator iterator = object.entrySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            object = iterator.next();
            paramArray[n2] = new Param((String)object.getKey(), (String)object.getValue());
            ++n2;
        }
        return paramArray;
    }

    public static Response post(String string2, File file, String string3) throws IOException {
        return OkHttpClientManager.getInstance()._post(string2, file, string3);
    }

    public static Response post(String string2, File file, String string3, Param ... paramArray) throws IOException {
        return OkHttpClientManager.getInstance()._post(string2, file, string3, paramArray);
    }

    public static Response post(String string2, Param ... paramArray) throws IOException {
        return OkHttpClientManager.getInstance()._post(string2, paramArray);
    }

    public static Response post(String string2, File[] fileArray, String[] stringArray, Param ... paramArray) throws IOException {
        return OkHttpClientManager.getInstance()._post(string2, fileArray, stringArray, paramArray);
    }

    public static String postAsString(String string2, Param ... paramArray) throws IOException {
        return OkHttpClientManager.getInstance()._postAsString(string2, paramArray);
    }

    public static void postAsyn(String string2, ResultCallback resultCallback, File file, String string3) throws IOException {
        OkHttpClientManager.getInstance()._postAsyn(string2, resultCallback, file, string3);
    }

    public static void postAsyn(String string2, ResultCallback resultCallback, File file, String string3, Param ... paramArray) throws IOException {
        OkHttpClientManager.getInstance()._postAsyn(string2, resultCallback, file, string3, paramArray);
    }

    public static void postAsyn(String string2, ResultCallback resultCallback, Map<String, String> map) {
        OkHttpClientManager.getInstance()._postAsyn(string2, resultCallback, map);
    }

    public static void postAsyn(String string2, ResultCallback resultCallback, Param ... paramArray) {
        OkHttpClientManager.getInstance()._postAsyn(string2, resultCallback, paramArray);
    }

    public static void postAsyn(String string2, ResultCallback resultCallback, File[] fileArray, String[] stringArray, Param ... paramArray) throws IOException {
        OkHttpClientManager.getInstance()._postAsyn(string2, resultCallback, fileArray, stringArray, paramArray);
    }

    private void sendFailedStringCallback(Request request, Exception exception, ResultCallback resultCallback) {
        this.mDelivery.post((Runnable)new f(this, resultCallback, request, exception));
    }

    private void sendSuccessResultCallback(Object object, ResultCallback resultCallback) {
        this.mDelivery.post((Runnable)new g(this, resultCallback, object));
    }

    private void setErrorResId(ImageView imageView, int n2) {
        this.mDelivery.post((Runnable)new d(this, imageView, n2));
    }

    private Param[] validateParam(Param[] paramArray) {
        Param[] paramArray2 = paramArray;
        if (paramArray == null) {
            paramArray2 = new Param[]{};
        }
        return paramArray2;
    }

    public static class Param {
        String key;
        String value;

        public Param() {
        }

        public Param(String string2, String string3) {
            this.key = string2;
            this.value = string3;
        }
    }

    public static abstract class ResultCallback<T> {
        Type mType = ResultCallback.getSuperclassTypeParameter(this.getClass());

        static Type getSuperclassTypeParameter(Class<?> type) {
            if ((type = type.getGenericSuperclass()) instanceof Class) {
                throw new RuntimeException("Missing type parameter.");
            }
            return $Gson$Types.canonicalize(((ParameterizedType)type).getActualTypeArguments()[0]);
        }

        public abstract void onError(Request var1, Exception var2);

        public abstract void onResponse(T var1);
    }
}

