/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.cache.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.widget.ImageView;
import com.a.a.ao;
import com.a.a.b;
import com.a.a.c;
import com.wuba.cache.util.FileUtils;
import com.wuba.cache.util.StringUtils;
import com.wuba.cache.util.WBCommonUtils;
import com.wuba.parsedata.ParseVideoJson;
import com.wuba.parsedata.bean.BaseElements;
import com.wuba.parsedata.bean.WatermarkElements;
import com.wuba.recorder.util.LogUtils;
import java.io.InputStream;

public class PicassoHelper {
    private static final int MAX_DISK_CACHE_SIZE = 0x2800000;
    private static final int MAX_MEMORY_CACHE_SIZE = 0x500000;
    private static final String TAG = PicassoHelper.class.getSimpleName();
    private static PicassoHelper mInstance;
    private Context mContext;
    private c mPicasso;

    public PicassoHelper(Context context) {
        this.mContext = context;
        this.mPicasso = new c.a(context).a(new b(context, 0x2800000L)).a(new ao(0x500000)).a();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PicassoHelper getInstance(Context context) {
        if (mInstance == null) {
            synchronized (PicassoHelper.class) {
                PicassoHelper picassoHelper;
                mInstance = picassoHelper = new PicassoHelper(context);
            }
        }
        return mInstance;
    }

    private int getRawResId(String string2) {
        int n2;
        String string3 = FileUtils.getFileRawName(string2);
        string2 = WBCommonUtils.mContext.getPackageName();
        int n3 = n2 = WBCommonUtils.mContext.getResources().getIdentifier(string3, "raw", string2);
        if (n2 <= 0) {
            n3 = WBCommonUtils.mContext.getResources().getIdentifier(string3, "drawable", string2);
        }
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Bitmap decodeBitmap(int n2) {
        synchronized (this) {
            InputStream inputStream = WBCommonUtils.mContext.getResources().openRawResource(n2);
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inPreferredConfig = Bitmap.Config.ARGB_8888;
            return BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        }
    }

    public void loadImage(int n2, ImageView imageView) {
        this.mPicasso.a(n2).a(imageView);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void loadImage(String string2, ImageView imageView) {
        int n2;
        if (StringUtils.isEmpty(string2)) return;
        if (imageView == null) {
            return;
        }
        if (FileUtils.isHttpFileName(string2)) {
            this.mPicasso.a(string2).a(imageView);
            return;
        }
        String string3 = WBCommonUtils.mContext.getPackageName();
        int n3 = n2 = WBCommonUtils.mContext.getResources().getIdentifier(FileUtils.getFileRawName(string2), "raw", string3);
        if (n2 <= 0) {
            n3 = WBCommonUtils.mContext.getResources().getIdentifier(FileUtils.getFileRawName(string2), "drawable", string3);
        }
        if (n3 <= 0) return;
        imageView.setImageResource(n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void loadItemIcon(WatermarkElements object, ImageView imageView, Bitmap bitmap) {
        int n2;
        if (!StringUtils.isEmpty(((WatermarkElements)object).icon)) {
            if (((WatermarkElements)object).icon.startsWith("@")) {
                LogUtils.d("ailey", "isStartWith @:" + ((WatermarkElements)object).icon);
                object = FileUtils.getFileNameA(((WatermarkElements)object).icon);
                LogUtils.d("ailey", "iconStr:" + (String)object);
                object = ParseVideoJson.getInstance().getElementById(Integer.valueOf((String)object));
                if (object == null) {
                    return;
                }
                object = ((BaseElements)object).icon;
            } else {
                object = ((WatermarkElements)object).icon;
            }
        } else {
            object = ParseVideoJson.getInstance().getElementById(((WatermarkElements)object).id);
            if (object == null) return;
            object = ((BaseElements)object).icon;
        }
        if (!StringUtils.isEmpty((CharSequence)object) && (n2 = this.getRawResId((String)object)) > 0) {
            this.mPicasso.a(n2).a(imageView);
            return;
        }
        if (!FileUtils.isHttpFileName((String)object)) return;
        this.mPicasso.a((String)object).a(imageView);
    }
}

