/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.parsedata;

import android.content.Context;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.wuba.cache.util.WBCommonUtils;
import com.wuba.parsedata.a;
import com.wuba.parsedata.bean.Group;
import com.wuba.parsedata.bean.WatermarkElements;
import com.wuba.parsedata.utils.FileUtils;
import com.wuba.video.R;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.util.Iterator;

public class ParseVideoJson {
    private static ParseVideoJson mInstance;
    private final String CONFIG_FILENAME;
    private Context mContext = WBCommonUtils.mContext;
    private Group mGroups;
    private Gson mGson;
    private int mRawId = R.raw.video;

    private ParseVideoJson() {
        this.CONFIG_FILENAME = "video_elements_config";
        this.mGson = new Gson();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T getDataFromFile(Type type, int n2) {
        JsonReader jsonReader = null;
        Object object = jsonReader;
        if (this.mGson == null) return (T)object;
        if (this.mContext == null) {
            object = jsonReader;
            return (T)object;
        }
        InputStream inputStream = this.mContext.getResources().openRawResource(n2);
        object = jsonReader;
        if (inputStream == null) return (T)object;
        jsonReader = new JsonReader(new InputStreamReader(inputStream));
        object = this.mGson.fromJson(jsonReader, type);
        try {
            jsonReader.close();
            inputStream.close();
            return (T)object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return (T)object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T getDataFromFile(Type type, String object) {
        JsonReader jsonReader = null;
        Object object2 = jsonReader;
        if (TextUtils.isEmpty((CharSequence)object)) return (T)object2;
        object2 = jsonReader;
        if (this.mGson == null) return (T)object2;
        if (this.mContext == null) {
            object2 = jsonReader;
            return (T)object2;
        }
        object = new ByteArrayInputStream(FileUtils.readFile((String)object, "UTF-8").toString().getBytes());
        object2 = jsonReader;
        if (object == null) return (T)object2;
        jsonReader = new JsonReader(new InputStreamReader((InputStream)object));
        object2 = this.mGson.fromJson(jsonReader, type);
        try {
            jsonReader.close();
            ((InputStream)object).close();
            return (T)object2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return (T)object2;
        }
    }

    public static ParseVideoJson getInstance() {
        if (mInstance == null) {
            mInstance = new ParseVideoJson();
        }
        return mInstance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WatermarkElements getElementById(int n2) {
        WatermarkElements watermarkElements;
        Iterator<WatermarkElements> iterator = this.mGroups.data.watermarks.iterator();
        do {
            if (!iterator.hasNext()) return null;
            watermarkElements = iterator.next();
        } while (n2 != watermarkElements.id);
        return watermarkElements;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Group getGroupsData() {
        Type type;
        block4: {
            block3: {
                if (this.mGroups != null) break block3;
                type = new a(this).getType();
                if (FileUtils.isFileExist(FileUtils.getConfigPath(this.mContext, "video_elements_config"))) break block4;
                this.mGroups = (Group)this.getDataFromFile(type, this.mRawId);
            }
            return this.mGroups;
        }
        this.mGroups = (Group)this.getDataFromFile(type, FileUtils.getConfigPath(this.mContext, "video_elements_config"));
        return this.mGroups;
    }
}

