/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.recorder;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Environment;
import com.wuba.recorder.util.LogUtils;
import com.wuba.recorder.util.StringUtils;
import com.wuba.recorder.util.VideoFileUtil;
import java.io.File;

public class RecordConfiguration {
    private static final int DURATION_10SEC = 10000;
    private static final int DURATION_17SEC = 17000;
    private static final int DURATION_45SEC = 45000;
    private static final int DURATION_EXTRA = 300;
    private static final int DURATION_MIN_IN_17SEC = 3000;
    private static final int DURATION_MIN_IN_45SEC = 5000;
    private static final int DURATION_UPLOAD_ANIM = 1000;
    public static final int FROM_TYPE_DRAFT = 7;
    public static final int FROM_TYPE_NOR = 1;
    public static final int MODE_LONG = 2;
    public static final int MODE_NOR = 1;
    private static final int RECORD_MIN_STORAGE = 0xA00000;
    private static final String SAVE_PICTURE_PATH = "wuba/pictures";
    private static final String SAVE_VIDEO_PATH = "wuba/videos";
    private static final int SHOW_GUIDE_TIMES = 3;
    private static final int SHOW_OTHER_GUIDE_TIMES = 1;
    private static final String SP_KEY_DELAY_TIMES = "recorder_delay_times";
    private static final String SP_KEY_FOCUS_DOWN_TIMES = "recorder_focus_down_times";
    private static final String SP_KEY_FOCUS_TIMES = "recorder_focus_times";
    private static final String SP_KEY_RECORDER_TIMES = "recorder_times";
    private static final String SP_KEY_SHARE_WEIBO_OPEN = "share_weibo_open";
    private static final String SP_KEY_SHARE_WEIXIN_OPEN = "share_wexin_open";
    private static final String SP_KEY_UPLOAD_TIMES = "recorder_upload_times";
    private static final String SP_NAME = "wuba_recorder";
    public static final int VIDEO_UPLOAD_SERVER = 1;
    private static final String WORKING_MUSIC_PATH = "music";
    private static final String WORKING_PICUTRE_PATH = "pictures";
    private static final String WORKING_VIDEO_PATH = "videos";
    private static final String WORKING_WATERMARK_PATH = "watermark";
    private static volatile RecordConfiguration instance;
    private Context context;
    public int delayUseTimes;
    public int extraDuration = 300;
    public int focusDownTimes;
    public int focusTimes;
    public int fromType = 1;
    public int maxDuration = 17000;
    public int minDuration = 3000;
    private SharedPreferences pref;
    public int recorderUseTimes;
    public boolean shareWeibo;
    public boolean shareWeixin;
    public boolean showDelayGuide;
    public boolean showFocusDownGuide;
    public boolean showFocusGuide;
    public boolean showRecorderGuide;
    public boolean showUploadDlg;
    public int uploadAnimDuration = 1000;
    public int uploadTimes;
    public int videoUploadType = 1;
    public String workingVideoFolder;

    protected RecordConfiguration(Context context) {
        this.workingVideoFolder = this.getWorkingPath(context, WORKING_VIDEO_PATH);
        this.pref = context.getSharedPreferences(SP_NAME, 0);
        this.recorderUseTimes = this.pref.getInt(SP_KEY_RECORDER_TIMES, 0);
        this.delayUseTimes = this.pref.getInt(SP_KEY_DELAY_TIMES, 0);
        this.focusTimes = this.pref.getInt(SP_KEY_FOCUS_TIMES, 0);
        this.focusDownTimes = this.pref.getInt(SP_KEY_FOCUS_DOWN_TIMES, 0);
        this.uploadTimes = this.pref.getInt(SP_KEY_UPLOAD_TIMES, 0);
        this.shareWeixin = this.pref.getBoolean(SP_KEY_SHARE_WEIXIN_OPEN, false);
        this.shareWeibo = this.pref.getBoolean(SP_KEY_SHARE_WEIBO_OPEN, true);
        this.showRecorderGuide = false;
        this.showDelayGuide = false;
        this.showFocusGuide = false;
        this.showFocusDownGuide = false;
        this.showUploadDlg = false;
        if (this.recorderUseTimes < 3) {
            this.showRecorderGuide = true;
        }
        if (this.delayUseTimes < 1) {
            this.showDelayGuide = true;
        }
        if (this.focusTimes < 3) {
            this.showFocusGuide = true;
        }
        if (this.focusDownTimes < 3) {
            this.showFocusDownGuide = true;
        }
        if (this.uploadTimes < 3) {
            this.showUploadDlg = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RecordConfiguration getInstance(Context context) {
        if (instance == null) {
            synchronized (RecordConfiguration.class) {
                if (instance == null) {
                    RecordConfiguration recordConfiguration;
                    instance = recordConfiguration = new RecordConfiguration(context);
                }
            }
        }
        return instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getSavePath(String object) {
        if (!Environment.getExternalStorageState().equals("mounted")) return null;
        object = new File(Environment.getExternalStorageDirectory(), (String)object);
        if (((File)object).exists()) return ((File)object).getAbsolutePath();
        ((File)object).mkdirs();
        return ((File)object).getAbsolutePath();
    }

    private String getWorkingPath(Context object, String string2) {
        object = new File(VideoFileUtil.getExternalFilesDir((Context)object), string2);
        ((File)object).mkdirs();
        return ((File)object).getAbsolutePath();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasStorageToRecord(Context context) {
        File file;
        boolean bl = false;
        if (StringUtils.isEmpty(this.workingVideoFolder)) {
            this.workingVideoFolder = this.getWorkingPath(context, WORKING_VIDEO_PATH);
        }
        if ((file = new File(this.workingVideoFolder)) != null && !file.exists()) {
            try {
                file.mkdirs();
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
        }
        LogUtils.d("RecordConfiguration", "videoPath root =" + this.workingVideoFolder);
        boolean bl2 = bl;
        if (file == null) return bl2;
        bl2 = bl;
        if (!file.exists()) return bl2;
        bl2 = bl;
        if (file.getUsableSpace() < 0xA00000L) return bl2;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setWorkingVideoPath(String string2) {
        if (StringUtils.isEmpty(string2)) {
            return;
        }
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (file != null && file.exists()) {
            this.workingVideoFolder = string2;
        }
        LogUtils.d("RecordConfiguration", "workingVideoFolder = " + this.workingVideoFolder);
    }
}

