/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.recorder.ffmpeg;

import android.content.Context;
import android.os.Build;
import com.wuba.recorder.ffmpeg.FFmpegException;
import com.wuba.recorder.util.LogUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;

public class Frame {
    private static final String TAG = "Frame";
    private int nativeId = -1;

    static {
        Frame.loadLibrary();
    }

    public Frame() {
        this.nativeAllocate();
    }

    public Frame(Frame frame) {
        this.nativeCopyAllocate(frame);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean copyFileFromAssets(Context object, String object2, String object3) {
        boolean bl = false;
        try {
            int n2;
            object = object.getAssets().open((String)object2);
            object2 = new File((String)object3);
            ((File)object2).createNewFile();
            object3 = new FileOutputStream((File)object2);
            object2 = new byte[1024];
            while ((n2 = ((InputStream)object).read((byte[])object2)) > 0) {
                ((FileOutputStream)object3).write((byte[])object2, 0, n2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            LogUtils.e(TAG, "[copyFileFromAssets] IOException " + iOException.toString());
            return bl;
        }
        {
            ((FileOutputStream)object3).close();
            ((InputStream)object).close();
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void loadLibrary() {
        try {
            System.loadLibrary("wffmpeg");
            System.loadLibrary("engine");
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            LogUtils.d(TAG, "load all library failed");
            LogUtils.d(TAG, unsatisfiedLinkError.getMessage() + "");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void loadLibrary(Context context, String string2) {
        File file;
        if (Build.VERSION.SDK_INT < 21) {
            LogUtils.d("ABI_LESS_21", Build.CPU_ABI);
        } else {
            LogUtils.d("ABI_MORE_21", Build.SUPPORTED_ABIS[0]);
        }
        if (Frame.copyFileFromAssets(context, string2, (file = new File("/storage/emulated/0/Android/data/com.wuba.wbvideodemo/files/videos" + File.separator + string2)).getAbsolutePath())) {
            System.load(file.getAbsolutePath());
        }
    }

    private native boolean nativeAllocate();

    private native boolean nativeCopyAllocate(Frame var1);

    private native boolean nativeDeallocate();

    public native void copyYUVData(byte[] var1, int var2, int var3, int var4, int var5) throws FFmpegException;

    protected void finalize() throws Throwable {
        super.finalize();
        this.releaseNativeAllocation();
    }

    public native void fromNioBufferSamples(Buffer[] var1, int var2, int var3);

    public native void fromTexture(int var1);

    public native void gatherFromGl(int var1, int var2, int var3) throws FFmpegException;

    public native long getTimeStamp();

    public native boolean hasAudioFrame();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasNativeAllocation() {
        synchronized (this) {
            int n2 = this.nativeId;
            if (n2 == -1) return false;
            return true;
        }
    }

    public native boolean hasVideoFrame();

    public void releaseNativeAllocation() {
        synchronized (this) {
            if (this.hasNativeAllocation()) {
                this.nativeDeallocate();
                this.nativeId = -1;
            }
            return;
        }
    }

    public native void setMusicAtteFactor(float var1);

    public native void setSampleToZero();

    public native void setStartTimeStamp(long var1);

    public native void setTimeStamp(long var1);

    public native int toTexture(int var1);
}

