/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.recorder.util;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.media.MediaMetadataRetriever;
import android.media.MediaPlayer;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.MovieBox;
import com.wuba.recorder.RecordConfiguration;
import com.wuba.recorder.util.LogUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class VideoFileUtil {
    public static final String SOUND_DELAY = "android.resource://com.wuba/raw/delaying";
    public static final String SOUND_FOCUS = "android.resource://com.wuba/raw/focusing";
    private static final String TAG = VideoFileUtil.class.getSimpleName();
    private static MediaPlayer gMediaPlayer = null;
    public static String pathRoot;

    public static void cleanupFileAsync(String string2) {
        new Thread(new b(string2)).start();
    }

    public static void cleanupFileRoundAsync(String string2) {
        new Thread(new a(string2)).start();
    }

    private static String createName(long l2, Context object) {
        object = new Date(l2);
        return new SimpleDateFormat("'VID'_yyyyMMdd_HHmmssSSS").format((Date)object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean deleteFile(String object) {
        boolean bl = false;
        if (TextUtils.isEmpty((CharSequence)object)) {
            return bl;
        }
        if (!((File)(object = new File((String)object))).exists()) return bl;
        return ((File)object).delete();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void deleteFiles(String string2, boolean bl) {
        LogUtils.d(TAG, "delete files: " + string2);
        if (string2 == null) return;
        try {
            Object object = new File(string2);
            if (((File)object).isDirectory()) {
                if ((object = ((File)object).listFiles()) != null) {
                    int n2 = ((File[])object).length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        VideoFileUtil.deleteFiles(((File)object[i2]).toString(), true);
                    }
                }
                VideoFileUtil.cleanupFileAsync(string2);
                return;
            }
            if (!bl) return;
            bl = ((File)object).delete();
            String string3 = TAG;
            object = new StringBuilder();
            LogUtils.d(string3, ((StringBuilder)object).append("Delete result: ").append(bl).append(" for file: ").append(string2).toString());
            return;
        }
        catch (NullPointerException nullPointerException) {
            LogUtils.e("FileUtil", "NullPointerException: " + nullPointerException);
            return;
        }
    }

    public static String generateImgFilename(String object, Context context) {
        String string2 = VideoFileUtil.createName(System.currentTimeMillis(), context);
        string2 = string2 + ".jpg";
        object = new File(RecordConfiguration.getInstance((Context)context).workingVideoFolder, (String)object);
        ((File)object).mkdirs();
        return new File((File)object, string2).getPath();
    }

    public static String generateRecordingSessionName(String string2, int n2, Context context) {
        long l2 = System.currentTimeMillis();
        String string3 = string2;
        if (string2 == null) {
            string3 = VideoFileUtil.createName(l2, context) + "_session_" + n2;
            boolean bl = new File(RecordConfiguration.getInstance((Context)context).workingVideoFolder, string3).mkdirs();
            LogUtils.d("VideoFileUtil", "Recording session started in folder " + string3 + " " + String.valueOf(bl));
        }
        return string3;
    }

    public static String generateVideoFilename(String object, Context context) {
        String string2 = VideoFileUtil.createName(System.currentTimeMillis(), context);
        string2 = string2 + ".mp4";
        object = new File(RecordConfiguration.getInstance((Context)context).workingVideoFolder, (String)object);
        ((File)object).mkdirs();
        return new File((File)object, string2).getPath();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File getExternalFilesDir(Context object) {
        void var0_5;
        File file = null;
        File file2 = object.getExternalFilesDir(null);
        if (file2 == null) {
            File file3 = object.getExternalCacheDir();
            if (file3 == null) {
                File file4 = file;
                if (VideoFileUtil.sdCardValid()) {
                    File file5 = file = new File(Environment.getExternalStorageDirectory(), "wuba");
                    if (!file.exists()) {
                        file.mkdirs();
                        File file6 = file;
                    }
                }
            }
            return var0_5;
        }
        File file7 = file2;
        return var0_5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TargetApi(value=10)
    public static Bitmap getFrameAtTime(FileDescriptor object, long l2, int n2, int n3) {
        MediaMetadataRetriever mediaMetadataRetriever = new MediaMetadataRetriever();
        mediaMetadataRetriever.setDataSource((FileDescriptor)object);
        object = mediaMetadataRetriever.extractMetadata(9);
        LogUtils.d(TAG, "duration:" + (String)object);
        if (l2 <= Long.parseLong((String)object)) return VideoFileUtil.scaleBitmap(mediaMetadataRetriever.getFrameAtTime(1000L * l2), n2, n3);
        LogUtils.d(TAG, "time is over duration");
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TargetApi(value=10)
    public static Bitmap getFrameAtTime(String string2, long l2, int n2, int n3) {
        Object var5_4 = null;
        if (!new File(string2).exists()) {
            LogUtils.d(TAG, "file not exist");
            return var5_4;
        }
        MediaMetadataRetriever mediaMetadataRetriever = new MediaMetadataRetriever();
        mediaMetadataRetriever.setDataSource(string2);
        if (l2 > Long.parseLong(mediaMetadataRetriever.extractMetadata(9))) {
            LogUtils.d(TAG, "time is over duration");
            return var5_4;
        }
        if (n2 == 0) {
            n2 = Integer.parseInt(mediaMetadataRetriever.extractMetadata(18));
        }
        if (n3 != 0) return VideoFileUtil.scaleBitmap(mediaMetadataRetriever.getFrameAtTime(1000L * l2), n2, n3);
        n2 = Integer.parseInt(mediaMetadataRetriever.extractMetadata(19));
        return VideoFileUtil.scaleBitmap(mediaMetadataRetriever.getFrameAtTime(1000L * l2), n2, n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long getVideoDuration(File object) {
        long l2 = 0L;
        if (object == null) {
            return l2;
        }
        long l3 = l2;
        if (!((File)object).exists()) return l3;
        IsoFile isoFile = new IsoFile(((File)object).getPath());
        object = isoFile.getMovieBox();
        l3 = l2;
        if (object == null) return l3;
        l3 = l2;
        try {
            if (((MovieBox)object).getMovieHeaderBox() == null) return l3;
            return ((MovieBox)object).getMovieHeaderBox().getDuration();
        }
        catch (IOException iOException) {
            LogUtils.e(TAG, "getVideoDuration io error:" + iOException);
            return l2;
        }
        catch (Exception exception) {
            LogUtils.e(TAG, "getVideoDuration error:" + exception);
            return l2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isExternalStorageRemovable() {
        if (Build.VERSION.SDK_INT < 9) return true;
        return Environment.isExternalStorageRemovable();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveToFile(Context object, Bitmap object2) {
        object = new File(VideoFileUtil.generateImgFilename("", object.getApplicationContext()));
        LogUtils.d("aileyTest", "saveToFile path = " + ((File)object).getAbsolutePath());
        try {
            ((File)object).createNewFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        OutputStream outputStream = new ByteArrayOutputStream();
        object2.compress(Bitmap.CompressFormat.JPEG, 0, outputStream);
        object2 = ((ByteArrayOutputStream)outputStream).toByteArray();
        try {
            outputStream = new FileOutputStream((File)object);
            ((FileOutputStream)outputStream).write((byte[])object2);
            outputStream.flush();
            ((FileOutputStream)outputStream).close();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Bitmap scaleBitmap(Bitmap bitmap, int n2, int n3) {
        if (bitmap == null) {
            return null;
        }
        int n4 = bitmap.getHeight();
        int n5 = bitmap.getWidth();
        float f2 = (float)n2 / (float)n5;
        float f3 = (float)n3 / (float)n4;
        Matrix matrix = new Matrix();
        matrix.postScale(f2, f3);
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n5, (int)n4, (Matrix)matrix, (boolean)false);
        matrix = bitmap2;
        if (bitmap.isRecycled()) return matrix;
        bitmap.recycle();
        return bitmap2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean sdCardValid() {
        if ("mounted".equals(Environment.getExternalStorageState())) return true;
        if (VideoFileUtil.isExternalStorageRemovable()) return false;
        return true;
    }

    private static class a
    implements Runnable {
        private String a;

        public a(String string2) {
            this.a = string2;
        }

        @Override
        public void run() {
            VideoFileUtil.deleteFiles(this.a, true);
        }
    }

    private static class b
    implements Runnable {
        private String a;

        public b(String string2) {
            this.a = string2;
        }

        @Override
        public void run() {
            if (this.a != null && new File(this.a).delete()) {
                LogUtils.v(TAG, "file deleted: " + this.a);
            }
        }
    }
}

