/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.wplayer.player;

import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.wuba.wplayer.player.IMediaPlayer;
import com.wuba.wplayer.player.ISurfaceTextureHolder;
import com.wuba.wplayer.player.ISurfaceTextureHost;
import com.wuba.wplayer.player.MediaPlayerProxy;

@TargetApi(value=14)
public class TextureMediaPlayer
extends MediaPlayerProxy
implements IMediaPlayer,
ISurfaceTextureHolder {
    private SurfaceTexture mSurfaceTexture;
    private ISurfaceTextureHost mSurfaceTextureHost;

    public TextureMediaPlayer(IMediaPlayer iMediaPlayer) {
        super(iMediaPlayer);
    }

    @Override
    public SurfaceTexture getSurfaceTexture() {
        return this.mSurfaceTexture;
    }

    @Override
    public void release() {
        super.release();
        this.releaseSurfaceTexture();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void releaseSurfaceTexture() {
        if (this.mSurfaceTexture != null) {
            if (this.mSurfaceTextureHost != null) {
                this.mSurfaceTextureHost.releaseSurfaceTexture(this.mSurfaceTexture);
            } else {
                this.mSurfaceTexture.release();
            }
            this.mSurfaceTexture = null;
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.releaseSurfaceTexture();
    }

    @Override
    public void setDisplay(SurfaceHolder surfaceHolder) {
        if (this.mSurfaceTexture == null) {
            super.setDisplay(surfaceHolder);
        }
    }

    @Override
    public void setSurface(Surface surface) {
        if (this.mSurfaceTexture == null) {
            super.setSurface(surface);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setSurfaceTexture(SurfaceTexture surfaceTexture) {
        if (this.mSurfaceTexture == surfaceTexture) {
            return;
        }
        this.releaseSurfaceTexture();
        this.mSurfaceTexture = surfaceTexture;
        if (surfaceTexture == null) {
            super.setSurface(null);
            return;
        }
        super.setSurface(new Surface(surfaceTexture));
    }

    @Override
    public void setSurfaceTextureHost(ISurfaceTextureHost iSurfaceTextureHost) {
        this.mSurfaceTextureHost = iSurfaceTextureHost;
    }
}

