/*
 * Decompiled with CFR 0.152.
 */
package com.wuba.wplayer.player;

import android.os.Bundle;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Locale;

public class WMediaMeta {
    public static final long AV_CH_BACK_CENTER = 256L;
    public static final long AV_CH_BACK_LEFT = 16L;
    public static final long AV_CH_BACK_RIGHT = 32L;
    public static final long AV_CH_FRONT_CENTER = 4L;
    public static final long AV_CH_FRONT_LEFT = 1L;
    public static final long AV_CH_FRONT_LEFT_OF_CENTER = 64L;
    public static final long AV_CH_FRONT_RIGHT = 2L;
    public static final long AV_CH_FRONT_RIGHT_OF_CENTER = 128L;
    public static final long AV_CH_LAYOUT_2POINT1 = 11L;
    public static final long AV_CH_LAYOUT_2_1 = 259L;
    public static final long AV_CH_LAYOUT_2_2 = 1539L;
    public static final long AV_CH_LAYOUT_3POINT1 = 15L;
    public static final long AV_CH_LAYOUT_4POINT0 = 263L;
    public static final long AV_CH_LAYOUT_4POINT1 = 271L;
    public static final long AV_CH_LAYOUT_5POINT0 = 1543L;
    public static final long AV_CH_LAYOUT_5POINT0_BACK = 55L;
    public static final long AV_CH_LAYOUT_5POINT1 = 1551L;
    public static final long AV_CH_LAYOUT_5POINT1_BACK = 63L;
    public static final long AV_CH_LAYOUT_6POINT0 = 1799L;
    public static final long AV_CH_LAYOUT_6POINT0_FRONT = 1731L;
    public static final long AV_CH_LAYOUT_6POINT1 = 1807L;
    public static final long AV_CH_LAYOUT_6POINT1_BACK = 319L;
    public static final long AV_CH_LAYOUT_6POINT1_FRONT = 1739L;
    public static final long AV_CH_LAYOUT_7POINT0 = 1591L;
    public static final long AV_CH_LAYOUT_7POINT0_FRONT = 1735L;
    public static final long AV_CH_LAYOUT_7POINT1 = 1599L;
    public static final long AV_CH_LAYOUT_7POINT1_WIDE = 1743L;
    public static final long AV_CH_LAYOUT_7POINT1_WIDE_BACK = 255L;
    public static final long AV_CH_LAYOUT_HEXAGONAL = 311L;
    public static final long AV_CH_LAYOUT_MONO = 4L;
    public static final long AV_CH_LAYOUT_OCTAGONAL = 1847L;
    public static final long AV_CH_LAYOUT_QUAD = 51L;
    public static final long AV_CH_LAYOUT_STEREO = 3L;
    public static final long AV_CH_LAYOUT_STEREO_DOWNMIX = 0x60000000L;
    public static final long AV_CH_LAYOUT_SURROUND = 7L;
    public static final long AV_CH_LOW_FREQUENCY = 8L;
    public static final long AV_CH_LOW_FREQUENCY_2 = 0x800000000L;
    public static final long AV_CH_SIDE_LEFT = 512L;
    public static final long AV_CH_SIDE_RIGHT = 1024L;
    public static final long AV_CH_STEREO_LEFT = 0x20000000L;
    public static final long AV_CH_STEREO_RIGHT = 0x40000000L;
    public static final long AV_CH_SURROUND_DIRECT_LEFT = 0x200000000L;
    public static final long AV_CH_SURROUND_DIRECT_RIGHT = 0x400000000L;
    public static final long AV_CH_TOP_BACK_CENTER = 65536L;
    public static final long AV_CH_TOP_BACK_LEFT = 32768L;
    public static final long AV_CH_TOP_BACK_RIGHT = 131072L;
    public static final long AV_CH_TOP_CENTER = 2048L;
    public static final long AV_CH_TOP_FRONT_CENTER = 8192L;
    public static final long AV_CH_TOP_FRONT_LEFT = 4096L;
    public static final long AV_CH_TOP_FRONT_RIGHT = 16384L;
    public static final long AV_CH_WIDE_LEFT = 0x80000000L;
    public static final long AV_CH_WIDE_RIGHT = 0x100000000L;
    public static final String IJKM_KEY_AUDIO_STREAM = "audio";
    public static final String IJKM_KEY_BITRATE = "bitrate";
    public static final String IJKM_KEY_CHANNEL_LAYOUT = "channel_layout";
    public static final String IJKM_KEY_CODEC_LEVEL = "codec_level";
    public static final String IJKM_KEY_CODEC_LONG_NAME = "codec_long_name";
    public static final String IJKM_KEY_CODEC_NAME = "codec_name";
    public static final String IJKM_KEY_CODEC_PIXEL_FORMAT = "codec_pixel_format";
    public static final String IJKM_KEY_CODEC_PROFILE = "codec_profile";
    public static final String IJKM_KEY_DURATION_US = "duration_us";
    public static final String IJKM_KEY_FORMAT = "format";
    public static final String IJKM_KEY_FPS_DEN = "fps_den";
    public static final String IJKM_KEY_FPS_NUM = "fps_num";
    public static final String IJKM_KEY_HEIGHT = "height";
    public static final String IJKM_KEY_LANGUAGE = "language";
    public static final String IJKM_KEY_SAMPLE_RATE = "sample_rate";
    public static final String IJKM_KEY_SAR_DEN = "sar_den";
    public static final String IJKM_KEY_SAR_NUM = "sar_num";
    public static final String IJKM_KEY_START_US = "start_us";
    public static final String IJKM_KEY_STREAMS = "streams";
    public static final String IJKM_KEY_TBR_DEN = "tbr_den";
    public static final String IJKM_KEY_TBR_NUM = "tbr_num";
    public static final String IJKM_KEY_TYPE = "type";
    public static final String IJKM_KEY_VIDEO_STREAM = "video";
    public static final String IJKM_KEY_WIDTH = "width";
    public static final String IJKM_VAL_TYPE__AUDIO = "audio";
    public static final String IJKM_VAL_TYPE__UNKNOWN = "unknown";
    public static final String IJKM_VAL_TYPE__VIDEO = "video";
    public IjkStreamMeta mAudioStream;
    public long mBitrate;
    public long mDurationUS;
    public String mFormat;
    public Bundle mMediaMeta;
    public long mStartUS;
    public final ArrayList<IjkStreamMeta> mStreams = new ArrayList();
    public IjkStreamMeta mVideoStream;

    /*
     * Enabled aggressive block sorting
     */
    public static WMediaMeta parse(Bundle object) {
        if (object == null) {
            return null;
        }
        WMediaMeta wMediaMeta = new WMediaMeta();
        wMediaMeta.mMediaMeta = object;
        wMediaMeta.mFormat = wMediaMeta.getString(IJKM_KEY_FORMAT);
        wMediaMeta.mDurationUS = wMediaMeta.getLong(IJKM_KEY_DURATION_US);
        wMediaMeta.mStartUS = wMediaMeta.getLong(IJKM_KEY_START_US);
        wMediaMeta.mBitrate = wMediaMeta.getLong(IJKM_KEY_BITRATE);
        int n2 = wMediaMeta.getInt("video", -1);
        int n3 = wMediaMeta.getInt("audio", -1);
        object = wMediaMeta.getParcelableArrayList(IJKM_KEY_STREAMS);
        if (object == null) {
            return wMediaMeta;
        }
        object = ((ArrayList)object).iterator();
        int n4 = -1;
        while (object.hasNext()) {
            int n5;
            Bundle bundle = (Bundle)object.next();
            n4 = n5 = n4 + 1;
            if (bundle == null) continue;
            IjkStreamMeta ijkStreamMeta = new IjkStreamMeta(n5);
            ijkStreamMeta.mMeta = bundle;
            ijkStreamMeta.mType = ijkStreamMeta.getString(IJKM_KEY_TYPE);
            ijkStreamMeta.mLanguage = ijkStreamMeta.getString(IJKM_KEY_LANGUAGE);
            n4 = n5;
            if (TextUtils.isEmpty((CharSequence)ijkStreamMeta.mType)) continue;
            ijkStreamMeta.mCodecName = ijkStreamMeta.getString(IJKM_KEY_CODEC_NAME);
            ijkStreamMeta.mCodecProfile = ijkStreamMeta.getString(IJKM_KEY_CODEC_PROFILE);
            ijkStreamMeta.mCodecLongName = ijkStreamMeta.getString(IJKM_KEY_CODEC_LONG_NAME);
            ijkStreamMeta.mBitrate = ijkStreamMeta.getInt(IJKM_KEY_BITRATE);
            if (ijkStreamMeta.mType.equalsIgnoreCase("video")) {
                ijkStreamMeta.mWidth = ijkStreamMeta.getInt(IJKM_KEY_WIDTH);
                ijkStreamMeta.mHeight = ijkStreamMeta.getInt(IJKM_KEY_HEIGHT);
                ijkStreamMeta.mFpsNum = ijkStreamMeta.getInt(IJKM_KEY_FPS_NUM);
                ijkStreamMeta.mFpsDen = ijkStreamMeta.getInt(IJKM_KEY_FPS_DEN);
                ijkStreamMeta.mTbrNum = ijkStreamMeta.getInt(IJKM_KEY_TBR_NUM);
                ijkStreamMeta.mTbrDen = ijkStreamMeta.getInt(IJKM_KEY_TBR_DEN);
                ijkStreamMeta.mSarNum = ijkStreamMeta.getInt(IJKM_KEY_SAR_NUM);
                ijkStreamMeta.mSarDen = ijkStreamMeta.getInt(IJKM_KEY_SAR_DEN);
                if (n2 == n5) {
                    wMediaMeta.mVideoStream = ijkStreamMeta;
                }
            } else if (ijkStreamMeta.mType.equalsIgnoreCase("audio")) {
                ijkStreamMeta.mSampleRate = ijkStreamMeta.getInt(IJKM_KEY_SAMPLE_RATE);
                ijkStreamMeta.mChannelLayout = ijkStreamMeta.getLong(IJKM_KEY_CHANNEL_LAYOUT);
                if (n3 == n5) {
                    wMediaMeta.mAudioStream = ijkStreamMeta;
                }
            }
            wMediaMeta.mStreams.add(ijkStreamMeta);
            n4 = n5;
        }
        return wMediaMeta;
    }

    public String getDurationInline() {
        long l2 = (this.mDurationUS + 5000L) / 1000000L;
        long l3 = l2 / 60L;
        long l4 = l3 / 60L;
        return String.format(Locale.US, "%02d:%02d:%02d", l4, l3 % 60L, l2 % 60L);
    }

    public int getInt(String string2) {
        return this.getInt(string2, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getInt(String string2, int n2) {
        if (TextUtils.isEmpty((CharSequence)(string2 = this.getString(string2)))) {
            return n2;
        }
        try {
            int n3 = Integer.parseInt(string2);
            return n3;
        }
        catch (NumberFormatException numberFormatException) {
            return n2;
        }
    }

    public long getLong(String string2) {
        return this.getLong(string2, 0L);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getLong(String string2, long l2) {
        if (TextUtils.isEmpty((CharSequence)(string2 = this.getString(string2)))) {
            return l2;
        }
        try {
            long l3 = Long.parseLong(string2);
            return l3;
        }
        catch (NumberFormatException numberFormatException) {
            return l2;
        }
    }

    public ArrayList<Bundle> getParcelableArrayList(String string2) {
        return this.mMediaMeta.getParcelableArrayList(string2);
    }

    public String getString(String string2) {
        return this.mMediaMeta.getString(string2);
    }

    public static class IjkStreamMeta {
        public long mBitrate;
        public long mChannelLayout;
        public String mCodecLongName;
        public String mCodecName;
        public String mCodecProfile;
        public int mFpsDen;
        public int mFpsNum;
        public int mHeight;
        public final int mIndex;
        public String mLanguage;
        public Bundle mMeta;
        public int mSampleRate;
        public int mSarDen;
        public int mSarNum;
        public int mTbrDen;
        public int mTbrNum;
        public String mType;
        public int mWidth;

        public IjkStreamMeta(int n2) {
            this.mIndex = n2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String getBitrateInline() {
            if (this.mBitrate <= 0L) {
                return "N/A";
            }
            if (this.mBitrate >= 1000L) return String.format(Locale.US, "%d kb/s", this.mBitrate / 1000L);
            return String.format(Locale.US, "%d bit/s", this.mBitrate);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String getChannelLayoutInline() {
            if (this.mChannelLayout <= 0L) {
                return "N/A";
            }
            if (this.mChannelLayout == 4L) {
                return "mono";
            }
            if (this.mChannelLayout != 3L) return String.format(Locale.US, "%x", this.mChannelLayout);
            return "stereo";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String getCodecLongNameInline() {
            if (!TextUtils.isEmpty((CharSequence)this.mCodecLongName)) {
                return this.mCodecLongName;
            }
            if (TextUtils.isEmpty((CharSequence)this.mCodecName)) return "N/A";
            return this.mCodecName;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String getCodecShortNameInline() {
            if (TextUtils.isEmpty((CharSequence)this.mCodecName)) return "N/A";
            return this.mCodecName;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String getFpsInline() {
            if (this.mFpsNum <= 0) return "N/A";
            if (this.mFpsDen > 0) return String.valueOf((float)this.mFpsNum / (float)this.mFpsDen);
            return "N/A";
        }

        public int getInt(String string2) {
            return this.getInt(string2, 0);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int getInt(String string2, int n2) {
            if (TextUtils.isEmpty((CharSequence)(string2 = this.getString(string2)))) {
                return n2;
            }
            try {
                int n3 = Integer.parseInt(string2);
                return n3;
            }
            catch (NumberFormatException numberFormatException) {
                return n2;
            }
        }

        public long getLong(String string2) {
            return this.getLong(string2, 0L);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public long getLong(String string2, long l2) {
            if (TextUtils.isEmpty((CharSequence)(string2 = this.getString(string2)))) {
                return l2;
            }
            try {
                long l3 = Long.parseLong(string2);
                return l3;
            }
            catch (NumberFormatException numberFormatException) {
                return l2;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String getResolutionInline() {
            if (this.mWidth <= 0) return "N/A";
            if (this.mHeight <= 0) {
                return "N/A";
            }
            if (this.mSarNum > 0 && this.mSarDen > 0) return String.format(Locale.US, "%d x %d [SAR %d:%d]", this.mWidth, this.mHeight, this.mSarNum, this.mSarDen);
            return String.format(Locale.US, "%d x %d", this.mWidth, this.mHeight);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String getSampleRateInline() {
            if (this.mSampleRate > 0) return String.format(Locale.US, "%d Hz", this.mSampleRate);
            return "N/A";
        }

        public String getString(String string2) {
            return this.mMeta.getString(string2);
        }
    }
}

