/*
 * Decompiled with CFR 0.152.
 */
package com.yintong.secure.widget;

public class Cell {
    static Cell[][] sCells = new Cell[3][3];
    int column;
    int row;

    static {
        int n2 = 0;
        block0: while (n2 < 3) {
            int n3 = 0;
            while (true) {
                if (n3 >= 3) {
                    ++n2;
                    continue block0;
                }
                Cell.sCells[n2][n3] = new Cell(n2, n3);
                ++n3;
            }
            break;
        }
        return;
    }

    private Cell(int n2, int n3) {
        Cell.checkRange(n2, n3);
        this.row = n2;
        this.column = n3;
    }

    private static void checkRange(int n2, int n3) {
        if (n2 < 0 || n2 > 2) {
            throw new IllegalArgumentException("row must be in range 0-2");
        }
        if (n3 < 0 || n3 > 2) {
            throw new IllegalArgumentException("column must be in range 0-2");
        }
    }

    public static Cell of(int n2, int n3) {
        synchronized (Cell.class) {
            Cell.checkRange(n2, n3);
            Cell cell = sCells[n2][n3];
            return cell;
        }
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }

    public String toString() {
        return "(row=" + this.row + ",clmn=" + this.column + ")";
    }
}

