/*
 * Decompiled with CFR 0.152.
 */
package com.yintong.secure.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.View;
import com.yintong.secure.f.g;
import com.yintong.secure.widget.Cell;
import com.yintong.secure.widget.LockIndicator$SavedState;
import com.yintong.secure.widget.LockPatternView$DisplayMode;
import java.util.ArrayList;
import java.util.List;

public class LockIndicator
extends View {
    private static final int MILLIS_PER_CIRCLE_ANIMATING = 200;
    private int circleOffsetX = 6;
    private int circleOffsetY = 7;
    private long mAnimatingPeriodStart;
    private Bitmap mBitmapBtnDefault;
    private Bitmap mBitmapBtnFocused;
    private int mBitmapHeight;
    private int mBitmapWidth;
    private final Path mCurrentPath;
    private float mDiameterFactor = 0.5f;
    private float mInProgressX = -1.0f;
    private float mInProgressY = -1.0f;
    private boolean mInStealthMode = false;
    private boolean mInputEnabled = true;
    private Paint mPaint = new Paint();
    private Paint mPathPaint = new Paint();
    private ArrayList mPattern = new ArrayList(9);
    private LockPatternView$DisplayMode mPatternDisplayMode;
    private boolean[][] mPatternDrawLookup = new boolean[3][3];
    private boolean mPatternInProgress = true;
    private float mSquareHeight;
    private float mSquareWidth;
    private boolean mTactileFeedbackEnabled = true;
    private float pathStrokeWidth;
    final float screenHeight;
    private float screenWidth;
    private int viewHeight = 60;

    public LockIndicator(Context context) {
        this(context, null);
    }

    public LockIndicator(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mPatternDisplayMode = LockPatternView$DisplayMode.Correct;
        this.mCurrentPath = new Path();
        this.screenHeight = this.getResources().getDisplayMetrics().heightPixels;
        this.pathStrokeWidth = 5.0f;
        this.setClickable(true);
        this.mPathPaint.setAntiAlias(true);
        this.mPathPaint.setDither(true);
        this.mPathPaint.setColor(-1);
        this.mPathPaint.setAlpha(128);
        this.mPathPaint.setStyle(Paint.Style.STROKE);
        this.mPathPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mPathPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mBitmapBtnDefault = g.f((Context)context, (String)"ll_stand_patternindicator_grid_normal");
        this.mBitmapBtnFocused = g.f((Context)context, (String)"ll_stand_patternindicator_grid_focused");
        this.mBitmapWidth = this.mBitmapBtnDefault.getWidth();
        this.mBitmapHeight = this.mBitmapBtnDefault.getHeight();
    }

    private void clearPatternDrawLookup() {
        int n2 = 0;
        block0: while (n2 < 3) {
            int n3 = 0;
            while (true) {
                if (n3 >= 3) {
                    ++n2;
                    continue block0;
                }
                this.mPatternDrawLookup[n2][n3] = false;
                ++n3;
            }
            break;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drawCircle(Canvas canvas, int n2, int n3, boolean bl2) {
        Bitmap bitmap = bl2 ? this.mBitmapBtnFocused : this.mBitmapBtnDefault;
        int n4 = this.mBitmapWidth;
        n4 = this.mBitmapHeight;
        float f2 = this.mSquareWidth;
        float f3 = this.mSquareHeight;
        canvas.drawBitmap(bitmap, (float)((int)f2 * 3 / 2 - (this.mBitmapWidth * 3 + this.circleOffsetX * 3) / 2 + n2), (float)(0 + n3), this.mPaint);
    }

    private Bitmap getBitmapFor(int n2) {
        return BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)n2);
    }

    private float getCenterXForColumn(int n2) {
        return this.screenWidth / 2.0f - ((float)this.mBitmapWidth * 3.0f + (float)this.circleOffsetX * 3.0f) / 2.0f + (float)this.getPaddingLeft() + (float)this.mBitmapWidth / 2.0f + (float)this.circleOffsetX * (float)n2 + (float)this.mBitmapWidth * (float)n2 + (float)n2;
    }

    private float getCenterYForRow(int n2) {
        return (float)this.getPaddingTop() + (float)this.mBitmapHeight / 2.0f + (float)this.circleOffsetY * (float)n2 + (float)this.mBitmapHeight * (float)n2 - (float)n2 - 0.5f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String patternToString(List object) {
        if (object == null) {
            return "";
        }
        int n2 = object.size();
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            Cell cell = (Cell)object.get(n3);
            int n4 = cell.getRow();
            byArray[n3] = (byte)(cell.getColumn() + n4 * 3);
            ++n3;
        }
        return new String(byArray);
    }

    private void resetPattern() {
        this.mPattern.clear();
        this.clearPatternDrawLookup();
        this.invalidate();
    }

    public static List stringToPattern(String object) {
        ArrayList<Cell> arrayList = new ArrayList<Cell>();
        object = ((String)object).getBytes();
        int n2 = 0;
        while (n2 < ((Object)object).length) {
            Object object2 = object[n2];
            arrayList.add(Cell.of((int)(object2 / 3), (int)(object2 % 3)));
            ++n2;
        }
        return arrayList;
    }

    public void clearPattern() {
        this.resetPattern();
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    protected void onDraw(Canvas canvas) {
        float f2;
        float f3;
        int n2;
        int n3;
        int n4;
        boolean[][] blArray;
        int n5;
        block11: {
            Path path;
            Cell cell;
            ArrayList arrayList = this.mPattern;
            n5 = arrayList.size();
            blArray = this.mPatternDrawLookup;
            this.mPathPaint.setAntiAlias(true);
            this.mPathPaint.setDither(true);
            this.mPathPaint.setColor(-1);
            this.mPathPaint.setAlpha(128);
            this.mPathPaint.setStyle(Paint.Style.STROKE);
            this.mPathPaint.setStrokeJoin(Paint.Join.ROUND);
            this.mPathPaint.setStrokeCap(Paint.Cap.ROUND);
            boolean bl2 = true;
            while (true) {
                block14: {
                    block13: {
                        block12: {
                            if (!bl2 || (bl2 = false)) break block12;
                            if (this.mPatternDisplayMode != LockPatternView$DisplayMode.Animate) break block13;
                            n4 = (int)(SystemClock.elapsedRealtime() - this.mAnimatingPeriodStart) % ((n5 + 1) * 200);
                            n3 = n4 / 200;
                            this.clearPatternDrawLookup();
                            n2 = 0;
                        }
                        if (n2 < n3) break block14;
                        n2 = n3 > 0 && n3 < n5 ? 1 : 0;
                        if (n2 != 0) {
                            f3 = (float)(n4 % 200) / 200.0f;
                            cell = (Cell)arrayList.get(n3 - 1);
                            float f4 = this.getCenterXForColumn(cell.column);
                            float f5 = this.getCenterYForRow(cell.row);
                            cell = (Cell)arrayList.get(n3);
                            f2 = this.getCenterXForColumn(cell.column);
                            float f6 = this.getCenterYForRow(cell.row);
                            this.mInProgressX = f4 + (f2 - f4) * f3;
                            this.mInProgressY = (f6 - f5) * f3 + f5;
                        }
                        this.invalidate();
                    }
                    this.mPathPaint.setStrokeWidth(this.pathStrokeWidth);
                    path = this.mCurrentPath;
                    path.rewind();
                    n2 = this.mInStealthMode && this.mPatternDisplayMode != LockPatternView$DisplayMode.Wrong ? 0 : 1;
                    if (n2 != 0) {
                        break;
                    }
                    break block11;
                }
                cell = (Cell)arrayList.get(n2);
                blArray[cell.getRow()][cell.getColumn()] = true;
                ++n2;
            }
            n2 = 0;
            n3 = 0;
            while (true) {
                block17: {
                    block16: {
                        block15: {
                            if (n2 >= n5) break block15;
                            cell = (Cell)arrayList.get(n2);
                            if (!blArray[cell.row][cell.column]) break block15;
                            f2 = this.getCenterXForColumn(cell.column);
                            f3 = this.getCenterYForRow(cell.row);
                            if (n2 != 0) break block16;
                            path.moveTo(f2, f3);
                            break block17;
                        }
                        if ((this.mPatternInProgress || this.mPatternDisplayMode == LockPatternView$DisplayMode.Animate) && n3 != 0) {
                            path.lineTo(this.mInProgressX, this.mInProgressY);
                        }
                        canvas.drawPath(path, this.mPathPaint);
                        break;
                    }
                    path.lineTo(f2, f3);
                }
                ++n2;
                n3 = 1;
            }
        }
        f2 = this.mSquareWidth;
        f3 = this.mSquareHeight;
        f3 = this.mDiameterFactor;
        this.mPathPaint.setStrokeWidth(f2 * f3 * 0.5f);
        n5 = this.getPaddingTop();
        n4 = this.getPaddingLeft();
        n2 = 0;
        block2: while (true) {
            if (n2 >= 3) {
                boolean bl3 = (this.mPaint.getFlags() & 2) != 0;
                this.mPaint.setFilterBitmap(true);
                this.mPaint.setFilterBitmap(bl3);
                return;
            }
            f2 = (this.mBitmapWidth + this.circleOffsetX) * n2 + n5;
            n3 = 0;
            while (true) {
                if (n3 >= 3) {
                    ++n2;
                    continue block2;
                }
                this.drawCircle(canvas, (int)((float)((this.mBitmapHeight + this.circleOffsetY) * n3 + n4)), (int)f2, blArray[n2][n3]);
                ++n3;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onMeasure(int n2, int n3) {
        n2 = Math.min(View.MeasureSpec.getSize((int)n2), View.MeasureSpec.getSize((int)n3));
        if (this.screenHeight == 1184.0f) {
            this.viewHeight = 75;
        } else if (this.screenHeight == 1280.0f) {
            this.viewHeight = 75;
        } else if (this.screenHeight == 1920.0f) {
            this.viewHeight = 110;
        } else if (this.screenHeight > 1920.0f) {
            this.viewHeight = 120;
        }
        this.setMeasuredDimension(n2, this.viewHeight);
    }

    protected void onRestoreInstanceState(Parcelable object) {
        object = (LockIndicator$SavedState)((Object)object);
        super.onRestoreInstanceState(object.getSuperState());
        this.setPattern(LockIndicator.stringToPattern(((LockIndicator$SavedState)((Object)object)).a()));
    }

    protected Parcelable onSaveInstanceState() {
        return new LockIndicator$SavedState(super.onSaveInstanceState(), LockIndicator.patternToString(this.mPattern), null);
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        n2 = n2 - this.getPaddingLeft() - this.getPaddingRight();
        this.mSquareWidth = (float)n2 / 3.0f;
        this.screenWidth = n2;
        this.mSquareHeight = (float)(n3 - this.getPaddingTop() - this.getPaddingBottom()) / 3.0f;
    }

    public void setDisplayMode(LockPatternView$DisplayMode object) {
        this.mPatternDisplayMode = object;
        if (object == LockPatternView$DisplayMode.Animate) {
            if (this.mPattern.size() == 0) {
                throw new IllegalStateException("you must have a pattern to animate if you want to set the display mode to animate");
            }
            this.mAnimatingPeriodStart = SystemClock.elapsedRealtime();
            object = (Cell)this.mPattern.get(0);
            this.mInProgressX = this.getCenterXForColumn(((Cell)object).getColumn());
            this.mInProgressY = this.getCenterYForRow(((Cell)object).getRow());
            this.clearPatternDrawLookup();
        }
        this.invalidate();
    }

    public void setPattern(List object) {
        this.mPattern.clear();
        this.mPattern.addAll(object);
        this.clearPatternDrawLookup();
        object = object.iterator();
        while (true) {
            if (!object.hasNext()) {
                this.invalidate();
                return;
            }
            Cell cell = (Cell)object.next();
            this.mPatternDrawLookup[cell.getRow()][cell.getColumn()] = true;
        }
    }
}

