/*
 * Decompiled with CFR 0.152.
 */
package de.tavendo.autobahn;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer mBuffer;

    public ByteBufferInputStream(ByteBuffer byteBuffer) {
        this.mBuffer = byteBuffer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read() throws IOException {
        synchronized (this) {
            boolean bl2 = this.mBuffer.hasRemaining();
            if (!bl2) {
                return -1;
            }
            int n2 = this.mBuffer.get();
            n2 &= 0xFF;
            return n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(byte[] object, int n2, int n3) throws IOException {
        synchronized (this) {
            if (object == null) {
                object = new NullPointerException;
                object();
                throw object;
            }
            if (n2 < 0 || n3 < 0 || n3 > ((byte[])object).length - n2) {
                object = new IndexOutOfBoundsException;
                object();
                throw object;
            }
            if (n3 == 0) {
                return 0;
            }
            n3 = Math.min(this.mBuffer.remaining(), n3);
            if (n3 == 0) {
                return -1;
            }
            this.mBuffer.get((byte[])object, n2, n3);
            return n3;
        }
    }
}

