/*
 * Decompiled with CFR 0.152.
 */
package de.tavendo.autobahn;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Base64;
import android.util.Log;
import de.tavendo.autobahn.WebSocketException;
import de.tavendo.autobahn.WebSocketMessage;
import de.tavendo.autobahn.WebSocketOptions;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Random;

public class WebSocketWriter
extends Thread {
    private static final String CRLF = "\r\n";
    private static final String TAG = WebSocketWriter.class.getCanonicalName();
    private static final int WEB_SOCKETS_VERSION = 13;
    private final ByteBuffer mApplicationBuffer;
    private Handler mHandler;
    private OutputStream mOutputStream;
    private final Random mRandom = new Random();
    private final Socket mSocket;
    private final Handler mWebSocketConnectionHandler;
    private final WebSocketOptions mWebSocketOptions;

    public WebSocketWriter(Handler handler, Socket socket, WebSocketOptions webSocketOptions, String string2) {
        super(string2);
        this.mWebSocketConnectionHandler = handler;
        this.mWebSocketOptions = webSocketOptions;
        this.mSocket = socket;
        this.mApplicationBuffer = ByteBuffer.allocate(webSocketOptions.getMaxFramePayloadSize() + 14);
        Log.d((String)TAG, (String)"WebSocket writer created.");
    }

    private byte[] newFrameMask() {
        byte[] byArray = new byte[4];
        this.mRandom.nextBytes(byArray);
        return byArray;
    }

    private String newHandshakeKey() {
        byte[] byArray = new byte[16];
        this.mRandom.nextBytes(byArray);
        return Base64.encodeToString((byte[])byArray, (int)2);
    }

    private void notify(Object object) {
        Message message = this.mWebSocketConnectionHandler.obtainMessage();
        message.obj = object;
        this.mWebSocketConnectionHandler.sendMessage(message);
    }

    private void sendBinaryMessage(WebSocketMessage.BinaryMessage binaryMessage) throws IOException, WebSocketException {
        if (binaryMessage.mPayload.length > this.mWebSocketOptions.getMaxMessagePayloadSize()) {
            throw new WebSocketException("message payload exceeds payload limit");
        }
        this.sendFrame(2, true, binaryMessage.mPayload);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void sendClientHandshake(WebSocketMessage.ClientHandshake clientHandshake) throws IOException {
        String string2;
        String string3;
        block9: {
            block8: {
                string3 = clientHandshake.getURI().getPath();
                if (string3 == null) break block8;
                string2 = string3;
                if (string3.length() != 0) break block9;
            }
            string2 = "/";
        }
        String string4 = clientHandshake.getURI().getQuery();
        string3 = string2;
        if (string4 != null) {
            string3 = string2;
            if (string4.length() > 0) {
                string3 = String.valueOf(string2) + "?" + string4;
            }
        }
        this.mApplicationBuffer.put(("GET " + string3 + " HTTP/1.1" + CRLF).getBytes());
        this.mApplicationBuffer.put(("Host: " + clientHandshake.getURI().getHost() + CRLF).getBytes());
        this.mApplicationBuffer.put("Upgrade: WebSocket\r\n".getBytes());
        this.mApplicationBuffer.put("Connection: Upgrade\r\n".getBytes());
        this.mApplicationBuffer.put(("Sec-WebSocket-Key: " + this.newHandshakeKey() + CRLF).getBytes());
        this.mApplicationBuffer.put("Origin: https://www.google.com\r\n".getBytes());
        if (clientHandshake.getSubprotocols() != null && clientHandshake.getSubprotocols().length > 0) {
            this.mApplicationBuffer.put("Sec-WebSocket-Protocol: ".getBytes());
            int n2 = 0;
            while (true) {
                if (n2 >= clientHandshake.getSubprotocols().length) {
                    this.mApplicationBuffer.put(CRLF.getBytes());
                    break;
                }
                this.mApplicationBuffer.put(clientHandshake.getSubprotocols()[n2].getBytes());
                this.mApplicationBuffer.put(", ".getBytes());
                ++n2;
            }
        }
        this.mApplicationBuffer.put("Sec-WebSocket-Version: 13\r\n".getBytes());
        this.mApplicationBuffer.put(CRLF.getBytes());
    }

    /*
     * Unable to fully structure code
     */
    private void sendClose(WebSocketMessage.Close var1_1) throws IOException, WebSocketException {
        block6: {
            block5: {
                if (var1_1.getCode() <= 0) break block6;
                if (var1_1.getReason() != null && var1_1.getReason().length() <= 0) {
                    var2_2 = var1_1.getReason().getBytes("UTF-8");
                    var3_3 = new byte[var2_2.length + 2];
                    var4_4 = 0;
                    while (true) {
                        if (var4_4 >= var2_2.length) lbl-1000:
                        // 2 sources

                        {
                            while (var3_3 != null && var3_3.length > 125) {
                                throw new WebSocketException("close payload exceeds 125 octets");
                            }
                            break block5;
                        }
                        var3_3[var4_4 + 2] = var2_2[var4_4];
                        ++var4_4;
                    }
                }
                var3_3 = new byte[2];
                ** GOTO lbl-1000
            }
            var3_3[0] = (byte)(var1_1.getCode() >> 8 & 255);
            var3_3[1] = (byte)(var1_1.getCode() & 255);
            this.sendFrame(8, true, var3_3);
lbl20:
            // 2 sources

            return;
        }
        this.sendFrame(8, true, null);
        ** while (true)
    }

    private void sendPing(WebSocketMessage.Ping ping) throws IOException, WebSocketException {
        if (ping.mPayload != null && ping.mPayload.length > 125) {
            throw new WebSocketException("ping payload exceeds 125 octets");
        }
        this.sendFrame(9, true, ping.mPayload);
    }

    private void sendPong(WebSocketMessage.Pong pong) throws IOException, WebSocketException {
        if (pong.mPayload != null && pong.mPayload.length > 125) {
            throw new WebSocketException("pong payload exceeds 125 octets");
        }
        this.sendFrame(10, true, pong.mPayload);
    }

    private void sendRawTextMessage(WebSocketMessage.RawTextMessage rawTextMessage) throws IOException, WebSocketException {
        if (rawTextMessage.mPayload.length > this.mWebSocketOptions.getMaxMessagePayloadSize()) {
            throw new WebSocketException("message payload exceeds payload limit");
        }
        this.sendFrame(1, true, rawTextMessage.mPayload);
    }

    private void sendTextMessage(WebSocketMessage.TextMessage object) throws IOException, WebSocketException {
        object = ((WebSocketMessage.TextMessage)object).mPayload.getBytes("UTF-8");
        if (((Object)object).length > this.mWebSocketOptions.getMaxMessagePayloadSize()) {
            throw new WebSocketException("message payload exceeds payload limit");
        }
        this.sendFrame(1, true, (byte[])object);
    }

    public void forward(Object object) {
        Message message = this.mHandler.obtainMessage();
        message.obj = object;
        this.mHandler.sendMessage(message);
    }

    protected void processAppMessage(Object object) throws WebSocketException, IOException {
        throw new WebSocketException("unknown message received by WebSocketWriter");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processMessage(Object object) throws IOException, WebSocketException {
        if (object instanceof WebSocketMessage.TextMessage) {
            this.sendTextMessage((WebSocketMessage.TextMessage)object);
            return;
        }
        if (object instanceof WebSocketMessage.RawTextMessage) {
            this.sendRawTextMessage((WebSocketMessage.RawTextMessage)object);
            return;
        }
        if (object instanceof WebSocketMessage.BinaryMessage) {
            this.sendBinaryMessage((WebSocketMessage.BinaryMessage)object);
            return;
        }
        if (object instanceof WebSocketMessage.Ping) {
            this.sendPing((WebSocketMessage.Ping)object);
            return;
        }
        if (object instanceof WebSocketMessage.Pong) {
            this.sendPong((WebSocketMessage.Pong)object);
            return;
        }
        if (object instanceof WebSocketMessage.Close) {
            this.sendClose((WebSocketMessage.Close)object);
            return;
        }
        if (object instanceof WebSocketMessage.ClientHandshake) {
            this.sendClientHandshake((WebSocketMessage.ClientHandshake)object);
            return;
        }
        if (object instanceof WebSocketMessage.Quit) {
            Looper.myLooper().quit();
            Log.d((String)TAG, (String)"WebSocket writer ended.");
            return;
        }
        this.processAppMessage(object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        OutputStream outputStream = null;
        try {
            OutputStream outputStream2;
            outputStream = outputStream2 = this.mSocket.getOutputStream();
        }
        catch (IOException iOException) {
            Log.e((String)TAG, (String)iOException.getLocalizedMessage());
        }
        this.mOutputStream = outputStream;
        Looper.prepare();
        this.mHandler = new ThreadHandler(this);
        synchronized (this) {
            Log.d((String)TAG, (String)"WebSocker writer running.");
            this.notifyAll();
        }
        Looper.loop();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void sendFrame(int n2, boolean bl2, byte[] byArray) throws IOException {
        if (byArray != null) {
            this.sendFrame(n2, bl2, byArray, 0, byArray.length);
            return;
        }
        this.sendFrame(n2, bl2, null, 0, 0);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    protected void sendFrame(int n2, boolean bl2, byte[] byArray, int n3, int n4) throws IOException {
        byte[] byArray2;
        long l2;
        byte by2 = 0;
        if (bl2) {
            by2 = (byte)-128;
        }
        byte by3 = (byte)(by2 | (byte)n2);
        this.mApplicationBuffer.put(by3);
        n2 = 0;
        if (this.mWebSocketOptions.getMaskClientFrames()) {
            n2 = -128;
        }
        if ((l2 = (long)n4) <= 125L) {
            by3 = (byte)(n2 | (byte)l2);
            this.mApplicationBuffer.put(by3);
        } else if (l2 <= 65535L) {
            by3 = (byte)(n2 | 0x7E);
            this.mApplicationBuffer.put(by3);
            this.mApplicationBuffer.put(new byte[]{(byte)(l2 >> 8 & 0xFFL), (byte)(0xFFL & l2)});
        } else {
            by3 = (byte)(n2 | 0x7F);
            this.mApplicationBuffer.put(by3);
            this.mApplicationBuffer.put(new byte[]{(byte)(l2 >> 56 & 0xFFL), (byte)(l2 >> 48 & 0xFFL), (byte)(l2 >> 40 & 0xFFL), (byte)(l2 >> 32 & 0xFFL), (byte)(l2 >> 24 & 0xFFL), (byte)(l2 >> 16 & 0xFFL), (byte)(l2 >> 8 & 0xFFL), (byte)(0xFFL & l2)});
        }
        if (this.mWebSocketOptions.getMaskClientFrames()) {
            byArray2 = this.newFrameMask();
            this.mApplicationBuffer.put(byArray2[0]);
            this.mApplicationBuffer.put(byArray2[1]);
            this.mApplicationBuffer.put(byArray2[2]);
            this.mApplicationBuffer.put(byArray2[3]);
        } else {
            byArray2 = null;
        }
        if (l2 <= 0L) return;
        boolean bl3 = true;
        while (true) {
            block14: {
                block13: {
                    block12: {
                        if (!bl3 || (bl3 = false)) break block12;
                        if (!this.mWebSocketOptions.getMaskClientFrames()) break block13;
                        n2 = 0;
                    }
                    if ((long)n2 < l2) break block14;
                }
                this.mApplicationBuffer.put(byArray, n3, n4);
                return;
            }
            by2 = (byte)(n2 + n3);
            byArray[by2] = (byte)(byArray[by2] ^ byArray2[n2 % 4]);
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeMessageToBuffer(Message message) {
        try {
            this.mApplicationBuffer.clear();
            this.processMessage(message.obj);
            this.mApplicationBuffer.flip();
            this.mOutputStream.write(this.mApplicationBuffer.array(), this.mApplicationBuffer.position(), this.mApplicationBuffer.limit());
            return;
        }
        catch (SocketException socketException) {
            Log.e((String)TAG, (String)("run() : SocketException (" + socketException.toString() + ")"));
            this.notify(new WebSocketMessage.ConnectionLost());
            return;
        }
        catch (IOException iOException) {
            Log.e((String)TAG, (String)("run() : IOException (" + iOException.toString() + ")"));
            return;
        }
        catch (Exception exception) {
            this.notify(new WebSocketMessage.Error(exception));
            return;
        }
    }

    private static class ThreadHandler
    extends Handler {
        private final WeakReference<WebSocketWriter> mWebSocketWriterReference;

        public ThreadHandler(WebSocketWriter webSocketWriter) {
            this.mWebSocketWriterReference = new WeakReference<WebSocketWriter>(webSocketWriter);
        }

        public void handleMessage(Message message) {
            WebSocketWriter webSocketWriter = (WebSocketWriter)this.mWebSocketWriterReference.get();
            if (webSocketWriter != null) {
                webSocketWriter.writeMessageToBuffer(message);
            }
        }
    }
}

