/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.smoothappbarlayout;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CollapsingToolbarLayout;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.Toolbar;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import me.henrytao.smoothappbarlayout.R;

public class SmoothCollapsingToolbarLayout
extends LinearLayout {
    public static boolean DEBUG = false;
    protected int mAvatarId;
    protected float mCollapsedAvatarSize;
    protected float mCollapsedOffsetX;
    protected float mCollapsedOffsetY;
    protected float mCollapsedSubTitleTextSize;
    protected float mCollapsedTitleTextSize;
    protected float mCurrentRatio;
    protected float mExpandedAvatarSize;
    protected float mExpandedOffsetX;
    protected float mExpandedOffsetY;
    protected float mExpandedSubtitleTextSize;
    protected float mExpandedTitleTextSize;
    protected AppBarLayout.OnOffsetChangedListener mOnAppBarLayoutOffsetChangedListener;
    protected OnOffsetChangedListener mOnOffsetChangedListener;
    protected int mSubtitleId;
    protected int mTitleId;
    protected AppBarLayout vAppBarLayout;
    protected View vAvatar;
    protected CollapsingToolbarLayout vCollapsingToolbarLayout;
    protected TextView vSubtitle;
    protected TextView vTitle;
    protected Toolbar vToolbar;

    public SmoothCollapsingToolbarLayout(Context context) {
        super(context);
        this.init(null);
    }

    public SmoothCollapsingToolbarLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(attributeSet);
    }

    @TargetApi(value=11)
    public SmoothCollapsingToolbarLayout(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.init(attributeSet);
    }

    @TargetApi(value=21)
    public SmoothCollapsingToolbarLayout(Context context, AttributeSet attributeSet, int n2, int n3) {
        super(context, attributeSet, n2, n3);
        this.init(attributeSet);
    }

    private static void log(String string2, Object ... objectArray) {
        if (DEBUG) {
            Log.d((String)"debug", (String)String.format(string2, objectArray));
        }
    }

    protected AppBarLayout getAppBarLayout() {
        block3: {
            block2: {
                if (this.vAppBarLayout != null) break block2;
                if (!(this.getParent() instanceof CollapsingToolbarLayout) || !(this.getParent().getParent() instanceof AppBarLayout)) break block3;
                this.vAppBarLayout = (AppBarLayout)this.getParent().getParent();
            }
            return this.vAppBarLayout;
        }
        throw new IllegalStateException("Must be inside a CollapsingToolbarLayout and AppBarLayout");
    }

    protected CollapsingToolbarLayout getCollapsingToolbarLayout() {
        block3: {
            block2: {
                if (this.vCollapsingToolbarLayout != null) break block2;
                if (!(this.getParent() instanceof CollapsingToolbarLayout)) break block3;
                this.vCollapsingToolbarLayout = (CollapsingToolbarLayout)this.getParent();
            }
            return this.vCollapsingToolbarLayout;
        }
        throw new IllegalStateException("Must be inside a CollapsingToolbarLayout");
    }

    protected Toolbar getToolbar() {
        block3: {
            if (this.vToolbar != null) break block3;
            ViewGroup viewGroup = (ViewGroup)this.getParent();
            int n2 = viewGroup.getChildCount();
            int n3 = 0;
            while (true) {
                block5: {
                    block4: {
                        if (n3 >= n2) break block4;
                        View view = viewGroup.getChildAt(n3);
                        if (!(view instanceof Toolbar)) break block5;
                        this.vToolbar = (Toolbar)view;
                    }
                    if (this.vToolbar != null) break;
                    throw new IllegalStateException("Must have Toolbar");
                }
                ++n3;
            }
        }
        return this.vToolbar;
    }

    protected float getTranslationOffset(float f2, float f3, float f4) {
        return (f3 - f2) * f4 + f2;
    }

    protected void init(AttributeSet attributeSet) {
        this.setOrientation(0);
        TypedArray typedArray = this.getContext().getTheme().obtainStyledAttributes(attributeSet, R.styleable.SmoothCollapsingToolbarLayout, 0, 0);
        try {
            this.mCollapsedOffsetX = typedArray.getDimension(R.styleable.SmoothCollapsingToolbarLayout_sctl_collapsed_offsetX, 0.0f);
            this.mCollapsedOffsetY = typedArray.getDimension(R.styleable.SmoothCollapsingToolbarLayout_sctl_collapsed_offsetY, 0.0f);
            this.mCollapsedAvatarSize = typedArray.getDimension(R.styleable.SmoothCollapsingToolbarLayout_sctl_collapsed_avatarSize, -1.0f);
            this.mCollapsedTitleTextSize = typedArray.getDimension(R.styleable.SmoothCollapsingToolbarLayout_sctl_collapsed_titleTextSize, -1.0f);
            this.mCollapsedSubTitleTextSize = typedArray.getDimension(R.styleable.SmoothCollapsingToolbarLayout_sctl_collapsed_subtitleTextSize, -1.0f);
            this.mExpandedOffsetX = typedArray.getDimension(R.styleable.SmoothCollapsingToolbarLayout_sctl_expanded_offsetX, 0.0f);
            this.mExpandedOffsetY = typedArray.getDimension(R.styleable.SmoothCollapsingToolbarLayout_sctl_expanded_offsetY, 0.0f);
            this.mExpandedAvatarSize = typedArray.getDimension(R.styleable.SmoothCollapsingToolbarLayout_sctl_expanded_avatarSize, -1.0f);
            this.mExpandedTitleTextSize = typedArray.getDimension(R.styleable.SmoothCollapsingToolbarLayout_sctl_expanded_titleTextSize, -1.0f);
            this.mExpandedSubtitleTextSize = typedArray.getDimension(R.styleable.SmoothCollapsingToolbarLayout_sctl_expanded_subtitleTextSize, -1.0f);
            this.mAvatarId = typedArray.getResourceId(R.styleable.SmoothCollapsingToolbarLayout_sctl_avatar_id, 0);
            this.mTitleId = typedArray.getResourceId(R.styleable.SmoothCollapsingToolbarLayout_sctl_title_id, 0);
            this.mSubtitleId = typedArray.getResourceId(R.styleable.SmoothCollapsingToolbarLayout_sctl_subtitle_id, 0);
            return;
        }
        finally {
            typedArray.recycle();
        }
    }

    protected void initViews() {
        this.updateViews();
        if (this.mAvatarId > 0) {
            this.vAvatar = this.findViewById(this.mAvatarId);
        }
        if (this.mTitleId > 0) {
            this.vTitle = (TextView)this.findViewById(this.mTitleId);
        }
        if (this.mSubtitleId > 0) {
            this.vSubtitle = (TextView)this.findViewById(this.mSubtitleId);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isAvatarSizeEnabled() {
        if (this.vAvatar == null) return false;
        if (!(this.mCollapsedAvatarSize > 0.0f)) return false;
        if (!(this.mExpandedAvatarSize > 0.0f)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isSubtitleTextSizeEnabled() {
        if (this.vSubtitle == null) return false;
        if (!(this.mCollapsedSubTitleTextSize > 0.0f)) return false;
        if (!(this.mExpandedSubtitleTextSize > 0.0f)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isTitleTextSizeEnabled() {
        if (this.vTitle == null) return false;
        if (!(this.mCollapsedTitleTextSize > 0.0f)) return false;
        if (!(this.mExpandedTitleTextSize > 0.0f)) return false;
        return true;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.initViews();
        if (!this.isInEditMode()) {
            this.mOnAppBarLayoutOffsetChangedListener = new AppBarLayout.OnOffsetChangedListener(){

                public void onOffsetChanged(AppBarLayout appBarLayout, int n2) {
                    SmoothCollapsingToolbarLayout.this.onOffsetChanged(appBarLayout, n2);
                }
            };
            this.getAppBarLayout().addOnOffsetChangedListener(this.mOnAppBarLayoutOffsetChangedListener);
        }
    }

    protected void onDetachedFromWindow() {
        if (this.mOnAppBarLayoutOffsetChangedListener != null) {
            this.getAppBarLayout().removeOnOffsetChangedListener(this.mOnAppBarLayoutOffsetChangedListener);
        }
        super.onDetachedFromWindow();
    }

    protected void onOffsetChanged(AppBarLayout appBarLayout, int n2) {
        int n3 = this.getAppBarLayout().getMeasuredHeight();
        int n4 = this.getToolbar().getMeasuredHeight();
        float f2 = Math.min((float)Math.abs(n2) * 1.0f / (float)(n3 - n4), 1.0f);
        this.updateViews(f2);
        SmoothCollapsingToolbarLayout.log("test onOffsetChanged collapsing | %d | %f", n2, Float.valueOf(f2));
    }

    public void setCollapsedAvatarSize(float f2) {
        this.mCollapsedAvatarSize = f2;
        this.updateViews();
    }

    public void setCollapsedOffsetX(float f2) {
        this.mCollapsedOffsetX = f2;
        this.updateViews();
    }

    public void setCollapsedOffsetY(float f2) {
        this.mCollapsedOffsetY = f2;
        this.updateViews();
    }

    public void setCollapsedSubTitleTextSize(float f2) {
        this.mCollapsedSubTitleTextSize = f2;
        this.updateViews();
    }

    public void setCollapsedTitleTextSize(float f2) {
        this.mCollapsedTitleTextSize = f2;
        this.updateViews();
    }

    public void setExpandedAvatarSize(float f2) {
        this.mExpandedAvatarSize = f2;
        this.updateViews();
    }

    public void setExpandedOffsetX(float f2) {
        this.mExpandedOffsetX = f2;
        this.updateViews();
    }

    public void setExpandedOffsetY(float f2) {
        this.mExpandedOffsetY = f2;
        this.updateViews();
    }

    public void setExpandedSubtitleTextSize(float f2) {
        this.mExpandedSubtitleTextSize = f2;
        this.updateViews();
    }

    public void setExpandedTitleTextSize(float f2) {
        this.mExpandedTitleTextSize = f2;
        this.updateViews();
    }

    public void setOnOffsetChangedListener(OnOffsetChangedListener onOffsetChangedListener) {
        this.mOnOffsetChangedListener = onOffsetChangedListener;
    }

    protected void updateViews() {
        this.updateViews(this.mCurrentRatio);
    }

    protected void updateViews(float f2) {
        this.mCurrentRatio = f2;
        int n2 = this.getAppBarLayout().getMeasuredHeight();
        int n3 = this.getMeasuredHeight();
        ViewCompat.setTranslationX((View)this, (float)(0.0f + this.getTranslationOffset(this.mExpandedOffsetX, this.mCollapsedOffsetX, f2)));
        ViewCompat.setTranslationY((View)this, (float)((float)(n2 - n3) - this.getTranslationOffset(this.mExpandedOffsetY, this.mCollapsedOffsetY, f2)));
        if (this.isAvatarSizeEnabled()) {
            ViewGroup.LayoutParams layoutParams = this.vAvatar.getLayoutParams();
            layoutParams.width = n2 = (int)this.getTranslationOffset(this.mExpandedAvatarSize, this.mCollapsedAvatarSize, f2);
            layoutParams.height = n2;
        }
        if (this.isTitleTextSizeEnabled()) {
            this.vTitle.setTextSize(0, this.getTranslationOffset(this.mExpandedTitleTextSize, this.mCollapsedTitleTextSize, f2));
        }
        if (this.isSubtitleTextSizeEnabled()) {
            this.vSubtitle.setTextSize(0, this.getTranslationOffset(this.mExpandedSubtitleTextSize, this.mCollapsedSubTitleTextSize, f2));
        }
        if (this.mOnOffsetChangedListener != null) {
            this.mOnOffsetChangedListener.onOffsetChanged(f2);
        }
        SmoothCollapsingToolbarLayout.log("test updateViews | %d | %f", (int)(this.mExpandedAvatarSize + (this.mCollapsedAvatarSize - this.mExpandedAvatarSize) * f2), Float.valueOf(f2));
    }

    public static interface OnOffsetChangedListener {
        public void onOffsetChanged(float var1);
    }
}

