/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.smoothappbarlayout.base;

import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import me.henrytao.smoothappbarlayout.R;
import me.henrytao.smoothappbarlayout.base.Observer;
import me.henrytao.smoothappbarlayout.base.OnScrollListener;
import me.henrytao.smoothappbarlayout.base.Utils;

public class ObservableRecyclerView
implements Observer {
    public static final int HEADER_VIEW_POSITION = 0;
    private OnScrollListener mOnScrollListener;
    private RecyclerView mRecyclerView;

    protected ObservableRecyclerView(@NonNull RecyclerView recyclerView) {
        this.mRecyclerView = recyclerView;
        if (this.mRecyclerView.getTag(R.id.tag_observable_view) == null) {
            this.mRecyclerView.setTag(R.id.tag_observable_view, (Object)true);
            this.init();
        }
    }

    private void init() {
        this.mRecyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int n2, int n3) {
                boolean bl2 = false;
                if (ObservableRecyclerView.this.mOnScrollListener != null) {
                    OnScrollListener onScrollListener = ObservableRecyclerView.this.mOnScrollListener;
                    int n4 = recyclerView.computeHorizontalScrollOffset();
                    int n5 = recyclerView.computeVerticalScrollOffset();
                    if (recyclerView.getLayoutManager().findViewByPosition(0) != null) {
                        bl2 = true;
                    }
                    onScrollListener.onScrollChanged((View)recyclerView, n4, n5, n2, n3, bl2);
                }
            }
        });
        this.mRecyclerView.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View view, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
                Utils.log("ObservableRecyclerView | %d | %d | %d | %d", n2, n3, n4, n5);
                ObservableRecyclerView.this.onAdapterChanged();
            }
        });
    }

    public static ObservableRecyclerView newInstance(@NonNull RecyclerView object, OnScrollListener onScrollListener) {
        object = new ObservableRecyclerView((RecyclerView)object);
        ((ObservableRecyclerView)object).setOnScrollListener(onScrollListener);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onAdapterChanged() {
        if (this.mOnScrollListener != null) {
            OnScrollListener onScrollListener = this.mOnScrollListener;
            RecyclerView recyclerView = this.mRecyclerView;
            int n2 = this.mRecyclerView.computeHorizontalScrollOffset();
            int n3 = this.mRecyclerView.computeVerticalScrollOffset();
            boolean bl2 = this.mRecyclerView.getLayoutManager().findViewByPosition(0) != null;
            onScrollListener.onScrollChanged((View)recyclerView, n2, n3, 0, 0, bl2);
        }
    }

    @Override
    public View getView() {
        return this.mRecyclerView;
    }

    @Override
    public void setOnScrollListener(OnScrollListener onScrollListener) {
        this.mOnScrollListener = onScrollListener;
    }
}

