/*
 * Decompiled with CFR 0.152.
 */
package me.henrytao.smoothappbarlayout.base;

import android.content.Context;
import android.support.v4.widget.NestedScrollView;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.View;
import me.henrytao.smoothappbarlayout.SmoothAppBarLayout;

public class Utils {
    public static int getActionBarSize(Context context) {
        context = context.getTheme().obtainStyledAttributes(new int[]{16843499});
        int n2 = (int)context.getDimension(0, 0.0f);
        context.recycle();
        return n2;
    }

    public static int getStatusBarSize(Context context) {
        int n2;
        int n3 = n2 = 0;
        if (context != null) {
            int n4 = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
            n3 = n2;
            if (n4 > 0) {
                n3 = context.getResources().getDimensionPixelSize(n4);
            }
        }
        return n3;
    }

    public static void intPreScroll(SmoothAppBarLayout smoothAppBarLayout, View view, int n2) {
        view.addOnLayoutChangeListener((View.OnLayoutChangeListener)new OnPreScrollListener(smoothAppBarLayout, view, n2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isScrollToTop(View view) {
        boolean bl2 = true;
        if (view instanceof NestedScrollView) {
            if (view.getScrollY() != 0) return false;
            return true;
        }
        boolean bl3 = bl2;
        if (!(view instanceof RecyclerView)) return bl3;
        if (((RecyclerView)view).getLayoutManager().findViewByPosition(0) == null) return false;
        bl3 = bl2;
        if (((RecyclerView)view).computeVerticalScrollOffset() == 0) return bl3;
        return false;
    }

    public static void log(String string2, Object ... objectArray) {
        if (SmoothAppBarLayout.DEBUG) {
            Log.d((String)"SmoothAppBarLayout", (String)String.format(string2, objectArray));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int parseInt(Object object) {
        if (object != null) return Integer.valueOf(object.toString());
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean syncOffset(SmoothAppBarLayout smoothAppBarLayout, View view, int n2, View view2) {
        boolean bl2 = view == view2;
        if (view2 instanceof NestedScrollView) {
            if ((view2 = (NestedScrollView)view2).getScrollY() < n2 || !bl2 && Utils.isScrollToTop(view)) {
                view2.scrollTo(0, n2);
            }
            if (!bl2) return true;
            if (view2.getScrollY() >= n2) {
                if (n2 != 0) return true;
            }
            view2.scrollTo(0, 0);
            smoothAppBarLayout.syncOffset(0);
            return true;
        }
        if (!(view2 instanceof RecyclerView)) return true;
        boolean bl3 = (view2 = (RecyclerView)view2).getLayoutManager().findViewByPosition(0) != null;
        if (bl3 && view2.computeVerticalScrollOffset() < n2) {
            view2.scrollBy(0, n2 - view2.computeVerticalScrollOffset());
        } else if (!bl2 && Utils.isScrollToTop(view)) {
            view2.scrollToPosition(0);
        }
        if (!bl3) return true;
        if (!bl2) return true;
        if (view2.computeVerticalScrollOffset() >= n2) {
            if (n2 != 0) return true;
        }
        view2.scrollToPosition(0);
        smoothAppBarLayout.syncOffset(0);
        return true;
    }

    private static class OnPreScrollListener
    implements View.OnLayoutChangeListener {
        private boolean mDone;
        private final int mOffset;
        private final SmoothAppBarLayout vSmoothAppBarLayout;
        private final View vTarget;

        public OnPreScrollListener(SmoothAppBarLayout smoothAppBarLayout, View view, int n2) {
            this.vSmoothAppBarLayout = smoothAppBarLayout;
            this.vTarget = view;
            this.mOffset = n2;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onLayoutChange(View view, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
            if (this.mDone) return;
            n2 = view instanceof NestedScrollView ? view.getScrollY() : (view instanceof RecyclerView ? ((RecyclerView)view).computeVerticalScrollOffset() : 0);
            if (n2 < this.mOffset) {
                this.vTarget.scrollBy(0, this.mOffset - n2);
                return;
            }
            this.vSmoothAppBarLayout.syncOffset(this.mOffset);
            this.mDone = true;
        }
    }
}

