/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.lang.reflect;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.aspectj.internal.lang.reflect.PointcutExpressionImpl;
import org.aspectj.lang.annotation.AdviceName;
import org.aspectj.lang.reflect.Advice;
import org.aspectj.lang.reflect.AdviceKind;
import org.aspectj.lang.reflect.AjType;
import org.aspectj.lang.reflect.AjTypeSystem;
import org.aspectj.lang.reflect.PointcutExpression;

public class AdviceImpl
implements Advice {
    private static final String AJC_INTERNAL = "org.aspectj.runtime.internal";
    private final Method adviceMethod;
    private AjType[] exceptionTypes;
    private Type[] genericParameterTypes;
    private boolean hasExtraParam = false;
    private final AdviceKind kind;
    private AjType[] parameterTypes;
    private PointcutExpression pointcutExpression;

    protected AdviceImpl(Method method, String string2, AdviceKind adviceKind) {
        this.kind = adviceKind;
        this.adviceMethod = method;
        this.pointcutExpression = new PointcutExpressionImpl(string2);
    }

    protected AdviceImpl(Method method, String string2, AdviceKind adviceKind, String string3) {
        this(method, string2, adviceKind);
        this.hasExtraParam = true;
    }

    @Override
    public AjType getDeclaringType() {
        return AjTypeSystem.getAjType(this.adviceMethod.getDeclaringClass());
    }

    @Override
    public AjType<?>[] getExceptionTypes() {
        if (this.exceptionTypes == null) {
            Class<?>[] classArray = this.adviceMethod.getExceptionTypes();
            this.exceptionTypes = new AjType[classArray.length];
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                this.exceptionTypes[i2] = AjTypeSystem.getAjType(classArray[i2]);
            }
        }
        return this.exceptionTypes;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Type[] getGenericParameterTypes() {
        if (this.genericParameterTypes == null) {
            Type[] typeArray = this.adviceMethod.getGenericParameterTypes();
            int n2 = typeArray.length;
            int n3 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                Type type = typeArray[i2];
                if (!(type instanceof Class) || !((Class)type).getPackage().getName().equals(AJC_INTERNAL)) continue;
                ++n3;
            }
            this.genericParameterTypes = new Type[typeArray.length - n3];
            for (n3 = 0; n3 < this.genericParameterTypes.length; ++n3) {
                this.genericParameterTypes[n3] = typeArray[n3] instanceof Class ? AjTypeSystem.getAjType((Class)typeArray[n3]) : typeArray[n3];
            }
        }
        return this.genericParameterTypes;
    }

    @Override
    public AdviceKind getKind() {
        return this.kind;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getName() {
        String string2;
        String string3 = string2 = this.adviceMethod.getName();
        if (!string2.startsWith("ajc$")) return string3;
        string3 = this.adviceMethod.getAnnotation(AdviceName.class);
        if (string3 == null) return "";
        return string3.value();
    }

    @Override
    public AjType<?>[] getParameterTypes() {
        if (this.parameterTypes == null) {
            int n2;
            Class<?>[] classArray = this.adviceMethod.getParameterTypes();
            int n3 = classArray.length;
            int n4 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                int n5 = n4;
                if (classArray[n2].getPackage().getName().equals(AJC_INTERNAL)) {
                    n5 = n4 + 1;
                }
                n4 = n5;
            }
            this.parameterTypes = new AjType[classArray.length - n4];
            for (n2 = 0; n2 < this.parameterTypes.length; ++n2) {
                this.parameterTypes[n2] = AjTypeSystem.getAjType(classArray[n2]);
            }
        }
        return this.parameterTypes;
    }

    @Override
    public PointcutExpression getPointcutExpression() {
        return this.pointcutExpression;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getName().length() > 0) {
            stringBuffer.append("@AdviceName(\"");
            stringBuffer.append(this.getName());
            stringBuffer.append("\") ");
        }
        if (this.getKind() == AdviceKind.AROUND) {
            stringBuffer.append(this.adviceMethod.getGenericReturnType().toString());
            stringBuffer.append(" ");
        }
        switch (1.$SwitchMap$org$aspectj$lang$reflect$AdviceKind[this.getKind().ordinal()]) {
            case 1: {
                stringBuffer.append("after(");
                break;
            }
            case 2: {
                stringBuffer.append("after(");
                break;
            }
            case 3: {
                stringBuffer.append("after(");
                break;
            }
            case 4: {
                stringBuffer.append("around(");
                break;
            }
            case 5: {
                stringBuffer.append("before(");
            }
        }
        AjType<?>[] ajTypeArray = this.getParameterTypes();
        int n3 = n2 = ajTypeArray.length;
        if (this.hasExtraParam) {
            n3 = n2 - 1;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuffer.append(ajTypeArray[n2].getName());
            if (n2 + 1 >= n3) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(") ");
        switch (this.getKind()) {
            case AFTER_RETURNING: {
                stringBuffer.append("returning");
                if (this.hasExtraParam) {
                    stringBuffer.append("(");
                    stringBuffer.append(ajTypeArray[n3 - 1].getName());
                    stringBuffer.append(") ");
                }
            }
            case AFTER_THROWING: {
                stringBuffer.append("throwing");
                if (this.hasExtraParam) {
                    stringBuffer.append("(");
                    stringBuffer.append(ajTypeArray[n3 - 1].getName());
                    stringBuffer.append(") ");
                } else {
                    break;
                }
            }
        }
        ajTypeArray = this.getExceptionTypes();
        if (ajTypeArray.length > 0) {
            stringBuffer.append("throws ");
            for (n3 = 0; n3 < ajTypeArray.length; ++n3) {
                stringBuffer.append(ajTypeArray[n3].getName());
                if (n3 + 1 >= ajTypeArray.length) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(" ");
        }
        stringBuffer.append(": ");
        stringBuffer.append(this.getPointcutExpression().asString());
        return stringBuffer.toString();
    }
}

