/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.aspectj.internal.lang.annotation.ajcDeclareAnnotation;
import org.aspectj.internal.lang.annotation.ajcDeclareEoW;
import org.aspectj.internal.lang.annotation.ajcDeclareParents;
import org.aspectj.internal.lang.annotation.ajcDeclarePrecedence;
import org.aspectj.internal.lang.annotation.ajcDeclareSoft;
import org.aspectj.internal.lang.annotation.ajcITD;
import org.aspectj.internal.lang.annotation.ajcPrivileged;
import org.aspectj.internal.lang.reflect.AdviceImpl;
import org.aspectj.internal.lang.reflect.DeclareAnnotationImpl;
import org.aspectj.internal.lang.reflect.DeclareErrorOrWarningImpl;
import org.aspectj.internal.lang.reflect.DeclareParentsImpl;
import org.aspectj.internal.lang.reflect.DeclarePrecedenceImpl;
import org.aspectj.internal.lang.reflect.DeclareSoftImpl;
import org.aspectj.internal.lang.reflect.InterTypeConstructorDeclarationImpl;
import org.aspectj.internal.lang.reflect.InterTypeFieldDeclarationImpl;
import org.aspectj.internal.lang.reflect.InterTypeMethodDeclarationImpl;
import org.aspectj.internal.lang.reflect.PerClauseImpl;
import org.aspectj.internal.lang.reflect.PointcutBasedPerClauseImpl;
import org.aspectj.internal.lang.reflect.PointcutImpl;
import org.aspectj.internal.lang.reflect.TypePatternBasedPerClauseImpl;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.DeclareError;
import org.aspectj.lang.annotation.DeclareParents;
import org.aspectj.lang.annotation.DeclareWarning;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.Advice;
import org.aspectj.lang.reflect.AdviceKind;
import org.aspectj.lang.reflect.AjType;
import org.aspectj.lang.reflect.AjTypeSystem;
import org.aspectj.lang.reflect.DeclareAnnotation;
import org.aspectj.lang.reflect.DeclareErrorOrWarning;
import org.aspectj.lang.reflect.DeclarePrecedence;
import org.aspectj.lang.reflect.DeclareSoft;
import org.aspectj.lang.reflect.InterTypeConstructorDeclaration;
import org.aspectj.lang.reflect.InterTypeFieldDeclaration;
import org.aspectj.lang.reflect.InterTypeMethodDeclaration;
import org.aspectj.lang.reflect.NoSuchAdviceException;
import org.aspectj.lang.reflect.NoSuchPointcutException;
import org.aspectj.lang.reflect.PerClause;
import org.aspectj.lang.reflect.PerClauseKind;

public class AjTypeImpl<T>
implements AjType<T> {
    private static final String ajcMagic = "ajc$";
    private Advice[] advice = null;
    private Class<T> clazz;
    private Advice[] declaredAdvice = null;
    private InterTypeConstructorDeclaration[] declaredITDCons = null;
    private InterTypeFieldDeclaration[] declaredITDFields = null;
    private InterTypeMethodDeclaration[] declaredITDMethods = null;
    private org.aspectj.lang.reflect.Pointcut[] declaredPointcuts = null;
    private InterTypeConstructorDeclaration[] itdCons = null;
    private InterTypeFieldDeclaration[] itdFields = null;
    private InterTypeMethodDeclaration[] itdMethods = null;
    private org.aspectj.lang.reflect.Pointcut[] pointcuts = null;

    public AjTypeImpl(Class<T> clazz) {
        this.clazz = clazz;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addAnnotationStyleDeclareParents(List<org.aspectj.lang.reflect.DeclareParents> list) {
        Field[] fieldArray = this.clazz.getDeclaredFields();
        int n2 = fieldArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Field field = fieldArray[n3];
            if (field.isAnnotationPresent(DeclareParents.class) && field.getType().isInterface()) {
                DeclareParents declareParents = field.getAnnotation(DeclareParents.class);
                String string2 = field.getType().getName();
                list.add(new DeclareParentsImpl(declareParents.value(), string2, false, this));
            }
            ++n3;
        }
        return;
    }

    private void addAnnotationStyleITDFields(List<InterTypeFieldDeclaration> list, boolean bl2) {
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addAnnotationStyleITDMethods(List<InterTypeMethodDeclaration> list, boolean bl2) {
        if (this.isAspect()) {
            block0: for (Field field : this.clazz.getDeclaredFields()) {
                if (!field.getType().isInterface() || !field.isAnnotationPresent(DeclareParents.class) || field.getAnnotation(DeclareParents.class).defaultImpl() == DeclareParents.class) continue;
                Method[] methodArray = field.getType().getDeclaredMethods();
                int n2 = methodArray.length;
                int n3 = 0;
                while (true) {
                    if (n3 >= n2) {
                        continue block0;
                    }
                    Method method = methodArray[n3];
                    if (Modifier.isPublic(method.getModifiers()) || !bl2) {
                        list.add(new InterTypeMethodDeclarationImpl(this, AjTypeSystem.getAjType(field.getType()), method, 1));
                    }
                    ++n3;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Advice asAdvice(Method object) {
        if (((AccessibleObject)object).getAnnotations().length == 0) {
            return null;
        }
        Before before = ((Method)object).getAnnotation(Before.class);
        if (before != null) {
            return new AdviceImpl((Method)object, before.value(), AdviceKind.BEFORE);
        }
        After after = ((Method)object).getAnnotation(After.class);
        if (after != null) {
            return new AdviceImpl((Method)object, after.value(), AdviceKind.AFTER);
        }
        AfterReturning afterReturning = ((Method)object).getAnnotation(AfterReturning.class);
        if (afterReturning != null) {
            void var2_6;
            String string2;
            String string3 = string2 = afterReturning.pointcut();
            if (!string2.equals("")) return new AdviceImpl((Method)object, (String)var2_6, AdviceKind.AFTER_RETURNING, afterReturning.returning());
            String string4 = afterReturning.value();
            return new AdviceImpl((Method)object, (String)var2_6, AdviceKind.AFTER_RETURNING, afterReturning.returning());
        }
        afterReturning = ((Method)object).getAnnotation(AfterThrowing.class);
        if (afterReturning != null) {
            void var2_9;
            String string5;
            String string6 = string5 = afterReturning.pointcut();
            if (string5 != null) return new AdviceImpl((Method)object, (String)var2_9, AdviceKind.AFTER_THROWING, afterReturning.throwing());
            String string7 = afterReturning.value();
            return new AdviceImpl((Method)object, (String)var2_9, AdviceKind.AFTER_THROWING, afterReturning.throwing());
        }
        Around around = ((Method)object).getAnnotation(Around.class);
        if (around == null) return null;
        return new AdviceImpl((Method)object, around.value(), AdviceKind.AROUND);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private org.aspectj.lang.reflect.Pointcut asPointcut(Method object) {
        String string2;
        Pointcut pointcut = ((Method)object).getAnnotation(Pointcut.class);
        if (pointcut == null) return null;
        String string3 = string2 = ((Method)object).getName();
        if (!string2.startsWith(ajcMagic)) return new PointcutImpl(string3, pointcut.value(), (Method)object, AjTypeSystem.getAjType(((Method)object).getDeclaringClass()), pointcut.argNames());
        string2 = string2.substring(string2.indexOf("$$") + 2, string2.length());
        int n2 = string2.indexOf("$");
        string3 = string2;
        if (n2 == -1) return new PointcutImpl(string3, pointcut.value(), (Method)object, AjTypeSystem.getAjType(((Method)object).getDeclaringClass()), pointcut.argNames());
        string3 = string2.substring(0, n2);
        return new PointcutImpl(string3, pointcut.value(), (Method)object, AjTypeSystem.getAjType(((Method)object).getDeclaringClass()), pointcut.argNames());
    }

    private Advice[] getAdvice(Set adviceArray) {
        if (this.advice == null) {
            this.initAdvice();
        }
        ArrayList<Advice> arrayList = new ArrayList<Advice>();
        for (Advice advice : this.advice) {
            if (!adviceArray.contains((Object)advice.getKind())) continue;
            arrayList.add(advice);
        }
        adviceArray = new Advice[arrayList.size()];
        arrayList.toArray(adviceArray);
        return adviceArray;
    }

    private Advice[] getDeclaredAdvice(Set adviceArray) {
        if (this.declaredAdvice == null) {
            this.initDeclaredAdvice();
        }
        ArrayList<Advice> arrayList = new ArrayList<Advice>();
        for (Advice advice : this.declaredAdvice) {
            if (!adviceArray.contains((Object)advice.getKind())) continue;
            arrayList.add(advice);
        }
        adviceArray = new Advice[arrayList.size()];
        arrayList.toArray(adviceArray);
        return adviceArray;
    }

    private void initAdvice() {
        Method[] methodArray = this.clazz.getMethods();
        ArrayList<Advice> arrayList = new ArrayList<Advice>();
        int n2 = methodArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Advice advice = this.asAdvice(methodArray[i2]);
            if (advice == null) continue;
            arrayList.add(advice);
        }
        this.advice = new Advice[arrayList.size()];
        arrayList.toArray(this.advice);
    }

    private void initDeclaredAdvice() {
        Method[] methodArray = this.clazz.getDeclaredMethods();
        ArrayList<Advice> arrayList = new ArrayList<Advice>();
        int n2 = methodArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Advice advice = this.asAdvice(methodArray[i2]);
            if (advice == null) continue;
            arrayList.add(advice);
        }
        this.declaredAdvice = new Advice[arrayList.size()];
        arrayList.toArray(this.declaredAdvice);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isReallyAMethod(Method method) {
        boolean bl2 = false;
        if (method.getName().startsWith(ajcMagic)) {
            return bl2;
        }
        if (method.getAnnotations().length == 0) {
            return true;
        }
        boolean bl3 = bl2;
        if (method.isAnnotationPresent(Pointcut.class)) return bl3;
        bl3 = bl2;
        if (method.isAnnotationPresent(Before.class)) return bl3;
        bl3 = bl2;
        if (method.isAnnotationPresent(After.class)) return bl3;
        bl3 = bl2;
        if (method.isAnnotationPresent(AfterReturning.class)) return bl3;
        bl3 = bl2;
        if (method.isAnnotationPresent(AfterThrowing.class)) return bl3;
        bl3 = bl2;
        if (method.isAnnotationPresent(Around.class)) return bl3;
        return true;
    }

    private AjType<?>[] toAjTypeArray(Class<?>[] classArray) {
        AjType[] ajTypeArray = new AjType[classArray.length];
        for (int i2 = 0; i2 < ajTypeArray.length; ++i2) {
            ajTypeArray[i2] = AjTypeSystem.getAjType(classArray[i2]);
        }
        return ajTypeArray;
    }

    private Class<?>[] toClassArray(AjType<?>[] ajTypeArray) {
        Class[] classArray = new Class[ajTypeArray.length];
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            classArray[i2] = ajTypeArray[i2].getJavaClass();
        }
        return classArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (object instanceof AjTypeImpl) return ((AjTypeImpl)object).clazz.equals(this.clazz);
        return false;
    }

    @Override
    public Advice getAdvice(String string2) throws NoSuchAdviceException {
        if (string2.equals("")) {
            throw new IllegalArgumentException("use getAdvice(AdviceType...) instead for un-named advice");
        }
        if (this.advice == null) {
            this.initAdvice();
        }
        for (Advice advice : this.advice) {
            if (!advice.getName().equals(string2)) continue;
            return advice;
        }
        throw new NoSuchAdviceException(string2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Advice[] getAdvice(AdviceKind ... object) {
        void var1_3;
        if (((AdviceKind[])object).length == 0) {
            EnumSet<AdviceKind> enumSet = EnumSet.allOf(AdviceKind.class);
            return this.getAdvice((Set)var1_3);
        }
        EnumSet<AdviceKind> enumSet = EnumSet.noneOf(AdviceKind.class);
        enumSet.addAll(Arrays.asList(object));
        EnumSet<AdviceKind> enumSet2 = enumSet;
        return this.getAdvice((Set)var1_3);
    }

    @Override
    public AjType<?>[] getAjTypes() {
        return this.toAjTypeArray(this.clazz.getClasses());
    }

    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        return this.clazz.getAnnotation(clazz);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.clazz.getAnnotations();
    }

    @Override
    public Constructor getConstructor(AjType<?> ... ajTypeArray) throws NoSuchMethodException {
        return this.clazz.getConstructor(this.toClassArray(ajTypeArray));
    }

    @Override
    public Constructor[] getConstructors() {
        return this.clazz.getConstructors();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public DeclareAnnotation[] getDeclareAnnotations() {
        ArrayList<DeclareAnnotation> arrayList = new ArrayList<DeclareAnnotation>();
        Method[] methodArray = this.clazz.getDeclaredMethods();
        int n2 = methodArray.length;
        int n3 = 0;
        while (true) {
            block6: {
                void var5_9;
                ajcDeclareAnnotation ajcDeclareAnnotation2;
                block4: {
                    int n4;
                    Annotation[] annotationArray;
                    block7: {
                        block5: {
                            if (n3 >= n2) break block5;
                            Method method = methodArray[n3];
                            if (!method.isAnnotationPresent(ajcDeclareAnnotation.class)) break block6;
                            ajcDeclareAnnotation2 = method.getAnnotation(ajcDeclareAnnotation.class);
                            annotationArray = method.getAnnotations();
                            n4 = annotationArray.length;
                            break block7;
                        }
                        if (this.getSupertype().isAspect()) {
                            arrayList.addAll(Arrays.asList(this.getSupertype().getDeclareAnnotations()));
                        }
                        DeclareAnnotation[] declareAnnotationArray = new DeclareAnnotation[arrayList.size()];
                        arrayList.toArray(declareAnnotationArray);
                        return declareAnnotationArray;
                    }
                    for (int i2 = 0; i2 < n4; ++i2) {
                        Annotation annotation = annotationArray[i2];
                        if (annotation.annotationType() == ajcDeclareAnnotation.class) {
                            continue;
                        }
                        break block4;
                    }
                    Object var5_11 = null;
                }
                arrayList.add(new DeclareAnnotationImpl(this, ajcDeclareAnnotation2.kind(), ajcDeclareAnnotation2.pattern(), (Annotation)var5_9, ajcDeclareAnnotation2.annotation()));
            }
            ++n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DeclareErrorOrWarning[] getDeclareErrorOrWarnings() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Field field : this.clazz.getDeclaredFields()) {
            try {
                Object object;
                if (field.isAnnotationPresent(DeclareWarning.class)) {
                    DeclareWarning declareWarning = field.getAnnotation(DeclareWarning.class);
                    if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers())) continue;
                    String string2 = (String)field.get(null);
                    object = new DeclareErrorOrWarningImpl(declareWarning.value(), string2, false, this);
                    arrayList.add(object);
                    continue;
                }
                if (!field.isAnnotationPresent(DeclareError.class)) continue;
                DeclareError declareError = field.getAnnotation(DeclareError.class);
                if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers())) continue;
                object = (String)field.get(null);
                DeclareErrorOrWarningImpl declareErrorOrWarningImpl = new DeclareErrorOrWarningImpl(declareError.value(), (String)object, true, this);
                arrayList.add(declareErrorOrWarningImpl);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        Object[] objectArray = this.clazz.getDeclaredMethods();
        int n2 = objectArray.length;
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                objectArray = new DeclareErrorOrWarning[arrayList.size()];
                arrayList.toArray(objectArray);
                return objectArray;
            }
            AccessibleObject accessibleObject = objectArray[n3];
            if (accessibleObject.isAnnotationPresent(ajcDeclareEoW.class)) {
                ajcDeclareEoW ajcDeclareEoW2 = ((Method)accessibleObject).getAnnotation(ajcDeclareEoW.class);
                arrayList.add(new DeclareErrorOrWarningImpl(ajcDeclareEoW2.pointcut(), ajcDeclareEoW2.message(), ajcDeclareEoW2.isError(), this));
            }
            ++n3;
        }
    }

    @Override
    public org.aspectj.lang.reflect.DeclareParents[] getDeclareParents() {
        ArrayList<org.aspectj.lang.reflect.DeclareParents> arrayList = new ArrayList<org.aspectj.lang.reflect.DeclareParents>();
        for (Method method : this.clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(ajcDeclareParents.class)) continue;
            method = method.getAnnotation(ajcDeclareParents.class);
            arrayList.add(new DeclareParentsImpl(method.targetTypePattern(), method.parentTypes(), method.isExtends(), this));
        }
        this.addAnnotationStyleDeclareParents(arrayList);
        if (this.getSupertype().isAspect()) {
            arrayList.addAll(Arrays.asList(this.getSupertype().getDeclareParents()));
        }
        Object[] objectArray = new org.aspectj.lang.reflect.DeclareParents[arrayList.size()];
        arrayList.toArray(objectArray);
        return objectArray;
    }

    @Override
    public DeclarePrecedence[] getDeclarePrecedence() {
        ArrayList<DeclarePrecedence> arrayList = new ArrayList<DeclarePrecedence>();
        if (this.clazz.isAnnotationPresent(org.aspectj.lang.annotation.DeclarePrecedence.class)) {
            arrayList.add(new DeclarePrecedenceImpl(this.clazz.getAnnotation(org.aspectj.lang.annotation.DeclarePrecedence.class).value(), this));
        }
        for (Method method : this.clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(ajcDeclarePrecedence.class)) continue;
            arrayList.add(new DeclarePrecedenceImpl(method.getAnnotation(ajcDeclarePrecedence.class).value(), this));
        }
        if (this.getSupertype().isAspect()) {
            arrayList.addAll(Arrays.asList(this.getSupertype().getDeclarePrecedence()));
        }
        Object[] objectArray = new DeclarePrecedence[arrayList.size()];
        arrayList.toArray(objectArray);
        return objectArray;
    }

    @Override
    public DeclareSoft[] getDeclareSofts() {
        ArrayList<DeclareSoft> arrayList = new ArrayList<DeclareSoft>();
        for (Method method : this.clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(ajcDeclareSoft.class)) continue;
            method = method.getAnnotation(ajcDeclareSoft.class);
            arrayList.add(new DeclareSoftImpl(this, method.pointcut(), method.exceptionType()));
        }
        if (this.getSupertype().isAspect()) {
            arrayList.addAll(Arrays.asList(this.getSupertype().getDeclareSofts()));
        }
        Object[] objectArray = new DeclareSoft[arrayList.size()];
        arrayList.toArray(objectArray);
        return objectArray;
    }

    @Override
    public Advice getDeclaredAdvice(String string2) throws NoSuchAdviceException {
        if (string2.equals("")) {
            throw new IllegalArgumentException("use getAdvice(AdviceType...) instead for un-named advice");
        }
        if (this.declaredAdvice == null) {
            this.initDeclaredAdvice();
        }
        for (Advice advice : this.declaredAdvice) {
            if (!advice.getName().equals(string2)) continue;
            return advice;
        }
        throw new NoSuchAdviceException(string2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Advice[] getDeclaredAdvice(AdviceKind ... object) {
        void var1_3;
        if (((AdviceKind[])object).length == 0) {
            EnumSet<AdviceKind> enumSet = EnumSet.allOf(AdviceKind.class);
            return this.getDeclaredAdvice((Set)var1_3);
        }
        EnumSet<AdviceKind> enumSet = EnumSet.noneOf(AdviceKind.class);
        enumSet.addAll(Arrays.asList(object));
        EnumSet<AdviceKind> enumSet2 = enumSet;
        return this.getDeclaredAdvice((Set)var1_3);
    }

    @Override
    public AjType<?>[] getDeclaredAjTypes() {
        return this.toAjTypeArray(this.clazz.getDeclaredClasses());
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.clazz.getDeclaredAnnotations();
    }

    @Override
    public Constructor getDeclaredConstructor(AjType<?> ... ajTypeArray) throws NoSuchMethodException {
        return this.clazz.getDeclaredConstructor(this.toClassArray(ajTypeArray));
    }

    @Override
    public Constructor[] getDeclaredConstructors() {
        return this.clazz.getDeclaredConstructors();
    }

    @Override
    public Field getDeclaredField(String string2) throws NoSuchFieldException {
        Field field = this.clazz.getDeclaredField(string2);
        if (field.getName().startsWith(ajcMagic)) {
            throw new NoSuchFieldException(string2);
        }
        return field;
    }

    @Override
    public Field[] getDeclaredFields() {
        Field[] fieldArray2 = this.clazz.getDeclaredFields();
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Field fieldArray3 : fieldArray2) {
            if (fieldArray3.getName().startsWith(ajcMagic) || fieldArray3.isAnnotationPresent(DeclareWarning.class) || fieldArray3.isAnnotationPresent(DeclareError.class)) continue;
            arrayList.add(fieldArray3);
        }
        Field[] fieldArray = new Field[arrayList.size()];
        arrayList.toArray(fieldArray);
        return fieldArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InterTypeConstructorDeclaration getDeclaredITDConstructor(AjType<?> ajType, AjType<?> ... ajTypeArray) throws NoSuchMethodException {
        InterTypeConstructorDeclaration[] interTypeConstructorDeclarationArray = this.getDeclaredITDConstructors();
        int n2 = interTypeConstructorDeclarationArray.length;
        int n3 = 0;
        while (true) {
            block6: {
                if (n3 >= n2) {
                    throw new NoSuchMethodException();
                }
                InterTypeConstructorDeclaration interTypeConstructorDeclaration = interTypeConstructorDeclarationArray[n3];
                try {
                    AjType<?>[] ajTypeArray2;
                    if (!interTypeConstructorDeclaration.getTargetType().equals(ajType) || (ajTypeArray2 = interTypeConstructorDeclaration.getParameterTypes()).length != ajTypeArray.length) break block6;
                    for (int i2 = 0; i2 < ajTypeArray2.length; ++i2) {
                        boolean bl2 = ajTypeArray2[i2].equals(ajTypeArray[i2]);
                        if (bl2) {
                            continue;
                        }
                        break block6;
                    }
                    return interTypeConstructorDeclaration;
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            ++n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public InterTypeConstructorDeclaration[] getDeclaredITDConstructors() {
        if (this.declaredITDCons == null) {
            ArrayList<InterTypeConstructorDeclarationImpl> arrayList = new ArrayList<InterTypeConstructorDeclarationImpl>();
            for (Method method : this.clazz.getDeclaredMethods()) {
                if (!method.getName().contains("ajc$postInterConstructor") || !method.isAnnotationPresent(ajcITD.class)) continue;
                ajcITD ajcITD2 = method.getAnnotation(ajcITD.class);
                arrayList.add(new InterTypeConstructorDeclarationImpl(this, ajcITD2.targetType(), ajcITD2.modifiers(), method));
            }
            this.declaredITDCons = new InterTypeConstructorDeclaration[arrayList.size()];
            arrayList.toArray(this.declaredITDCons);
        }
        return this.declaredITDCons;
    }

    @Override
    public InterTypeFieldDeclaration getDeclaredITDField(String string2, AjType<?> ajType) throws NoSuchFieldException {
        for (InterTypeFieldDeclaration interTypeFieldDeclaration : this.getDeclaredITDFields()) {
            if (!interTypeFieldDeclaration.getName().equals(string2)) continue;
            try {
                boolean bl2 = interTypeFieldDeclaration.getTargetType().equals(ajType);
                if (!bl2) continue;
                return interTypeFieldDeclaration;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new NoSuchFieldException(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InterTypeFieldDeclaration[] getDeclaredITDFields() {
        ArrayList<InterTypeFieldDeclaration> arrayList = new ArrayList<InterTypeFieldDeclaration>();
        if (this.declaredITDFields == null) {
            for (Method method : this.clazz.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(ajcITD.class) || !method.getName().contains("ajc$interFieldInit")) continue;
                ajcITD ajcITD2 = method.getAnnotation(ajcITD.class);
                Object object = method.getName().replace("FieldInit", "FieldGetDispatch");
                try {
                    object = this.clazz.getDeclaredMethod((String)object, method.getParameterTypes());
                    InterTypeFieldDeclarationImpl interTypeFieldDeclarationImpl = new InterTypeFieldDeclarationImpl(this, ajcITD2.targetType(), ajcITD2.modifiers(), ajcITD2.name(), AjTypeSystem.getAjType(((Method)object).getReturnType()), ((Method)object).getGenericReturnType());
                    arrayList.add(interTypeFieldDeclarationImpl);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new IllegalStateException("Can't find field get dispatch method for " + method.getName());
                }
            }
            this.addAnnotationStyleITDFields(arrayList, false);
            this.declaredITDFields = new InterTypeFieldDeclaration[arrayList.size()];
            arrayList.toArray(this.declaredITDFields);
        }
        return this.declaredITDFields;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InterTypeMethodDeclaration getDeclaredITDMethod(String string2, AjType<?> ajType, AjType<?> ... ajTypeArray) throws NoSuchMethodException {
        InterTypeMethodDeclaration[] interTypeMethodDeclarationArray = this.getDeclaredITDMethods();
        int n2 = interTypeMethodDeclarationArray.length;
        int n3 = 0;
        while (true) {
            block7: {
                if (n3 >= n2) {
                    throw new NoSuchMethodException(string2);
                }
                InterTypeMethodDeclaration interTypeMethodDeclaration = interTypeMethodDeclarationArray[n3];
                try {
                    AjType<?>[] ajTypeArray2;
                    if (!interTypeMethodDeclaration.getName().equals(string2) || !interTypeMethodDeclaration.getTargetType().equals(ajType) || (ajTypeArray2 = interTypeMethodDeclaration.getParameterTypes()).length != ajTypeArray.length) break block7;
                    for (int i2 = 0; i2 < ajTypeArray2.length; ++i2) {
                        boolean bl2 = ajTypeArray2[i2].equals(ajTypeArray[i2]);
                        if (bl2) {
                            continue;
                        }
                        break block7;
                    }
                    return interTypeMethodDeclaration;
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            ++n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public InterTypeMethodDeclaration[] getDeclaredITDMethods() {
        if (this.declaredITDMethods == null) {
            ArrayList<InterTypeMethodDeclaration> arrayList = new ArrayList<InterTypeMethodDeclaration>();
            for (Method method : this.clazz.getDeclaredMethods()) {
                if (!method.getName().contains("ajc$interMethodDispatch1$") || !method.isAnnotationPresent(ajcITD.class)) continue;
                ajcITD ajcITD2 = method.getAnnotation(ajcITD.class);
                arrayList.add(new InterTypeMethodDeclarationImpl(this, ajcITD2.targetType(), ajcITD2.modifiers(), ajcITD2.name(), method));
            }
            this.addAnnotationStyleITDMethods(arrayList, false);
            this.declaredITDMethods = new InterTypeMethodDeclaration[arrayList.size()];
            arrayList.toArray(this.declaredITDMethods);
        }
        return this.declaredITDMethods;
    }

    @Override
    public Method getDeclaredMethod(String string2, AjType<?> ... object) throws NoSuchMethodException {
        if (!this.isReallyAMethod((Method)(object = this.clazz.getDeclaredMethod(string2, this.toClassArray((AjType<?>[])object))))) {
            throw new NoSuchMethodException(string2);
        }
        return object;
    }

    @Override
    public Method[] getDeclaredMethods() {
        Method[] methodArray = this.clazz.getDeclaredMethods();
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (Method method : methodArray) {
            if (!this.isReallyAMethod(method)) continue;
            arrayList.add(method);
        }
        methodArray = new Method[arrayList.size()];
        arrayList.toArray(methodArray);
        return methodArray;
    }

    @Override
    public org.aspectj.lang.reflect.Pointcut getDeclaredPointcut(String string2) throws NoSuchPointcutException {
        for (org.aspectj.lang.reflect.Pointcut pointcut : this.getDeclaredPointcuts()) {
            if (!pointcut.getName().equals(string2)) continue;
            return pointcut;
        }
        throw new NoSuchPointcutException(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public org.aspectj.lang.reflect.Pointcut[] getDeclaredPointcuts() {
        if (this.declaredPointcuts != null) {
            return this.declaredPointcuts;
        }
        ArrayList<org.aspectj.lang.reflect.Pointcut> arrayList = new ArrayList<org.aspectj.lang.reflect.Pointcut>();
        Object[] objectArray = this.clazz.getDeclaredMethods();
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            org.aspectj.lang.reflect.Pointcut pointcut = this.asPointcut((Method)objectArray[i2]);
            if (pointcut == null) continue;
            arrayList.add(pointcut);
        }
        objectArray = new org.aspectj.lang.reflect.Pointcut[arrayList.size()];
        arrayList.toArray(objectArray);
        this.declaredPointcuts = objectArray;
        return objectArray;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AjType<?> getDeclaringType() {
        void var1_3;
        Class<?> clazz = this.clazz.getDeclaringClass();
        if (clazz == null) return var1_3;
        AjTypeImpl ajTypeImpl = new AjTypeImpl(clazz);
        return var1_3;
    }

    @Override
    public Constructor getEnclosingConstructor() {
        return this.clazz.getEnclosingConstructor();
    }

    @Override
    public Method getEnclosingMethod() {
        return this.clazz.getEnclosingMethod();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AjType<?> getEnclosingType() {
        void var1_3;
        Class<?> clazz = this.clazz.getEnclosingClass();
        if (clazz == null) return var1_3;
        AjTypeImpl ajTypeImpl = new AjTypeImpl(clazz);
        return var1_3;
    }

    @Override
    public T[] getEnumConstants() {
        return this.clazz.getEnumConstants();
    }

    @Override
    public Field getField(String string2) throws NoSuchFieldException {
        Field field = this.clazz.getField(string2);
        if (field.getName().startsWith(ajcMagic)) {
            throw new NoSuchFieldException(string2);
        }
        return field;
    }

    @Override
    public Field[] getFields() {
        Field[] fieldArray2 = this.clazz.getFields();
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Field fieldArray3 : fieldArray2) {
            if (fieldArray3.getName().startsWith(ajcMagic) || fieldArray3.isAnnotationPresent(DeclareWarning.class) || fieldArray3.isAnnotationPresent(DeclareError.class)) continue;
            arrayList.add(fieldArray3);
        }
        Field[] fieldArray = new Field[arrayList.size()];
        arrayList.toArray(fieldArray);
        return fieldArray;
    }

    @Override
    public Type getGenericSupertype() {
        return this.clazz.getGenericSuperclass();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InterTypeConstructorDeclaration getITDConstructor(AjType<?> ajType, AjType<?> ... ajTypeArray) throws NoSuchMethodException {
        InterTypeConstructorDeclaration[] interTypeConstructorDeclarationArray = this.getITDConstructors();
        int n2 = interTypeConstructorDeclarationArray.length;
        int n3 = 0;
        while (true) {
            block6: {
                if (n3 >= n2) {
                    throw new NoSuchMethodException();
                }
                InterTypeConstructorDeclaration interTypeConstructorDeclaration = interTypeConstructorDeclarationArray[n3];
                try {
                    AjType<?>[] ajTypeArray2;
                    if (!interTypeConstructorDeclaration.getTargetType().equals(ajType) || (ajTypeArray2 = interTypeConstructorDeclaration.getParameterTypes()).length != ajTypeArray.length) break block6;
                    for (int i2 = 0; i2 < ajTypeArray2.length; ++i2) {
                        boolean bl2 = ajTypeArray2[i2].equals(ajTypeArray[i2]);
                        if (bl2) {
                            continue;
                        }
                        break block6;
                    }
                    return interTypeConstructorDeclaration;
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            ++n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public InterTypeConstructorDeclaration[] getITDConstructors() {
        if (this.itdCons == null) {
            ArrayList<InterTypeConstructorDeclarationImpl> arrayList = new ArrayList<InterTypeConstructorDeclarationImpl>();
            for (Method method : this.clazz.getMethods()) {
                ajcITD ajcITD2;
                if (!method.getName().contains("ajc$postInterConstructor") || !method.isAnnotationPresent(ajcITD.class) || !Modifier.isPublic((ajcITD2 = method.getAnnotation(ajcITD.class)).modifiers())) continue;
                arrayList.add(new InterTypeConstructorDeclarationImpl(this, ajcITD2.targetType(), ajcITD2.modifiers(), method));
            }
            this.itdCons = new InterTypeConstructorDeclaration[arrayList.size()];
            arrayList.toArray(this.itdCons);
        }
        return this.itdCons;
    }

    @Override
    public InterTypeFieldDeclaration getITDField(String string2, AjType<?> ajType) throws NoSuchFieldException {
        for (InterTypeFieldDeclaration interTypeFieldDeclaration : this.getITDFields()) {
            if (!interTypeFieldDeclaration.getName().equals(string2)) continue;
            try {
                boolean bl2 = interTypeFieldDeclaration.getTargetType().equals(ajType);
                if (!bl2) continue;
                return interTypeFieldDeclaration;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new NoSuchFieldException(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InterTypeFieldDeclaration[] getITDFields() {
        ArrayList<InterTypeFieldDeclaration> arrayList = new ArrayList<InterTypeFieldDeclaration>();
        if (this.itdFields == null) {
            for (Method method : this.clazz.getMethods()) {
                if (!method.isAnnotationPresent(ajcITD.class)) continue;
                ajcITD ajcITD2 = method.getAnnotation(ajcITD.class);
                if (!method.getName().contains("ajc$interFieldInit") || !Modifier.isPublic(ajcITD2.modifiers())) continue;
                Object object = method.getName().replace("FieldInit", "FieldGetDispatch");
                try {
                    object = method.getDeclaringClass().getDeclaredMethod((String)object, method.getParameterTypes());
                    InterTypeFieldDeclarationImpl interTypeFieldDeclarationImpl = new InterTypeFieldDeclarationImpl(this, ajcITD2.targetType(), ajcITD2.modifiers(), ajcITD2.name(), AjTypeSystem.getAjType(((Method)object).getReturnType()), ((Method)object).getGenericReturnType());
                    arrayList.add(interTypeFieldDeclarationImpl);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new IllegalStateException("Can't find field get dispatch method for " + method.getName());
                }
            }
            this.addAnnotationStyleITDFields(arrayList, true);
            this.itdFields = new InterTypeFieldDeclaration[arrayList.size()];
            arrayList.toArray(this.itdFields);
        }
        return this.itdFields;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InterTypeMethodDeclaration getITDMethod(String string2, AjType<?> ajType, AjType<?> ... ajTypeArray) throws NoSuchMethodException {
        InterTypeMethodDeclaration[] interTypeMethodDeclarationArray = this.getITDMethods();
        int n2 = interTypeMethodDeclarationArray.length;
        int n3 = 0;
        while (true) {
            block7: {
                if (n3 >= n2) {
                    throw new NoSuchMethodException(string2);
                }
                InterTypeMethodDeclaration interTypeMethodDeclaration = interTypeMethodDeclarationArray[n3];
                try {
                    AjType<?>[] ajTypeArray2;
                    if (!interTypeMethodDeclaration.getName().equals(string2) || !interTypeMethodDeclaration.getTargetType().equals(ajType) || (ajTypeArray2 = interTypeMethodDeclaration.getParameterTypes()).length != ajTypeArray.length) break block7;
                    for (int i2 = 0; i2 < ajTypeArray2.length; ++i2) {
                        boolean bl2 = ajTypeArray2[i2].equals(ajTypeArray[i2]);
                        if (bl2) {
                            continue;
                        }
                        break block7;
                    }
                    return interTypeMethodDeclaration;
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            ++n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public InterTypeMethodDeclaration[] getITDMethods() {
        if (this.itdMethods == null) {
            ArrayList<InterTypeMethodDeclaration> arrayList = new ArrayList<InterTypeMethodDeclaration>();
            for (Method method : this.clazz.getDeclaredMethods()) {
                ajcITD ajcITD2;
                if (!method.getName().contains("ajc$interMethod$") || !method.isAnnotationPresent(ajcITD.class) || !Modifier.isPublic((ajcITD2 = method.getAnnotation(ajcITD.class)).modifiers())) continue;
                arrayList.add(new InterTypeMethodDeclarationImpl(this, ajcITD2.targetType(), ajcITD2.modifiers(), ajcITD2.name(), method));
            }
            this.addAnnotationStyleITDMethods(arrayList, true);
            this.itdMethods = new InterTypeMethodDeclaration[arrayList.size()];
            arrayList.toArray(this.itdMethods);
        }
        return this.itdMethods;
    }

    @Override
    public AjType<?>[] getInterfaces() {
        return this.toAjTypeArray(this.clazz.getInterfaces());
    }

    @Override
    public Class<T> getJavaClass() {
        return this.clazz;
    }

    @Override
    public Method getMethod(String string2, AjType<?> ... object) throws NoSuchMethodException {
        if (!this.isReallyAMethod((Method)(object = this.clazz.getMethod(string2, this.toClassArray((AjType<?>[])object))))) {
            throw new NoSuchMethodException(string2);
        }
        return object;
    }

    @Override
    public Method[] getMethods() {
        Method[] methodArray = this.clazz.getMethods();
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (Method method : methodArray) {
            if (!this.isReallyAMethod(method)) continue;
            arrayList.add(method);
        }
        methodArray = new Method[arrayList.size()];
        arrayList.toArray(methodArray);
        return methodArray;
    }

    @Override
    public int getModifiers() {
        return this.clazz.getModifiers();
    }

    @Override
    public String getName() {
        return this.clazz.getName();
    }

    @Override
    public Package getPackage() {
        return this.clazz.getPackage();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PerClause getPerClause() {
        if (!this.isAspect()) return null;
        String string2 = this.clazz.getAnnotation(Aspect.class).value();
        if (string2.equals("")) {
            if (!this.getSupertype().isAspect()) return new PerClauseImpl(PerClauseKind.SINGLETON);
            return this.getSupertype().getPerClause();
        }
        if (string2.startsWith("perthis(")) {
            return new PointcutBasedPerClauseImpl(PerClauseKind.PERTHIS, string2.substring("perthis(".length(), string2.length() - 1));
        }
        if (string2.startsWith("pertarget(")) {
            return new PointcutBasedPerClauseImpl(PerClauseKind.PERTARGET, string2.substring("pertarget(".length(), string2.length() - 1));
        }
        if (string2.startsWith("percflow(")) {
            return new PointcutBasedPerClauseImpl(PerClauseKind.PERCFLOW, string2.substring("percflow(".length(), string2.length() - 1));
        }
        if (string2.startsWith("percflowbelow(")) {
            return new PointcutBasedPerClauseImpl(PerClauseKind.PERCFLOWBELOW, string2.substring("percflowbelow(".length(), string2.length() - 1));
        }
        if (!string2.startsWith("pertypewithin")) throw new IllegalStateException("Per-clause not recognized: " + (String)string2);
        return new TypePatternBasedPerClauseImpl(PerClauseKind.PERTYPEWITHIN, string2.substring("pertypewithin(".length(), string2.length() - 1));
    }

    @Override
    public org.aspectj.lang.reflect.Pointcut getPointcut(String string2) throws NoSuchPointcutException {
        for (org.aspectj.lang.reflect.Pointcut pointcut : this.getPointcuts()) {
            if (!pointcut.getName().equals(string2)) continue;
            return pointcut;
        }
        throw new NoSuchPointcutException(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public org.aspectj.lang.reflect.Pointcut[] getPointcuts() {
        if (this.pointcuts != null) {
            return this.pointcuts;
        }
        ArrayList<org.aspectj.lang.reflect.Pointcut> arrayList = new ArrayList<org.aspectj.lang.reflect.Pointcut>();
        Object[] objectArray = this.clazz.getMethods();
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            org.aspectj.lang.reflect.Pointcut pointcut = this.asPointcut((Method)objectArray[i2]);
            if (pointcut == null) continue;
            arrayList.add(pointcut);
        }
        objectArray = new org.aspectj.lang.reflect.Pointcut[arrayList.size()];
        arrayList.toArray(objectArray);
        this.pointcuts = objectArray;
        return objectArray;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public AjType<? super T> getSupertype() {
        void var1_3;
        Class<T> clazz = this.clazz.getSuperclass();
        if (clazz == null) {
            return var1_3;
        }
        AjTypeImpl<T> ajTypeImpl = new AjTypeImpl<T>(clazz);
        return var1_3;
    }

    @Override
    public TypeVariable<Class<T>>[] getTypeParameters() {
        return this.clazz.getTypeParameters();
    }

    public int hashCode() {
        return this.clazz.hashCode();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> clazz) {
        return this.clazz.isAnnotationPresent(clazz);
    }

    @Override
    public boolean isArray() {
        return this.clazz.isArray();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isAspect() {
        if (this.clazz.getAnnotation(Aspect.class) == null) return false;
        return true;
    }

    @Override
    public boolean isEnum() {
        return this.clazz.isEnum();
    }

    @Override
    public boolean isInstance(Object object) {
        return this.clazz.isInstance(object);
    }

    @Override
    public boolean isInterface() {
        return this.clazz.isInterface();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isLocalClass() {
        if (!this.clazz.isLocalClass()) return false;
        if (this.isAspect()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isMemberAspect() {
        if (!this.clazz.isMemberClass()) return false;
        if (!this.isAspect()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isMemberClass() {
        if (!this.clazz.isMemberClass()) return false;
        if (this.isAspect()) return false;
        return true;
    }

    @Override
    public boolean isPrimitive() {
        return this.clazz.isPrimitive();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isPrivileged() {
        if (!this.isAspect()) return false;
        if (!this.clazz.isAnnotationPresent(ajcPrivileged.class)) return false;
        return true;
    }

    public String toString() {
        return this.getName();
    }
}

