/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.lang.reflect;

import org.aspectj.internal.lang.reflect.PointcutExpressionImpl;
import org.aspectj.lang.reflect.AjType;
import org.aspectj.lang.reflect.AjTypeSystem;
import org.aspectj.lang.reflect.DeclareSoft;
import org.aspectj.lang.reflect.PointcutExpression;

public class DeclareSoftImpl
implements DeclareSoft {
    private AjType<?> declaringType;
    private AjType<?> exceptionType;
    private String missingTypeName;
    private PointcutExpression pointcut;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DeclareSoftImpl(AjType<?> ajType, String string2, String string3) {
        this.declaringType = ajType;
        this.pointcut = new PointcutExpressionImpl(string2);
        try {
            this.exceptionType = AjTypeSystem.getAjType(Class.forName(string3, false, ajType.getJavaClass().getClassLoader()));
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.missingTypeName = string3;
            return;
        }
    }

    @Override
    public AjType getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public PointcutExpression getPointcutExpression() {
        return this.pointcut;
    }

    @Override
    public AjType getSoftenedExceptionType() throws ClassNotFoundException {
        if (this.missingTypeName != null) {
            throw new ClassNotFoundException(this.missingTypeName);
        }
        return this.exceptionType;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("declare soft : ");
        if (this.missingTypeName != null) {
            stringBuffer.append(this.exceptionType.getName());
        } else {
            stringBuffer.append(this.missingTypeName);
        }
        stringBuffer.append(" : ");
        stringBuffer.append(this.getPointcutExpression().asString());
        return stringBuffer.toString();
    }
}

