/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.lang;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.aspectj.lang.NoAspectBoundException;

public class Aspects14 {
    private static final String ASPECTOF = "aspectOf";
    private static final Class[] EMPTY_CLASS_ARRAY;
    private static final Object[] EMPTY_OBJECT_ARRAY;
    private static final String HASASPECT = "hasAspect";
    private static final Class[] PEROBJECT_CLASS_ARRAY;
    private static final Class[] PERTYPEWITHIN_CLASS_ARRAY;
    static Class class$java$lang$Class;
    static Class class$java$lang$Object;

    /*
     * Enabled aggressive block sorting
     */
    static {
        Class clazz;
        EMPTY_CLASS_ARRAY = new Class[0];
        if (class$java$lang$Object == null) {
            class$java$lang$Object = clazz = Aspects14.class$("java.lang.Object");
        } else {
            clazz = class$java$lang$Object;
        }
        PEROBJECT_CLASS_ARRAY = new Class[]{clazz};
        if (class$java$lang$Class == null) {
            class$java$lang$Class = clazz = Aspects14.class$("java.lang.Class");
        } else {
            clazz = class$java$lang$Class;
        }
        PERTYPEWITHIN_CLASS_ARRAY = new Class[]{clazz};
        EMPTY_OBJECT_ARRAY = new Object[0];
    }

    public static Object aspectOf(Class clazz) throws NoAspectBoundException {
        try {
            Object object = Aspects14.getSingletonOrThreadAspectOf(clazz).invoke(null, EMPTY_OBJECT_ARRAY);
            return object;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new NoAspectBoundException(clazz.getName(), invocationTargetException);
        }
        catch (Exception exception) {
            throw new NoAspectBoundException(clazz.getName(), exception);
        }
    }

    public static Object aspectOf(Class clazz, Class object) throws NoAspectBoundException {
        try {
            object = Aspects14.getPerTypeWithinAspectOf(clazz).invoke(null, object);
            return object;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new NoAspectBoundException(clazz.getName(), invocationTargetException);
        }
        catch (Exception exception) {
            throw new NoAspectBoundException(clazz.getName(), exception);
        }
    }

    public static Object aspectOf(Class clazz, Object object) throws NoAspectBoundException {
        try {
            object = Aspects14.getPerObjectAspectOf(clazz).invoke(null, object);
            return object;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new NoAspectBoundException(clazz.getName(), invocationTargetException);
        }
        catch (Exception exception) {
            throw new NoAspectBoundException(clazz.getName(), exception);
        }
    }

    private static Method checkAspectOf(Method method, Class clazz) throws NoSuchMethodException {
        ((AccessibleObject)method).setAccessible(true);
        if (!(method.isAccessible() && Modifier.isPublic(method.getModifiers()) && Modifier.isStatic(method.getModifiers()))) {
            throw new NoSuchMethodException(new StringBuffer().append(clazz.getName()).append(".aspectOf(..) is not accessible public static").toString());
        }
        return method;
    }

    private static Method checkHasAspect(Method method, Class clazz) throws NoSuchMethodException {
        ((AccessibleObject)method).setAccessible(true);
        if (!(method.isAccessible() && Modifier.isPublic(method.getModifiers()) && Modifier.isStatic(method.getModifiers()))) {
            throw new NoSuchMethodException(new StringBuffer().append(clazz.getName()).append(".hasAspect(..) is not accessible public static").toString());
        }
        return method;
    }

    static Class class$(String object) {
        try {
            object = Class.forName((String)object);
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static Method getPerObjectAspectOf(Class clazz) throws NoSuchMethodException {
        return Aspects14.checkAspectOf(clazz.getDeclaredMethod(ASPECTOF, PEROBJECT_CLASS_ARRAY), clazz);
    }

    private static Method getPerObjectHasAspect(Class clazz) throws NoSuchMethodException {
        return Aspects14.checkHasAspect(clazz.getDeclaredMethod(HASASPECT, PEROBJECT_CLASS_ARRAY), clazz);
    }

    private static Method getPerTypeWithinAspectOf(Class clazz) throws NoSuchMethodException {
        return Aspects14.checkAspectOf(clazz.getDeclaredMethod(ASPECTOF, PERTYPEWITHIN_CLASS_ARRAY), clazz);
    }

    private static Method getPerTypeWithinHasAspect(Class clazz) throws NoSuchMethodException {
        return Aspects14.checkHasAspect(clazz.getDeclaredMethod(HASASPECT, PERTYPEWITHIN_CLASS_ARRAY), clazz);
    }

    private static Method getSingletonOrThreadAspectOf(Class clazz) throws NoSuchMethodException {
        return Aspects14.checkAspectOf(clazz.getDeclaredMethod(ASPECTOF, EMPTY_CLASS_ARRAY), clazz);
    }

    private static Method getSingletonOrThreadHasAspect(Class clazz) throws NoSuchMethodException {
        return Aspects14.checkHasAspect(clazz.getDeclaredMethod(HASASPECT, EMPTY_CLASS_ARRAY), clazz);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasAspect(Class clazz) throws NoAspectBoundException {
        try {
            return (Boolean)Aspects14.getSingletonOrThreadHasAspect(clazz).invoke(null, EMPTY_OBJECT_ARRAY);
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasAspect(Class clazz, Class clazz2) throws NoAspectBoundException {
        try {
            return (Boolean)Aspects14.getPerTypeWithinHasAspect(clazz).invoke(null, clazz2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasAspect(Class clazz, Object object) throws NoAspectBoundException {
        try {
            return (Boolean)Aspects14.getPerObjectHasAspect(clazz).invoke(null, object);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

