/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.lang;

import java.io.PrintStream;
import java.io.PrintWriter;

public class SoftException
extends RuntimeException {
    private static final boolean HAVE_JAVA_14;
    Throwable inner;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        boolean bl2 = false;
        try {
            Class.forName("java.nio.Buffer");
            bl2 = true;
        }
        catch (Throwable throwable) {}
        HAVE_JAVA_14 = bl2;
    }

    public SoftException(Throwable throwable) {
        this.inner = throwable;
    }

    @Override
    public Throwable getCause() {
        return this.inner;
    }

    public Throwable getWrappedThrowable() {
        return this.inner;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream printStream) {
        super.printStackTrace(printStream);
        Throwable throwable = this.inner;
        if (!HAVE_JAVA_14 && throwable != null) {
            printStream.print("Caused by: ");
            throwable.printStackTrace(printStream);
        }
    }

    @Override
    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
        Throwable throwable = this.inner;
        if (!HAVE_JAVA_14 && throwable != null) {
            printWriter.print("Caused by: ");
            throwable.printStackTrace(printWriter);
        }
    }
}

