/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.runtime.internal;

import java.util.Stack;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.runtime.CFlow;
import org.aspectj.runtime.internal.CFlowPlusState;
import org.aspectj.runtime.internal.cflowstack.ThreadStack;
import org.aspectj.runtime.internal.cflowstack.ThreadStackFactory;
import org.aspectj.runtime.internal.cflowstack.ThreadStackFactoryImpl;
import org.aspectj.runtime.internal.cflowstack.ThreadStackFactoryImpl11;

public class CFlowStack {
    private static ThreadStackFactory tsFactory;
    private ThreadStack stackProxy = tsFactory.getNewThreadStack();

    static {
        CFlowStack.selectFactoryForVMVersion();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getSystemPropertyWithoutSecurityException(String string2, String string3) {
        try {
            return string2 = System.getProperty(string2, string3);
        }
        catch (SecurityException securityException) {
            return string3;
        }
    }

    private static ThreadStackFactory getThreadLocalStackFactory() {
        return new ThreadStackFactoryImpl();
    }

    private static ThreadStackFactory getThreadLocalStackFactoryFor11() {
        return new ThreadStackFactoryImpl11();
    }

    private Stack getThreadStack() {
        return this.stackProxy.getThreadStack();
    }

    public static String getThreadStackFactoryClassName() {
        return tsFactory.getClass().getName();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void selectFactoryForVMVersion() {
        boolean bl2 = true;
        boolean bl3 = false;
        String string2 = CFlowStack.getSystemPropertyWithoutSecurityException("aspectj.runtime.cflowstack.usethreadlocal", "unspecified");
        if (string2.equals("unspecified")) {
            bl3 = System.getProperty("java.class.version", "0.0").compareTo("46.0") >= 0 ? bl2 : false;
        } else if (string2.equals("yes") || string2.equals("true")) {
            bl3 = true;
        }
        if (bl3) {
            tsFactory = CFlowStack.getThreadLocalStackFactory();
            return;
        }
        tsFactory = CFlowStack.getThreadLocalStackFactoryFor11();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object get(int n2) {
        CFlow cFlow = this.peekCFlow();
        if (cFlow != null) return cFlow.get(n2);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValid() {
        if (this.getThreadStack().isEmpty()) return false;
        return true;
    }

    public Object peek() {
        Stack stack = this.getThreadStack();
        if (stack.isEmpty()) {
            throw new NoAspectBoundException();
        }
        return stack.peek();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CFlow peekCFlow() {
        Stack stack = this.getThreadStack();
        if (!stack.isEmpty()) return (CFlow)stack.peek();
        return null;
    }

    public Object peekInstance() {
        CFlow cFlow = this.peekCFlow();
        if (cFlow != null) {
            return cFlow.getAspect();
        }
        throw new NoAspectBoundException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CFlow peekTopCFlow() {
        Stack stack = this.getThreadStack();
        if (!stack.isEmpty()) return (CFlow)stack.elementAt(0);
        return null;
    }

    public void pop() {
        Stack stack = this.getThreadStack();
        stack.pop();
        if (stack.isEmpty()) {
            this.stackProxy.removeThreadStack();
        }
    }

    public void push(Object object) {
        this.getThreadStack().push(object);
    }

    public void push(Object[] objectArray) {
        this.getThreadStack().push(new CFlowPlusState(objectArray));
    }

    public void pushInstance(Object object) {
        this.getThreadStack().push(new CFlow(object));
    }
}

