/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.runtime.internal;

public final class Conversions {
    private Conversions() {
    }

    public static Object booleanObject(boolean bl2) {
        return new Boolean(bl2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean booleanValue(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Boolean)) throw new ClassCastException(new StringBuffer().append(object.getClass().getName()).append(" can not be converted to boolean").toString());
        return (Boolean)object;
    }

    public static Object byteObject(byte by2) {
        return new Byte(by2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte byteValue(Object object) {
        if (object == null) {
            byte by2 = 0;
            return by2;
        }
        if (!(object instanceof Number)) throw new ClassCastException(new StringBuffer().append(object.getClass().getName()).append(" can not be converted to byte").toString());
        byte by3 = ((Number)object).byteValue();
        return by3;
    }

    public static Object charObject(char c2) {
        return new Character(c2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static char charValue(Object object) {
        if (object == null) {
            char c2 = '\u0000';
            return c2;
        }
        if (!(object instanceof Character)) throw new ClassCastException(new StringBuffer().append(object.getClass().getName()).append(" can not be converted to char").toString());
        char c3 = ((Character)object).charValue();
        return c3;
    }

    public static Object doubleObject(double d2) {
        return new Double(d2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double doubleValue(Object object) {
        if (object == null) {
            return 0.0;
        }
        if (!(object instanceof Number)) throw new ClassCastException(new StringBuffer().append(object.getClass().getName()).append(" can not be converted to double").toString());
        return ((Number)object).doubleValue();
    }

    public static Object floatObject(float f2) {
        return new Float(f2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static float floatValue(Object object) {
        if (object == null) {
            return 0.0f;
        }
        if (!(object instanceof Number)) throw new ClassCastException(new StringBuffer().append(object.getClass().getName()).append(" can not be converted to float").toString());
        return ((Number)object).floatValue();
    }

    public static Object intObject(int n2) {
        return new Integer(n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int intValue(Object object) {
        if (object == null) {
            return 0;
        }
        if (!(object instanceof Number)) throw new ClassCastException(new StringBuffer().append(object.getClass().getName()).append(" can not be converted to int").toString());
        return ((Number)object).intValue();
    }

    public static Object longObject(long l2) {
        return new Long(l2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long longValue(Object object) {
        if (object == null) {
            return 0L;
        }
        if (!(object instanceof Number)) throw new ClassCastException(new StringBuffer().append(object.getClass().getName()).append(" can not be converted to long").toString());
        return ((Number)object).longValue();
    }

    public static Object shortObject(short s2) {
        return new Short(s2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static short shortValue(Object object) {
        if (object == null) {
            short s2 = 0;
            return s2;
        }
        if (!(object instanceof Number)) throw new ClassCastException(new StringBuffer().append(object.getClass().getName()).append(" can not be converted to short").toString());
        short s3 = ((Number)object).shortValue();
        return s3;
    }

    public static Object voidObject() {
        return null;
    }

    public static Object voidValue(Object object) {
        if (object == null) {
            // empty if block
        }
        return object;
    }
}

