/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.runtime.internal.cflowstack;

import java.util.Stack;
import org.aspectj.runtime.internal.cflowstack.ThreadCounter;
import org.aspectj.runtime.internal.cflowstack.ThreadStack;
import org.aspectj.runtime.internal.cflowstack.ThreadStackFactory;

public class ThreadStackFactoryImpl
implements ThreadStackFactory {
    @Override
    public ThreadCounter getNewThreadCounter() {
        return new ThreadCounterImpl(null);
    }

    @Override
    public ThreadStack getNewThreadStack() {
        return new ThreadStackImpl(null);
    }

    private static class ThreadCounterImpl
    extends ThreadLocal
    implements ThreadCounter {
        private ThreadCounterImpl() {
        }

        ThreadCounterImpl(1 var1_1) {
            this();
        }

        @Override
        public void dec() {
            Counter counter = this.getThreadCounter();
            --counter.value;
        }

        public Counter getThreadCounter() {
            return (Counter)this.get();
        }

        @Override
        public void inc() {
            Counter counter = this.getThreadCounter();
            ++counter.value;
        }

        public Object initialValue() {
            return new Counter();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isNotZero() {
            if (this.getThreadCounter().value == 0) return false;
            return true;
        }

        @Override
        public void removeThreadCounter() {
            this.remove();
        }

        static class Counter {
            protected int value = 0;

            Counter() {
            }
        }
    }

    private static class ThreadStackImpl
    extends ThreadLocal
    implements ThreadStack {
        private ThreadStackImpl() {
        }

        ThreadStackImpl(1 var1_1) {
            this();
        }

        @Override
        public Stack getThreadStack() {
            return (Stack)this.get();
        }

        public Object initialValue() {
            return new Stack();
        }

        @Override
        public void removeThreadStack() {
            this.remove();
        }
    }
}

