/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.runtime.internal.cflowstack;

import java.util.Hashtable;
import java.util.Stack;
import org.aspectj.runtime.internal.cflowstack.ThreadStack;

public class ThreadStackImpl11
implements ThreadStack {
    private static final int COLLECT_AT = 20000;
    private static final int MIN_COLLECT_AT = 100;
    private Stack cached_stack;
    private Thread cached_thread;
    private int change_count = 0;
    private Hashtable stacks = new Hashtable();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Stack getThreadStack() {
        synchronized (this) {
            Object object;
            if (Thread.currentThread() == this.cached_thread) return this.cached_stack;
            this.cached_thread = Thread.currentThread();
            this.cached_stack = (Stack)this.stacks.get(this.cached_thread);
            if (this.cached_stack == null) {
                object = new Stack();
                this.cached_stack = object;
                this.stacks.put(this.cached_thread, this.cached_stack);
            }
            ++this.change_count;
            int n2 = Math.max(1, this.stacks.size());
            if (this.change_count <= Math.max(100, 20000 / n2)) return this.cached_stack;
            Stack<Object> stack = new Stack<Object>();
            Object object2 = this.stacks.keys();
            while (object2.hasMoreElements()) {
                object = (Thread)object2.nextElement();
                if (((Thread)object).isAlive()) continue;
                stack.push(object);
            }
            object = stack.elements();
            while (object.hasMoreElements()) {
                object2 = (Thread)object.nextElement();
                this.stacks.remove(object2);
            }
            this.change_count = 0;
            return this.cached_stack;
        }
    }

    @Override
    public void removeThreadStack() {
    }
}

