/*
 * Decompiled with CFR 0.152.
 */
package org.wrtc;

import android.content.Context;
import android.hardware.Camera;
import android.os.Handler;
import android.view.WindowManager;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.wrtc.Camera1Enumerator;
import org.wrtc.Camera1Session$1;
import org.wrtc.Camera1Session$2;
import org.wrtc.Camera1Session$3;
import org.wrtc.CameraEnumerationAndroid;
import org.wrtc.CameraSession;
import org.wrtc.Logging;
import org.wrtc.Metrics;
import org.wrtc.Size;
import org.wrtc.SurfaceTextureHelper;

public class Camera1Session
implements CameraSession {
    private static final int NUMBER_OF_CAPTURE_BUFFERS = 3;
    private static final String TAG = "Camera1Session";
    private static final Metrics.Histogram camera1StartTimeMsHistogram = Metrics.Histogram.createCounts("WebRTC.Android.Camera1.StartTimeMs", 1, 10000, 50);
    private static final Metrics.Histogram camera1StopTimeMsHistogram = Metrics.Histogram.createCounts("WebRTC.Android.Camera1.StopTimeMs", 1, 10000, 50);
    private final Context applicationContext;
    private final Camera camera;
    private final int cameraId;
    private final Handler cameraThreadHandler;
    private final CameraEnumerationAndroid.CaptureFormat captureFormat;
    private final boolean captureToTexture;
    private final long constructionTimeNs;
    private final CameraSession.Events events;
    private boolean firstFrameReported = false;
    private final int framerate;
    private final int height;
    private final Camera.CameraInfo info;
    private SessionState state;
    private final SurfaceTextureHelper surfaceTextureHelper;
    private final int width;

    private Camera1Session(CameraSession.Events events, boolean bl2, Context context, SurfaceTextureHelper surfaceTextureHelper, int n2, int n3, int n4, int n5, Camera camera, Camera.CameraInfo cameraInfo, CameraEnumerationAndroid.CaptureFormat captureFormat, long l2) {
        Logging.d(TAG, "Create new camera1 session on camera " + n2);
        this.cameraThreadHandler = new Handler();
        this.events = events;
        this.captureToTexture = bl2;
        this.applicationContext = context;
        this.surfaceTextureHelper = surfaceTextureHelper;
        this.cameraId = n2;
        this.width = n3;
        this.height = n4;
        this.framerate = n5;
        this.camera = camera;
        this.info = cameraInfo;
        this.captureFormat = captureFormat;
        this.constructionTimeNs = l2;
        this.startCapturing();
    }

    static /* synthetic */ SessionState access$000(Camera1Session camera1Session) {
        return camera1Session.state;
    }

    static /* synthetic */ SessionState access$002(Camera1Session camera1Session, SessionState sessionState) {
        camera1Session.state = sessionState;
        return sessionState;
    }

    static /* synthetic */ void access$100(Camera1Session camera1Session) {
        camera1Session.stopInternal();
    }

    static /* synthetic */ CameraEnumerationAndroid.CaptureFormat access$1000(Camera1Session camera1Session) {
        return camera1Session.captureFormat;
    }

    static /* synthetic */ Camera access$1100(Camera1Session camera1Session) {
        return camera1Session.camera;
    }

    static /* synthetic */ CameraSession.Events access$200(Camera1Session camera1Session) {
        return camera1Session.events;
    }

    static /* synthetic */ void access$300(Camera1Session camera1Session) {
        camera1Session.checkIsOnCameraThread();
    }

    static /* synthetic */ SurfaceTextureHelper access$400(Camera1Session camera1Session) {
        return camera1Session.surfaceTextureHelper;
    }

    static /* synthetic */ boolean access$500(Camera1Session camera1Session) {
        return camera1Session.firstFrameReported;
    }

    static /* synthetic */ boolean access$502(Camera1Session camera1Session, boolean bl2) {
        camera1Session.firstFrameReported = bl2;
        return bl2;
    }

    static /* synthetic */ long access$600(Camera1Session camera1Session) {
        return camera1Session.constructionTimeNs;
    }

    static /* synthetic */ Metrics.Histogram access$700() {
        return camera1StartTimeMsHistogram;
    }

    static /* synthetic */ int access$800(Camera1Session camera1Session) {
        return camera1Session.getFrameOrientation();
    }

    static /* synthetic */ Camera.CameraInfo access$900(Camera1Session camera1Session) {
        return camera1Session.info;
    }

    private void checkIsOnCameraThread() {
        if (Thread.currentThread() != this.cameraThreadHandler.getLooper().getThread()) {
            throw new IllegalStateException("Wrong thread");
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void create(CameraSession.CreateSessionCallback createSessionCallback, CameraSession.Events events, boolean bl2, Context context, SurfaceTextureHelper surfaceTextureHelper, int n2, int n3, int n4, int n5) {
        CameraEnumerationAndroid.CaptureFormat captureFormat;
        Camera.CameraInfo cameraInfo;
        Camera camera;
        long l2;
        block9: {
            l2 = System.nanoTime();
            Logging.d(TAG, "Open camera " + n2);
            events.onCameraOpening();
            camera = Camera.open((int)n2);
            try {
                camera.setPreviewTexture(surfaceTextureHelper.getSurfaceTexture());
            }
            catch (IOException iOException) {
                camera.release();
                createSessionCallback.onFailure(iOException.getMessage());
                return;
            }
            catch (RuntimeException runtimeException) {
                if (camera != null) {
                    camera.release();
                }
                createSessionCallback.onFailure(runtimeException.getMessage());
                return;
            }
            cameraInfo = new Camera.CameraInfo();
            Camera.getCameraInfo((int)n2, (Camera.CameraInfo)cameraInfo);
            Camera.Parameters parameters = camera.getParameters();
            captureFormat = Camera1Session.findClosestCaptureFormat(parameters, n3, n4, n5);
            Camera1Session.updateCameraParameters(camera, parameters, captureFormat, Camera1Session.findClosestPictureSize(parameters, n3, n4), bl2);
            if (!bl2) {
                int n6 = captureFormat.frameSize();
                for (int i2 = 0; i2 < 3; ++i2) {
                    camera.addCallbackBuffer(ByteBuffer.allocateDirect(n6).array());
                }
            }
            break block9;
            catch (RuntimeException runtimeException) {
                createSessionCallback.onFailure(runtimeException.getMessage());
                return;
            }
        }
        camera.setDisplayOrientation(0);
        createSessionCallback.onDone(new Camera1Session(events, bl2, context, surfaceTextureHelper, n2, n3, n4, n5, camera, cameraInfo, captureFormat, l2));
    }

    private static CameraEnumerationAndroid.CaptureFormat findClosestCaptureFormat(Camera.Parameters object, int n2, int n3, int n4) {
        Object object2 = Camera1Enumerator.convertFramerates(object.getSupportedPreviewFpsRange());
        Logging.d(TAG, "Available fps ranges: " + object2);
        object2 = CameraEnumerationAndroid.getClosestSupportedFramerateRange(object2, (int)n4);
        object = CameraEnumerationAndroid.getClosestSupportedSize(Camera1Enumerator.convertSizes(object.getSupportedPreviewSizes()), (int)n2, (int)n3);
        return new CameraEnumerationAndroid.CaptureFormat(object.width, object.height, (CameraEnumerationAndroid.CaptureFormat.FramerateRange)object2);
    }

    private static Size findClosestPictureSize(Camera.Parameters parameters, int n2, int n3) {
        return CameraEnumerationAndroid.getClosestSupportedSize(Camera1Enumerator.convertSizes(parameters.getSupportedPictureSizes()), (int)n2, (int)n3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getDeviceOrientation() {
        switch (((WindowManager)this.applicationContext.getSystemService("window")).getDefaultDisplay().getRotation()) {
            default: {
                return 0;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: 
        }
        return 270;
    }

    private int getFrameOrientation() {
        int n2;
        int n3 = n2 = this.getDeviceOrientation();
        if (this.info.facing == 0) {
            n3 = 360 - n2;
        }
        return (n3 + this.info.orientation) % 360;
    }

    private void listenForBytebufferFrames() {
        this.camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)new Camera1Session$3(this));
    }

    private void listenForTextureFrames() {
        this.surfaceTextureHelper.startListening(new Camera1Session$2(this));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void startCapturing() {
        Logging.d(TAG, "Start capturing");
        this.checkIsOnCameraThread();
        this.state = SessionState.RUNNING;
        this.camera.setErrorCallback((Camera.ErrorCallback)new Camera1Session$1(this));
        if (this.captureToTexture) {
            this.listenForTextureFrames();
        } else {
            this.listenForBytebufferFrames();
        }
        try {
            this.camera.startPreview();
            return;
        }
        catch (RuntimeException runtimeException) {
            this.state = SessionState.STOPPED;
            this.stopInternal();
            this.events.onCameraError(this, runtimeException.getMessage());
            return;
        }
    }

    private void stopInternal() {
        Logging.d(TAG, "Stop internal");
        this.checkIsOnCameraThread();
        this.surfaceTextureHelper.stopListening();
        this.camera.stopPreview();
        this.camera.release();
        this.events.onCameraClosed(this);
        Logging.d(TAG, "Stop done");
    }

    private static void updateCameraParameters(Camera camera, Camera.Parameters parameters, CameraEnumerationAndroid.CaptureFormat captureFormat, Size size, boolean bl2) {
        List list = parameters.getSupportedFocusModes();
        parameters.setPreviewFpsRange(captureFormat.framerate.min, captureFormat.framerate.max);
        parameters.setPreviewSize(captureFormat.width, captureFormat.height);
        parameters.setPictureSize(size.width, size.height);
        if (!bl2) {
            captureFormat.getClass();
            parameters.setPreviewFormat(17);
        }
        if (parameters.isVideoStabilizationSupported()) {
            parameters.setVideoStabilization(true);
        }
        if (list.contains("continuous-video")) {
            parameters.setFocusMode("continuous-video");
        }
        camera.setParameters(parameters);
    }

    @Override
    public void stop() {
        Logging.d(TAG, "Stop camera1 session on camera " + this.cameraId);
        this.checkIsOnCameraThread();
        if (this.state != SessionState.STOPPED) {
            long l2 = System.nanoTime();
            this.state = SessionState.STOPPED;
            this.stopInternal();
            int n2 = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l2);
            camera1StopTimeMsHistogram.addSample(n2);
        }
    }

    private static enum SessionState {
        RUNNING,
        STOPPED;

    }
}

