/*
 * Decompiled with CFR 0.152.
 */
package org.wrtc;

import org.wrtc.CameraVideoCapturer$CameraStatistics$1;
import org.wrtc.SurfaceTextureHelper;
import org.wrtc.VideoCapturer;

public interface CameraVideoCapturer
extends VideoCapturer {
    public void switchCamera(CameraSwitchHandler var1);

    public static interface CameraEventsHandler {
        public void onCameraClosed();

        public void onCameraDisconnected();

        public void onCameraError(String var1);

        public void onCameraFreezed(String var1);

        public void onCameraOpening(String var1);

        public void onFirstFrameAvailable();
    }

    public static class CameraStatistics {
        private static final int CAMERA_FREEZE_REPORT_TIMOUT_MS = 4000;
        private static final int CAMERA_OBSERVER_PERIOD_MS = 2000;
        private static final String TAG = "CameraStatistics";
        private final Runnable cameraObserver = new CameraVideoCapturer$CameraStatistics$1(this);
        private final CameraEventsHandler eventsHandler;
        private int frameCount;
        private int freezePeriodCount;
        private final SurfaceTextureHelper surfaceTextureHelper;

        public CameraStatistics(SurfaceTextureHelper surfaceTextureHelper, CameraEventsHandler cameraEventsHandler) {
            if (surfaceTextureHelper == null) {
                throw new IllegalArgumentException("SurfaceTextureHelper is null");
            }
            this.surfaceTextureHelper = surfaceTextureHelper;
            this.eventsHandler = cameraEventsHandler;
            this.frameCount = 0;
            this.freezePeriodCount = 0;
            surfaceTextureHelper.getHandler().postDelayed(this.cameraObserver, 2000L);
        }

        static /* synthetic */ int access$000(CameraStatistics cameraStatistics) {
            return cameraStatistics.frameCount;
        }

        static /* synthetic */ int access$002(CameraStatistics cameraStatistics, int n2) {
            cameraStatistics.frameCount = n2;
            return n2;
        }

        static /* synthetic */ int access$100(CameraStatistics cameraStatistics) {
            return cameraStatistics.freezePeriodCount;
        }

        static /* synthetic */ int access$102(CameraStatistics cameraStatistics, int n2) {
            cameraStatistics.freezePeriodCount = n2;
            return n2;
        }

        static /* synthetic */ int access$104(CameraStatistics cameraStatistics) {
            int n2;
            cameraStatistics.freezePeriodCount = n2 = cameraStatistics.freezePeriodCount + 1;
            return n2;
        }

        static /* synthetic */ CameraEventsHandler access$200(CameraStatistics cameraStatistics) {
            return cameraStatistics.eventsHandler;
        }

        static /* synthetic */ SurfaceTextureHelper access$300(CameraStatistics cameraStatistics) {
            return cameraStatistics.surfaceTextureHelper;
        }

        private void checkThread() {
            if (Thread.currentThread() != this.surfaceTextureHelper.getHandler().getLooper().getThread()) {
                throw new IllegalStateException("Wrong thread");
            }
        }

        public void addFrame() {
            this.checkThread();
            ++this.frameCount;
        }

        public void release() {
            this.surfaceTextureHelper.getHandler().removeCallbacks(this.cameraObserver);
        }
    }

    public static interface CameraSwitchHandler {
        public void onCameraSwitchDone(boolean var1);

        public void onCameraSwitchError(String var1);
    }
}

