/*
 * Decompiled with CFR 0.152.
 */
package org.wrtc;

import android.media.MediaCodec;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.os.SystemClock;
import android.view.Surface;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.wrtc.Logging;
import org.wrtc.MediaCodecVideoDecoder$1;
import org.wrtc.MediaCodecVideoEncoder;
import org.wrtc.SurfaceTextureHelper;
import org.wrtc.ThreadUtils;

public class MediaCodecVideoDecoder {
    private static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    private static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar16m4ka = 2141391874;
    private static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar32m4ka = 2141391873;
    private static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar64x32Tile2m8ka = 2141391875;
    private static final int DEQUEUE_INPUT_TIMEOUT = 500000;
    private static final String H264_MIME_TYPE = "video/avc";
    private static final long MAX_DECODE_TIME_MS = 200L;
    private static final int MAX_QUEUED_OUTPUTBUFFERS = 3;
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final String TAG = "MediaCodecVideoDecoder";
    private static final String VP8_MIME_TYPE = "video/x-vnd.on2.vp8";
    private static final String VP9_MIME_TYPE = "video/x-vnd.on2.vp9";
    private static int codecErrors;
    private static MediaCodecVideoDecoderErrorCallback errorCallback;
    private static Set<String> hwDecoderDisabledTypes;
    private static MediaCodecVideoDecoder runningInstance;
    private static final List<Integer> supportedColorList;
    private static final String[] supportedH264HwCodecPrefixes;
    private static final String[] supportedVp8HwCodecPrefixes;
    private static final String[] supportedVp9HwCodecPrefixes;
    private int colorFormat;
    private final Queue<TimeStamps> decodeStartTimeMs = new LinkedList<TimeStamps>();
    private final Queue<DecodedOutputBuffer> dequeuedSurfaceOutputBuffers = new LinkedList<DecodedOutputBuffer>();
    private int droppedFrames;
    private boolean hasDecodedFirstFrame;
    private int height;
    private ByteBuffer[] inputBuffers;
    private MediaCodec mediaCodec;
    private Thread mediaCodecThread;
    private ByteBuffer[] outputBuffers;
    private int sliceHeight;
    private int stride;
    private Surface surface = null;
    private TextureListener textureListener;
    private boolean useSurface;
    private int width;

    static {
        runningInstance = null;
        errorCallback = null;
        codecErrors = 0;
        hwDecoderDisabledTypes = new HashSet<String>();
        supportedVp8HwCodecPrefixes = new String[]{"OMX.qcom.", "OMX.Nvidia.", "OMX.Exynos.", "OMX.Intel."};
        supportedVp9HwCodecPrefixes = new String[]{"OMX.qcom.", "OMX.Exynos."};
        supportedH264HwCodecPrefixes = new String[]{"OMX.qcom.", "OMX.Intel.", "OMX.Exynos."};
        supportedColorList = Arrays.asList(19, 21, 2141391872, 2141391873, 2141391874, 2141391875, 2141391876);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void MaybeRenderDecodedTextureBuffer() {
        if (this.dequeuedSurfaceOutputBuffers.isEmpty() || this.textureListener.isWaitingForTexture()) {
            return;
        }
        DecodedOutputBuffer decodedOutputBuffer = this.dequeuedSurfaceOutputBuffers.remove();
        this.textureListener.addBufferToRender(decodedOutputBuffer);
        this.mediaCodec.releaseOutputBuffer(decodedOutputBuffer.index, true);
    }

    static /* synthetic */ MediaCodec access$000(MediaCodecVideoDecoder mediaCodecVideoDecoder) {
        return mediaCodecVideoDecoder.mediaCodec;
    }

    private void checkOnMediaCodecThread() throws IllegalStateException {
        if (this.mediaCodecThread.getId() != Thread.currentThread().getId()) {
            throw new IllegalStateException("MediaCodecVideoDecoder previously operated on " + this.mediaCodecThread + " but is now called on " + Thread.currentThread());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int dequeueInputBuffer() {
        this.checkOnMediaCodecThread();
        try {
            return this.mediaCodec.dequeueInputBuffer(500000L);
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "dequeueIntputBuffer failed", illegalStateException);
            return -2;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DecodedOutputBuffer dequeueOutputBuffer(int n2) {
        void var5_5;
        long l2 = 200L;
        Object var4_3 = null;
        this.checkOnMediaCodecThread();
        if (this.decodeStartTimeMs.isEmpty()) {
            Object var5_4 = var4_3;
            return var5_5;
        }
        MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
        block6: while (true) {
            int n3 = this.mediaCodec.dequeueOutputBuffer(bufferInfo, TimeUnit.MILLISECONDS.toMicros(n2));
            Object var5_7 = var4_3;
            switch (n3) {
                case -1: {
                    return var5_5;
                }
                default: {
                    this.hasDecodedFirstFrame = true;
                    TimeStamps timeStamps = this.decodeStartTimeMs.remove();
                    long l3 = SystemClock.elapsedRealtime() - timeStamps.decodeStartTimeMs;
                    if (l3 > 200L) {
                        Logging.e(TAG, "Very high decode time: " + l3 + "ms. Q size: " + this.decodeStartTimeMs.size() + ". Might be caused by resuming H264 decoding after a pause.");
                        l3 = l2;
                    }
                    DecodedOutputBuffer decodedOutputBuffer = new DecodedOutputBuffer(n3, bufferInfo.offset, bufferInfo.size, TimeUnit.MICROSECONDS.toMillis(bufferInfo.presentationTimeUs), timeStamps.timeStampMs, timeStamps.ntpTimeStampMs, l3, SystemClock.elapsedRealtime());
                    return var5_5;
                }
                case -3: {
                    this.outputBuffers = this.mediaCodec.getOutputBuffers();
                    Logging.d(TAG, "Decoder output buffers changed: " + this.outputBuffers.length);
                    if (!this.hasDecodedFirstFrame) continue block6;
                    throw new RuntimeException("Unexpected output buffer change event.");
                }
                case -2: 
            }
            MediaFormat mediaFormat = this.mediaCodec.getOutputFormat();
            Logging.d(TAG, "Decoder format changed: " + mediaFormat.toString());
            int n4 = mediaFormat.getInteger("width");
            n3 = mediaFormat.getInteger("height");
            if (this.hasDecodedFirstFrame && (n4 != this.width || n3 != this.height)) {
                throw new RuntimeException("Unexpected size change. Configured " + this.width + "*" + this.height + ". New " + n4 + "*" + n3);
            }
            this.width = mediaFormat.getInteger("width");
            this.height = mediaFormat.getInteger("height");
            if (!this.useSurface && mediaFormat.containsKey("color-format")) {
                this.colorFormat = mediaFormat.getInteger("color-format");
                Logging.d(TAG, "Color: 0x" + Integer.toHexString(this.colorFormat));
                if (!supportedColorList.contains(this.colorFormat)) {
                    throw new IllegalStateException("Non supported color format: " + this.colorFormat);
                }
            }
            if (mediaFormat.containsKey("stride")) {
                this.stride = mediaFormat.getInteger("stride");
            }
            if (mediaFormat.containsKey("slice-height")) {
                this.sliceHeight = mediaFormat.getInteger("slice-height");
            }
            Logging.d(TAG, "Frame stride and slice height: " + this.stride + " x " + this.sliceHeight);
            this.stride = Math.max(this.width, this.stride);
            this.sliceHeight = Math.max(this.height, this.sliceHeight);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private DecodedTextureBuffer dequeueTextureBuffer(int n2) {
        this.checkOnMediaCodecThread();
        if (!this.useSurface) {
            throw new IllegalStateException("dequeueTexture() called for byte buffer decoding.");
        }
        Object object = this.dequeueOutputBuffer(n2);
        if (object != null) {
            this.dequeuedSurfaceOutputBuffers.add((DecodedOutputBuffer)object);
        }
        this.MaybeRenderDecodedTextureBuffer();
        object = this.textureListener.dequeueTextureBuffer(n2);
        if (object != null) {
            this.MaybeRenderDecodedTextureBuffer();
            return object;
        }
        if (this.dequeuedSurfaceOutputBuffers.size() < Math.min(3, this.outputBuffers.length)) {
            if (n2 <= 0) return null;
            if (this.dequeuedSurfaceOutputBuffers.isEmpty()) return null;
        }
        ++this.droppedFrames;
        object = this.dequeuedSurfaceOutputBuffers.remove();
        if (n2 > 0) {
            Logging.w(TAG, "Draining decoder. Dropping frame with TS: " + ((DecodedOutputBuffer)object).presentationTimeStampMs + ". Total number of dropped frames: " + this.droppedFrames);
        } else {
            Logging.w(TAG, "Too many output buffers " + this.dequeuedSurfaceOutputBuffers.size() + ". Dropping frame with TS: " + ((DecodedOutputBuffer)object).presentationTimeStampMs + ". Total number of dropped frames: " + this.droppedFrames);
        }
        this.mediaCodec.releaseOutputBuffer(((DecodedOutputBuffer)object).index, false);
        return new DecodedTextureBuffer(0, null, ((DecodedOutputBuffer)object).presentationTimeStampMs, ((DecodedOutputBuffer)object).timeStampMs, ((DecodedOutputBuffer)object).ntpTimeStampMs, ((DecodedOutputBuffer)object).decodeTimeMs, SystemClock.elapsedRealtime() - ((DecodedOutputBuffer)object).endDecodeTimeMs);
    }

    public static void disableH264HwCodec() {
        Logging.w(TAG, "H.264 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(H264_MIME_TYPE);
    }

    public static void disableVp8HwCodec() {
        Logging.w(TAG, "VP8 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(VP8_MIME_TYPE);
    }

    public static void disableVp9HwCodec() {
        Logging.w(TAG, "VP9 decoding is disabled by application.");
        hwDecoderDisabledTypes.add(VP9_MIME_TYPE);
    }

    /*
     * Unable to fully structure code
     */
    private static DecoderProperties findDecoder(String var0, String[] var1_1) {
        block18: {
            block17: {
                if (Build.VERSION.SDK_INT < 19) {
                    var0 = null;
lbl3:
                    // 3 sources

                    return var0;
                }
                Logging.d("MediaCodecVideoDecoder", "Trying to find HW decoder for mime " + (String)var0);
                block5: for (var2_2 = 0; var2_2 < MediaCodecList.getCodecCount(); ++var2_2) {
                    try {
                        var3_3 = MediaCodecList.getCodecInfoAt((int)var2_2);
                    }
                    catch (IllegalArgumentException var4_5) {
                        Logging.e("MediaCodecVideoDecoder", "Cannot retrieve decoder codec info", var4_5);
                        var3_3 = null;
                    }
                    while (var3_3 == null || var3_3.isEncoder()) lbl-1000:
                    // 5 sources

                    {
                        continue block5;
                    }
                    var4_4 = var3_3.getSupportedTypes();
                    var5_7 = ((String[])var4_4).length;
                    for (var6_8 = 0; var6_8 < var5_7; ++var6_8) {
                        block16: {
                            if (!var4_4[var6_8].equals(var0)) continue;
                            var4_4 = var3_3.getName();
lbl23:
                            // 2 sources

                            block9: while (true) {
                                if (var4_4 == null) ** GOTO lbl-1000
                                Logging.d("MediaCodecVideoDecoder", "Found candidate decoder " + (String)var4_4);
                                var5_7 = var1_1.length;
                                var6_8 = 0;
lbl28:
                                // 2 sources

                                while (var6_8 < var5_7) {
                                    if (!var4_4.startsWith(var1_1[var6_8])) break block9;
                                    var6_8 = 1;
lbl31:
                                    // 2 sources

                                    while (true) {
                                        if (var6_8 == 0) ** GOTO lbl-1000
                                        var3_3 = var3_3.getCapabilitiesForType((String)var0);
                                        for (int var8_10 : var3_3.colorFormats) {
                                            Logging.v("MediaCodecVideoDecoder", "   Color: 0x" + Integer.toHexString(var8_10));
                                        }
                                        break block16;
                                        break;
                                    }
                                }
                                break block17;
                                break;
                            }
                            ++var6_8;
                            ** GOTO lbl28
                            catch (IllegalArgumentException var4_6) {
                                Logging.e("MediaCodecVideoDecoder", "Cannot retrieve decoder capabilities", var4_6);
                                ** GOTO lbl-1000
                            }
                        }
                        var9_11 = MediaCodecVideoDecoder.supportedColorList.iterator();
                        block13: while (true) {
                            if (var9_11.hasNext()) ** break;
                            ** continue;
                            var8_10 = var9_11.next();
                            var7_9 = var3_3.colorFormats;
                            var5_7 = var7_9.length;
                            var6_8 = 0;
                            while (true) {
                                block20: {
                                    if (var6_8 >= var5_7) continue block13;
                                    var10_12 = var7_9[var6_8];
                                    if (var10_12 != var8_10) break block20;
                                    Logging.d("MediaCodecVideoDecoder", "Found target decoder " + (String)var4_4 + ". Color: 0x" + Integer.toHexString(var10_12));
                                    var0 = new DecoderProperties((String)var4_4, var10_12);
                                    ** GOTO lbl3
                                }
                                ++var6_8;
                            }
                            break;
                        }
                    }
                    break block18;
                }
                Logging.d("MediaCodecVideoDecoder", "No HW decoder found for mime " + (String)var0);
                var0 = null;
                ** while (true)
            }
            var6_8 = 0;
            ** while (true)
        }
        var4_4 = null;
        ** while (true)
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean initDecode(VideoCodecType object, int n2, int n3, SurfaceTextureHelper object2) {
        void var8_10;
        DecoderProperties decoderProperties;
        String string2;
        boolean bl2 = false;
        if (this.mediaCodecThread != null) {
            throw new RuntimeException("initDecode: Forgot to release()?");
        }
        boolean bl3 = object2 != null;
        this.useSurface = bl3;
        if (object == VideoCodecType.VIDEO_CODEC_VP8) {
            string2 = VP8_MIME_TYPE;
            String[] stringArray = supportedVp8HwCodecPrefixes;
        } else if (object == VideoCodecType.VIDEO_CODEC_VP9) {
            string2 = VP9_MIME_TYPE;
            String[] stringArray = supportedVp9HwCodecPrefixes;
        } else {
            if (object != VideoCodecType.VIDEO_CODEC_H264) throw new RuntimeException("initDecode: Non-supported codec " + object);
            string2 = H264_MIME_TYPE;
            String[] stringArray = supportedH264HwCodecPrefixes;
        }
        if ((decoderProperties = MediaCodecVideoDecoder.findDecoder(string2, (String[])var8_10)) == null) {
            throw new RuntimeException("Cannot find HW decoder for " + object);
        }
        Logging.d(TAG, "Java initDecode: " + object + " : " + n2 + " x " + n3 + ". Color: 0x" + Integer.toHexString(decoderProperties.colorFormat) + ". Use Surface: " + this.useSurface);
        runningInstance = this;
        this.mediaCodecThread = Thread.currentThread();
        try {
            this.width = n2;
            this.height = n3;
            this.stride = n2;
            this.sliceHeight = n3;
            if (this.useSurface) {
                this.textureListener = object = new TextureListener((SurfaceTextureHelper)object2);
                object = new Surface(((SurfaceTextureHelper)object2).getSurfaceTexture());
                this.surface = object;
            }
            object = MediaFormat.createVideoFormat((String)string2, (int)n2, (int)n3);
            if (!this.useSurface) {
                object.setInteger("color-format", decoderProperties.colorFormat);
            }
            object2 = new StringBuilder();
            Logging.d(TAG, ((StringBuilder)object2).append("  Format: ").append(object).toString());
            this.mediaCodec = MediaCodecVideoEncoder.createByCodecName(decoderProperties.codecName);
            if (this.mediaCodec == null) {
                Logging.e(TAG, "Can not create media decoder");
                return bl2;
            }
            this.mediaCodec.configure((MediaFormat)object, this.surface, null, 0);
            this.mediaCodec.start();
            this.colorFormat = decoderProperties.colorFormat;
            this.outputBuffers = this.mediaCodec.getOutputBuffers();
            this.inputBuffers = this.mediaCodec.getInputBuffers();
            this.decodeStartTimeMs.clear();
            this.hasDecodedFirstFrame = false;
            this.dequeuedSurfaceOutputBuffers.clear();
            this.droppedFrames = 0;
            object = new StringBuilder();
            Logging.d(TAG, ((StringBuilder)object).append("Input buffers: ").append(this.inputBuffers.length).append(". Output buffers: ").append(this.outputBuffers.length).toString());
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "initDecode failed", illegalStateException);
            return bl2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isH264HwSupported() {
        if (hwDecoderDisabledTypes.contains(H264_MIME_TYPE)) return false;
        if (MediaCodecVideoDecoder.findDecoder(H264_MIME_TYPE, supportedH264HwCodecPrefixes) == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isVp8HwSupported() {
        if (hwDecoderDisabledTypes.contains(VP8_MIME_TYPE)) return false;
        if (MediaCodecVideoDecoder.findDecoder(VP8_MIME_TYPE, supportedVp8HwCodecPrefixes) == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isVp9HwSupported() {
        if (hwDecoderDisabledTypes.contains(VP9_MIME_TYPE)) return false;
        if (MediaCodecVideoDecoder.findDecoder(VP9_MIME_TYPE, supportedVp9HwCodecPrefixes) == null) return false;
        return true;
    }

    public static void printStackTrace() {
        StackTraceElement[] stackTraceElementArray;
        if (runningInstance != null && MediaCodecVideoDecoder.runningInstance.mediaCodecThread != null && (stackTraceElementArray = MediaCodecVideoDecoder.runningInstance.mediaCodecThread.getStackTrace()).length > 0) {
            Logging.d(TAG, "MediaCodecVideoDecoder stacks trace:");
            int n2 = stackTraceElementArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Logging.d(TAG, stackTraceElementArray[i2].toString());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean queueInputBuffer(int n2, int n3, long l2, long l3, long l4) {
        this.checkOnMediaCodecThread();
        try {
            this.inputBuffers[n2].position(0);
            this.inputBuffers[n2].limit(n3);
            Queue<TimeStamps> queue = this.decodeStartTimeMs;
            TimeStamps timeStamps = new TimeStamps(SystemClock.elapsedRealtime(), l3, l4);
            queue.add(timeStamps);
            this.mediaCodec.queueInputBuffer(n2, 0, n3, l2, 0);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Logging.e(TAG, "decode failed", illegalStateException);
            return false;
        }
    }

    private void release() {
        Logging.d(TAG, "Java releaseDecoder. Total number of dropped frames: " + this.droppedFrames);
        this.checkOnMediaCodecThread();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        new Thread(new MediaCodecVideoDecoder$1(this, countDownLatch)).start();
        if (!ThreadUtils.awaitUninterruptibly(countDownLatch, 5000L)) {
            Logging.e(TAG, "Media decoder release timeout");
            ++codecErrors;
            if (errorCallback != null) {
                Logging.e(TAG, "Invoke codec error callback. Errors: " + codecErrors);
                errorCallback.onMediaCodecVideoDecoderCriticalError(codecErrors);
            }
        }
        this.mediaCodec = null;
        this.mediaCodecThread = null;
        runningInstance = null;
        if (this.useSurface) {
            this.surface.release();
            this.surface = null;
            this.textureListener.release();
        }
        Logging.d(TAG, "Java releaseDecoder done");
    }

    private void reset(int n2, int n3) {
        if (this.mediaCodecThread == null || this.mediaCodec == null) {
            throw new RuntimeException("Incorrect reset call for non-initialized decoder.");
        }
        Logging.d(TAG, "Java reset: " + n2 + " x " + n3);
        this.mediaCodec.flush();
        this.width = n2;
        this.height = n3;
        this.decodeStartTimeMs.clear();
        this.dequeuedSurfaceOutputBuffers.clear();
        this.hasDecodedFirstFrame = false;
        this.droppedFrames = 0;
    }

    private void returnDecodedOutputBuffer(int n2) throws IllegalStateException, MediaCodec.CodecException {
        this.checkOnMediaCodecThread();
        if (this.useSurface) {
            throw new IllegalStateException("returnDecodedOutputBuffer() called for surface decoding.");
        }
        this.mediaCodec.releaseOutputBuffer(n2, false);
    }

    public static void setErrorCallback(MediaCodecVideoDecoderErrorCallback mediaCodecVideoDecoderErrorCallback) {
        Logging.d(TAG, "Set error callback");
        errorCallback = mediaCodecVideoDecoderErrorCallback;
    }

    private static class DecodedOutputBuffer {
        private final long decodeTimeMs;
        private final long endDecodeTimeMs;
        private final int index;
        private final long ntpTimeStampMs;
        private final int offset;
        private final long presentationTimeStampMs;
        private final int size;
        private final long timeStampMs;

        public DecodedOutputBuffer(int n2, int n3, int n4, long l2, long l3, long l4, long l5, long l6) {
            this.index = n2;
            this.offset = n3;
            this.size = n4;
            this.presentationTimeStampMs = l2;
            this.timeStampMs = l3;
            this.ntpTimeStampMs = l4;
            this.decodeTimeMs = l5;
            this.endDecodeTimeMs = l6;
        }
    }

    private static class DecodedTextureBuffer {
        private final long decodeTimeMs;
        private final long frameDelayMs;
        private final long ntpTimeStampMs;
        private final long presentationTimeStampMs;
        private final int textureID;
        private final long timeStampMs;
        private final float[] transformMatrix;

        public DecodedTextureBuffer(int n2, float[] fArray, long l2, long l3, long l4, long l5, long l6) {
            this.textureID = n2;
            this.transformMatrix = fArray;
            this.presentationTimeStampMs = l2;
            this.timeStampMs = l3;
            this.ntpTimeStampMs = l4;
            this.decodeTimeMs = l5;
            this.frameDelayMs = l6;
        }
    }

    private static class DecoderProperties {
        public final String codecName;
        public final int colorFormat;

        public DecoderProperties(String string2, int n2) {
            this.codecName = string2;
            this.colorFormat = n2;
        }
    }

    public static interface MediaCodecVideoDecoderErrorCallback {
        public void onMediaCodecVideoDecoderCriticalError(int var1);
    }

    private static class TextureListener
    implements SurfaceTextureHelper.OnTextureFrameAvailableListener {
        private DecodedOutputBuffer bufferToRender;
        private final Object newFrameLock = new Object();
        private DecodedTextureBuffer renderedBuffer;
        private final SurfaceTextureHelper surfaceTextureHelper;

        public TextureListener(SurfaceTextureHelper surfaceTextureHelper) {
            this.surfaceTextureHelper = surfaceTextureHelper;
            surfaceTextureHelper.startListening(this);
        }

        public void addBufferToRender(DecodedOutputBuffer decodedOutputBuffer) {
            if (this.bufferToRender != null) {
                Logging.e(MediaCodecVideoDecoder.TAG, "Unexpected addBufferToRender() called while waiting for a texture.");
                throw new IllegalStateException("Waiting for a texture.");
            }
            this.bufferToRender = decodedOutputBuffer;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public DecodedTextureBuffer dequeueTextureBuffer(int n2) {
            Object object = this.newFrameLock;
            synchronized (object) {
                boolean bl2;
                if (this.renderedBuffer == null && n2 > 0 && (bl2 = this.isWaitingForTexture())) {
                    try {
                        this.newFrameLock.wait(n2);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                DecodedTextureBuffer decodedTextureBuffer = this.renderedBuffer;
                this.renderedBuffer = null;
                return decodedTextureBuffer;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean isWaitingForTexture() {
            Object object = this.newFrameLock;
            synchronized (object) {
                if (this.bufferToRender == null) return false;
                return true;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onTextureFrameAvailable(int n2, float[] object, long l2) {
            Object object2 = this.newFrameLock;
            synchronized (object2) {
                DecodedTextureBuffer decodedTextureBuffer;
                if (this.renderedBuffer != null) {
                    Logging.e(MediaCodecVideoDecoder.TAG, "Unexpected onTextureFrameAvailable() called while already holding a texture.");
                    object = new IllegalStateException;
                    object("Already holding a texture.");
                    throw object;
                }
                this.renderedBuffer = decodedTextureBuffer = new DecodedTextureBuffer(n2, (float[])object, this.bufferToRender.presentationTimeStampMs, this.bufferToRender.timeStampMs, this.bufferToRender.ntpTimeStampMs, this.bufferToRender.decodeTimeMs, SystemClock.elapsedRealtime() - this.bufferToRender.endDecodeTimeMs);
                this.bufferToRender = null;
                this.newFrameLock.notifyAll();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void release() {
            this.surfaceTextureHelper.stopListening();
            Object object = this.newFrameLock;
            synchronized (object) {
                if (this.renderedBuffer != null) {
                    this.surfaceTextureHelper.returnTextureFrame();
                    this.renderedBuffer = null;
                }
                return;
            }
        }
    }

    private static class TimeStamps {
        private final long decodeStartTimeMs;
        private final long ntpTimeStampMs;
        private final long timeStampMs;

        public TimeStamps(long l2, long l3, long l4) {
            this.decodeStartTimeMs = l2;
            this.timeStampMs = l3;
            this.ntpTimeStampMs = l4;
        }
    }

    public static enum VideoCodecType {
        VIDEO_CODEC_VP8,
        VIDEO_CODEC_VP9,
        VIDEO_CODEC_H264;

    }
}

