/*
 * Decompiled with CFR 0.152.
 */
package org.wrtc;

import java.util.LinkedList;
import java.util.List;

public class MediaConstraints {
    public final List<KeyValuePair> mandatory = new LinkedList<KeyValuePair>();
    public final List<KeyValuePair> optional = new LinkedList<KeyValuePair>();

    private static String stringifyKeyValuePairList(List<KeyValuePair> object) {
        StringBuilder stringBuilder = new StringBuilder("[");
        object = object.iterator();
        while (object.hasNext()) {
            KeyValuePair keyValuePair = (KeyValuePair)object.next();
            if (stringBuilder.length() > 1) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(keyValuePair.toString());
        }
        return stringBuilder.append("]").toString();
    }

    public String toString() {
        return "mandatory: " + MediaConstraints.stringifyKeyValuePairList(this.mandatory) + ", optional: " + MediaConstraints.stringifyKeyValuePairList(this.optional);
    }

    public static class KeyValuePair {
        private final String key;
        private final String value;

        public KeyValuePair(String string2, String string3) {
            this.key = string2;
            this.value = string3;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            boolean bl2 = true;
            if (this == object) {
                return bl2;
            }
            if (object == null) return false;
            if (this.getClass() != object.getClass()) {
                return false;
            }
            object = (KeyValuePair)object;
            if (!this.key.equals(((KeyValuePair)object).key)) return false;
            if (this.value.equals(((KeyValuePair)object).value)) return bl2;
            return false;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.key.hashCode() + this.value.hashCode();
        }

        public String toString() {
            return this.key + ": " + this.value;
        }
    }
}

