/*
 * Decompiled with CFR 0.152.
 */
package org.wrtc;

import java.util.LinkedList;
import org.wrtc.AudioTrack;
import org.wrtc.MediaStreamTrack;
import org.wrtc.VideoTrack;

public class MediaStream {
    public final LinkedList<AudioTrack> audioTracks = new LinkedList();
    final long nativeStream;
    public final LinkedList<VideoTrack> preservedVideoTracks;
    public final LinkedList<VideoTrack> videoTracks = new LinkedList();

    public MediaStream(long l2) {
        this.preservedVideoTracks = new LinkedList();
        this.nativeStream = l2;
    }

    private static native void free(long var0);

    private static native boolean nativeAddAudioTrack(long var0, long var2);

    private static native boolean nativeAddVideoTrack(long var0, long var2);

    private static native String nativeLabel(long var0);

    private static native boolean nativeRemoveAudioTrack(long var0, long var2);

    private static native boolean nativeRemoveVideoTrack(long var0, long var2);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean addPreservedTrack(VideoTrack videoTrack) {
        if (!MediaStream.nativeAddVideoTrack(this.nativeStream, videoTrack.nativeTrack)) return false;
        this.preservedVideoTracks.add(videoTrack);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean addTrack(AudioTrack audioTrack) {
        if (!MediaStream.nativeAddAudioTrack(this.nativeStream, audioTrack.nativeTrack)) return false;
        this.audioTracks.add(audioTrack);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean addTrack(VideoTrack videoTrack) {
        if (!MediaStream.nativeAddVideoTrack(this.nativeStream, videoTrack.nativeTrack)) return false;
        this.videoTracks.add(videoTrack);
        return true;
    }

    public void dispose() {
        MediaStreamTrack mediaStreamTrack;
        while (!this.audioTracks.isEmpty()) {
            mediaStreamTrack = this.audioTracks.getFirst();
            this.removeTrack((AudioTrack)mediaStreamTrack);
            mediaStreamTrack.dispose();
        }
        while (!this.videoTracks.isEmpty()) {
            mediaStreamTrack = this.videoTracks.getFirst();
            this.removeTrack((VideoTrack)mediaStreamTrack);
            ((VideoTrack)mediaStreamTrack).dispose();
        }
        while (!this.preservedVideoTracks.isEmpty()) {
            this.removeTrack(this.preservedVideoTracks.getFirst());
        }
        MediaStream.free(this.nativeStream);
    }

    public String label() {
        return MediaStream.nativeLabel(this.nativeStream);
    }

    public boolean removeTrack(AudioTrack audioTrack) {
        this.audioTracks.remove(audioTrack);
        return MediaStream.nativeRemoveAudioTrack(this.nativeStream, audioTrack.nativeTrack);
    }

    public boolean removeTrack(VideoTrack videoTrack) {
        this.videoTracks.remove(videoTrack);
        this.preservedVideoTracks.remove(videoTrack);
        return MediaStream.nativeRemoveVideoTrack(this.nativeStream, videoTrack.nativeTrack);
    }

    public String toString() {
        return "[" + this.label() + ":A=" + this.audioTracks.size() + ":V=" + this.videoTracks.size() + "]";
    }
}

