/*
 * Decompiled with CFR 0.152.
 */
package org.wrtc;

import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.SystemClock;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.concurrent.TimeUnit;
import org.wrtc.EglBase;
import org.wrtc.GlShader;
import org.wrtc.GlUtil;
import org.wrtc.Logging;
import org.wrtc.RendererCommon;
import org.wrtc.SurfaceTextureHelper$1;
import org.wrtc.SurfaceTextureHelper$2;
import org.wrtc.SurfaceTextureHelper$3;
import org.wrtc.SurfaceTextureHelper$4;
import org.wrtc.SurfaceTextureHelper$5;
import org.wrtc.SurfaceTextureHelper$6;
import org.wrtc.ThreadUtils;

class SurfaceTextureHelper {
    private static final String TAG = "SurfaceTextureHelper";
    private final EglBase eglBase;
    private final Handler handler;
    private boolean hasPendingTexture = false;
    private boolean isQuitting = false;
    private volatile boolean isTextureInUse = false;
    private OnTextureFrameAvailableListener listener;
    private final int oesTextureId;
    private OnTextureFrameAvailableListener pendingListener;
    final Runnable setListenerRunnable = new SurfaceTextureHelper$2(this);
    private final SurfaceTexture surfaceTexture;
    private YuvConverter yuvConverter;

    private SurfaceTextureHelper(EglBase.Context context, Handler handler) {
        if (handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("SurfaceTextureHelper must be created on the handler thread");
        }
        this.handler = handler;
        this.eglBase = EglBase.create(context, EglBase.CONFIG_PIXEL_BUFFER);
        try {
            this.eglBase.createDummyPbufferSurface();
            this.eglBase.makeCurrent();
        }
        catch (RuntimeException runtimeException) {
            this.eglBase.release();
            handler.getLooper().quit();
            throw runtimeException;
        }
        this.oesTextureId = GlUtil.generateTexture(36197);
        this.surfaceTexture = new SurfaceTexture(this.oesTextureId);
        this.surfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)new SurfaceTextureHelper$3(this));
    }

    /* synthetic */ SurfaceTextureHelper(EglBase.Context context, Handler handler, SurfaceTextureHelper$1 surfaceTextureHelper$1) {
        this(context, handler);
    }

    static /* synthetic */ OnTextureFrameAvailableListener access$100(SurfaceTextureHelper surfaceTextureHelper) {
        return surfaceTextureHelper.pendingListener;
    }

    static /* synthetic */ OnTextureFrameAvailableListener access$102(SurfaceTextureHelper surfaceTextureHelper, OnTextureFrameAvailableListener onTextureFrameAvailableListener) {
        surfaceTextureHelper.pendingListener = onTextureFrameAvailableListener;
        return onTextureFrameAvailableListener;
    }

    static /* synthetic */ OnTextureFrameAvailableListener access$202(SurfaceTextureHelper surfaceTextureHelper, OnTextureFrameAvailableListener onTextureFrameAvailableListener) {
        surfaceTextureHelper.listener = onTextureFrameAvailableListener;
        return onTextureFrameAvailableListener;
    }

    static /* synthetic */ boolean access$300(SurfaceTextureHelper surfaceTextureHelper) {
        return surfaceTextureHelper.hasPendingTexture;
    }

    static /* synthetic */ boolean access$302(SurfaceTextureHelper surfaceTextureHelper, boolean bl2) {
        surfaceTextureHelper.hasPendingTexture = bl2;
        return bl2;
    }

    static /* synthetic */ void access$400(SurfaceTextureHelper surfaceTextureHelper) {
        surfaceTextureHelper.updateTexImage();
    }

    static /* synthetic */ void access$500(SurfaceTextureHelper surfaceTextureHelper) {
        surfaceTextureHelper.tryDeliverTextureFrame();
    }

    static /* synthetic */ boolean access$600(SurfaceTextureHelper surfaceTextureHelper) {
        return surfaceTextureHelper.isTextureInUse;
    }

    static /* synthetic */ boolean access$602(SurfaceTextureHelper surfaceTextureHelper, boolean bl2) {
        surfaceTextureHelper.isTextureInUse = bl2;
        return bl2;
    }

    static /* synthetic */ boolean access$700(SurfaceTextureHelper surfaceTextureHelper) {
        return surfaceTextureHelper.isQuitting;
    }

    static /* synthetic */ boolean access$702(SurfaceTextureHelper surfaceTextureHelper, boolean bl2) {
        surfaceTextureHelper.isQuitting = bl2;
        return bl2;
    }

    static /* synthetic */ void access$800(SurfaceTextureHelper surfaceTextureHelper) {
        surfaceTextureHelper.release();
    }

    public static SurfaceTextureHelper create(String string2, EglBase.Context context) {
        HandlerThread handlerThread = new HandlerThread(string2);
        handlerThread.start();
        handlerThread = new Handler(handlerThread.getLooper());
        return ThreadUtils.invokeAtFrontUninterruptibly((Handler)handlerThread, new SurfaceTextureHelper$1(context, (Handler)handlerThread, string2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private YuvConverter getYuvConverter() {
        if (this.yuvConverter != null) {
            return this.yuvConverter;
        }
        synchronized (this) {
            YuvConverter yuvConverter;
            if (this.yuvConverter != null) return this.yuvConverter;
            this.yuvConverter = yuvConverter = new YuvConverter(this.eglBase.getEglBaseContext());
            return this.yuvConverter;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void release() {
        if (this.handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Wrong thread.");
        }
        if (this.isTextureInUse || !this.isQuitting) {
            throw new IllegalStateException("Unexpected release.");
        }
        synchronized (this) {
            if (this.yuvConverter != null) {
                this.yuvConverter.release();
            }
        }
        GLES20.glDeleteTextures((int)1, (int[])new int[]{this.oesTextureId}, (int)0);
        this.surfaceTexture.release();
        this.eglBase.release();
        this.handler.getLooper().quit();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void tryDeliverTextureFrame() {
        if (this.handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Wrong thread.");
        }
        if (this.isQuitting) return;
        if (!this.hasPendingTexture) return;
        if (this.isTextureInUse) return;
        if (this.listener == null) {
            return;
        }
        this.isTextureInUse = true;
        this.hasPendingTexture = false;
        this.updateTexImage();
        float[] fArray = new float[16];
        this.surfaceTexture.getTransformMatrix(fArray);
        long l2 = Build.VERSION.SDK_INT >= 14 ? this.surfaceTexture.getTimestamp() : TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
        this.listener.onTextureFrameAvailable(this.oesTextureId, fArray, l2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateTexImage() {
        Object object = EglBase.lock;
        synchronized (object) {
            this.surfaceTexture.updateTexImage();
            return;
        }
    }

    public void dispose() {
        Logging.d(TAG, "dispose()");
        ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new SurfaceTextureHelper$6(this));
    }

    public Handler getHandler() {
        return this.handler;
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.surfaceTexture;
    }

    public boolean isTextureInUse() {
        return this.isTextureInUse;
    }

    public void returnTextureFrame() {
        this.handler.post((Runnable)new SurfaceTextureHelper$5(this));
    }

    public void startListening(OnTextureFrameAvailableListener onTextureFrameAvailableListener) {
        if (this.listener != null || this.pendingListener != null) {
            throw new IllegalStateException("SurfaceTextureHelper listener has already been set.");
        }
        this.pendingListener = onTextureFrameAvailableListener;
        this.handler.post(this.setListenerRunnable);
    }

    public void stopListening() {
        Logging.d(TAG, "stopListening()");
        this.handler.removeCallbacks(this.setListenerRunnable);
        ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new SurfaceTextureHelper$4(this));
    }

    public void textureToYUV(ByteBuffer byteBuffer, int n2, int n3, int n4, int n5, float[] fArray) {
        if (n5 != this.oesTextureId) {
            throw new IllegalStateException("textureToByteBuffer called with unexpected textureId");
        }
        this.getYuvConverter().convert(byteBuffer, n2, n3, n4, n5, fArray);
    }

    public static interface OnTextureFrameAvailableListener {
        public void onTextureFrameAvailable(int var1, float[] var2, long var3);
    }

    private static class YuvConverter {
        private static final FloatBuffer DEVICE_RECTANGLE = GlUtil.createFloatBuffer(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
        private static final String FRAGMENT_SHADER = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 interp_tc;\n\nuniform samplerExternalOES oesTex;\nuniform vec2 xUnit;\nuniform vec4 coeffs;\n\nvoid main() {\n  gl_FragColor.r = coeffs.a + dot(coeffs.rgb,\n      texture2D(oesTex, interp_tc - 1.5 * xUnit).rgb);\n  gl_FragColor.g = coeffs.a + dot(coeffs.rgb,\n      texture2D(oesTex, interp_tc - 0.5 * xUnit).rgb);\n  gl_FragColor.b = coeffs.a + dot(coeffs.rgb,\n      texture2D(oesTex, interp_tc + 0.5 * xUnit).rgb);\n  gl_FragColor.a = coeffs.a + dot(coeffs.rgb,\n      texture2D(oesTex, interp_tc + 1.5 * xUnit).rgb);\n}\n";
        private static final FloatBuffer TEXTURE_RECTANGLE = GlUtil.createFloatBuffer(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});
        private static final String VERTEX_SHADER = "varying vec2 interp_tc;\nattribute vec4 in_pos;\nattribute vec4 in_tc;\n\nuniform mat4 texMatrix;\n\nvoid main() {\n    gl_Position = in_pos;\n    interp_tc = (texMatrix * in_tc).xy;\n}\n";
        private int coeffsLoc;
        private final EglBase eglBase;
        private boolean released = false;
        private final GlShader shader;
        private int texMatrixLoc;
        private int xUnitLoc;

        YuvConverter(EglBase.Context context) {
            this.eglBase = EglBase.create(context, EglBase.CONFIG_PIXEL_RGBA_BUFFER);
            this.eglBase.createDummyPbufferSurface();
            this.eglBase.makeCurrent();
            this.shader = new GlShader(VERTEX_SHADER, FRAGMENT_SHADER);
            this.shader.useProgram();
            this.texMatrixLoc = this.shader.getUniformLocation("texMatrix");
            this.xUnitLoc = this.shader.getUniformLocation("xUnit");
            this.coeffsLoc = this.shader.getUniformLocation("coeffs");
            GLES20.glUniform1i((int)this.shader.getUniformLocation("oesTex"), (int)0);
            GlUtil.checkNoGLES2Error("Initialize fragment shader uniform values.");
            this.shader.setVertexAttribArray("in_pos", 2, DEVICE_RECTANGLE);
            this.shader.setVertexAttribArray("in_tc", 2, TEXTURE_RECTANGLE);
            this.eglBase.detachCurrent();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void convert(ByteBuffer object, int n2, int n3, int n4, int n5, float[] fArray) {
            synchronized (this) {
                if (this.released) {
                    object = new IllegalStateException("YuvConverter.convert called on released object");
                    throw object;
                }
                if (n4 % 8 != 0) {
                    object = new IllegalArgumentException("Invalid stride, must be a multiple of 8");
                    throw object;
                }
                if (n4 < n2) {
                    object = new IllegalArgumentException("Invalid stride, must >= width");
                    throw object;
                }
                int n6 = (n2 + 3) / 4;
                int n7 = (n2 + 7) / 8;
                int n8 = (n3 + 1) / 2;
                int n9 = n3 + n8;
                if (((Buffer)object).capacity() < n4 * n9) {
                    object = new IllegalArgumentException("YuvConverter.convert called with too small buffer");
                    throw object;
                }
                fArray = RendererCommon.multiplyMatrices((float[])fArray, (float[])RendererCommon.verticalFlipMatrix());
                if (this.eglBase.hasSurface()) {
                    if (this.eglBase.surfaceWidth() != n4 / 4 || this.eglBase.surfaceHeight() != n9) {
                        this.eglBase.releaseSurface();
                        this.eglBase.createPbufferSurface(n4 / 4, n9);
                    }
                } else {
                    this.eglBase.createPbufferSurface(n4 / 4, n9);
                }
                this.eglBase.makeCurrent();
                GLES20.glActiveTexture((int)33984);
                GLES20.glBindTexture((int)36197, (int)n5);
                GLES20.glUniformMatrix4fv((int)this.texMatrixLoc, (int)1, (boolean)false, (float[])fArray, (int)0);
                GLES20.glViewport((int)0, (int)0, (int)n6, (int)n3);
                GLES20.glUniform2f((int)this.xUnitLoc, (float)(fArray[0] / (float)n2), (float)(fArray[1] / (float)n2));
                GLES20.glUniform4f((int)this.coeffsLoc, (float)0.299f, (float)0.587f, (float)0.114f, (float)0.0f);
                GLES20.glDrawArrays((int)5, (int)0, (int)4);
                GLES20.glViewport((int)0, (int)n3, (int)n7, (int)n8);
                GLES20.glUniform2f((int)this.xUnitLoc, (float)(2.0f * fArray[0] / (float)n2), (float)(fArray[1] * 2.0f / (float)n2));
                GLES20.glUniform4f((int)this.coeffsLoc, (float)-0.169f, (float)-0.331f, (float)0.499f, (float)0.5f);
                GLES20.glDrawArrays((int)5, (int)0, (int)4);
                GLES20.glViewport((int)(n4 / 8), (int)n3, (int)n7, (int)n8);
                GLES20.glUniform4f((int)this.coeffsLoc, (float)0.499f, (float)-0.418f, (float)-0.0813f, (float)0.5f);
                GLES20.glDrawArrays((int)5, (int)0, (int)4);
                GLES20.glReadPixels((int)0, (int)0, (int)(n4 / 4), (int)n9, (int)6408, (int)5121, (Buffer)object);
                GlUtil.checkNoGLES2Error("YuvConverter.convert");
                GLES20.glBindTexture((int)36197, (int)0);
                this.eglBase.detachCurrent();
                return;
            }
        }

        void release() {
            synchronized (this) {
                this.released = true;
                this.eglBase.makeCurrent();
                this.shader.release();
                this.eglBase.release();
                return;
            }
        }
    }
}

