/*
 * Decompiled with CFR 0.152.
 */
package org.wrtc;

import android.annotation.SuppressLint;
import android.graphics.Point;
import android.graphics.Rect;
import android.opengl.EGL14;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.opengles.GL10;
import org.wrtc.EglBase;
import org.wrtc.EglBase10;
import org.wrtc.EglBase14;
import org.wrtc.GlRectDrawer;
import org.wrtc.GlTextureFrameBuffer;
import org.wrtc.GlUtil;
import org.wrtc.Logging;
import org.wrtc.RendererCommon;
import org.wrtc.VideoRenderer;
import org.wrtc.VideoRendererGui$1;

public class VideoRendererGui
implements GLSurfaceView.Renderer {
    private static final String TAG = "VideoRendererGui";
    private static Thread drawThread;
    private static EglBase.Context eglContext;
    private static Runnable eglContextReady;
    private static VideoRendererGui instance;
    private static Thread renderFrameThread;
    private boolean onSurfaceCreatedCalled;
    private int screenHeight;
    private int screenWidth;
    private GLSurfaceView surface;
    private final ArrayList<YuvImageRenderer> yuvImageRenderers;

    static {
        instance = null;
        eglContextReady = null;
        eglContext = null;
    }

    private VideoRendererGui(GLSurfaceView gLSurfaceView) {
        this.surface = gLSurfaceView;
        gLSurfaceView.setPreserveEGLContextOnPause(true);
        gLSurfaceView.setEGLContextClientVersion(2);
        gLSurfaceView.setRenderer((GLSurfaceView.Renderer)this);
        gLSurfaceView.setRenderMode(0);
        this.yuvImageRenderers = new ArrayList();
    }

    static /* synthetic */ Thread access$002(Thread thread) {
        renderFrameThread = thread;
        return thread;
    }

    static /* synthetic */ VideoRendererGui access$400() {
        return instance;
    }

    static /* synthetic */ int access$500(VideoRendererGui videoRendererGui) {
        return videoRendererGui.screenWidth;
    }

    static /* synthetic */ int access$600(VideoRendererGui videoRendererGui) {
        return videoRendererGui.screenHeight;
    }

    public static YuvImageRenderer create(int n2, int n3, int n4, int n5, RendererCommon.ScalingType object, boolean bl2) {
        synchronized (VideoRendererGui.class) {
            GlRectDrawer glRectDrawer = new GlRectDrawer();
            object = VideoRendererGui.create(n2, n3, n4, n5, object, bl2, glRectDrawer);
            return object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static YuvImageRenderer create(int n2, int n3, int n4, int n5, RendererCommon.ScalingType object, boolean bl2, RendererCommon.GlDrawer object2) {
        synchronized (VideoRendererGui.class) {
            if (n2 < 0 || n2 > 100 || n3 < 0 || n3 > 100 || n4 < 0 || n4 > 100 || n5 < 0 || n5 > 100 || n2 + n4 > 100 || n3 + n5 > 100) {
                object = new RuntimeException("Incorrect window parameters.");
                throw object;
            }
            if (instance == null) {
                object = new RuntimeException("Attempt to create yuv renderer before setting GLSurfaceView");
                throw object;
            }
            YuvImageRenderer yuvImageRenderer = new YuvImageRenderer(VideoRendererGui.instance.surface, VideoRendererGui.instance.yuvImageRenderers.size(), n2, n3, n4, n5, (RendererCommon.ScalingType)object, bl2, (RendererCommon.GlDrawer)object2, null);
            object = VideoRendererGui.instance.yuvImageRenderers;
            synchronized (object) {
                if (VideoRendererGui.instance.onSurfaceCreatedCalled) {
                    CountDownLatch countDownLatch = new CountDownLatch(1);
                    GLSurfaceView gLSurfaceView = VideoRendererGui.instance.surface;
                    object2 = new VideoRendererGui$1(yuvImageRenderer, countDownLatch);
                    gLSurfaceView.queueEvent((Runnable)object2);
                    try {
                        countDownLatch.await();
                    }
                    catch (InterruptedException interruptedException) {
                        object2 = new RuntimeException(interruptedException);
                        throw object2;
                    }
                }
                VideoRendererGui.instance.yuvImageRenderers.add(yuvImageRenderer);
                return yuvImageRenderer;
            }
        }
    }

    public static VideoRenderer createGui(int n2, int n3, int n4, int n5, RendererCommon.ScalingType scalingType, boolean bl2) throws Exception {
        return new VideoRenderer(VideoRendererGui.create(n2, n3, n4, n5, scalingType, bl2));
    }

    public static VideoRenderer.Callbacks createGuiRenderer(int n2, int n3, int n4, int n5, RendererCommon.ScalingType scalingType, boolean bl2) {
        return VideoRendererGui.create(n2, n3, n4, n5, scalingType, bl2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void dispose() {
        synchronized (VideoRendererGui.class) {
            Object object = instance;
            if (object != null) {
                Logging.d(TAG, "VideoRendererGui.dispose");
                object = VideoRendererGui.instance.yuvImageRenderers;
                synchronized (object) {
                    Iterator<YuvImageRenderer> iterator = VideoRendererGui.instance.yuvImageRenderers.iterator();
                    while (iterator.hasNext()) {
                        iterator.next().release();
                    }
                    VideoRendererGui.instance.yuvImageRenderers.clear();
                }
                renderFrameThread = null;
                drawThread = null;
                VideoRendererGui.instance.surface = null;
                eglContext = null;
                eglContextReady = null;
                instance = null;
            }
            return;
        }
    }

    public static EglBase.Context getEglBaseContext() {
        synchronized (VideoRendererGui.class) {
            EglBase.Context context = eglContext;
            return context;
        }
    }

    private static void printStackTrace(Thread stackTraceElementArray, String string2) {
        if (stackTraceElementArray != null && (stackTraceElementArray = stackTraceElementArray.getStackTrace()).length > 0) {
            Logging.d(TAG, string2 + " stacks trace:");
            int n2 = stackTraceElementArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Logging.d(TAG, stackTraceElementArray[i2].toString());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void printStackTraces() {
        synchronized (VideoRendererGui.class) {
            block6: {
                VideoRendererGui videoRendererGui = instance;
                if (videoRendererGui != null) break block6;
                return;
            }
            VideoRendererGui.printStackTrace(renderFrameThread, "Render frame thread");
            VideoRendererGui.printStackTrace(drawThread, "Draw thread");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void remove(VideoRenderer.Callbacks object) {
        synchronized (VideoRendererGui.class) {
            Logging.d(TAG, "VideoRendererGui.remove");
            if (instance == null) {
                object = new RuntimeException("Attempt to remove renderer before setting GLSurfaceView");
                throw object;
            }
            ArrayList<YuvImageRenderer> arrayList = VideoRendererGui.instance.yuvImageRenderers;
            synchronized (arrayList) {
                int n2 = VideoRendererGui.instance.yuvImageRenderers.indexOf(object);
                if (n2 == -1) {
                    Logging.w(TAG, "Couldn't remove renderer (not present in current list)");
                } else {
                    VideoRendererGui.instance.yuvImageRenderers.remove(n2).release();
                }
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void reset(VideoRenderer.Callbacks object) {
        synchronized (VideoRendererGui.class) {
            Logging.d(TAG, "VideoRendererGui.reset");
            if (instance == null) {
                object = new RuntimeException("Attempt to reset renderer before setting GLSurfaceView");
                throw object;
            }
            ArrayList<YuvImageRenderer> arrayList = VideoRendererGui.instance.yuvImageRenderers;
            synchronized (arrayList) {
                Iterator<YuvImageRenderer> iterator = VideoRendererGui.instance.yuvImageRenderers.iterator();
                while (iterator.hasNext()) {
                    YuvImageRenderer yuvImageRenderer = iterator.next();
                    if (yuvImageRenderer != object) continue;
                    yuvImageRenderer.reset();
                }
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setRendererEvents(VideoRenderer.Callbacks object, RendererCommon.RendererEvents rendererEvents) {
        synchronized (VideoRendererGui.class) {
            Logging.d(TAG, "VideoRendererGui.setRendererEvents");
            if (instance == null) {
                object = new RuntimeException("Attempt to set renderer events before setting GLSurfaceView");
                throw object;
            }
            ArrayList<YuvImageRenderer> arrayList = VideoRendererGui.instance.yuvImageRenderers;
            synchronized (arrayList) {
                Iterator<YuvImageRenderer> iterator = VideoRendererGui.instance.yuvImageRenderers.iterator();
                while (iterator.hasNext()) {
                    YuvImageRenderer yuvImageRenderer = iterator.next();
                    if (yuvImageRenderer != object) continue;
                    YuvImageRenderer.access$702(yuvImageRenderer, rendererEvents);
                }
                return;
            }
        }
    }

    public static void setView(GLSurfaceView gLSurfaceView, Runnable runnable) {
        synchronized (VideoRendererGui.class) {
            VideoRendererGui videoRendererGui;
            Logging.d(TAG, "VideoRendererGui.setView");
            instance = videoRendererGui = new VideoRendererGui(gLSurfaceView);
            eglContextReady = runnable;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void update(VideoRenderer.Callbacks object, int n2, int n3, int n4, int n5, RendererCommon.ScalingType scalingType, boolean bl2) {
        synchronized (VideoRendererGui.class) {
            Logging.d(TAG, "VideoRendererGui.update");
            if (instance == null) {
                object = new RuntimeException("Attempt to update yuv renderer before setting GLSurfaceView");
                throw object;
            }
            ArrayList<YuvImageRenderer> arrayList = VideoRendererGui.instance.yuvImageRenderers;
            synchronized (arrayList) {
                Iterator<YuvImageRenderer> iterator = VideoRendererGui.instance.yuvImageRenderers.iterator();
                while (iterator.hasNext()) {
                    YuvImageRenderer yuvImageRenderer = iterator.next();
                    if (yuvImageRenderer != object) continue;
                    yuvImageRenderer.setPosition(n2, n3, n4, n5, scalingType, bl2);
                }
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onDrawFrame(GL10 object) {
        if (drawThread == null) {
            drawThread = Thread.currentThread();
        }
        GLES20.glViewport((int)0, (int)0, (int)this.screenWidth, (int)this.screenHeight);
        GLES20.glClear((int)16384);
        object = this.yuvImageRenderers;
        synchronized (object) {
            Iterator<YuvImageRenderer> iterator = this.yuvImageRenderers.iterator();
            while (iterator.hasNext()) {
                iterator.next().draw();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onSurfaceChanged(GL10 object, int n2, int n3) {
        Logging.d(TAG, "VideoRendererGui.onSurfaceChanged: " + n2 + " x " + n3 + "  ");
        this.screenWidth = n2;
        this.screenHeight = n3;
        object = this.yuvImageRenderers;
        synchronized (object) {
            Iterator<YuvImageRenderer> iterator = this.yuvImageRenderers.iterator();
            while (iterator.hasNext()) {
                iterator.next().setScreenSize(this.screenWidth, this.screenHeight);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"NewApi"})
    public void onSurfaceCreated(GL10 object, EGLConfig object2) {
        Logging.d(TAG, "VideoRendererGui.onSurfaceCreated");
        synchronized (VideoRendererGui.class) {
            if (EglBase14.isEGL14Supported()) {
                object = new EglBase14.Context(EGL14.eglGetCurrentContext());
                eglContext = object;
            } else {
                object = new EglBase10.Context(((EGL10)EGLContext.getEGL()).eglGetCurrentContext());
                eglContext = object;
            }
            object = new StringBuilder();
            Logging.d(TAG, ((StringBuilder)object).append("VideoRendererGui EGL Context: ").append(eglContext).toString());
        }
        object = this.yuvImageRenderers;
        synchronized (object) {
            object2 = this.yuvImageRenderers.iterator();
            while (object2.hasNext()) {
                ((YuvImageRenderer)object2.next()).createTextures();
            }
            this.onSurfaceCreatedCalled = true;
        }
        GlUtil.checkNoGLES2Error("onSurfaceCreated done");
        GLES20.glPixelStorei((int)3317, (int)1);
        GLES20.glClearColor((float)0.15f, (float)0.15f, (float)0.15f, (float)1.0f);
        synchronized (VideoRendererGui.class) {
            if (eglContextReady != null) {
                eglContextReady.run();
            }
            return;
        }
    }

    private static class YuvImageRenderer
    implements VideoRenderer.Callbacks {
        private long copyTimeNs;
        private final Rect displayLayout;
        private long drawTimeNs;
        private final RendererCommon.GlDrawer drawer;
        private int framesDropped;
        private int framesReceived;
        private int framesRendered;
        private int id;
        private final Rect layoutInPercentage;
        private float[] layoutMatrix;
        private boolean mirror;
        private VideoRenderer.I420Frame pendingFrame;
        private final Object pendingFrameLock;
        private RendererCommon.RendererEvents rendererEvents;
        private RendererType rendererType;
        private float[] rotatedSamplingMatrix;
        private int rotationDegree;
        private RendererCommon.ScalingType scalingType;
        private int screenHeight;
        private int screenWidth;
        boolean seenFrame;
        private long startTimeNs = -1L;
        private GLSurfaceView surface;
        private GlTextureFrameBuffer textureCopy;
        private final Object updateLayoutLock;
        private boolean updateLayoutProperties;
        private int videoHeight;
        private int videoWidth;
        private int[] yuvTextures = new int[]{0, 0, 0};
        private final RendererCommon.YuvUploader yuvUploader = new RendererCommon.YuvUploader();

        private YuvImageRenderer(GLSurfaceView gLSurfaceView, int n2, int n3, int n4, int n5, int n6, RendererCommon.ScalingType scalingType, boolean bl2, RendererCommon.GlDrawer glDrawer) {
            this.pendingFrameLock = new Object();
            this.displayLayout = new Rect();
            this.updateLayoutLock = new Object();
            Logging.d(VideoRendererGui.TAG, "YuvImageRenderer.Create id: " + n2);
            this.surface = gLSurfaceView;
            this.id = n2;
            this.scalingType = scalingType;
            this.mirror = bl2;
            this.drawer = glDrawer;
            this.layoutInPercentage = new Rect(n3, n4, Math.min(100, n3 + n5), Math.min(100, n4 + n6));
            this.updateLayoutProperties = false;
            this.rotationDegree = 0;
        }

        /* synthetic */ YuvImageRenderer(GLSurfaceView gLSurfaceView, int n2, int n3, int n4, int n5, int n6, RendererCommon.ScalingType scalingType, boolean bl2, RendererCommon.GlDrawer glDrawer, VideoRendererGui$1 videoRendererGui$1) {
            this(gLSurfaceView, n2, n3, n4, n5, n6, scalingType, bl2, glDrawer);
        }

        static /* synthetic */ RendererCommon.RendererEvents access$702(YuvImageRenderer yuvImageRenderer, RendererCommon.RendererEvents rendererEvents) {
            yuvImageRenderer.rendererEvents = rendererEvents;
            return rendererEvents;
        }

        private void createTextures() {
            Logging.d(VideoRendererGui.TAG, "  YuvImageRenderer.createTextures " + this.id + " on GL thread:" + Thread.currentThread().getId());
            for (int i2 = 0; i2 < 3; ++i2) {
                this.yuvTextures[i2] = GlUtil.generateTexture(3553);
            }
            this.textureCopy = new GlTextureFrameBuffer(6407);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void draw() {
            boolean bl2;
            if (!this.seenFrame) {
                return;
            }
            long l2 = System.nanoTime();
            Object object = this.pendingFrameLock;
            synchronized (object) {
                bl2 = this.pendingFrame != null;
                if (bl2 && this.startTimeNs == -1L) {
                    this.startTimeNs = l2;
                }
                if (bl2) {
                    this.rotatedSamplingMatrix = RendererCommon.rotateTextureMatrix((float[])this.pendingFrame.samplingMatrix, (float)this.pendingFrame.rotationDegree);
                    if (this.pendingFrame.yuvFrame) {
                        this.rendererType = RendererType.RENDERER_YUV;
                        this.yuvUploader.uploadYuvData(this.yuvTextures, this.pendingFrame.width, this.pendingFrame.height, this.pendingFrame.yuvStrides, this.pendingFrame.yuvPlanes);
                    } else {
                        this.rendererType = RendererType.RENDERER_TEXTURE;
                        this.textureCopy.setSize(this.pendingFrame.rotatedWidth(), this.pendingFrame.rotatedHeight());
                        GLES20.glBindFramebuffer((int)36160, (int)this.textureCopy.getFrameBufferId());
                        GlUtil.checkNoGLES2Error("glBindFramebuffer");
                        this.drawer.drawOes(this.pendingFrame.textureId, this.rotatedSamplingMatrix, this.textureCopy.getWidth(), this.textureCopy.getHeight(), 0, 0, this.textureCopy.getWidth(), this.textureCopy.getHeight());
                        this.rotatedSamplingMatrix = RendererCommon.identityMatrix();
                        GLES20.glBindFramebuffer((int)36160, (int)0);
                        GLES20.glFinish();
                    }
                    this.copyTimeNs += System.nanoTime() - l2;
                    VideoRenderer.renderFrameDone(this.pendingFrame);
                    this.pendingFrame = null;
                }
            }
            this.updateLayoutMatrix();
            object = RendererCommon.multiplyMatrices((float[])this.rotatedSamplingMatrix, (float[])this.layoutMatrix);
            int n2 = this.screenHeight - this.displayLayout.bottom;
            if (this.rendererType == RendererType.RENDERER_YUV) {
                this.drawer.drawYuv(this.yuvTextures, (float[])object, this.videoWidth, this.videoHeight, this.displayLayout.left, n2, this.displayLayout.width(), this.displayLayout.height());
            } else {
                this.drawer.drawRgb(this.textureCopy.getTextureId(), (float[])object, this.videoWidth, this.videoHeight, this.displayLayout.left, n2, this.displayLayout.width(), this.displayLayout.height());
            }
            if (!bl2) return;
            ++this.framesRendered;
            this.drawTimeNs += System.nanoTime() - l2;
            if (this.framesRendered % 300 != 0) return;
            this.logStatistics();
        }

        private void logStatistics() {
            long l2 = System.nanoTime() - this.startTimeNs;
            Logging.d(VideoRendererGui.TAG, "ID: " + this.id + ". Type: " + (Object)((Object)this.rendererType) + ". Frames received: " + this.framesReceived + ". Dropped: " + this.framesDropped + ". Rendered: " + this.framesRendered);
            if (this.framesReceived > 0 && this.framesRendered > 0) {
                Logging.d(VideoRendererGui.TAG, "Duration: " + (int)((double)l2 / 1000000.0) + " ms. FPS: " + (double)this.framesRendered * 1.0E9 / (double)l2);
                Logging.d(VideoRendererGui.TAG, "Draw time: " + (int)(this.drawTimeNs / (long)(this.framesRendered * 1000)) + " us. Copy time: " + (int)(this.copyTimeNs / (long)(this.framesReceived * 1000)) + " us");
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void release() {
            synchronized (this) {
                this.surface = null;
                this.drawer.release();
                Object object = this.pendingFrameLock;
                synchronized (object) {
                    if (this.pendingFrame != null) {
                        VideoRenderer.renderFrameDone(this.pendingFrame);
                        this.pendingFrame = null;
                    }
                    return;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void setSize(int n2, int n3, int n4) {
            if (n2 == this.videoWidth && n3 == this.videoHeight && n4 == this.rotationDegree) {
                return;
            }
            if (this.rendererEvents != null) {
                Logging.d(VideoRendererGui.TAG, "ID: " + this.id + ". Reporting frame resolution changed to " + n2 + " x " + n3);
                this.rendererEvents.onFrameResolutionChanged(n2, n3, n4);
            }
            Object object = this.updateLayoutLock;
            synchronized (object) {
                StringBuilder stringBuilder = new StringBuilder();
                Logging.d(VideoRendererGui.TAG, stringBuilder.append("ID: ").append(this.id).append(". YuvImageRenderer.setSize: ").append(n2).append(" x ").append(n3).append(" rotation ").append(n4).toString());
                this.videoWidth = n2;
                this.videoHeight = n3;
                this.rotationDegree = n4;
                this.updateLayoutProperties = true;
                Logging.d(VideoRendererGui.TAG, "  YuvImageRenderer.setSize done.");
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void updateLayoutMatrix() {
            Object object = this.updateLayoutLock;
            synchronized (object) {
                float f2;
                if (!this.updateLayoutProperties) {
                    return;
                }
                this.displayLayout.set((this.screenWidth * this.layoutInPercentage.left + 99) / 100, (this.screenHeight * this.layoutInPercentage.top + 99) / 100, this.screenWidth * this.layoutInPercentage.right / 100, this.screenHeight * this.layoutInPercentage.bottom / 100);
                StringBuilder stringBuilder = new StringBuilder();
                Logging.d(VideoRendererGui.TAG, stringBuilder.append("ID: ").append(this.id).append(". AdjustTextureCoords. Allowed display size: ").append(this.displayLayout.width()).append(" x ").append(this.displayLayout.height()).append(". Video: ").append(this.videoWidth).append(" x ").append(this.videoHeight).append(". Rotation: ").append(this.rotationDegree).append(". Mirror: ").append(this.mirror).toString());
                if (this.rotationDegree % 180 == 0) {
                    f2 = (float)this.videoWidth / (float)this.videoHeight;
                } else {
                    f2 = this.videoHeight;
                    int n2 = this.videoWidth;
                    f2 /= (float)n2;
                }
                stringBuilder = RendererCommon.getDisplaySize((RendererCommon.ScalingType)this.scalingType, (float)f2, (int)this.displayLayout.width(), (int)this.displayLayout.height());
                this.displayLayout.inset((this.displayLayout.width() - ((Point)stringBuilder).x) / 2, (this.displayLayout.height() - ((Point)stringBuilder).y) / 2);
                stringBuilder = new StringBuilder();
                Logging.d(VideoRendererGui.TAG, stringBuilder.append("  Adjusted display size: ").append(this.displayLayout.width()).append(" x ").append(this.displayLayout.height()).toString());
                this.layoutMatrix = RendererCommon.getLayoutMatrix((boolean)this.mirror, (float)f2, (float)((float)this.displayLayout.width() / (float)this.displayLayout.height()));
                this.updateLayoutProperties = false;
                Logging.d(VideoRendererGui.TAG, "  AdjustTextureCoords done");
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void renderFrame(VideoRenderer.I420Frame i420Frame) {
            synchronized (this) {
                if (this.surface == null) {
                    VideoRenderer.renderFrameDone(i420Frame);
                } else {
                    Object object;
                    if (renderFrameThread == null) {
                        VideoRendererGui.access$002(Thread.currentThread());
                    }
                    if (!this.seenFrame && this.rendererEvents != null) {
                        object = new StringBuilder();
                        Logging.d(VideoRendererGui.TAG, ((StringBuilder)object).append("ID: ").append(this.id).append(". Reporting first rendered frame.").toString());
                        this.rendererEvents.onFirstFrameRendered();
                    }
                    ++this.framesReceived;
                    object = this.pendingFrameLock;
                    synchronized (object) {
                        if (i420Frame.yuvFrame && (i420Frame.yuvStrides[0] < i420Frame.width || i420Frame.yuvStrides[1] < i420Frame.width / 2 || i420Frame.yuvStrides[2] < i420Frame.width / 2)) {
                            StringBuilder stringBuilder = new StringBuilder();
                            Logging.e(VideoRendererGui.TAG, stringBuilder.append("Incorrect strides ").append(i420Frame.yuvStrides[0]).append(", ").append(i420Frame.yuvStrides[1]).append(", ").append(i420Frame.yuvStrides[2]).toString());
                            VideoRenderer.renderFrameDone(i420Frame);
                        } else if (this.pendingFrame != null) {
                            ++this.framesDropped;
                            VideoRenderer.renderFrameDone(i420Frame);
                            this.seenFrame = true;
                        } else {
                            this.pendingFrame = i420Frame;
                            // MONITOREXIT @DISABLED, blocks:[5, 6, 7, 9, 13] lbl28 : MonitorExitStatement: MONITOREXIT : var2_2
                            this.setSize(i420Frame.width, i420Frame.height, i420Frame.rotationDegree);
                            this.seenFrame = true;
                            this.surface.requestRender();
                        }
                    }
                }
                return;
            }
        }

        public void reset() {
            synchronized (this) {
                this.seenFrame = false;
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void setPosition(int n2, int n3, int n4, int n5, RendererCommon.ScalingType scalingType, boolean bl2) {
            Rect rect = new Rect(n2, n3, Math.min(100, n2 + n4), Math.min(100, n3 + n5));
            Object object = this.updateLayoutLock;
            synchronized (object) {
                if (rect.equals((Object)this.layoutInPercentage) && scalingType == this.scalingType && bl2 == this.mirror) {
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder();
                Logging.d(VideoRendererGui.TAG, stringBuilder.append("ID: ").append(this.id).append(". YuvImageRenderer.setPosition: (").append(n2).append(", ").append(n3).append(") ").append(n4).append(" x ").append(n5).append(". Scaling: ").append(scalingType).append(". Mirror: ").append(bl2).toString());
                this.layoutInPercentage.set(rect);
                this.scalingType = scalingType;
                this.mirror = bl2;
                this.updateLayoutProperties = true;
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void setScreenSize(int n2, int n3) {
            Object object = this.updateLayoutLock;
            synchronized (object) {
                if (n2 == this.screenWidth && n3 == this.screenHeight) {
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder();
                Logging.d(VideoRendererGui.TAG, stringBuilder.append("ID: ").append(this.id).append(". YuvImageRenderer.setScreenSize: ").append(n2).append(" x ").append(n3).toString());
                this.screenWidth = n2;
                this.screenHeight = n3;
                this.updateLayoutProperties = true;
                return;
            }
        }

        private static enum RendererType {
            RENDERER_YUV,
            RENDERER_TEXTURE;

        }
    }
}

