/*
 * Decompiled with CFR 0.152.
 */
package org.wrtc.voiceengine;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioTrack;
import android.os.Build;
import java.util.Timer;
import java.util.TimerTask;
import org.wrtc.Logging;
import org.wrtc.voiceengine.WebRtcAudioEffects;
import org.wrtc.voiceengine.WebRtcAudioUtils;

public class WebRtcAudioManager {
    private static final String[] AUDIO_MODES;
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CHANNELS = 1;
    private static final boolean DEBUG = false;
    private static final int DEFAULT_FRAME_PER_BUFFER = 256;
    private static final String TAG = "WebRtcAudioManager";
    private static boolean blacklistDeviceForOpenSLESUsage;
    private static boolean blacklistDeviceForOpenSLESUsageIsOverridden;
    private final AudioManager audioManager;
    private int channels;
    private final Context context;
    private boolean hardwareAEC;
    private boolean hardwareAGC;
    private boolean hardwareNS;
    private boolean initialized = false;
    private int inputBufferSize;
    private boolean lowLatencyInput;
    private boolean lowLatencyOutput;
    private final long nativeAudioManager;
    private int nativeChannels;
    private int nativeSampleRate;
    private int outputBufferSize;
    private boolean proAudio;
    private int sampleRate;
    private final VolumeLogger volumeLogger;

    static {
        blacklistDeviceForOpenSLESUsage = false;
        blacklistDeviceForOpenSLESUsageIsOverridden = false;
        AUDIO_MODES = new String[]{"MODE_NORMAL", "MODE_RINGTONE", "MODE_IN_CALL", "MODE_IN_COMMUNICATION"};
    }

    WebRtcAudioManager(Context context, long l2) {
        Logging.d(TAG, "ctor" + WebRtcAudioUtils.getThreadInfo());
        this.context = context;
        this.nativeAudioManager = l2;
        this.audioManager = (AudioManager)context.getSystemService("audio");
        this.volumeLogger = new VolumeLogger(this.audioManager);
        this.storeAudioParameters();
        this.nativeCacheAudioParameters(this.sampleRate, this.channels, this.hardwareAEC, this.hardwareAGC, this.hardwareNS, this.lowLatencyOutput, this.lowLatencyInput, this.proAudio, this.outputBufferSize, this.inputBufferSize, l2);
    }

    private static void assertTrue(boolean bl2) {
        if (!bl2) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void dispose() {
        Logging.d(TAG, "dispose" + WebRtcAudioUtils.getThreadInfo());
        if (!this.initialized) {
            return;
        }
        this.volumeLogger.stop();
    }

    private int getLowLatencyInputFramesPerBuffer() {
        WebRtcAudioManager.assertTrue(this.isLowLatencyInputSupported());
        return this.getLowLatencyOutputFramesPerBuffer();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TargetApi(value=17)
    private int getLowLatencyOutputFramesPerBuffer() {
        int n2 = 256;
        WebRtcAudioManager.assertTrue(this.isLowLatencyOutputSupported());
        if (!WebRtcAudioUtils.runningOnJellyBeanMR1OrHigher()) {
            return n2;
        }
        String string2 = this.audioManager.getProperty("android.media.property.OUTPUT_FRAMES_PER_BUFFER");
        if (string2 == null) return n2;
        return Integer.parseInt(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int getMinInputFrameSize(int n2, int n3) {
        boolean bl2 = true;
        if (n3 != 1) {
            bl2 = false;
        }
        WebRtcAudioManager.assertTrue(bl2);
        return AudioRecord.getMinBufferSize((int)n2, (int)16, (int)2) / (n3 * 2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getMinOutputFrameSize(int n2, int n3) {
        int n4;
        if (n3 == 1) {
            n4 = 4;
            return AudioTrack.getMinBufferSize((int)n2, (int)n4, (int)2) / (n3 * 2);
        }
        if (n3 != 2) return -1;
        n4 = 12;
        return AudioTrack.getMinBufferSize((int)n2, (int)n4, (int)2) / (n3 * 2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getNativeOutputSampleRate() {
        if (WebRtcAudioUtils.runningOnEmulator()) {
            Logging.d(TAG, "Running emulator, overriding sample rate to 8 kHz.");
            return 8000;
        }
        if (WebRtcAudioUtils.isDefaultSampleRateOverridden()) {
            Logging.d(TAG, "Default sample rate is overriden to " + WebRtcAudioUtils.getDefaultSampleRateHz() + " Hz");
            return WebRtcAudioUtils.getDefaultSampleRateHz();
        }
        int n2 = WebRtcAudioUtils.runningOnJellyBeanMR1OrHigher() ? this.getSampleRateOnJellyBeanMR10OrHigher() : WebRtcAudioUtils.getDefaultSampleRateHz();
        Logging.d(TAG, "Sample rate is set to " + n2 + " Hz");
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TargetApi(value=17)
    private int getSampleRateOnJellyBeanMR10OrHigher() {
        String string2 = this.audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
        if (string2 != null) return Integer.parseInt(string2);
        return WebRtcAudioUtils.getDefaultSampleRateHz();
    }

    private boolean hasEarpiece() {
        return this.context.getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean init() {
        Logging.d(TAG, "init" + WebRtcAudioUtils.getThreadInfo());
        if (this.initialized) {
            return true;
        }
        Logging.d(TAG, "audio mode is: " + AUDIO_MODES[this.audioManager.getMode()]);
        this.initialized = true;
        this.volumeLogger.start();
        return true;
    }

    private static boolean isAcousticEchoCancelerSupported() {
        return WebRtcAudioEffects.canUseAcousticEchoCanceler();
    }

    private static boolean isAutomaticGainControlSupported() {
        return WebRtcAudioEffects.canUseAutomaticGainControl();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isCommunicationModeEnabled() {
        if (this.audioManager.getMode() != 3) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isDeviceBlacklistedForOpenSLESUsage() {
        boolean bl2 = blacklistDeviceForOpenSLESUsageIsOverridden ? blacklistDeviceForOpenSLESUsage : WebRtcAudioUtils.deviceIsBlacklistedForOpenSLESUsage();
        if (bl2) {
            Logging.e(TAG, Build.MODEL + " is blacklisted for OpenSL ES usage!");
        }
        return bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isLowLatencyOutputSupported() {
        if (!WebRtcAudioManager.isOpenSLESSupported()) return false;
        if (!this.context.getPackageManager().hasSystemFeature("android.hardware.audio.low_latency")) return false;
        return true;
    }

    private static boolean isNoiseSuppressorSupported() {
        return WebRtcAudioEffects.canUseNoiseSuppressor();
    }

    private static boolean isOpenSLESSupported() {
        return WebRtcAudioUtils.runningOnGingerBreadOrHigher();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isProAudioSupported() {
        if (!WebRtcAudioUtils.runningOnMarshmallowOrHigher()) return false;
        if (!this.context.getPackageManager().hasSystemFeature("android.hardware.audio.pro")) return false;
        return true;
    }

    private native void nativeCacheAudioParameters(int var1, int var2, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8, int var9, int var10, long var11);

    public static void setBlacklistDeviceForOpenSLESUsage(boolean bl2) {
        synchronized (WebRtcAudioManager.class) {
            blacklistDeviceForOpenSLESUsageIsOverridden = true;
            blacklistDeviceForOpenSLESUsage = bl2;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void storeAudioParameters() {
        this.channels = 1;
        this.sampleRate = this.getNativeOutputSampleRate();
        this.hardwareAEC = WebRtcAudioManager.isAcousticEchoCancelerSupported();
        this.hardwareAGC = WebRtcAudioManager.isAutomaticGainControlSupported();
        this.hardwareNS = WebRtcAudioManager.isNoiseSuppressorSupported();
        this.lowLatencyOutput = this.isLowLatencyOutputSupported();
        this.lowLatencyInput = this.isLowLatencyInputSupported();
        this.proAudio = this.isProAudioSupported();
        int n2 = this.lowLatencyOutput ? this.getLowLatencyOutputFramesPerBuffer() : WebRtcAudioManager.getMinOutputFrameSize(this.sampleRate, this.channels);
        this.outputBufferSize = n2;
        n2 = this.lowLatencyInput ? this.getLowLatencyInputFramesPerBuffer() : WebRtcAudioManager.getMinInputFrameSize(this.sampleRate, this.channels);
        this.inputBufferSize = n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isLowLatencyInputSupported() {
        if (!WebRtcAudioUtils.runningOnLollipopOrHigher()) return false;
        if (!this.isLowLatencyOutputSupported()) return false;
        return true;
    }

    private static class VolumeLogger {
        private static final String THREAD_NAME = "WebRtcVolumeLevelLoggerThread";
        private static final int TIMER_PERIOD_IN_SECONDS = 10;
        private final AudioManager audioManager;
        private Timer timer;

        public VolumeLogger(AudioManager audioManager) {
            this.audioManager = audioManager;
        }

        private void stop() {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        }

        public void start() {
            this.timer = new Timer(THREAD_NAME);
            this.timer.schedule((TimerTask)new LogVolumeTask(this.audioManager.getStreamMaxVolume(2), this.audioManager.getStreamMaxVolume(0)), 0L, 10000L);
        }

        private class LogVolumeTask
        extends TimerTask {
            private final int maxRingVolume;
            private final int maxVoiceCallVolume;

            LogVolumeTask(int n2, int n3) {
                this.maxRingVolume = n2;
                this.maxVoiceCallVolume = n3;
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void run() {
                int n2 = VolumeLogger.this.audioManager.getMode();
                if (n2 == 1) {
                    Logging.d(WebRtcAudioManager.TAG, "STREAM_RING stream volume: " + VolumeLogger.this.audioManager.getStreamVolume(2) + " (max=" + this.maxRingVolume + ")");
                    return;
                }
                if (n2 != 3) return;
                Logging.d(WebRtcAudioManager.TAG, "VOICE_CALL stream volume: " + VolumeLogger.this.audioManager.getStreamVolume(0) + " (max=" + this.maxVoiceCallVolume + ")");
            }
        }
    }
}

