/*
 * Decompiled with CFR 0.152.
 */
package org.wrtc.voiceengine;

import android.content.Context;
import android.os.Build;
import android.os.Process;
import java.util.Arrays;
import java.util.List;
import org.wrtc.Logging;
import org.wrtc.voiceengine.WebRtcAudioEffects;

public final class WebRtcAudioUtils {
    private static final String[] BLACKLISTED_AEC_MODELS;
    private static final String[] BLACKLISTED_AGC_MODELS;
    private static final String[] BLACKLISTED_NS_MODELS;
    private static final String[] BLACKLISTED_OPEN_SL_ES_MODELS;
    private static final int DEFAULT_SAMPLE_RATE_HZ = 16000;
    private static final String TAG = "WebRtcAudioUtils";
    private static int defaultSampleRateHz;
    private static boolean isDefaultSampleRateOverridden;
    private static boolean useWebRtcBasedAcousticEchoCanceler;
    private static boolean useWebRtcBasedAutomaticGainControl;
    private static boolean useWebRtcBasedNoiseSuppressor;

    static {
        BLACKLISTED_OPEN_SL_ES_MODELS = new String[0];
        BLACKLISTED_AEC_MODELS = new String[]{"D6503", "ONE A2005", "MotoG3"};
        BLACKLISTED_AGC_MODELS = new String[]{"Nexus 10", "Nexus 9"};
        BLACKLISTED_NS_MODELS = new String[]{"Nexus 10", "Nexus 9", "ONE A2005"};
        defaultSampleRateHz = 16000;
        isDefaultSampleRateOverridden = false;
        useWebRtcBasedAcousticEchoCanceler = false;
        useWebRtcBasedAutomaticGainControl = false;
        useWebRtcBasedNoiseSuppressor = false;
    }

    public static boolean deviceIsBlacklistedForOpenSLESUsage() {
        return Arrays.asList(BLACKLISTED_OPEN_SL_ES_MODELS).contains(Build.MODEL);
    }

    public static List<String> getBlackListedModelsForAecUsage() {
        return Arrays.asList(BLACKLISTED_AEC_MODELS);
    }

    public static List<String> getBlackListedModelsForAgcUsage() {
        return Arrays.asList(BLACKLISTED_AGC_MODELS);
    }

    public static List<String> getBlackListedModelsForNsUsage() {
        return Arrays.asList(BLACKLISTED_NS_MODELS);
    }

    public static int getDefaultSampleRateHz() {
        synchronized (WebRtcAudioUtils.class) {
            int n2 = defaultSampleRateHz;
            return n2;
        }
    }

    public static String getThreadInfo() {
        return "@[name=" + Thread.currentThread().getName() + ", id=" + Thread.currentThread().getId() + "]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasPermission(Context context, String string2) {
        if (context.checkPermission(string2, Process.myPid(), Process.myUid()) != 0) return false;
        return true;
    }

    public static boolean isAcousticEchoCancelerSupported() {
        return WebRtcAudioEffects.canUseAcousticEchoCanceler();
    }

    public static boolean isAutomaticGainControlSupported() {
        return WebRtcAudioEffects.canUseAutomaticGainControl();
    }

    public static boolean isDefaultSampleRateOverridden() {
        synchronized (WebRtcAudioUtils.class) {
            boolean bl2 = isDefaultSampleRateOverridden;
            return bl2;
        }
    }

    public static boolean isNoiseSuppressorSupported() {
        return WebRtcAudioEffects.canUseNoiseSuppressor();
    }

    public static void logDeviceInfo(String string2) {
        Logging.d(string2, "Android SDK: " + Build.VERSION.SDK_INT + ", Release: " + Build.VERSION.RELEASE + ", Brand: " + Build.BRAND + ", Device: " + Build.DEVICE + ", Id: " + Build.ID + ", Hardware: " + Build.HARDWARE + ", Manufacturer: " + Build.MANUFACTURER + ", Model: " + Build.MODEL + ", Product: " + Build.PRODUCT);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean runningOnEmulator() {
        if (!Build.HARDWARE.equals("goldfish")) return false;
        if (!Build.BRAND.startsWith("generic_")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean runningOnGingerBreadOrHigher() {
        if (Build.VERSION.SDK_INT < 9) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean runningOnJellyBeanMR1OrHigher() {
        if (Build.VERSION.SDK_INT < 17) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean runningOnJellyBeanMR2OrHigher() {
        if (Build.VERSION.SDK_INT < 18) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean runningOnJellyBeanOrHigher() {
        if (Build.VERSION.SDK_INT < 16) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean runningOnLollipopOrHigher() {
        if (Build.VERSION.SDK_INT < 21) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean runningOnMarshmallowOrHigher() {
        if (Build.VERSION.SDK_INT < 23) return false;
        return true;
    }

    public static void setDefaultSampleRateHz(int n2) {
        synchronized (WebRtcAudioUtils.class) {
            isDefaultSampleRateOverridden = true;
            defaultSampleRateHz = n2;
            return;
        }
    }

    public static void setWebRtcBasedAcousticEchoCanceler(boolean bl2) {
        synchronized (WebRtcAudioUtils.class) {
            useWebRtcBasedAcousticEchoCanceler = bl2;
            return;
        }
    }

    public static void setWebRtcBasedAutomaticGainControl(boolean bl2) {
        synchronized (WebRtcAudioUtils.class) {
            useWebRtcBasedAutomaticGainControl = bl2;
            return;
        }
    }

    public static void setWebRtcBasedNoiseSuppressor(boolean bl2) {
        synchronized (WebRtcAudioUtils.class) {
            useWebRtcBasedNoiseSuppressor = bl2;
            return;
        }
    }

    public static boolean useWebRtcBasedAcousticEchoCanceler() {
        synchronized (WebRtcAudioUtils.class) {
            if (useWebRtcBasedAcousticEchoCanceler) {
                Logging.w(TAG, "Overriding default behavior; now using WebRTC AEC!");
            }
            boolean bl2 = useWebRtcBasedAcousticEchoCanceler;
            return bl2;
        }
    }

    public static boolean useWebRtcBasedAutomaticGainControl() {
        synchronized (WebRtcAudioUtils.class) {
            if (useWebRtcBasedAutomaticGainControl) {
                Logging.w(TAG, "Overriding default behavior; now using WebRTC AGC!");
            }
            boolean bl2 = useWebRtcBasedAutomaticGainControl;
            return bl2;
        }
    }

    public static boolean useWebRtcBasedNoiseSuppressor() {
        synchronized (WebRtcAudioUtils.class) {
            if (useWebRtcBasedNoiseSuppressor) {
                Logging.w(TAG, "Overriding default behavior; now using WebRTC NS!");
            }
            boolean bl2 = useWebRtcBasedNoiseSuppressor;
            return bl2;
        }
    }
}

