/*
 * Decompiled with CFR 0.152.
 */
package com.wjdiankong.parseresource;

import com.wjdiankong.parseresource.Utils;
import com.wjdiankong.parseresource.type.ResChunkHeader;
import com.wjdiankong.parseresource.type.ResStringPoolHeader;
import com.wjdiankong.parseresource.type.ResStringPoolRef;
import com.wjdiankong.parseresource.type.ResTableConfig;
import com.wjdiankong.parseresource.type.ResTableEntry;
import com.wjdiankong.parseresource.type.ResTableHeader;
import com.wjdiankong.parseresource.type.ResTableMap;
import com.wjdiankong.parseresource.type.ResTableMapEntry;
import com.wjdiankong.parseresource.type.ResTablePackage;
import com.wjdiankong.parseresource.type.ResTableRef;
import com.wjdiankong.parseresource.type.ResTableType;
import com.wjdiankong.parseresource.type.ResTableTypeSpec;
import com.wjdiankong.parseresource.type.ResValue;
import java.util.ArrayList;

public class ParseResourceUtils {
    private static int resStringPoolChunkOffset;
    private static int packageChunkOffset;
    private static int keyStringPoolChunkOffset;
    private static int typeStringPoolChunkOffset;
    private static int resTypeOffset;
    private static ArrayList<String> resStringList;
    private static ArrayList<String> keyStringList;
    private static ArrayList<String> typeStringList;
    private static int packId;
    private static int resTypeId;

    public static void parseResTableHeaderChunk(byte[] src) {
        ResTableHeader resTableHeader = new ResTableHeader();
        resTableHeader.header = ParseResourceUtils.parseResChunkHeader(src, 0);
        resStringPoolChunkOffset = resTableHeader.header.headerSize;
        byte[] packageCountByte = Utils.copyByte(src, resTableHeader.header.getHeaderSize(), 4);
        resTableHeader.packageCount = Utils.byte2int(packageCountByte);
    }

    public static void parseResStringPoolChunk(byte[] src) {
        ResStringPoolHeader stringPoolHeader = ParseResourceUtils.parseStringPoolChunk(src, resStringList, resStringPoolChunkOffset);
        packageChunkOffset = resStringPoolChunkOffset + stringPoolHeader.header.size;
    }

    public static void parsePackage(byte[] src) {
        System.out.println("pchunkoffset:" + Utils.bytesToHexString(Utils.int2Byte(packageChunkOffset)));
        ResTablePackage resTabPackage = new ResTablePackage();
        resTabPackage.header = ParseResourceUtils.parseResChunkHeader(src, packageChunkOffset);
        System.out.println("package size:" + resTabPackage.header.headerSize);
        int offset = packageChunkOffset + resTabPackage.header.getHeaderSize();
        byte[] idByte = Utils.copyByte(src, offset, 4);
        packId = resTabPackage.id = Utils.byte2int(idByte);
        System.out.println("package offset:" + Utils.bytesToHexString(Utils.int2Byte(offset + 4)));
        byte[] nameByte = Utils.copyByte(src, offset + 4, 256);
        String packageName = new String(nameByte);
        packageName = Utils.filterStringNull(packageName);
        System.out.println("pkgName:" + packageName);
        byte[] typeStringsByte = Utils.copyByte(src, offset + 4 + 256, 4);
        resTabPackage.typeStrings = Utils.byte2int(typeStringsByte);
        System.out.println("typeString:" + resTabPackage.typeStrings);
        byte[] lastPublicType = Utils.copyByte(src, offset + 8 + 256, 4);
        resTabPackage.lastPublicType = Utils.byte2int(lastPublicType);
        byte[] keyStrings = Utils.copyByte(src, offset + 12 + 256, 4);
        resTabPackage.keyStrings = Utils.byte2int(keyStrings);
        System.out.println("keyString:" + resTabPackage.keyStrings);
        byte[] lastPublicKey = Utils.copyByte(src, offset + 12 + 256, 4);
        resTabPackage.lastPublicKey = Utils.byte2int(lastPublicKey);
        keyStringPoolChunkOffset = packageChunkOffset + resTabPackage.keyStrings;
        typeStringPoolChunkOffset = packageChunkOffset + resTabPackage.typeStrings;
    }

    public static void parseTypeStringPoolChunk(byte[] src) {
        System.out.println("typestring offset:" + Utils.bytesToHexString(Utils.int2Byte(typeStringPoolChunkOffset)));
        ResStringPoolHeader stringPoolHeader = ParseResourceUtils.parseStringPoolChunk(src, typeStringList, typeStringPoolChunkOffset);
        System.out.println("size:" + stringPoolHeader.header.size);
    }

    public static void parseKeyStringPoolChunk(byte[] src) {
        System.out.println("keystring offset:" + Utils.bytesToHexString(Utils.int2Byte(keyStringPoolChunkOffset)));
        ResStringPoolHeader stringPoolHeader = ParseResourceUtils.parseStringPoolChunk(src, keyStringList, keyStringPoolChunkOffset);
        System.out.println("size:" + stringPoolHeader.header.size);
        resTypeOffset = keyStringPoolChunkOffset + stringPoolHeader.header.size;
    }

    public static void parseResTypeSpec(byte[] src) {
        System.out.println("res type spec offset:" + Utils.bytesToHexString(Utils.int2Byte(resTypeOffset)));
        ResTableTypeSpec typeSpec = new ResTableTypeSpec();
        typeSpec.header = ParseResourceUtils.parseResChunkHeader(src, resTypeOffset);
        int offset = resTypeOffset + typeSpec.header.getHeaderSize();
        byte[] idByte = Utils.copyByte(src, offset, 1);
        typeSpec.id = (byte)(idByte[0] & 0xFF);
        resTypeId = typeSpec.id;
        byte[] res0Byte = Utils.copyByte(src, offset + 1, 1);
        typeSpec.res0 = (byte)(res0Byte[0] & 0xFF);
        byte[] res1Byte = Utils.copyByte(src, offset + 2, 2);
        typeSpec.res1 = Utils.byte2Short(res1Byte);
        byte[] entryCountByte = Utils.copyByte(src, offset + 4, 4);
        typeSpec.entryCount = Utils.byte2int(entryCountByte);
        System.out.println("res type spec:" + typeSpec);
        System.out.println("type_name:" + typeStringList.get(typeSpec.id - 1));
        int[] intAry = new int[typeSpec.entryCount];
        int intAryOffset = resTypeOffset + typeSpec.header.headerSize;
        System.out.print("int element:");
        for (int i = 0; i < typeSpec.entryCount; ++i) {
            int element;
            intAry[i] = element = Utils.byte2int(Utils.copyByte(src, intAryOffset + i * 4, 4));
            System.out.print(element + ",");
        }
        System.out.println();
        resTypeOffset += typeSpec.header.size;
    }

    public static void parseResTypeInfo(byte[] src) {
        System.out.println("type chunk offset:" + Utils.bytesToHexString(Utils.int2Byte(resTypeOffset)));
        ResTableType type = new ResTableType();
        type.header = ParseResourceUtils.parseResChunkHeader(src, resTypeOffset);
        int offset = resTypeOffset + type.header.getHeaderSize();
        byte[] idByte = Utils.copyByte(src, offset, 1);
        type.id = (byte)(idByte[0] & 0xFF);
        byte[] res0 = Utils.copyByte(src, offset + 1, 1);
        type.res0 = (byte)(res0[0] & 0xFF);
        byte[] res1 = Utils.copyByte(src, offset + 2, 2);
        type.res1 = Utils.byte2Short(res1);
        byte[] entryCountByte = Utils.copyByte(src, offset + 4, 4);
        type.entryCount = Utils.byte2int(entryCountByte);
        byte[] entriesStartByte = Utils.copyByte(src, offset + 8, 4);
        type.entriesStart = Utils.byte2int(entriesStartByte);
        ResTableConfig resConfig = new ResTableConfig();
        resConfig = ParseResourceUtils.parseResTableConfig(Utils.copyByte(src, offset + 12, resConfig.getSize()));
        System.out.println("config:" + resConfig);
        System.out.println("res type info:" + type);
        System.out.println("type_name:" + typeStringList.get(type.id - 1));
        System.out.print("type int elements:");
        int[] intAry = new int[type.entryCount];
        for (int i = 0; i < type.entryCount; ++i) {
            int element;
            intAry[i] = element = Utils.byte2int(Utils.copyByte(src, resTypeOffset + type.header.headerSize + i * 4, 4));
            System.out.print(element + ",");
        }
        System.out.println();
        int entryAryOffset = resTypeOffset + type.entriesStart;
        ResTableEntry[] tableEntryAry = new ResTableEntry[type.entryCount];
        ResValue[] resValueAry = new ResValue[type.entryCount];
        System.out.println("entry offset:" + Utils.bytesToHexString(Utils.int2Byte(entryAryOffset)));
        int bodySize = 0;
        int valueOffset = entryAryOffset;
        for (int i = 0; i < type.entryCount; ++i) {
            int resId = ParseResourceUtils.getResId(i);
            System.out.println("resId:" + Utils.bytesToHexString(Utils.int2Byte(resId)));
            ResTableEntry entry = new ResTableEntry();
            ResValue value = new ResValue();
            System.out.println("valueOffset:" + Utils.bytesToHexString(Utils.int2Byte(valueOffset += bodySize)));
            entry = ParseResourceUtils.parseResEntry(Utils.copyByte(src, valueOffset, entry.getSize()));
            if (entry.flags == 1) {
                ResTableMapEntry mapEntry = new ResTableMapEntry();
                mapEntry = ParseResourceUtils.parseResMapEntry(Utils.copyByte(src, valueOffset, mapEntry.getSize()));
                System.out.println("map entry:" + mapEntry);
                ResTableMap resMap = new ResTableMap();
                for (int j = 0; j < mapEntry.count; ++j) {
                    int mapOffset = valueOffset + mapEntry.getSize() + resMap.getSize() * j;
                    resMap = ParseResourceUtils.parseResTableMap(Utils.copyByte(src, mapOffset, resMap.getSize()));
                    System.out.println("map:" + resMap);
                }
                bodySize = mapEntry.getSize() + resMap.getSize() * mapEntry.count;
            } else {
                System.out.println("entry:" + entry);
                value = ParseResourceUtils.parseResValue(Utils.copyByte(src, valueOffset + entry.getSize(), value.getSize()));
                System.out.println("value:" + value);
                bodySize = entry.getSize() + value.getSize();
            }
            tableEntryAry[i] = entry;
            resValueAry[i] = value;
            System.out.println("======================================");
        }
        resTypeOffset += type.header.size;
    }

    public static ResTableEntry parseResEntry(byte[] src) {
        ResTableEntry entry = new ResTableEntry();
        byte[] sizeByte = Utils.copyByte(src, 0, 2);
        entry.size = Utils.byte2Short(sizeByte);
        byte[] flagByte = Utils.copyByte(src, 2, 2);
        entry.flags = Utils.byte2Short(flagByte);
        ResStringPoolRef key = new ResStringPoolRef();
        byte[] keyByte = Utils.copyByte(src, 4, 4);
        key.index = Utils.byte2int(keyByte);
        entry.key = key;
        return entry;
    }

    public static ResTableMapEntry parseResMapEntry(byte[] src) {
        ResTableMapEntry entry = new ResTableMapEntry();
        byte[] sizeByte = Utils.copyByte(src, 0, 2);
        entry.size = Utils.byte2Short(sizeByte);
        byte[] flagByte = Utils.copyByte(src, 2, 2);
        entry.flags = Utils.byte2Short(flagByte);
        ResStringPoolRef key = new ResStringPoolRef();
        byte[] keyByte = Utils.copyByte(src, 4, 4);
        key.index = Utils.byte2int(keyByte);
        entry.key = key;
        ResTableRef ref = new ResTableRef();
        byte[] identByte = Utils.copyByte(src, 8, 4);
        ref.ident = Utils.byte2int(identByte);
        entry.parent = ref;
        byte[] countByte = Utils.copyByte(src, 12, 4);
        entry.count = Utils.byte2int(countByte);
        return entry;
    }

    public static ResValue parseResValue(byte[] src) {
        ResValue resValue = new ResValue();
        byte[] sizeByte = Utils.copyByte(src, 0, 2);
        resValue.size = Utils.byte2Short(sizeByte);
        byte[] res0Byte = Utils.copyByte(src, 2, 1);
        resValue.res0 = (byte)(res0Byte[0] & 0xFF);
        byte[] dataType = Utils.copyByte(src, 3, 1);
        resValue.dataType = (byte)(dataType[0] & 0xFF);
        byte[] data = Utils.copyByte(src, 4, 4);
        resValue.data = Utils.byte2int(data);
        return resValue;
    }

    public static ResTableMap parseResTableMap(byte[] src) {
        ResTableMap tableMap = new ResTableMap();
        ResTableRef ref = new ResTableRef();
        byte[] identByte = Utils.copyByte(src, 0, ref.getSize());
        ref.ident = Utils.byte2int(identByte);
        tableMap.name = ref;
        ResValue value = new ResValue();
        tableMap.value = value = ParseResourceUtils.parseResValue(Utils.copyByte(src, ref.getSize(), value.getSize()));
        return tableMap;
    }

    public static ResTableConfig parseResTableConfig(byte[] src) {
        ResTableConfig config = new ResTableConfig();
        byte[] sizeByte = Utils.copyByte(src, 0, 4);
        config.size = Utils.byte2int(sizeByte);
        byte[] mccByte = Utils.copyByte(src, 4, 2);
        config.mcc = Utils.byte2Short(mccByte);
        byte[] mncByte = Utils.copyByte(src, 6, 2);
        config.mnc = Utils.byte2Short(mncByte);
        byte[] imsiByte = Utils.copyByte(src, 4, 4);
        config.imsi = Utils.byte2int(imsiByte);
        byte[] languageByte = Utils.copyByte(src, 8, 2);
        config.language = languageByte;
        byte[] countryByte = Utils.copyByte(src, 10, 2);
        config.country = countryByte;
        byte[] localeByte = Utils.copyByte(src, 8, 4);
        config.locale = Utils.byte2int(localeByte);
        byte[] orientationByte = Utils.copyByte(src, 12, 1);
        config.orientation = orientationByte[0];
        byte[] touchscreenByte = Utils.copyByte(src, 13, 1);
        config.touchscreen = touchscreenByte[0];
        byte[] densityByte = Utils.copyByte(src, 14, 2);
        config.density = Utils.byte2Short(densityByte);
        byte[] screenTypeByte = Utils.copyByte(src, 12, 4);
        config.screenType = Utils.byte2int(screenTypeByte);
        byte[] keyboardByte = Utils.copyByte(src, 16, 1);
        config.keyboard = keyboardByte[0];
        byte[] navigationByte = Utils.copyByte(src, 17, 1);
        config.navigation = navigationByte[0];
        byte[] inputFlagsByte = Utils.copyByte(src, 18, 1);
        config.inputFlags = inputFlagsByte[0];
        byte[] inputPad0Byte = Utils.copyByte(src, 19, 1);
        config.inputPad0 = inputPad0Byte[0];
        byte[] inputByte = Utils.copyByte(src, 16, 4);
        config.input = Utils.byte2int(inputByte);
        byte[] screenWidthByte = Utils.copyByte(src, 20, 2);
        config.screenWidth = Utils.byte2Short(screenWidthByte);
        byte[] screenHeightByte = Utils.copyByte(src, 22, 2);
        config.screenHeight = Utils.byte2Short(screenHeightByte);
        byte[] screenSizeByte = Utils.copyByte(src, 20, 4);
        config.screenSize = Utils.byte2int(screenSizeByte);
        byte[] sdVersionByte = Utils.copyByte(src, 24, 2);
        config.sdVersion = Utils.byte2Short(sdVersionByte);
        byte[] minorVersionByte = Utils.copyByte(src, 26, 2);
        config.minorVersion = Utils.byte2Short(minorVersionByte);
        byte[] versionByte = Utils.copyByte(src, 24, 4);
        config.version = Utils.byte2int(versionByte);
        byte[] screenLayoutByte = Utils.copyByte(src, 28, 1);
        config.screenLayout = screenLayoutByte[0];
        byte[] uiModeByte = Utils.copyByte(src, 29, 1);
        config.uiMode = uiModeByte[0];
        byte[] smallestScreenWidthDpByte = Utils.copyByte(src, 30, 2);
        config.smallestScreenWidthDp = Utils.byte2Short(smallestScreenWidthDpByte);
        byte[] screenConfigByte = Utils.copyByte(src, 28, 4);
        config.screenConfig = Utils.byte2int(screenConfigByte);
        byte[] screenWidthDpByte = Utils.copyByte(src, 32, 2);
        config.screenWidthDp = Utils.byte2Short(screenWidthDpByte);
        byte[] screenHeightDpByte = Utils.copyByte(src, 34, 2);
        config.screenHeightDp = Utils.byte2Short(screenHeightDpByte);
        byte[] screenSizeDpByte = Utils.copyByte(src, 32, 4);
        config.screenSizeDp = Utils.byte2int(screenSizeDpByte);
        byte[] localeScriptByte = Utils.copyByte(src, 36, 4);
        config.localeScript = localeScriptByte;
        byte[] localeVariantByte = Utils.copyByte(src, 40, 8);
        config.localeVariant = localeVariantByte;
        return config;
    }

    public static ResStringPoolHeader parseStringPoolChunk(byte[] src, ArrayList<String> stringList, int stringOffset) {
        ResStringPoolHeader stringPoolHeader = new ResStringPoolHeader();
        stringPoolHeader.header = ParseResourceUtils.parseResChunkHeader(src, stringOffset);
        System.out.println("header size:" + stringPoolHeader.header.headerSize);
        System.out.println("size:" + stringPoolHeader.header.size);
        int offset = stringOffset + stringPoolHeader.header.getHeaderSize();
        byte[] stringCountByte = Utils.copyByte(src, offset, 4);
        stringPoolHeader.stringCount = Utils.byte2int(stringCountByte);
        byte[] styleCountByte = Utils.copyByte(src, offset + 4, 4);
        stringPoolHeader.styleCount = Utils.byte2int(styleCountByte);
        byte[] flagByte = Utils.copyByte(src, offset + 8, 4);
        System.out.println("flag:" + Utils.bytesToHexString(flagByte));
        stringPoolHeader.flags = Utils.byte2int(flagByte);
        byte[] stringStartByte = Utils.copyByte(src, offset + 12, 4);
        stringPoolHeader.stringsStart = Utils.byte2int(stringStartByte);
        System.out.println("string start:" + Utils.bytesToHexString(stringStartByte));
        byte[] sytleStartByte = Utils.copyByte(src, offset + 16, 4);
        stringPoolHeader.stylesStart = Utils.byte2int(sytleStartByte);
        System.out.println("style start:" + Utils.bytesToHexString(sytleStartByte));
        int[] stringIndexAry = new int[stringPoolHeader.stringCount];
        int[] styleIndexAry = new int[stringPoolHeader.styleCount];
        System.out.println("string count:" + stringPoolHeader.stringCount);
        System.out.println("style count:" + stringPoolHeader.styleCount);
        int stringIndex = offset + 20;
        for (int i = 0; i < stringPoolHeader.stringCount; ++i) {
            stringIndexAry[i] = Utils.byte2int(Utils.copyByte(src, stringIndex + i * 4, 4));
        }
        int styleIndex = stringIndex + 4 * stringPoolHeader.stringCount;
        for (int i = 0; i < stringPoolHeader.styleCount; ++i) {
            styleIndexAry[i] = Utils.byte2int(Utils.copyByte(src, styleIndex + i * 4, 4));
        }
        int stringContentIndex = styleIndex + stringPoolHeader.styleCount * 4;
        System.out.println("string index:" + Utils.bytesToHexString(Utils.int2Byte(stringContentIndex)));
        for (int index = 0; index < stringPoolHeader.stringCount; ++index) {
            byte[] stringSizeByte = Utils.copyByte(src, stringContentIndex, 2);
            int stringSize = stringSizeByte[1] & 0x7F;
            if (stringSize != 0) {
                String val = "";
                try {
                    val = new String(Utils.copyByte(src, stringContentIndex + 2, stringSize), "utf-8");
                }
                catch (Exception e) {
                    System.out.println("string encode error:" + e.toString());
                }
                stringList.add(val);
            } else {
                stringList.add("");
            }
            stringContentIndex += stringSize + 3;
        }
        for (String str : stringList) {
            System.out.println("str:" + str);
        }
        return stringPoolHeader;
    }

    private static ResChunkHeader parseResChunkHeader(byte[] src, int start) {
        ResChunkHeader header = new ResChunkHeader();
        byte[] typeByte = Utils.copyByte(src, start, 2);
        header.type = Utils.byte2Short(typeByte);
        byte[] headerSizeByte = Utils.copyByte(src, start + 2, 2);
        header.headerSize = Utils.byte2Short(headerSizeByte);
        byte[] tableSizeByte = Utils.copyByte(src, start + 4, 4);
        header.size = Utils.byte2int(tableSizeByte);
        return header;
    }

    public static boolean isEnd(int length) {
        return resTypeOffset >= length;
    }

    public static boolean isTypeSpec(byte[] src) {
        ResChunkHeader header = ParseResourceUtils.parseResChunkHeader(src, resTypeOffset);
        return header.type == 514;
    }

    public static String getResString(int index) {
        if (index >= resStringList.size() || index < 0) {
            return "";
        }
        return resStringList.get(index);
    }

    public static String getKeyString(int index) {
        if (index >= keyStringList.size() || index < 0) {
            return "";
        }
        return keyStringList.get(index);
    }

    public static int getResId(int entryid) {
        return packId << 24 | (resTypeId & 0xFF) << 16 | entryid & 0xFFFF;
    }

    static {
        resStringList = new ArrayList();
        keyStringList = new ArrayList();
        typeStringList = new ArrayList();
    }
}

