/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl;

import com.objectspace.jgl.Algos;
import com.objectspace.jgl.BinaryPredicate;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InvalidOperationException;
import com.objectspace.jgl.OrderedSetIterator;
import com.objectspace.jgl.Pair;
import com.objectspace.jgl.Range;
import com.objectspace.jgl.Set;
import com.objectspace.jgl.Tree;
import com.objectspace.jgl.algorithms.SetOperations;
import com.objectspace.jgl.util.InsertIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;

public class OrderedSet
implements Set {
    Tree myTree;
    int version = 30100;
    static final long serialVersionUID = -4993180520108826183L;

    public OrderedSet() {
        this.myTree = new Tree(false, false, this);
    }

    public OrderedSet(boolean bl) {
        this.myTree = new Tree(false, bl, this);
    }

    public OrderedSet(BinaryPredicate binaryPredicate) {
        this.myTree = new Tree(false, false, binaryPredicate, this);
    }

    public OrderedSet(BinaryPredicate binaryPredicate, boolean bl) {
        this.myTree = new Tree(false, bl, binaryPredicate, this);
    }

    public OrderedSet(OrderedSet orderedSet) {
        OrderedSet orderedSet2 = orderedSet;
        synchronized (orderedSet2) {
            this.myTree = new Tree(orderedSet.myTree, this);
        }
    }

    public boolean allowsDuplicates() {
        return this.myTree.myInsertAlways;
    }

    public synchronized Object clone() {
        return new OrderedSet(this);
    }

    public synchronized void copy(OrderedSet orderedSet) {
        OrderedSet orderedSet2 = orderedSet;
        synchronized (orderedSet2) {
            this.myTree.copy(orderedSet.myTree);
        }
    }

    public synchronized String toString() {
        return Algos.Printing.toString(this, "OrderedSet");
    }

    public synchronized Enumeration elements() {
        return this.myTree.beginSet();
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public synchronized OrderedSetIterator begin() {
        return this.myTree.beginSet();
    }

    public synchronized OrderedSetIterator end() {
        return this.myTree.endSet();
    }

    public boolean isEmpty() {
        return this.myTree.size == 0;
    }

    public int size() {
        return this.myTree.size;
    }

    public int maxSize() {
        return this.myTree.maxSize();
    }

    public boolean equals(Object object) {
        return object instanceof OrderedSet && this.equals((OrderedSet)object);
    }

    public synchronized boolean equals(OrderedSet orderedSet) {
        OrderedSet orderedSet2 = orderedSet;
        synchronized (orderedSet2) {
            boolean bl = Algos.Comparing.equal(this, orderedSet);
            Object var4_4 = null;
            return bl;
        }
    }

    public synchronized int hashCode() {
        return Algos.Hashing.orderedHash(this.begin(), this.myTree.size);
    }

    public synchronized void swap(OrderedSet orderedSet) {
        OrderedSet orderedSet2 = orderedSet;
        synchronized (orderedSet2) {
            Tree tree = this.myTree;
            this.myTree = orderedSet.myTree;
            orderedSet.myTree = tree;
        }
    }

    public synchronized void clear() {
        this.myTree.clear();
    }

    public synchronized int remove(Object object) {
        Pair pair = this.myTree.remove(object);
        return ((Number)pair.second).intValue();
    }

    public synchronized int remove(Object object, int n) {
        Pair pair = this.myTree.remove(object, n);
        return ((Number)pair.second).intValue();
    }

    public synchronized Object remove(Enumeration enumeration) {
        if (!(enumeration instanceof OrderedSetIterator)) {
            throw new IllegalArgumentException("Enumeration not a OrderedSetIterator");
        }
        if (((OrderedSetIterator)enumeration).myOrderedSet != this) {
            throw new IllegalArgumentException("Enumeration not for this OrderedSet");
        }
        Tree.TreeNode treeNode = this.myTree.remove(((OrderedSetIterator)enumeration).myNode);
        return treeNode == null ? null : treeNode.object;
    }

    public synchronized int remove(Enumeration enumeration, Enumeration enumeration2) {
        if (!(enumeration instanceof OrderedSetIterator) || !(enumeration2 instanceof OrderedSetIterator)) {
            throw new IllegalArgumentException("Enumeration not a OrderedSetIterator");
        }
        if (((OrderedSetIterator)enumeration).myOrderedSet != this || ((OrderedSetIterator)enumeration2).myOrderedSet != this) {
            throw new IllegalArgumentException("Enumeration not for this OrderedSet");
        }
        Pair pair = this.myTree.remove(((OrderedSetIterator)enumeration).myNode, ((OrderedSetIterator)enumeration2).myNode);
        return ((Number)pair.second).intValue();
    }

    public synchronized OrderedSetIterator find(Object object) {
        return new OrderedSetIterator(this.myTree, this.myTree.find(object), this);
    }

    public synchronized int count(Object object) {
        return this.myTree.count(object);
    }

    public synchronized OrderedSetIterator lowerBound(Object object) {
        return new OrderedSetIterator(this.myTree, this.myTree.lowerBound(object), this);
    }

    public synchronized OrderedSetIterator upperBound(Object object) {
        return new OrderedSetIterator(this.myTree, this.myTree.upperBound(object), this);
    }

    public synchronized Range equalRange(Object object) {
        Pair pair = this.myTree.equalRange(object);
        return new Range(new OrderedSetIterator(this.myTree, (Tree.TreeNode)pair.first, this), new OrderedSetIterator(this.myTree, (Tree.TreeNode)pair.second, this));
    }

    public BinaryPredicate getComparator() {
        return this.myTree.myComparator;
    }

    public synchronized Object add(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Tree.InsertResult insertResult = this.myTree.insert(object);
        return insertResult.ok ? null : insertResult.node.object;
    }

    public synchronized Object get(Object object) {
        Tree.TreeNode treeNode = this.myTree.find(object);
        if (treeNode.object == null) {
            return null;
        }
        return treeNode.object.equals(object) ? treeNode.object : null;
    }

    public synchronized Object put(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Tree.InsertResult insertResult = this.myTree.put(object);
        if (insertResult.ok) {
            return null;
        }
        Object object2 = insertResult.node.object;
        insertResult.node.object = object;
        return object2;
    }

    public synchronized OrderedSet union(OrderedSet orderedSet) {
        if (this.myTree.myInsertAlways || orderedSet.myTree.myInsertAlways) {
            throw new InvalidOperationException("union operation invalid on multisets");
        }
        OrderedSet orderedSet2 = new OrderedSet(this.getComparator(), this.allowsDuplicates());
        SetOperations.setUnion(this, orderedSet, new InsertIterator(orderedSet2), this.getComparator());
        return orderedSet2;
    }

    public synchronized OrderedSet intersection(OrderedSet orderedSet) {
        OrderedSet orderedSet2 = orderedSet;
        synchronized (orderedSet2) {
            if (this.myTree.myInsertAlways || orderedSet.myTree.myInsertAlways) {
                throw new InvalidOperationException("intersection operation invalid on multisets");
            }
            OrderedSet orderedSet3 = new OrderedSet(this.getComparator(), this.allowsDuplicates());
            SetOperations.setIntersection(this, orderedSet, new InsertIterator(orderedSet3), this.getComparator());
            OrderedSet orderedSet4 = orderedSet3;
            Object var4_5 = null;
            return orderedSet4;
        }
    }

    public synchronized OrderedSet difference(OrderedSet orderedSet) {
        OrderedSet orderedSet2 = orderedSet;
        synchronized (orderedSet2) {
            if (this.myTree.myInsertAlways || orderedSet.myTree.myInsertAlways) {
                throw new InvalidOperationException("difference operation invalid on multisets");
            }
            OrderedSet orderedSet3 = new OrderedSet(this.getComparator(), this.allowsDuplicates());
            SetOperations.setDifference(this, orderedSet, new InsertIterator(orderedSet3), this.getComparator());
            OrderedSet orderedSet4 = orderedSet3;
            Object var4_5 = null;
            return orderedSet4;
        }
    }

    public synchronized OrderedSet symmetricDifference(OrderedSet orderedSet) {
        OrderedSet orderedSet2 = orderedSet;
        synchronized (orderedSet2) {
            if (this.myTree.myInsertAlways || orderedSet.myTree.myInsertAlways) {
                throw new InvalidOperationException("symmetricDifference operation invalid on multisets");
            }
            OrderedSet orderedSet3 = new OrderedSet(this.getComparator(), this.allowsDuplicates());
            SetOperations.setSymmetricDifference(this, orderedSet, new InsertIterator(orderedSet3), this.getComparator());
            OrderedSet orderedSet4 = orderedSet3;
            Object var4_5 = null;
            return orderedSet4;
        }
    }

    public synchronized boolean subsetOf(OrderedSet orderedSet) {
        OrderedSet orderedSet2 = orderedSet;
        synchronized (orderedSet2) {
            if (this.myTree.myInsertAlways || orderedSet.myTree.myInsertAlways) {
                throw new InvalidOperationException("subsetOf operation invalid on multisets");
            }
            boolean bl = SetOperations.includes(orderedSet, this, this.getComparator());
            Object var4_4 = null;
            return bl;
        }
    }

    public synchronized boolean properSubsetOf(OrderedSet orderedSet) {
        OrderedSet orderedSet2 = orderedSet;
        synchronized (orderedSet2) {
            if (this.myTree.myInsertAlways || orderedSet.myTree.myInsertAlways) {
                throw new InvalidOperationException("properSubsetOf operation invalid on multisets");
            }
            boolean bl = this.size() < orderedSet.size() && this.subsetOf(orderedSet);
            Object var4_4 = null;
            return bl;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.version == 0) {
            boolean bl = objectInputStream.readBoolean();
            BinaryPredicate binaryPredicate = (BinaryPredicate)objectInputStream.readObject();
            this.myTree = new Tree(false, bl, binaryPredicate, this);
            int n = objectInputStream.readInt();
            while (n-- > 0) {
                this.add(objectInputStream.readObject());
            }
        }
    }
}

