// vcavxView.cpp : implementation of the CVcavxView class
//

#include "StdAfx.h"
#include "vcavx.h"

#include "vcavxDoc.h"
#include "vcavxView.h"
#include "MainFrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CVcavxView

IMPLEMENT_DYNCREATE(CVcavxView, CFormView)

BEGIN_MESSAGE_MAP(CVcavxView, CFormView)
	//{{AFX_MSG_MAP(CVcavxView)
	ON_WM_SIZE()
	ON_WM_CREATE()
	ON_LBN_SELCHANGE(IDC_FILELIST, OnSelchangeFilelist)
	ON_WM_TIMER()
	ON_WM_DESTROY()
	ON_UPDATE_COMMAND_UI(ID_FILE_OPEN, OnUpdateFileOpen)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVcavxView construction/destruction

CVcavxView::CVcavxView()
	: CFormView(CVcavxView::IDD)
{
	//{{AFX_DATA_INIT(CVcavxView)

	m_sSelFile = _T("");
	m_sPath = _T("");
	m_sSelectedFile = _T("");
	//}}AFX_DATA_INIT
	// TODO: add construction code here
	m_pAvXCtrl = NULL;
	m_nTimerID = 0;
	m_bInit = FALSE;

}

CVcavxView::~CVcavxView()
{


}

void CVcavxView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CVcavxView)
	DDX_Control(pDX, IDC_AUTOVUEXCTRL1, m_AvXCtrl);
	DDX_LBString(pDX, IDC_FILELIST, m_sSelFile);
	DDX_Text(pDX, IDC_PATH, m_sPath);
	DDX_Text(pDX, IDC_SELECTEDFILE, m_sSelectedFile);
	//}}AFX_DATA_MAP
}

BOOL CVcavxView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CFormView::PreCreateWindow(cs);
}

void CVcavxView::OnInitialUpdate()
{
 	if(m_bInit == FALSE) {
		// Tricky part. Do not initialize twice, otherwise, the OCX toolbars will 
		// not get painted properly
		CFormView::OnInitialUpdate();
		// Demo version OCX initialization fails
		if (!m_AvXCtrl.GetSafeHwnd())
		{
			return;
		}
		GetParentFrame()->RecalcLayout();
		ResizeParentToFit();
		m_bInit = TRUE;
	}
	PostInit();	
}

/////////////////////////////////////////////////////////////////////////////
// CVcavxView diagnostics

#ifdef _DEBUG
void CVcavxView::AssertValid() const
{
	CFormView::AssertValid();
}

void CVcavxView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

CVcavxDoc* CVcavxView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CVcavxDoc)));
	return (CVcavxDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CVcavxView message handlers

void CVcavxView::OnSize(UINT nType, int cx, int cy) 
{
	CFormView::OnSize(nType, cx, cy);
}

int CVcavxView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
 	if (CFormView::OnCreate(lpCreateStruct) == -1)
		return -1;
	m_nTimerID = SetTimer(1, 250, NULL);
	return 0;
}



BEGIN_EVENTSINK_MAP(CVcavxView, CFormView)
    //{{AFX_EVENTSINK_MAP(CVcavxView)
	ON_EVENT(CVcavxView, IDC_AUTOVUEXCTRL1, 3 /* HelpString */, OnHelpStringAutovuexctrl, VTS_BSTR)
	ON_EVENT(CVcavxView, IDC_AUTOVUEXCTRL1, 1 /* ModeChanged */, OnModeChanged, VTS_I2 VTS_I2)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()

void CVcavxView::OnHelpStringAutovuexctrl(LPCTSTR szMsg) 
{
	SetDlgItemText(IDC_STATUS, szMsg);
}

void CVcavxView::OnSelchangeFilelist() 
{
	// TODO: Add your control notification handler code here

	UpdateData(TRUE);
	if(!m_sSelFile.IsEmpty()) {
		m_sSelectedFile = (m_sPath.GetLength() == 3) ? m_sPath + m_sSelFile: m_sPath + "\\" + m_sSelFile;
	}
	UpdateData(FALSE);

	OnShow();	
}

void CVcavxView::OnShow() 
{
	// TODO: Add your control notification handler code here
	if (!m_AvXCtrl.GetSafeHwnd())
	{
		return;
	}

	if(!m_sSelectedFile.IsEmpty()) {
		m_AvXCtrl.SetSrc(m_sSelectedFile);
	}
	// Update title
	CMainFrame* pFrame = (CMainFrame*) AfxGetMainWnd();
	if(pFrame) {
		pFrame->SetTitle(m_sSelectedFile);
	}
	GetDocument()->SetTitle("VC Sample for AutoVueX");
}



void CVcavxView::Fill_FileListBox()
{
	CListBox* pLB = (CListBox*) GetDlgItem(IDC_FILELIST);
	pLB->ResetContent();

	int		nLen = m_sPath.GetLength();
	CString	sShortPath = "";
	LPTSTR lpBuffer = sShortPath.GetBuffer(_MAX_PATH);
	DWORD	dwRes = GetShortPathName(m_sPath, lpBuffer, _MAX_PATH);
	sShortPath.ReleaseBuffer();

	if (dwRes > 0) {
		sShortPath = (nLen == 3) ? sShortPath + "*.*" : sShortPath + "\\*.*";

		pLB->Dir(0, sShortPath);

		pLB->SetCurSel(0);
	}

	// Refresh:
	UpdateData(FALSE);
}

void CVcavxView::PostInit()
{
	UpdateData(FALSE);

	// Get Current Path:
	GetCurrentDirectory(_MAX_PATH, m_sPath.GetBuffer(_MAX_PATH));
	m_sPath.ReleaseBuffer();

	// Refresh File List:
	Fill_FileListBox();
	OnSelchangeFilelist();
}

CString CVcavxView::GetAutoVueDir() 
{
	LONG		cb;
	HKEY		hkCommandKey;
	char		AVdir[_MAX_PATH];
	CString		sCmd;

	// Clear memory:
	memset(AVdir, 0, _MAX_PATH);

	// Search for AutoVue EXE Path in the Registry:
	if (RegOpenKey(HKEY_CLASSES_ROOT,
		//"AutoVue.Document\\shell\\open\\command",
		"CLSID\\{B6FCC215-D303-11D1-BC6C-0000C078797F}\\InprocServer32",
		&hkCommandKey) == ERROR_SUCCESS) {
		cb = _MAX_PATH;

		if (RegQueryValue(hkCommandKey, NULL, AVdir, &cb) == ERROR_SUCCESS) {
			sCmd = AVdir;
		}
		RegCloseKey(hkCommandKey);

	} else {
		// Can't find AutoVue in the Registry:
		AfxMessageBox("Cannot fine AutoVue application.");
	}

	return sCmd;
}

void CVcavxView::ShowFile(LPCTSTR lpszPathName)
{
	CString strFullPath = lpszPathName;

	// Reverse to find the \ character which seperates the path and file name
	strFullPath.MakeReverse();
	int nIndex = strFullPath.Find('\\');
	int nPathCount = strFullPath.GetLength() - nIndex;
	int nFnameCount = nIndex;

	// Reverse back to normal
	strFullPath.MakeReverse();
	CString strPath = strFullPath.Left(nPathCount);
	CString strFname = strFullPath.Right(nFnameCount);
	
	m_sPath = strPath;
	m_sSelFile = strFname;

/*
	CString sPath = "";
	LPTSTR lpBuffer = sPath.GetBuffer(_MAX_PATH);
	
	CString sFilePart = "";
	LPTSTR lpFilePart = sFilePart.GetBuffer(_MAX_PATH);

	GetFullPathName(
		strFullPath,// file name
		_MAX_PATH, // size of path buffer
		lpBuffer,     // path buffer
		&lpFilePart   // address of file name in path
		);
	sPath.ReleaseBuffer();
	sFilePart.ReleaseBuffer();
	m_sPath = sPath;
	m_sSelFile = sFilePart;

*/
}

void CVcavxView::OnTimer(UINT_PTR nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	double dPosX, dPosY;
	CString sPosX = "", sPosY = "";
	if (!m_AvXCtrl.GetSafeHwnd())
	{
		return;
	}
	if (m_AvXCtrl.GetMousePos(&dPosX, &dPosY)) {
		sPosX.Format("%.2lf", dPosX);
		sPosY.Format("%.2lf", dPosY);
	}
	SetDlgItemText(IDC_POSX, sPosX);
	SetDlgItemText(IDC_POSY, sPosY);
	CFormView::OnTimer(nIDEvent);
}

void CVcavxView::OnDestroy() 
{
	CFormView::OnDestroy();
	
	// TODO: Add your message handler code here
	KillTimer(m_nTimerID);
}



void CVcavxView::OnModeChanged(short nOldMode, short nNewMode) 
{
	if (!m_AvXCtrl.GetSafeHwnd())
	{
		return;
	}

	CListBox* pLB = (CListBox*) GetDlgItem(IDC_FILELIST);
	CEdit* pEditDir = (CEdit*) GetDlgItem(IDC_PATH);
	CEdit* pEditFileName = (CEdit*) GetDlgItem(IDC_SELECTEDFILE);
	
	if (pLB == NULL || pEditDir == NULL || pEditFileName == NULL) {
		return;
	}
	if (nNewMode == 0) {
		pLB->EnableWindow(TRUE);
		pEditDir->EnableWindow(TRUE);
		pEditFileName->EnableWindow(TRUE);
	}  else {
		// Enter markup / print preview mode, force to repainting 
 		pLB->EnableWindow(FALSE);
		pEditDir->EnableWindow(FALSE);
		pEditFileName->EnableWindow(FALSE);
		m_AvXCtrl.Invalidate();
		m_AvXCtrl.UpdateWindow();
	}
}

void CVcavxView::OnUpdateFileOpen(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here
	if (!m_AvXCtrl.GetSafeHwnd())
	{
		return;
	}
	int nMode = m_AvXCtrl.GetMode();
	// Only enable in view mode
	pCmdUI->Enable(nMode == 0? TRUE:FALSE);	
}
