using System;
using System.Drawing;
using System.Drawing.Printing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Runtime.InteropServices;

namespace csAvX
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.MenuItem fileOpenMenuItem;
		private System.Windows.Forms.MenuItem fileExitMenuItem;
		private System.Windows.Forms.StatusBar statusBar1;
		private System.Windows.Forms.MenuItem fileMenuItem;
		private System.Windows.Forms.MenuItem fileSepMenuItem1;
		private System.Windows.Forms.MenuItem viewMenuItem;
		private System.Windows.Forms.MenuItem helpMenuItem;
		private System.Windows.Forms.MenuItem fileMarkupMenuItem;
		private System.Windows.Forms.MenuItem filePrintMenuItem;
		private System.Windows.Forms.MenuItem filePrintpreviewMenuItem;
		private System.Windows.Forms.MenuItem viewPageMenuItem;
		private System.Windows.Forms.MenuItem viewPagePrevMenuItem;
		private System.Windows.Forms.MenuItem viewPageNextMenuItem;
		private System.Windows.Forms.MenuItem helpAboutMenuItem;
		private System.Windows.Forms.PrintDialog printDialog1;
		private System.Windows.Forms.StatusBarPanel statusBarPanel1;
		private System.Windows.Forms.StatusBarPanel statusBarPanel2;
		private System.Windows.Forms.StatusBarPanel statusBarPanel3;
		private System.Windows.Forms.StatusBarPanel statusBarPanel4;
		private System.Windows.Forms.OpenFileDialog openFileDialog1;
		private AxAUTOVUEXLib.AxAutoVueX axAutoVueX1;
		private System.Windows.Forms.MenuItem fileSepMenuItem2;
		private System.Windows.Forms.MenuItem fileSepMenuItem3;

		private PAN_CtlFileInfo currentFileInfo;
		private int currentPage;
		private System.Windows.Forms.MenuItem fileRenderMenuItem;

		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
			this.fileMenuItem.Popup += new EventHandler(this.onFileMenuPopup);
			this.fileOpenMenuItem.Click += new EventHandler(this.onFileOpenClick);
			this.fileMarkupMenuItem.Click += new EventHandler(this.onFileMarkupClick);
			this.filePrintMenuItem.Click += new EventHandler(this.onFilePrintClick);
			this.fileRenderMenuItem.Click += new EventHandler(this.onFileRenderClick);
			this.filePrintpreviewMenuItem.Click += new EventHandler(this.onFilePrintPreviewClick);
			this.fileExitMenuItem.Click += new EventHandler(this.onExitClick);

			this.viewPageMenuItem.Popup += new EventHandler(this.onPageMenuPopup);
			this.viewPageNextMenuItem.Click += new EventHandler(this.onPageNextClick);
			this.viewPagePrevMenuItem.Click += new EventHandler(this.onPagePrevClick);

			this.helpAboutMenuItem.Click += new EventHandler(this.onAboutClick);

			// Clear the filename field.
			this.statusBarPanel1.Text = "";
			this.statusBarPanel2.Text = "";
			this.statusBarPanel3.Text = "";
			this.statusBarPanel4.Text = "";

			// Register delegates for handling events from AutoVueX.
			axAutoVueX1.OnNewDocument += new AxAUTOVUEXLib._DAutoVueXEvents_OnNewDocumentEventHandler(this.re_NewDocument);
			axAutoVueX1.HelpString += new AxAUTOVUEXLib._DAutoVueXEvents_HelpStringEventHandler(this.re_HelpString);
			axAutoVueX1.PageChanged += new AxAUTOVUEXLib._DAutoVueXEvents_PageChangedEventHandler(this.re_PageChanged);
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		// <summary>
		// Override for OnResize handling. This method resizes
		// AutoVueX control to match frame window size.
		// </summary>
		protected override void OnResize(System.EventArgs e)
		{
			int newWidth;
			int newHeight;

			newWidth = this.Width - 8;
			newHeight = this.Height - 70;

			if (newWidth < 100)
				newWidth = 100;
			if (newHeight < 100)
				newHeight = 100;

			this.axAutoVueX1.Size = new System.Drawing.Size(newWidth, newHeight);
			base.OnResize(e);
		}

		/// <summary>
		/// Adjust file menu enabling based on file loaded.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		//
		//
		private void onFileMenuPopup(object sender, System.EventArgs e)
		{
			if (currentFileInfo == null)
			{
				this.fileMarkupMenuItem.Enabled = false;
				this.filePrintMenuItem.Enabled = false;
				this.fileRenderMenuItem.Enabled = false;
				this.filePrintpreviewMenuItem.Enabled = false;
			}
			else
			{
				this.fileMarkupMenuItem.Enabled = true;
				this.filePrintMenuItem.Enabled = true;
				this.fileRenderMenuItem.Enabled = true;
				this.filePrintpreviewMenuItem.Enabled = true;
			}
		}

		//
		// Show the open file dialog.
		//
		private void onFileOpenClick(object sender, System.EventArgs e)
		{
			OpenFileDialog dlg = new OpenFileDialog();
			if (dlg.ShowDialog(this) == DialogResult.OK) 
			{
				axAutoVueX1.SRC = dlg.FileName;
			}
			dlg.Dispose();
		}

		//
		// Enter markup mode.
		//
		private void onFileMarkupClick(object sender, System.EventArgs e)
		{
			if (axAutoVueX1.SRC.Equals("") == false)
			{
				axAutoVueX1.EnterMarkupMode();
			}
		}

		//
		// Handle print command using built-in PrintIt method.
		//
		private void onFilePrintClick(object sender, System.EventArgs e)
		{
			if (axAutoVueX1.SRC.Equals("") == false)
			{
				axAutoVueX1.PrintIt(false);
			}
		}

		// Prototype of SendMessage used to send PM_CTLGETPAGESIZE message.
		[DllImport("user32.dll", EntryPoint="SendMessage")]
		public static extern int
			SendMessageGetPageSize(int _WindowHandle, int msg, int wParam,
			/* [In, Out] */ ref PAN_CtlRange lplf);

		// Prototype of SendMessage used to send PM_CTLRENDERONTODC message.
		[DllImport("user32.dll", EntryPoint="SendMessage")]
		public static extern int
			SendMessageRenderOntoDC(int _WindowHandle, int msg, int wParam,
			/* [In, Out] */ PAN_CtlRenderOptions lplf);

		// <summary>
		// Print implementation for formatted report. Illustrates use of
		// PM_CTLRENDERONTODC message to provided customized output. Currently
		// displayed page is printed in top 3/4 of page, textual information
		// drawn beneath.
		// </summary>
		private void doc_PrintPage(object sender, PrintPageEventArgs ev)
		{
			// Find the text region.
			float textTop = (ev.MarginBounds.Bottom - ev.MarginBounds.Top) * (float) 0.75 +
							ev.MarginBounds.Top;
			float vcetBottom = textTop;
			float textLeft = ev.MarginBounds.Left;
			
			textTop += (float) 50.0;

			// Draw label information.
			Font f = new Font("Arial", 12);

			ev.Graphics.DrawString("File: " + currentFileInfo.name,
				f, Brushes.Black, textLeft, textTop);
			textTop += f.GetHeight();
			ev.Graphics.DrawString("Page: " + currentPage,
				f, Brushes.Black, textLeft, textTop);
			textTop += f.GetHeight();
			ev.Graphics.DrawString("File size: " + currentFileInfo.size,
				f, Brushes.Black, textLeft, textTop);
			textTop += f.GetHeight();
			ev.Graphics.DrawString("Drawn by C# / AutoVueX sample",
				f, Brushes.Black, textLeft, textTop);

			// Draw a frame around region where current page will be
			// printed.
			Pen blackPen = new Pen(Color.Black, 3);
			ev.Graphics.DrawRectangle(blackPen,
				ev.MarginBounds.Left, ev.MarginBounds.Top,
				ev.MarginBounds.Right - ev.MarginBounds.Left,
				vcetBottom - ev.MarginBounds.Top);
			
			// Set up rendering of document: Calculate mapping between
			// extents of current page and the display region of the
			// output page.
			PAN_CtlRenderOptions ro = new PAN_CtlRenderOptions();
			float dpix = ev.Graphics.DpiX / (float) 100.0;
			float dpiy = ev.Graphics.DpiX / (float) 100.0;

			ro.hdc = ev.Graphics.GetHdc();
			ro.mode = (uint) VCET_mode.PAN_CTLMODEOPAQUE;

			// outWidth and outHeight are the dimensions of the region
			// on the physical page.
            float outWidth = ev.MarginBounds.Right - ev.MarginBounds.Left;
			float outHeight = vcetBottom - ev.MarginBounds.Top;

			// Leave space for the rectangular border.
			outWidth -= (float) 6.0;
			outHeight -= (float) 6.0;

			// Get the current pages' extents.
			PAN_CtlRange srcRange = new PAN_CtlRange();
			int result = SendMessageGetPageSize(axAutoVueX1.GetVcetHandle(),
									(int) VCET_messages.PM_CTLGETPAGESIZE,
									currentPage, ref srcRange);
			ro.source = srcRange;

			// Position the current page to fill the display region on
			// the page.
			double wRatio = outWidth / (srcRange.max.x - srcRange.min.x);
			double hRatio = outHeight / (srcRange.max.y - srcRange.min.y);

			// Adjust for aspect ratio.
			if (wRatio < hRatio)
			{
				ro.devRect.left = (int) ((ev.MarginBounds.Left + (float) 3.0) * dpix);
				ro.devRect.right = (int) ((ev.MarginBounds.Right - (float) 3.0) * dpix);

				double useDist = wRatio * (srcRange.max.y - srcRange.min.y);
				double offset = (outHeight - useDist) * 0.5;

				ro.devRect.top = (int) ((ev.MarginBounds.Top + (float) 3.0 + offset) * dpiy);
				ro.devRect.bottom = ro.devRect.top + (int) (useDist * dpiy);
			}
			else
			{
				ro.devRect.top = (int) ((ev.MarginBounds.Top + (float) 3.0) * dpiy);
				ro.devRect.bottom = (int) ((vcetBottom - (float) 3.0)* dpiy);

				double useDist = hRatio * (srcRange.max.x - srcRange.min.x);
				double offset = (outWidth - useDist) * 0.5;

				ro.devRect.left = (int) ((ev.MarginBounds.Left + (float) 3.0 + offset) * dpix);
				ro.devRect.right = ro.devRect.left + (int) (useDist * dpix);
			}

			// Draw the current page.
			result = SendMessageRenderOntoDC(axAutoVueX1.GetVcetHandle(),
				(int) VCET_messages.PM_CTLRENDERONTODC,
				0, ro);

			ev.Graphics.ReleaseHdc(ro.hdc);

			ev.HasMorePages = false;
		}

		// <summary>
		// Handle formatted print request using default printer and
		// VCET PM_CTLRENDERONTODC message.
		// </summary>
		private void onFileRenderClick(object sender, System.EventArgs e)
		{
			PrintDocument doc = new PrintDocument();

			doc.PrintPage += new PrintPageEventHandler(doc_PrintPage);

			try
			{
				doc.Print();
			}
			catch (Exception ex)
			{
				string why = ex.Message;
			}
		}

		// <summary>
		// Handle print preview request using AutoVueX capabilities.
		// </summary>
		private void onFilePrintPreviewClick(object sender, System.EventArgs e)
		{
			if (currentFileInfo != null)
			{
				axAutoVueX1.PrintPreview(false, true);
			}
		}

		// <summary>
		// Exits the program when the "Exit" menu item is clicked.
		// </summary>
		private void onExitClick(object sender, System.EventArgs e)
		{
			// Close the form.
			this.Close();
		}

		// <summary>
		// Enable/disable page movement actions based on current
		// context.
		// </summary>
		private void onPageMenuPopup(object sender, System.EventArgs e)
		{
			if (currentFileInfo == null)
			{
				this.viewPageNextMenuItem.Enabled = false;
				this.viewPagePrevMenuItem.Enabled = false;
				return;
			}

			bool fwdOk = ((currentFileInfo.nPages < 0) ||
							(currentPage < currentFileInfo.nPages));
			this.viewPageNextMenuItem.Enabled = fwdOk;

			bool backOk = (currentPage > 1);
			this.viewPagePrevMenuItem.Enabled = backOk;
		}

		// Switch to next page.
		private void onPageNextClick(object sender, System.EventArgs e)
		{
			axAutoVueX1.Page = (short) (currentPage + 1);
		}

		// Switch to previous page.
		private void onPagePrevClick(object sender, System.EventArgs e)
		{
			axAutoVueX1.Page = (short) (currentPage - 1);
		}

		private void onAboutClick(object sender, System.EventArgs e)
		{
			// Show the About dialog.
			About dlg = new About();
			dlg.ShowDialog(this);
			dlg.Dispose();
		}

		
		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(Form1));
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.fileMenuItem = new System.Windows.Forms.MenuItem();
			this.fileOpenMenuItem = new System.Windows.Forms.MenuItem();
			this.fileSepMenuItem1 = new System.Windows.Forms.MenuItem();
			this.fileMarkupMenuItem = new System.Windows.Forms.MenuItem();
			this.fileSepMenuItem2 = new System.Windows.Forms.MenuItem();
			this.filePrintMenuItem = new System.Windows.Forms.MenuItem();
			this.fileRenderMenuItem = new System.Windows.Forms.MenuItem();
			this.filePrintpreviewMenuItem = new System.Windows.Forms.MenuItem();
			this.fileSepMenuItem3 = new System.Windows.Forms.MenuItem();
			this.fileExitMenuItem = new System.Windows.Forms.MenuItem();
			this.viewMenuItem = new System.Windows.Forms.MenuItem();
			this.viewPageMenuItem = new System.Windows.Forms.MenuItem();
			this.viewPagePrevMenuItem = new System.Windows.Forms.MenuItem();
			this.viewPageNextMenuItem = new System.Windows.Forms.MenuItem();
			this.helpMenuItem = new System.Windows.Forms.MenuItem();
			this.helpAboutMenuItem = new System.Windows.Forms.MenuItem();
			this.statusBar1 = new System.Windows.Forms.StatusBar();
			this.statusBarPanel1 = new System.Windows.Forms.StatusBarPanel();
			this.statusBarPanel2 = new System.Windows.Forms.StatusBarPanel();
			this.statusBarPanel3 = new System.Windows.Forms.StatusBarPanel();
			this.statusBarPanel4 = new System.Windows.Forms.StatusBarPanel();
			this.printDialog1 = new System.Windows.Forms.PrintDialog();
			this.openFileDialog1 = new System.Windows.Forms.OpenFileDialog();
			this.axAutoVueX1 = new AxAUTOVUEXLib.AxAutoVueX();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanel1)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanel2)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanel3)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanel4)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.axAutoVueX1)).BeginInit();
			this.SuspendLayout();
			// 
			// mainMenu1
			// 
			this.mainMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																					  this.fileMenuItem,
																					  this.viewMenuItem,
																					  this.helpMenuItem});
			// 
			// fileMenuItem
			// 
			this.fileMenuItem.Index = 0;
			this.fileMenuItem.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						 this.fileOpenMenuItem,
																						 this.fileSepMenuItem1,
																						 this.fileMarkupMenuItem,
																						 this.fileSepMenuItem2,
																						 this.filePrintMenuItem,
																						 this.fileRenderMenuItem,
																						 this.filePrintpreviewMenuItem,
																						 this.fileSepMenuItem3,
																						 this.fileExitMenuItem});
			this.fileMenuItem.Text = "File";
			// 
			// fileOpenMenuItem
			// 
			this.fileOpenMenuItem.Index = 0;
			this.fileOpenMenuItem.Text = "Open";
			// 
			// fileSepMenuItem1
			// 
			this.fileSepMenuItem1.Index = 1;
			this.fileSepMenuItem1.Text = "-";
			// 
			// fileMarkupMenuItem
			// 
			this.fileMarkupMenuItem.Index = 2;
			this.fileMarkupMenuItem.Text = "Markup...";
			// 
			// fileSepMenuItem2
			// 
			this.fileSepMenuItem2.Index = 3;
			this.fileSepMenuItem2.Text = "-";
			// 
			// filePrintMenuItem
			// 
			this.filePrintMenuItem.Index = 4;
			this.filePrintMenuItem.Text = "Print";
			// 
			// fileRenderMenuItem
			// 
			this.fileRenderMenuItem.Index = 5;
			this.fileRenderMenuItem.Text = "Formatted Print";
			// 
			// filePrintpreviewMenuItem
			// 
			this.filePrintpreviewMenuItem.Index = 6;
			this.filePrintpreviewMenuItem.Text = "Print Preview";
			// 
			// fileSepMenuItem3
			// 
			this.fileSepMenuItem3.Index = 7;
			this.fileSepMenuItem3.Text = "-";
			// 
			// fileExitMenuItem
			// 
			this.fileExitMenuItem.Index = 8;
			this.fileExitMenuItem.Text = "Exit";
			// 
			// viewMenuItem
			// 
			this.viewMenuItem.Index = 1;
			this.viewMenuItem.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						 this.viewPageMenuItem});
			this.viewMenuItem.Text = "View";
			// 
			// viewPageMenuItem
			// 
			this.viewPageMenuItem.Index = 0;
			this.viewPageMenuItem.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																							 this.viewPagePrevMenuItem,
																							 this.viewPageNextMenuItem});
			this.viewPageMenuItem.Text = "Page";
			// 
			// viewPagePrevMenuItem
			// 
			this.viewPagePrevMenuItem.Index = 0;
			this.viewPagePrevMenuItem.Text = "Previous";
			// 
			// viewPageNextMenuItem
			// 
			this.viewPageNextMenuItem.Index = 1;
			this.viewPageNextMenuItem.Text = "Next";
			// 
			// helpMenuItem
			// 
			this.helpMenuItem.Index = 2;
			this.helpMenuItem.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						 this.helpAboutMenuItem});
			this.helpMenuItem.Text = "Help";
			// 
			// helpAboutMenuItem
			// 
			this.helpAboutMenuItem.Index = 0;
			this.helpAboutMenuItem.Text = "About";
			// 
			// statusBar1
			// 
			this.statusBar1.Location = new System.Drawing.Point(0, 347);
			this.statusBar1.Name = "statusBar1";
			this.statusBar1.Panels.AddRange(new System.Windows.Forms.StatusBarPanel[] {
																						  this.statusBarPanel1,
																						  this.statusBarPanel2,
																						  this.statusBarPanel3,
																						  this.statusBarPanel4});
			this.statusBar1.ShowPanels = true;
			this.statusBar1.Size = new System.Drawing.Size(544, 22);
			this.statusBar1.TabIndex = 1;
			this.statusBar1.Text = "statusBar1";
			// 
			// statusBarPanel1
			// 
			this.statusBarPanel1.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Spring;
			this.statusBarPanel1.Text = "statusBarPanel1";
			this.statusBarPanel1.Width = 132;
			// 
			// statusBarPanel2
			// 
			this.statusBarPanel2.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Spring;
			this.statusBarPanel2.Text = "statusBarPanel2";
			this.statusBarPanel2.Width = 132;
			// 
			// statusBarPanel3
			// 
			this.statusBarPanel3.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Spring;
			this.statusBarPanel3.Text = "statusBarPanel3";
			this.statusBarPanel3.Width = 132;
			// 
			// statusBarPanel4
			// 
			this.statusBarPanel4.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Spring;
			this.statusBarPanel4.Text = "statusBarPanel4";
			this.statusBarPanel4.Width = 132;
			// 
			// axAutoVueX1
			// 
			this.axAutoVueX1.Enabled = true;
			this.axAutoVueX1.Location = new System.Drawing.Point(0, 0);
			this.axAutoVueX1.Name = "axAutoVueX1";
			this.axAutoVueX1.OcxState = ((System.Windows.Forms.AxHost.State)(resources.GetObject("axAutoVueX1.OcxState")));
			this.axAutoVueX1.Size = new System.Drawing.Size(536, 344);
			this.axAutoVueX1.TabIndex = 2;
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(544, 369);
			this.Controls.Add(this.axAutoVueX1);
			this.Controls.Add(this.statusBar1);
			this.Menu = this.mainMenu1;
			this.Name = "Form1";
			this.Text = "csAutoVueX";
			this.Load += new System.EventHandler(this.Form1_Load);
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanel1)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanel2)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanel3)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanel4)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.axAutoVueX1)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		private void Form1_Load(object sender, System.EventArgs e)
		{
			currentFileInfo = null;
		}

		//
		// Methods for handling ActiveX events from AutoVueX control.
		//
		// Handle HelpString notification - display string in status bar.
		private void re_HelpString(object sender, AxAUTOVUEXLib._DAutoVueXEvents_HelpStringEvent e)
		{
			this.statusBarPanel4.Text = e.szMsg;
		}

		[DllImport("user32.dll", EntryPoint="SendMessage", CharSet=CharSet.Ansi)]
		public static extern int
			SendMessageFileInfo(int _WindowHandle, int msg, int wParam,
			[In, Out] PAN_CtlFileInfo lplf);

		// <summary>
		// Handle NewDocument events fired by the AutoVueX control.
		// </summary>
		private void re_NewDocument(object sender, AxAUTOVUEXLib._DAutoVueXEvents_OnNewDocumentEvent e)
		{
			this.statusBarPanel1.Text = e.szFileName;

			// Get the file size from the underlying VCET Control.
			PAN_CtlFileInfo fi = new PAN_CtlFileInfo();
			
			int result = SendMessageFileInfo(axAutoVueX1.GetVcetHandle(),
									(int) VCET_messages.PM_CTLGETFILE,
									0, fi);
			
			currentFileInfo = fi;
			currentPage = 1;

			this.statusBarPanel3.Text = fi.size.ToString() + " Bytes";
		}

		// <summary>
		// Handle PageChanged events fired by the AutoVueX control.
		// </summary>
		private void re_PageChanged(object sender, AxAUTOVUEXLib._DAutoVueXEvents_PageChangedEvent e)
		{
			this.statusBarPanel2.Text = "Page " + e.nNewPage.ToString();
			currentPage = e.nNewPage;
		}
	}
}
