using System;
using System.Runtime.InteropServices;

namespace csAvX
{
	/// <summary>
	/// C# translation of VCET PAN_CtlFileInfo structure. Used by
	/// PM_CTLGETFILE message to retrieve principal properties of the
	/// viewed document.
	/// </summary>
	[StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
	public class PAN_CtlFileInfo
	{
		public const int PAN_MAX_PATH = 320;
		public const int PAN_CTLMAXDESC = 64;

		public uint type;
		[MarshalAs(UnmanagedType.ByValTStr, SizeConst=PAN_MAX_PATH)]
		public string name;
		public uint size;
		public uint date;
		[MarshalAs(UnmanagedType.ByValTStr, SizeConst=PAN_CTLMAXDESC)]
		public string desc;
		public PAN_CtlRange dimensions;
		public ushort colorDepth;
		public int nPages;
		public int tilex, tiley;
		public uint dwHints;

		public PAN_Point offset;
		public PAN_Point scale;
		public PAN_Point dpi;
		public double rot;
		public ushort flip;
		public ushort units;
		public int curPage;
		public uint clipCount;
		public int loadedFromMetafile;
	}
}
